/*
 * Decompiled with CFR 0.152.
 */
package com.hero.ui;

import com.hero.HeroDesigner;
import com.hero.objects.Adder;
import com.hero.objects.GenericObject;
import com.hero.objects.List;
import com.hero.objects.disads.Disadvantage;
import com.hero.objects.enhancers.Enhancer;
import com.hero.objects.martialarts.Maneuver;
import com.hero.objects.modifiers.Modifier;
import com.hero.objects.perks.Perk;
import com.hero.objects.powers.CompoundPower;
import com.hero.objects.powers.Power;
import com.hero.objects.skills.Skill;
import com.hero.objects.talents.MageSight;
import com.hero.objects.talents.Talent;
import com.hero.ui.PerksList;
import com.hero.ui.SkillList;
import com.hero.ui.dialog.GenericDialog;
import com.hero.ui.widgets.PopupMessage;
import com.hero.util.Rounder;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.math.BigDecimal;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;

public abstract class GenericObjectList
extends JInternalFrame {
    protected long checkIndicesTime;
    boolean col3Present;
    String column1;
    String column2;
    String column3;
    protected ActionListener copyListener;
    protected JMenuItem copyMI;
    protected ActionListener cutListener;
    protected JMenuItem cutMI;
    protected JMenuItem defineMI;
    JButton deleteBtn;
    protected JMenuItem deleteMI;
    JButton downBtn;
    protected JMenuItem downMI;
    JButton editBtn;
    protected JMenuItem editMI;
    boolean insertBefore = false;
    JButton insertBtn;
    long lastSet = -1L;
    ArrayList<UpdateListener> listeners;
    protected HeroModel model;
    ArrayList<GenericObject> objects;
    protected ActionListener pasteListener;
    protected JMenuItem pasteMI;
    protected JMenuItem copyModsMI;
    protected JMenuItem cutModsMI;
    protected JMenuItem pasteModsMI;
    protected JPopupMenu popup;
    JScrollPane scroll;
    protected int selectedIndex = -1;
    protected JTable table;
    double thisTotal = -999999.0;
    double thisCarried = 0.0;
    double thisWeight = 0.0;
    protected long totalCostCalcTime;
    String type;
    JButton upBtn;
    protected JMenuItem upMI;
    private boolean locked;

    public GenericObjectList(String string, String string2, String string3, String string4, ArrayList<GenericObject> arrayList) {
        super(string, false, false, false, false);
        this.type = string;
        this.column1 = string2;
        this.column2 = string3;
        this.column3 = string4;
        this.col3Present = this.column3 != null && this.column3.trim().length() != 0;
        this.objects = arrayList;
        this.listeners = new ArrayList();
        this.initWidgets();
        this.initListeners();
        this.layoutComponent();
        this.pack();
        this.setVisible(true);
        this.toFront();
        this.setFrameIcon(new ImageIcon(Toolkit.getDefaultToolkit().createImage(new byte[0], 0, 0)));
    }

    public void addObject(GenericObject genericObject) {
        Object object;
        int n = this.getInsertionIndex();
        int n2 = n - 1;
        if (n2 < 0) {
            n2 = 0;
        }
        if (this.insertBefore) {
            n2 = n - 1;
        }
        if (n2 >= this.objects.size()) {
            n2 = this.objects.size() - 1;
        }
        if (n2 >= 0 && this.objects.size() > 0) {
            GenericObject genericObject2 = this.objects.get(n2);
            if (genericObject2 instanceof List) {
                object = (List)genericObject2;
                if (!((List)object).objectAllowed(genericObject)) {
                    genericObject.setParent(null);
                    n = this.insertBefore ? --n : (n += ((List)object).getObjects().size());
                    if (((List)object).getRejectionMessage().trim().length() > 0) {
                        GenericObjectList genericObjectList = this;
                        PopupMessage object2 = PopupMessage.getInstance(HeroDesigner.getAppFrame(), genericObjectList, ((List)object).getRejectionMessage(), true);
                        object2.setVisible(true);
                    }
                } else {
                    ((List)object).getObjects().add(0, genericObject);
                    genericObject.setParent((List)object);
                }
            } else if (genericObject2.getParentList() != null) {
                object = genericObject2.getParentList();
                if (!((List)object).objectAllowed(genericObject)) {
                    genericObject.setParent(null);
                    n = this.insertBefore ? n - (genericObject2.getPosition() - ((GenericObject)object).getPosition()) - 1 : ((GenericObject)object).getPosition() + ((List)object).getObjects().size() + 1;
                    if (((List)object).getRejectionMessage().trim().length() > 0) {
                        GenericObjectList genericObjectList = this;
                        PopupMessage popupMessage = PopupMessage.getInstance(HeroDesigner.getAppFrame(), genericObjectList, ((List)object).getRejectionMessage(), true);
                        popupMessage.setVisible(true);
                    }
                } else {
                    int n3 = n - ((GenericObject)object).getPosition();
                    if (n3 >= ((List)object).getObjects().size()) {
                        ((List)object).getObjects().add(genericObject);
                    } else if (n3 < 0) {
                        n3 = 0;
                    } else {
                        ((List)object).getObjects().add(n3, genericObject);
                    }
                    genericObject.setParent((List)object);
                }
            }
        }
        genericObject.setPosition(n);
        int n4 = 1;
        if (genericObject instanceof List) {
            object = (List)genericObject;
            n4 += ((List)object).getObjects().size();
        }
        for (GenericObject genericObject3 : this.objects) {
            if (genericObject3.getPosition() < n) continue;
            genericObject3.setPosition(genericObject3.getPosition() + n4);
        }
        if (n < this.objects.size()) {
            if (genericObject instanceof List) {
                object = (List)genericObject;
                for (int i = ((List)object).getObjects().size() - 1; i >= 0; --i) {
                    this.objects.add(n, ((List)object).getObjects().get(i));
                }
            }
            this.objects.add(n, genericObject);
        } else {
            this.objects.add(genericObject);
            if (genericObject instanceof List) {
                object = (List)genericObject;
                for (GenericObject genericObject2 : ((List)object).getObjects()) {
                    genericObject2.getRealCostPreList();
                    this.objects.add(genericObject2);
                }
            }
        }
        this.selectedIndex = n;
        HeroDesigner.getActiveHero().setDirty(true);
        this.updateTotal();
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.table.getSelectionModel().addListSelectionListener(selectionListener);
    }

    public void addUpdateListener(UpdateListener updateListener) {
        this.listeners.add(updateListener);
    }

    protected boolean checkCopy() {
        return this.selectedIndex >= 0;
    }

    protected boolean checkCut() {
        return this.selectedIndex >= 0;
    }

    private boolean checkDown() {
        if (this.selectedIndex < 0 || this.selectedIndex >= this.objects.size()) {
            return false;
        }
        GenericObject genericObject = this.objects.get(this.selectedIndex);
        if (genericObject instanceof List) {
            int n = ((List)genericObject).getObjects().size();
            return this.selectedIndex + n < this.objects.size() - 1;
        }
        if (genericObject.getParentList() != null) {
            return true;
        }
        return this.selectedIndex < this.objects.size() - 1;
    }

    void checkIndices() {
        if (this.checkIndicesTime > 0L && this.checkIndicesTime > HeroDesigner.lastEdit) {
            return;
        }
        for (int i = this.objects.size() - 1; i >= 0; --i) {
            List list;
            GenericObject genericObject = this.objects.get(i);
            if (genericObject.getParentList() == null || genericObject.getParentList() instanceof Enhancer || (list = genericObject.getParentList()).objectAllowed(genericObject, false)) continue;
            this.objects.remove(i);
            list.remove(genericObject);
            genericObject.setParent(null);
            if (list.getPosition() + list.getObjects().size() + 1 >= this.objects.size()) {
                this.objects.add(genericObject);
            } else {
                this.objects.add(list.getPosition() + list.getObjects().size() + 1, genericObject);
            }
            JOptionPane.showMessageDialog(HeroDesigner.getAppFrame(), list.getRejectionMessage(), "Object not allowed in list", 2);
            genericObject.setAppAdjusted(true);
            HeroDesigner.getActiveHero().setDirty(true);
        }
        this.normalize();
    }

    protected boolean checkPaste() {
        return HeroDesigner.getCopyBuffer() != null;
    }

    protected boolean checkPasteMods() {
        return HeroDesigner.getInstance().getCopyModBuffer() != null && HeroDesigner.getInstance().getCopyModBuffer().size() > 0;
    }

    protected abstract boolean checkReplace(GenericObject var1, GenericObject var2);

    private boolean checkUp() {
        return this.selectedIndex > 0;
    }

    public void cutSelection() {
        this.locked = true;
        this.syncSelectedIndex();
        if (this.selectedIndex >= 0) {
            GenericObject genericObject;
            GenericObject genericObject2 = this.objects.get(this.selectedIndex);
            if (genericObject2 instanceof Adder) {
                this.locked = false;
                return;
            }
            if (genericObject2.getMainPower() != null) {
                genericObject = genericObject2.getMainPower();
                ((CompoundPower)genericObject).getPowers().remove(genericObject2);
            }
            if (genericObject2 instanceof List && ((List)genericObject2).getObjects().size() > 0) {
                genericObject = (List)genericObject2;
                for (int i = 0; i < ((List)genericObject).getObjects().size(); ++i) {
                    this.objects.remove(((List)genericObject).getObjects().get(i));
                }
            } else if (genericObject2.getParentList() != null) {
                genericObject = genericObject2.getParentList();
                ((List)genericObject).remove(genericObject2);
            }
            int n = this.objects.indexOf(genericObject2);
            this.objects.remove(genericObject2);
            if (n >= this.objects.size()) {
                n = this.objects.size() - 1;
            }
        }
        HeroDesigner.getActiveHero().setDirty(true);
        this.updateTotal();
        this.locked = false;
    }

    protected JPanel getButtonPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(1));
        jPanel.add(this.downBtn);
        jPanel.add(this.editBtn);
        jPanel.add(this.insertBtn);
        jPanel.add(this.deleteBtn);
        jPanel.add(this.upBtn);
        jPanel.setOpaque(false);
        return jPanel;
    }

    protected ActionListener getCopyAction() {
        return this.copyListener;
    }

    protected ActionListener getCutAction() {
        return this.cutListener;
    }

    protected int getInsertionIndex() {
        this.syncSelectedIndex();
        int n = 0;
        n = this.selectedIndex < 0 || this.selectedIndex >= this.objects.size() ? (this.insertBefore ? 0 : this.objects.size()) : (this.insertBefore ? this.selectedIndex : this.selectedIndex + 1);
        if (n < 0) {
            n = 0;
        }
        if (n > this.objects.size()) {
            n = this.objects.size();
        }
        return n;
    }

    protected List getInsertionParent() {
        this.syncSelectedIndex();
        List list = null;
        if (this.selectedIndex >= 0) {
            GenericObject genericObject = this.objects.get(this.selectedIndex);
            list = genericObject.getParentList();
            if (genericObject instanceof List && !this.insertBefore) {
                list = (List)genericObject;
            } else if (genericObject.getParentList() != null) {
                list = genericObject.getParentList();
            }
        }
        return list;
    }

    protected ArrayList<GenericObject> getObjects() {
        return this.objects;
    }

    protected ActionListener getPasteAction() {
        return this.pasteListener;
    }

    protected JPopupMenu getPopupMenu() {
        return this.popup;
    }

    public JScrollPane getScroll() {
        return this.scroll;
    }

    public int getSelectedIndex() {
        this.syncSelectedIndex();
        return this.selectedIndex;
    }

    public GenericObject getSelection() {
        this.syncSelectedIndex();
        if (this.selectedIndex < 0 || this.selectedIndex >= this.objects.size()) {
            return null;
        }
        return this.objects.get(this.selectedIndex);
    }

    protected void initListeners() {
        this.upMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GenericObjectList.this.upBtn.doClick();
            }
        });
        this.downMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GenericObjectList.this.downBtn.doClick();
            }
        });
        this.editMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GenericObjectList.this.editBtn.doClick();
            }
        });
        this.deleteMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GenericObjectList.this.deleteBtn.doClick();
            }
        });
        this.defineMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GenericObject genericObject = GenericObjectList.this.getSelection();
                if (genericObject == null) {
                    return;
                }
                String string = genericObject.getNotes();
                if (string == null || string.trim().length() == 0) {
                    string = genericObject.getDefinition();
                }
                if (string == null) {
                    return;
                }
                if (string.trim().length() == 0) {
                    return;
                }
                PopupMessage popupMessage = PopupMessage.getInstance(HeroDesigner.getAppFrame(), GenericObjectList.this.table, string, false);
                popupMessage.setVisible(true);
            }
        });
        this.table.addComponentListener(new ComponentListener(){

            @Override
            public void componentHidden(ComponentEvent componentEvent) {
            }

            @Override
            public void componentMoved(ComponentEvent componentEvent) {
            }

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                GenericObjectList.this.model.fireTableDataChanged();
            }

            @Override
            public void componentShown(ComponentEvent componentEvent) {
                GenericObjectList.this.model.fireTableDataChanged();
            }
        });
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (GenericObjectList.this.locked) {
                    return;
                }
                JTable jTable = GenericObjectList.this.table;
                synchronized (jTable) {
                    GenericObjectList.this.locked = true;
                    GenericObjectList.this.setSelectedIndex(GenericObjectList.this.table.getSelectedRow(), false);
                    GenericObjectList.this.lastSet = System.currentTimeMillis();
                    GenericObjectList.this.locked = false;
                }
            }
        });
        this.table.addMouseListener(new MouseListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (GenericObjectList.this.locked) {
                    return;
                }
                if (mouseEvent.isPopupTrigger() && GenericObjectList.this.popup != null) {
                    if (!GenericObjectList.this.locked) {
                        GenericObjectList.this.locked = true;
                        JTable jTable = GenericObjectList.this.table;
                        synchronized (jTable) {
                            GenericObjectList.this.selectedIndex = -1;
                            GenericObjectList.this.setSelectedIndex(GenericObjectList.this.table.rowAtPoint(mouseEvent.getPoint()), false);
                        }
                        GenericObjectList.this.pasteMI.setEnabled(GenericObjectList.this.checkPaste());
                        GenericObjectList.this.pasteModsMI.setEnabled(GenericObjectList.this.getSelection() != null && GenericObjectList.this.checkPasteMods());
                        if (GenericObjectList.this.getSelection() != null && GenericObjectList.this.getSelection().getAllAssignedModifiers() != null && GenericObjectList.this.getSelection().getAllAssignedModifiers().size() > 0) {
                            GenericObjectList.this.cutModsMI.setEnabled(true);
                            GenericObjectList.this.copyModsMI.setEnabled(true);
                        } else {
                            GenericObjectList.this.cutModsMI.setEnabled(false);
                            GenericObjectList.this.copyModsMI.setEnabled(true);
                        }
                        GenericObjectList.this.editMI.setEnabled(GenericObjectList.this.editBtn.isEnabled());
                        GenericObjectList.this.deleteMI.setEnabled(GenericObjectList.this.deleteBtn.isEnabled());
                        GenericObjectList.this.upMI.setEnabled(GenericObjectList.this.upBtn.isEnabled());
                        GenericObjectList.this.downMI.setEnabled(GenericObjectList.this.downBtn.isEnabled());
                        GenericObjectList.this.defineMI.setEnabled(GenericObjectList.this.selectedIndex >= 0 && GenericObjectList.this.objects.get(GenericObjectList.this.selectedIndex).getDefinition().trim().length() > 0);
                        GenericObjectList.this.table.repaint();
                        if (GenericObjectList.this.table.getSelectedRow() >= 0) {
                            GenericObjectList.this.popup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                        }
                        GenericObjectList.this.locked = false;
                    }
                    return;
                }
                if (mouseEvent.getClickCount() == 2) {
                    JTable jTable = GenericObjectList.this.table;
                    synchronized (jTable) {
                        GenericObjectList.this.selectedIndex = -1;
                        GenericObjectList.this.setSelectedIndex(GenericObjectList.this.table.getSelectedRow(), true);
                    }
                }
                if (mouseEvent.getButton() == 1 && System.currentTimeMillis() - GenericObjectList.this.lastSet > 1000L) {
                    JTable jTable = GenericObjectList.this.table;
                    synchronized (jTable) {
                        if (GenericObjectList.this.table.rowAtPoint(mouseEvent.getPoint()) == GenericObjectList.this.selectedIndex) {
                            GenericObjectList.this.table.clearSelection();
                            GenericObjectList.this.upBtn.setEnabled(false);
                            GenericObjectList.this.downBtn.setEnabled(false);
                            GenericObjectList.this.editBtn.setEnabled(false);
                            GenericObjectList.this.deleteBtn.setEnabled(false);
                            if (GenericObjectList.this.insertBefore) {
                                GenericObjectList.this.insertBtn.setText("Insert At Top");
                            } else {
                                GenericObjectList.this.insertBtn.setText("Insert At End");
                            }
                            GenericObjectList.this.selectedIndex = -1;
                        }
                    }
                }
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (GenericObjectList.this.locked) {
                    return;
                }
                if (mouseEvent.isPopupTrigger() && GenericObjectList.this.popup != null) {
                    if (!GenericObjectList.this.locked) {
                        GenericObjectList.this.locked = true;
                        JTable jTable = GenericObjectList.this.table;
                        synchronized (jTable) {
                            GenericObjectList.this.selectedIndex = -1;
                            GenericObjectList.this.setSelectedIndex(GenericObjectList.this.table.rowAtPoint(mouseEvent.getPoint()), false);
                        }
                        GenericObjectList.this.pasteMI.setEnabled(GenericObjectList.this.checkPaste());
                        GenericObjectList.this.pasteModsMI.setEnabled(GenericObjectList.this.getSelection() != null && GenericObjectList.this.checkPasteMods());
                        if (GenericObjectList.this.getSelection() != null && GenericObjectList.this.getSelection().getAllAssignedModifiers() != null && GenericObjectList.this.getSelection().getAllAssignedModifiers().size() > 0) {
                            GenericObjectList.this.cutModsMI.setEnabled(true);
                            GenericObjectList.this.copyModsMI.setEnabled(true);
                        } else {
                            GenericObjectList.this.cutModsMI.setEnabled(false);
                            GenericObjectList.this.copyModsMI.setEnabled(true);
                        }
                        GenericObjectList.this.editMI.setEnabled(GenericObjectList.this.editBtn.isEnabled());
                        GenericObjectList.this.deleteMI.setEnabled(GenericObjectList.this.deleteBtn.isEnabled());
                        GenericObjectList.this.upMI.setEnabled(GenericObjectList.this.upBtn.isEnabled());
                        GenericObjectList.this.downMI.setEnabled(GenericObjectList.this.downBtn.isEnabled());
                        GenericObjectList.this.defineMI.setEnabled(GenericObjectList.this.selectedIndex >= 0 && GenericObjectList.this.objects.get(GenericObjectList.this.selectedIndex).getDefinition().trim().length() > 0);
                        GenericObjectList.this.table.repaint();
                        if (GenericObjectList.this.table.getSelectedRow() >= 0) {
                            GenericObjectList.this.popup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                        }
                        GenericObjectList.this.locked = false;
                    }
                    return;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (GenericObjectList.this.locked) {
                    return;
                }
                if (mouseEvent.isPopupTrigger() && GenericObjectList.this.popup != null) {
                    if (!GenericObjectList.this.locked) {
                        GenericObjectList.this.locked = true;
                        JTable jTable = GenericObjectList.this.table;
                        synchronized (jTable) {
                            GenericObjectList.this.selectedIndex = -1;
                            GenericObjectList.this.setSelectedIndex(GenericObjectList.this.table.rowAtPoint(mouseEvent.getPoint()), false);
                        }
                        GenericObjectList.this.pasteMI.setEnabled(GenericObjectList.this.checkPaste());
                        GenericObjectList.this.pasteModsMI.setEnabled(GenericObjectList.this.getSelection() != null && GenericObjectList.this.checkPasteMods());
                        if (GenericObjectList.this.getSelection() != null && GenericObjectList.this.getSelection().getAllAssignedModifiers() != null && GenericObjectList.this.getSelection().getAllAssignedModifiers().size() > 0) {
                            GenericObjectList.this.cutModsMI.setEnabled(true);
                            GenericObjectList.this.copyModsMI.setEnabled(true);
                        } else {
                            GenericObjectList.this.cutModsMI.setEnabled(false);
                            GenericObjectList.this.copyModsMI.setEnabled(true);
                        }
                        GenericObjectList.this.editMI.setEnabled(GenericObjectList.this.editBtn.isEnabled());
                        GenericObjectList.this.deleteMI.setEnabled(GenericObjectList.this.deleteBtn.isEnabled());
                        GenericObjectList.this.upMI.setEnabled(GenericObjectList.this.upBtn.isEnabled());
                        GenericObjectList.this.downMI.setEnabled(GenericObjectList.this.downBtn.isEnabled());
                        GenericObjectList.this.defineMI.setEnabled(GenericObjectList.this.selectedIndex >= 0 && GenericObjectList.this.objects.get(GenericObjectList.this.selectedIndex).getDefinition().trim().length() > 0);
                        GenericObjectList.this.table.repaint();
                        if (GenericObjectList.this.table.getSelectedRow() >= 0) {
                            GenericObjectList.this.popup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                        }
                        GenericObjectList.this.locked = false;
                    }
                    return;
                }
            }
        });
        this.table.addKeyListener(new KeyAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void keyPressed(KeyEvent keyEvent) {
                GenericObject genericObject;
                if (keyEvent.isControlDown()) {
                    if (keyEvent.getKeyCode() == 67 && GenericObjectList.this.getSelection() != null) {
                        GenericObjectList.this.copyMI.doClick();
                    }
                    if (keyEvent.getKeyCode() == 86 && HeroDesigner.getCopyBuffer() != null) {
                        GenericObjectList.this.pasteMI.setEnabled(GenericObjectList.this.checkPaste());
                        GenericObjectList.this.pasteMI.doClick();
                    }
                    if (keyEvent.getKeyCode() == 88 && GenericObjectList.this.getSelection() != null) {
                        GenericObjectList.this.cutMI.doClick();
                    }
                } else if (keyEvent.getKeyChar() == '\n') {
                    JTable jTable = GenericObjectList.this.table;
                    synchronized (jTable) {
                        GenericObjectList.this.setSelectedIndex(GenericObjectList.this.table.getSelectedRow(), true);
                    }
                } else if (keyEvent.getKeyCode() == 127) {
                    GenericObjectList.this.deleteBtn.doClick();
                } else if ((keyEvent.getKeyCode() == 45 || keyEvent.getKeyCode() == 521 || keyEvent.getKeyCode() == 61) && GenericObjectList.this.getSelection() != null && (genericObject = GenericObjectList.this.getSelection()).getLevelCost() != 0.0 && genericObject.getLevelValue() != 0.0) {
                    if (keyEvent.getKeyCode() == 45 && genericObject.getLevels() > genericObject.getMinimumLevel()) {
                        List list;
                        long l = genericObject.getID();
                        GenericObject genericObject2 = genericObject.clone();
                        genericObject2.setID(l);
                        genericObject2.setLevels(genericObject.getLevels() - 1);
                        genericObject2.setMainPower(genericObject.getMainPower());
                        if (genericObject.getMainPower() != null) {
                            genericObject2.setParent(genericObject.getMainPower().getParentList());
                        } else {
                            genericObject2.setParent(genericObject.getParentList());
                        }
                        if (!GenericObjectList.this.checkReplace(genericObject2, genericObject)) {
                            GenericObjectList.this.locked = false;
                            return;
                        }
                        GenericObjectList.this.objects.set(GenericObjectList.this.selectedIndex, genericObject2);
                        if (genericObject2 instanceof List) {
                            List list2 = (List)genericObject2;
                            ArrayList<GenericObject> arrayList = list2.getObjects();
                            for (GenericObject genericObject3 : arrayList) {
                                genericObject3.setParent(list2);
                            }
                        } else if (genericObject2.getParentList() != null && (list = genericObject2.getParentList()).getObjects().indexOf(genericObject) >= 0) {
                            list.getObjects().set(list.getObjects().indexOf(genericObject), genericObject2);
                        }
                        GenericObjectList.this.checkIndices();
                        HeroDesigner.getActiveHero().setDirty(true);
                        GenericObjectList.this.updateTotal();
                        HeroDesigner.getActiveHero().setDirty(true);
                        GenericObjectList.this.updateTotal();
                    } else if ((keyEvent.getKeyCode() == 521 || keyEvent.getKeyCode() == 61) && genericObject.getLevels() < genericObject.getMaxLevel()) {
                        List list;
                        long l = genericObject.getID();
                        GenericObject genericObject4 = genericObject.clone();
                        genericObject4.setID(l);
                        genericObject4.setLevels(genericObject.getLevels() + 1);
                        genericObject4.setMainPower(genericObject.getMainPower());
                        if (genericObject.getMainPower() != null) {
                            genericObject4.setParent(genericObject.getMainPower().getParentList());
                        } else {
                            genericObject4.setParent(genericObject.getParentList());
                        }
                        if (!GenericObjectList.this.checkReplace(genericObject4, genericObject)) {
                            GenericObjectList.this.locked = false;
                            return;
                        }
                        GenericObjectList.this.objects.set(GenericObjectList.this.selectedIndex, genericObject4);
                        if (genericObject4 instanceof List) {
                            List list3 = (List)genericObject4;
                            ArrayList<GenericObject> arrayList = list3.getObjects();
                            for (GenericObject genericObject5 : arrayList) {
                                genericObject5.setParent(list3);
                            }
                        } else if (genericObject4.getParentList() != null && (list = genericObject4.getParentList()).getObjects().indexOf(genericObject) >= 0) {
                            list.getObjects().set(list.getObjects().indexOf(genericObject), genericObject4);
                        }
                        GenericObjectList.this.checkIndices();
                        HeroDesigner.getActiveHero().setDirty(true);
                        GenericObjectList.this.updateTotal();
                        HeroDesigner.getActiveHero().setDirty(true);
                        GenericObjectList.this.updateTotal();
                    }
                }
            }
        });
        this.insertBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GenericObjectList.this.syncSelectedIndex();
                if (!GenericObjectList.this.insertBefore) {
                    if (GenericObjectList.this.selectedIndex >= 0) {
                        GenericObjectList.this.insertBtn.setText("Insert Before");
                    } else {
                        GenericObjectList.this.insertBtn.setText("Insert At Top");
                    }
                    GenericObjectList.this.insertBefore = true;
                } else {
                    if (GenericObjectList.this.selectedIndex >= 0) {
                        GenericObjectList.this.insertBtn.setText("Insert After");
                    } else {
                        GenericObjectList.this.insertBtn.setText("Insert At End");
                    }
                    GenericObjectList.this.insertBefore = false;
                }
            }
        });
        this.downBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GenericObjectList.this.locked = true;
                if (GenericObjectList.this.selectedIndex >= 0 && (GenericObjectList.this.selectedIndex < GenericObjectList.this.objects.size() - 1 || GenericObjectList.this.objects.get(GenericObjectList.this.selectedIndex).getParentList() != null)) {
                    GenericObject genericObject = GenericObjectList.this.objects.get(GenericObjectList.this.selectedIndex);
                    if (genericObject instanceof List) {
                        int n;
                        List list = (List)genericObject;
                        GenericObject genericObject2 = GenericObjectList.this.objects.get(GenericObjectList.this.selectedIndex + list.getObjects().size() + 1);
                        int n2 = 1 + list.getObjects().size() + 1;
                        if (genericObject2 instanceof List) {
                            List list2 = (List)genericObject2;
                            n2 += list2.getObjects().size();
                        }
                        int n3 = 1 + list.getObjects().size();
                        n2 -= n3;
                        for (n = 0; n < n3; ++n) {
                            GenericObjectList.this.objects.remove(GenericObjectList.this.selectedIndex);
                        }
                        for (n = list.getObjects().size() - 1; n >= 0; --n) {
                            GenericObjectList.this.objects.add(GenericObjectList.this.selectedIndex + n2, list.getObjects().get(n));
                        }
                        GenericObjectList.this.objects.add(GenericObjectList.this.selectedIndex + n2, list);
                        GenericObjectList.this.selectedIndex += n2;
                    } else {
                        boolean bl = true;
                        if (GenericObjectList.this.selectedIndex < GenericObjectList.this.objects.size() - 1) {
                            GenericObject genericObject3 = GenericObjectList.this.objects.get(GenericObjectList.this.selectedIndex + 1);
                            if (genericObject3.getParentList() == null && genericObject.getParentList() != null) {
                                List list = genericObject.getParentList();
                                list.remove(genericObject);
                                genericObject.setParent(null);
                                bl = false;
                            } else if (genericObject3 instanceof List) {
                                List list = (List)genericObject3;
                                if (list.objectAllowed(genericObject)) {
                                    ArrayList<GenericObject> arrayList = ((List)genericObject3).getObjects();
                                    arrayList.add(0, genericObject);
                                    genericObject.setParent((List)genericObject3);
                                } else {
                                    genericObject.setParent(null);
                                    GenericObjectList.this.objects.remove(GenericObjectList.this.selectedIndex);
                                    int n = GenericObjectList.this.selectedIndex + list.getObjects().size() + 1;
                                    if (n >= GenericObjectList.this.objects.size()) {
                                        GenericObjectList.this.objects.add(genericObject);
                                    } else {
                                        GenericObjectList.this.objects.add(n, genericObject);
                                    }
                                    GenericObjectList.this.selectedIndex = n;
                                    bl = false;
                                    if (list.getRejectionMessage().trim().length() > 0) {
                                        PopupMessage popupMessage = PopupMessage.getInstance(HeroDesigner.getAppFrame(), GenericObjectList.this.downBtn, list.getRejectionMessage(), true);
                                        popupMessage.setVisible(true);
                                    }
                                }
                            }
                        } else {
                            genericObject.getParentList().remove(genericObject);
                            genericObject.setParent(null);
                            bl = false;
                        }
                        if (bl) {
                            GenericObjectList.this.objects.remove(GenericObjectList.this.selectedIndex);
                            GenericObjectList.this.objects.add(GenericObjectList.this.selectedIndex + 1, genericObject);
                            ++GenericObjectList.this.selectedIndex;
                        }
                    }
                    HeroDesigner.getActiveHero().setDirty(true);
                }
                GenericObjectList.this.upBtn.setEnabled(GenericObjectList.this.checkUp());
                GenericObjectList.this.downBtn.setEnabled(GenericObjectList.this.checkDown());
                GenericObjectList.this.updateTotal();
                GenericObjectList.this.locked = false;
            }
        });
        this.upBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GenericObjectList.this.locked = true;
                if (GenericObjectList.this.selectedIndex > 0 && GenericObjectList.this.selectedIndex < GenericObjectList.this.objects.size()) {
                    GenericObject genericObject = GenericObjectList.this.objects.get(GenericObjectList.this.selectedIndex);
                    boolean bl = true;
                    if (GenericObjectList.this.selectedIndex > 0) {
                        GenericObject genericObject2 = GenericObjectList.this.objects.get(GenericObjectList.this.selectedIndex - 1);
                        if (genericObject instanceof List) {
                            int n;
                            List list = (List)genericObject;
                            int n2 = 1;
                            if (genericObject2.getParentList() != null) {
                                List list2 = genericObject2.getParentList();
                                n2 += list2.getObjects().size();
                            }
                            int n3 = 1 + list.getObjects().size();
                            for (n = 0; n < n3; ++n) {
                                if (GenericObjectList.this.selectedIndex < GenericObjectList.this.objects.size()) {
                                    GenericObjectList.this.objects.remove(GenericObjectList.this.selectedIndex);
                                    continue;
                                }
                                GenericObjectList.this.objects.remove(GenericObjectList.this.objects.size() - 1);
                            }
                            for (n = list.getObjects().size() - 1; n >= 0; --n) {
                                GenericObjectList.this.objects.add(GenericObjectList.this.selectedIndex - n2, list.getObjects().get(n));
                            }
                            GenericObjectList.this.objects.add(GenericObjectList.this.selectedIndex - n2, list);
                            GenericObjectList.this.selectedIndex -= n2;
                        } else {
                            if (genericObject2.getParentList() == null && genericObject.getParentList() != null) {
                                List list = genericObject.getParentList();
                                list.remove(genericObject);
                                genericObject.setParent(null);
                            } else if (genericObject2.getParentList() != null && genericObject.getParentList() == null) {
                                if (genericObject2.getParentList().objectAllowed(genericObject)) {
                                    ArrayList<GenericObject> arrayList = genericObject2.getParentList().getObjects();
                                    arrayList.add(genericObject);
                                    genericObject.setParent(genericObject2.getParentList());
                                    bl = false;
                                } else {
                                    genericObject.setParent(null);
                                    GenericObjectList.this.objects.remove(GenericObjectList.this.selectedIndex);
                                    GenericObjectList.this.objects.add(Math.max(GenericObjectList.this.selectedIndex - 1 - genericObject2.getParentList().getObjects().size(), 0), genericObject);
                                    GenericObjectList.this.selectedIndex = Math.max(GenericObjectList.this.selectedIndex - 1 - genericObject2.getParentList().getObjects().size(), 0);
                                    bl = false;
                                    PopupMessage popupMessage = PopupMessage.getInstance(HeroDesigner.getAppFrame(), GenericObjectList.this.upBtn, genericObject2.getParentList().getRejectionMessage(), true);
                                    popupMessage.setVisible(true);
                                }
                            } else if (genericObject2 instanceof List && genericObject.getParentList() == null) {
                                List list = (List)genericObject2;
                                if (list.objectAllowed(genericObject)) {
                                    list.getObjects().add(genericObject);
                                    genericObject.setParent(list);
                                    bl = false;
                                } else {
                                    genericObject.setParent(null);
                                    PopupMessage popupMessage = PopupMessage.getInstance(HeroDesigner.getAppFrame(), GenericObjectList.this.upBtn, list.getRejectionMessage(), true);
                                    popupMessage.setVisible(true);
                                }
                            }
                            if (bl) {
                                GenericObjectList.this.objects.remove(GenericObjectList.this.selectedIndex);
                                GenericObjectList.this.objects.add(GenericObjectList.this.selectedIndex - 1, genericObject);
                                --GenericObjectList.this.selectedIndex;
                            }
                        }
                    }
                    HeroDesigner.getActiveHero().setDirty(true);
                }
                GenericObjectList.this.upBtn.setEnabled(GenericObjectList.this.checkUp());
                GenericObjectList.this.downBtn.setEnabled(GenericObjectList.this.checkDown());
                GenericObjectList.this.updateTotal();
                GenericObjectList.this.locked = false;
            }
        });
        this.editBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GenericObjectList.this.locked = true;
                if (GenericObjectList.this.selectedIndex >= 0 && GenericObjectList.this.selectedIndex < GenericObjectList.this.objects.size()) {
                    try {
                        GenericObject genericObject = GenericObjectList.this.objects.get(GenericObjectList.this.selectedIndex);
                        if (genericObject instanceof Adder) {
                            GenericObjectList.this.locked = false;
                            return;
                        }
                        if (genericObject instanceof List && genericObject.getTextOutput().trim().length() == 0) {
                            GenericObjectList.this.locked = false;
                            return;
                        }
                        long l = genericObject.getID();
                        GenericObject genericObject2 = genericObject.clone();
                        genericObject2.setID(l);
                        genericObject2.setMainPower(genericObject.getMainPower());
                        if (genericObject.getMainPower() != null) {
                            genericObject2.setParent(genericObject.getMainPower().getParentList());
                        } else {
                            genericObject2.setParent(genericObject.getParentList());
                        }
                        GenericDialog genericDialog = genericObject2.getDialog(false, GenericObjectList.this.objects == HeroDesigner.getActiveHero().getPowers() || GenericObjectList.this.objects == HeroDesigner.getActiveHero().getEquipment());
                        genericDialog.setLocationRelativeTo(GenericObjectList.this);
                        genericDialog.setVisible(true);
                        if (genericDialog.okButtonClicked) {
                            List list;
                            if (!GenericObjectList.this.checkReplace(genericObject2, genericObject)) {
                                genericDialog.dispose();
                                GenericObjectList.this.locked = false;
                                return;
                            }
                            GenericObjectList.this.objects.set(GenericObjectList.this.selectedIndex, genericObject2);
                            if (genericObject2 instanceof List) {
                                List list2 = (List)genericObject2;
                                ArrayList<GenericObject> arrayList = list2.getObjects();
                                for (GenericObject genericObject3 : arrayList) {
                                    genericObject3.setParent(list2);
                                }
                            } else if (genericObject2.getParentList() != null && (list = genericObject2.getParentList()).getObjects().indexOf(genericObject) >= 0) {
                                list.getObjects().set(list.getObjects().indexOf(genericObject), genericObject2);
                            }
                            GenericObjectList.this.checkIndices();
                            HeroDesigner.getActiveHero().setDirty(true);
                        } else if (genericDialog.deleteButtonClicked) {
                            GenericObjectList.this.deleteBtn.doClick();
                        } else if (genericDialog.cancelButtonClicked) {
                            genericDialog.dispose();
                            GenericObjectList.this.locked = false;
                            return;
                        }
                        genericDialog.dispose();
                        GenericObjectList.this.updateTotal();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                GenericObjectList.this.locked = false;
            }
        });
        this.deleteBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GenericObjectList.this.locked = true;
                if (GenericObjectList.this.selectedIndex >= 0 && GenericObjectList.this.selectedIndex < GenericObjectList.this.objects.size()) {
                    int n;
                    GenericObject genericObject = GenericObjectList.this.objects.get(GenericObjectList.this.selectedIndex);
                    if (genericObject instanceof Adder) {
                        GenericObjectList.this.locked = false;
                        return;
                    }
                    String string = "ability";
                    if (genericObject instanceof List) {
                        string = "list";
                    } else if (GenericObjectList.this.type.equals("Equipment")) {
                        string = "piece of equipment";
                    } else if (genericObject instanceof Skill) {
                        string = "skill";
                    } else if (genericObject instanceof Perk) {
                        string = "perk";
                    } else if (genericObject instanceof Talent || genericObject instanceof MageSight) {
                        string = "talent";
                    } else if (genericObject instanceof Maneuver) {
                        string = "maneuver";
                    } else if (genericObject instanceof Power) {
                        string = "power";
                    } else if (genericObject instanceof Disadvantage) {
                        string = HeroDesigner.getActiveTemplate().is6E() ? "complication" : "disadvantage";
                    }
                    if (HeroDesigner.getInstance().getPrefs().confirmDelete() && (n = JOptionPane.showConfirmDialog(GenericObjectList.this, "Are you sure you want to delete this " + string + "?", "Confirm Delete", 0)) != 0) {
                        GenericObjectList.this.locked = false;
                        return;
                    }
                    if (genericObject instanceof List && ((List)genericObject).getObjects().size() > 0) {
                        n = JOptionPane.showConfirmDialog(GenericObjectList.this, "Do you want to delete all items contained by " + genericObject.getAlias() + "?");
                        if (n == 2) {
                            GenericObjectList.this.locked = false;
                            return;
                        }
                        if (n == 0) {
                            List list = (List)genericObject;
                            for (int i = list.getObjects().size() - 1; i >= 0; --i) {
                                GenericObjectList.this.objects.remove(list.getObjects().get(i));
                            }
                        } else {
                            List list = (List)genericObject;
                            for (GenericObject genericObject2 : list.getObjects()) {
                                genericObject2.setParent(null);
                            }
                        }
                    } else if (genericObject.getParentList() != null) {
                        List list = genericObject.getParentList();
                        list.remove(genericObject);
                    }
                    if (GenericObjectList.this.objects.size() > 1) {
                        GenericObjectList.this.objects.remove(genericObject);
                    } else {
                        GenericObjectList.this.objects.clear();
                    }
                    --GenericObjectList.this.selectedIndex;
                }
                HeroDesigner.getActiveHero().setDirty(true);
                GenericObjectList.this.updateTotal();
                GenericObjectList.this.locked = false;
            }
        });
        this.setCutAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (GenericObjectList.this.selectedIndex >= 0) {
                    GenericObject genericObject = GenericObjectList.this.objects.get(GenericObjectList.this.selectedIndex);
                    HeroDesigner.getInstance().setCopyBuffer(genericObject.clone());
                    GenericObjectList.this.cutSelection();
                    if (HeroDesigner.getCopyBuffer() != null) {
                        GenericObjectList.this.pasteMI.setEnabled(true);
                    } else {
                        GenericObjectList.this.pasteMI.setEnabled(false);
                    }
                }
            }
        });
        this.setCopyAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (GenericObjectList.this.selectedIndex >= 0) {
                    GenericObject genericObject = GenericObjectList.this.objects.get(GenericObjectList.this.selectedIndex);
                    String string = genericObject.getNamelessColumn2Output();
                    if (genericObject.getName() != null && genericObject.getName().trim().length() > 0) {
                        string = genericObject.getName() + ":  " + string;
                    }
                    StringSelection stringSelection = new StringSelection(string);
                    Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stringSelection, stringSelection);
                    HeroDesigner.getInstance().setCopyBuffer(genericObject.clone());
                    if (HeroDesigner.getCopyBuffer() != null) {
                        GenericObjectList.this.pasteMI.setEnabled(true);
                    } else {
                        GenericObjectList.this.pasteMI.setEnabled(false);
                    }
                }
            }
        });
        this.copyModsMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (GenericObjectList.this.getSelection() != null) {
                    HeroDesigner.getInstance().setCopyModBuffer(GenericObjectList.this.getSelection().getAllAssignedModifiers());
                }
            }
        });
        this.cutModsMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (GenericObjectList.this.getSelection() != null) {
                    HeroDesigner.getInstance().setCopyModBuffer(GenericObjectList.this.getSelection().getAllAssignedModifiers());
                    GenericObjectList.this.getSelection().setAssignedModifiers(new ArrayList<Modifier>());
                    GenericObjectList.this.updateTotal();
                }
            }
        });
        this.pasteModsMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (GenericObjectList.this.getSelection() != null) {
                    ArrayList<Modifier> arrayList = HeroDesigner.getInstance().getCopyModBuffer();
                    for (int i = 0; i < arrayList.size(); ++i) {
                        Modifier modifier = arrayList.get(i);
                        if (modifier.included(GenericObjectList.this.getSelection()).trim().length() != 0) continue;
                        GenericObjectList.this.getSelection().getAssignedModifiers().add(modifier);
                    }
                    GenericObjectList.this.updateTotal();
                }
            }
        });
        this.table.getColumnModel().addColumnModelListener(new TableColumnModelListener(){

            @Override
            public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
            }

            @Override
            public void columnMarginChanged(ChangeEvent changeEvent) {
            }

            @Override
            public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
            }

            @Override
            public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
            }

            @Override
            public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
            }
        });
    }

    protected void initWidgets() {
        this.popup = new JPopupMenu("Edit Options");
        this.copyMI = new JMenuItem("Copy");
        this.cutMI = new JMenuItem("Cut");
        this.pasteMI = new JMenuItem("Paste");
        this.copyModsMI = new JMenuItem("Copy Modifiers");
        this.cutModsMI = new JMenuItem("Cut Modifiers");
        this.pasteModsMI = new JMenuItem("Paste Modifiers");
        this.editMI = new JMenuItem("Edit...");
        this.deleteMI = new JMenuItem("Delete");
        this.defineMI = new JMenuItem("Define");
        this.upMI = new JMenuItem("Move Up");
        this.downMI = new JMenuItem("Move Down");
        this.popup.add(this.cutMI);
        this.popup.add(this.copyMI);
        this.popup.add(this.pasteMI);
        this.popup.addSeparator();
        this.popup.add(this.copyModsMI);
        this.popup.add(this.cutModsMI);
        this.popup.add(this.pasteModsMI);
        this.popup.addSeparator();
        this.popup.add(this.upMI);
        this.popup.add(this.downMI);
        this.popup.addSeparator();
        this.popup.add(this.editMI);
        this.popup.add(this.defineMI);
        this.popup.addSeparator();
        this.popup.add(this.deleteMI);
        if (this.objects == null) {
            this.objects = new ArrayList();
        }
        this.model = new HeroModel();
        this.table = new JTable();
        this.table.setIntercellSpacing(new Dimension(3, 3));
        this.table.setModel(this.model);
        this.table.setShowGrid(true);
        this.table.setShowHorizontalLines(false);
        this.table.setShowVerticalLines(false);
        this.table.setCellSelectionEnabled(true);
        this.table.setRowSelectionAllowed(true);
        this.table.setColumnSelectionAllowed(false);
        this.table.getSelectionModel().setSelectionMode(0);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.getTableHeader().setDefaultRenderer(new HeroHeaderRenderer());
        this.table.getColumnModel().getColumn(0).setHeaderValue(this.column1);
        this.table.getColumnModel().getColumn(1).setHeaderValue(this.column2);
        if (this.col3Present) {
            this.table.getColumnModel().getColumn(2).setHeaderValue(this.column3);
        }
        this.table.setAutoResizeMode(1);
        this.table.getColumnModel().getColumn(0).setResizable(false);
        this.table.getColumnModel().getColumn(1).setResizable(false);
        if (this.col3Present) {
            this.table.getColumnModel().getColumn(2).setResizable(false);
        }
        this.table.getColumnModel().getColumn(0).setMaxWidth(60);
        this.table.getColumnModel().getColumn(0).setMinWidth(60);
        if (this.col3Present) {
            this.table.getColumnModel().getColumn(2).setMaxWidth(40);
            this.table.getColumnModel().getColumn(2).setMinWidth(40);
        }
        this.table.setDefaultRenderer(String.class, new HeroRenderer());
        this.table.setDefaultEditor(String.class, new HeroEditor());
        this.insertBtn = new JButton("Insert At End");
        this.insertBefore = false;
        Image image = Toolkit.getDefaultToolkit().createImage(ClassLoader.getSystemResource("up.gif"));
        this.upBtn = new JButton(new ImageIcon(image));
        this.upBtn.setEnabled(false);
        this.upBtn.setMargin(new Insets(0, 0, 0, 0));
        Image image2 = Toolkit.getDefaultToolkit().createImage(ClassLoader.getSystemResource("down.gif"));
        this.downBtn = new JButton(new ImageIcon(image2));
        this.downBtn.setEnabled(false);
        this.downBtn.setMargin(new Insets(0, 0, 0, 0));
        this.editBtn = new JButton("Edit");
        this.editBtn.setEnabled(false);
        this.deleteBtn = new JButton("Delete");
        this.deleteBtn.setEnabled(false);
    }

    private void layoutComponent() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 15;
        this.scroll = new JScrollPane(this.table);
        this.scroll.getViewport().setBackground(Color.white);
        this.scroll.getVerticalScrollBar().setUnitIncrement(10);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.scroll, "Center");
        this.getContentPane().add((Component)this.getButtonPanel(), "South");
    }

    private void normalize() {
        for (int i = 0; i < this.objects.size(); ++i) {
            GenericObject genericObject = this.objects.get(i);
            genericObject.setPosition(i);
        }
        this.syncSelectedIndex();
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.table.getSelectionModel().removeListSelectionListener(selectionListener);
    }

    protected void setCopyAction(ActionListener actionListener) {
        if (this.copyListener != null) {
            this.copyMI.removeActionListener(this.copyListener);
        }
        this.copyMI.addActionListener(actionListener);
        this.copyListener = actionListener;
    }

    protected void setCutAction(ActionListener actionListener) {
        if (this.cutListener != null) {
            this.cutMI.removeActionListener(this.cutListener);
        }
        this.cutMI.addActionListener(actionListener);
        this.cutListener = actionListener;
    }

    public void setData(ArrayList<GenericObject> arrayList) {
        this.objects = arrayList;
        this.updateTotal();
        this.syncSelectedIndex();
    }

    protected void setPasteAction(ActionListener actionListener) {
        if (this.pasteListener != null) {
            this.pasteMI.removeActionListener(this.pasteListener);
        }
        this.pasteMI.addActionListener(actionListener);
        this.pasteListener = actionListener;
    }

    public synchronized void setSelectedIndex(int n, boolean bl) {
        Cloneable cloneable;
        if (!this.locked) {
            this.table.requestFocus();
        }
        if (n < 0 || n >= this.objects.size()) {
            return;
        }
        this.selectedIndex = n;
        if (this.selectedIndex < 0 && !this.locked) {
            this.requestFocus(true);
        }
        if (this.selectedIndex >= 0) {
            if (this.table.getSelectedRow() != this.selectedIndex) {
                this.table.setRowSelectionInterval(this.selectedIndex, this.selectedIndex);
            }
        } else {
            this.table.clearSelection();
        }
        this.upBtn.setEnabled(this.checkUp());
        this.downBtn.setEnabled(this.checkDown());
        if (this.selectedIndex >= 0 && this.objects.get(this.selectedIndex) != null) {
            cloneable = this.objects.get(this.selectedIndex);
            this.deleteBtn.setEnabled(!(this.objects.get(this.selectedIndex) instanceof Adder));
            if (!(cloneable instanceof List) || ((GenericObject)cloneable).getTextOutput().trim().length() != 0) {
                this.editBtn.setEnabled(!(this.objects.get(this.selectedIndex) instanceof Adder));
                if (bl && !(this.objects.get(this.selectedIndex) instanceof Adder)) {
                    this.editBtn.doClick();
                }
            }
        } else {
            this.editBtn.setEnabled(false);
            this.deleteBtn.setEnabled(false);
        }
        if (this.selectedIndex >= 0 && this.insertBefore) {
            this.insertBtn.setText("Insert Before");
        } else if (this.insertBefore) {
            this.insertBtn.setText("Insert At Top");
        } else if (this.selectedIndex >= 0) {
            this.insertBtn.setText("Insert After");
        } else {
            this.insertBtn.setText("Insert At End");
        }
        if (this.selectedIndex >= 0 && !this.locked) {
            cloneable = this.table.getCellRect(this.selectedIndex, 1, true);
            ((Rectangle)cloneable).setRect(((Rectangle)cloneable).getX(), ((Rectangle)cloneable).getY() + 30.0, ((Rectangle)cloneable).getWidth(), ((Rectangle)cloneable).getHeight());
            this.table.scrollRectToVisible((Rectangle)cloneable);
        }
        this.syncSelectedIndex();
    }

    public void setTotalCost() {
        Comparable comparable;
        if (this.type.equals("Disadvantages") || this.type.equals("Complications")) {
            if (HeroDesigner.getActiveTemplate().is6E()) {
                this.type = "Complications";
                this.table.getColumnModel().getColumn(1).setHeaderValue("Complication");
            } else {
                this.type = "Disadvantages";
                this.table.getColumnModel().getColumn(1).setHeaderValue("Disadvantage");
            }
        }
        if (this.totalCostCalcTime > 0L && this.totalCostCalcTime > HeroDesigner.lastEdit) {
            return;
        }
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        long l = System.currentTimeMillis();
        boolean bl = this.type.equals("Equipment");
        for (int i = 0; i < this.objects.size(); ++i) {
            comparable = this.objects.get(i);
            d = bl ? (d += ((GenericObject)comparable).getTotalPrice()) : (d += ((GenericObject)comparable).getRealCost());
            if (((GenericObject)comparable).isCarried()) {
                d2 += ((GenericObject)comparable).getTotalWeight();
            }
            this.thisTotal = d;
            this.thisCarried = d2;
            this.thisWeight = d3 += ((GenericObject)comparable).getTotalWeight();
            this.lastSet = l;
        }
        String string = "" + Rounder.roundUp(d);
        comparable = new BigDecimal(d2);
        comparable = ((BigDecimal)comparable).setScale(2, 4);
        String string2 = ((BigDecimal)comparable).toString() + (HeroDesigner.getInstance().getPrefs().isMetric() ? " kg" : " lbs");
        comparable = new BigDecimal(d3);
        comparable = ((BigDecimal)comparable).setScale(2, 4);
        String string3 = ((BigDecimal)comparable).toString() + (HeroDesigner.getInstance().getPrefs().isMetric() ? " kg" : " lbs");
        if (bl) {
            comparable = new BigDecimal(d);
            comparable = ((BigDecimal)comparable).setScale(HeroDesigner.getActiveHero().getRules().getEquipmentCostDecimalPlaces(), 4);
            string = ((BigDecimal)comparable).toString();
            string = HeroDesigner.getActiveHero().getRules().isEquipmentUnitsPrefix() ? HeroDesigner.getActiveHero().getRules().getEquipmentCostUnits() + string : string + HeroDesigner.getActiveHero().getRules().getEquipmentCostUnits();
        }
        double d4 = HeroDesigner.getActiveHero().getSpentTotal();
        double d5 = HeroDesigner.getActiveHero().getBasePoints() + HeroDesigner.getActiveHero().getDisadPoints() + HeroDesigner.getActiveHero().getExperience();
        if (HeroDesigner.getActiveTemplate().is6E()) {
            d5 -= (double)HeroDesigner.getActiveHero().getDisadPoints();
        }
        if (bl) {
            this.setTitle(this.type + " Totals -- Cost: " + string + ", Carried: " + string2 + ", Weight: " + string3);
        } else {
            this.setTitle(this.type + " -- Total " + this.type + (bl ? " Cost: " : " Points: ") + string + (bl ? "" : " (Total Spent: " + Rounder.roundUp(d4) + (HeroDesigner.getActiveHero().isPrefab() ? "" : "/" + Rounder.roundUp(d5)) + ")"));
        }
    }

    private void syncSelectedIndex() {
        int n = this.table.getSelectedRow();
        if (n != this.selectedIndex) {
            System.out.println("Selected index out of sync!  Resetting...");
            this.selectedIndex = n;
            this.setSelectedIndex(this.selectedIndex, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTotal() {
        if (this instanceof SkillList) {
            ((SkillList)this).setEnhancerLists();
        }
        if (this instanceof PerksList) {
            ((PerksList)this).setEnhancerLists();
        }
        this.setTotalCost();
        int n = this.selectedIndex;
        this.model.fireTableDataChanged();
        if (n < 0) {
            n = -1;
        }
        if (n >= this.objects.size()) {
            n = this.objects.size() - 1;
        }
        this.locked = true;
        JTable jTable = this.table;
        synchronized (jTable) {
            this.setSelectedIndex(n, false);
        }
        for (UpdateListener updateListener : this.listeners) {
            updateListener.updatePerformed();
        }
        this.syncSelectedIndex();
        this.locked = false;
    }

    private class HeroModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 5084721192653813290L;

        private HeroModel() {
        }

        @Override
        public void fireTableDataChanged() {
            GenericObjectList.this.table.setPreferredScrollableViewportSize(GenericObjectList.this.scroll.getViewport().getSize());
            super.fireTableDataChanged();
            int n = -1;
            for (GenericObject genericObject : GenericObjectList.this.objects) {
                genericObject.setPosition(++n);
                Component component = GenericObjectList.this.table.getCellRenderer(n, 1).getTableCellRendererComponent(GenericObjectList.this.table, GenericObjectList.this.table.getValueAt(n, 1), false, false, n, 1);
                int n2 = component.getPreferredSize().height;
                if (n2 < 10) {
                    n2 = 20;
                }
                GenericObjectList.this.table.setRowHeight(n, n2 + 3);
            }
            if (GenericObjectList.this.selectedIndex >= 0 && GenericObjectList.this.objects.size() > 0) {
                if (GenericObjectList.this.selectedIndex >= GenericObjectList.this.objects.size()) {
                    GenericObjectList.this.selectedIndex = GenericObjectList.this.objects.size() - 1;
                }
                GenericObjectList.this.table.clearSelection();
                GenericObjectList.this.table.setRowSelectionInterval(GenericObjectList.this.selectedIndex, GenericObjectList.this.selectedIndex);
            } else {
                GenericObjectList.this.table.clearSelection();
            }
        }

        public Class getColumnClass(int n) {
            return String.class;
        }

        @Override
        public int getColumnCount() {
            return GenericObjectList.this.col3Present ? 3 : 2;
        }

        @Override
        public int getRowCount() {
            return GenericObjectList.this.objects.size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            GenericObject genericObject = GenericObjectList.this.objects.get(n);
            switch (n2) {
                case 0: {
                    return genericObject.getColumn1Output();
                }
                case 1: {
                    return genericObject.getTableColumn2Output(GenericObjectList.this.table.getColumnModel().getColumn(1).getWidth());
                }
                case 2: {
                    return genericObject.getColumn3Output();
                }
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 1;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (n2 == 1) {
                GenericObject genericObject = GenericObjectList.this.objects.get(n);
                genericObject.setTextOutput(object.toString());
            }
        }
    }

    private class HeroHeaderRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = -8515500448995331098L;

        private HeroHeaderRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            JLabel jLabel = new JLabel();
            if (n2 == 0) {
                jLabel.setText(GenericObjectList.this.column1);
                jLabel.setHorizontalAlignment(4);
                jLabel.setHorizontalTextPosition(4);
            } else if (n2 == 2) {
                jLabel.setText(GenericObjectList.this.column3);
                jLabel.setHorizontalAlignment(0);
                jLabel.setHorizontalTextPosition(4);
            } else {
                if (GenericObjectList.this.column2.equals("Disadvantage")) {
                    jLabel.setText(HeroDesigner.getActiveTemplate().is6E() ? "Complication" : "Disadvantage");
                } else {
                    jLabel.setText(GenericObjectList.this.column2);
                }
                jLabel.setHorizontalAlignment(2);
                jLabel.setHorizontalTextPosition(4);
            }
            jLabel.setFont(jLabel.getFont().deriveFont(1));
            jLabel.setBorder(BorderFactory.createRaisedBevelBorder());
            jLabel.setOpaque(false);
            jLabel.setVerticalAlignment(0);
            return jLabel;
        }
    }

    private class HeroRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = -258890461916547952L;

        private HeroRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (n2 == 0) {
                jLabel.setHorizontalAlignment(4);
            } else if (n2 == 2) {
                jLabel.setHorizontalAlignment(0);
            } else {
                jLabel.setHorizontalAlignment(2);
                jLabel.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 5));
            }
            jLabel.setVerticalAlignment(1);
            return jLabel;
        }
    }

    private class HeroEditor
    extends DefaultCellEditor {
        private static final long serialVersionUID = -258890461916547952L;

        public HeroEditor() {
            super(new JTextField());
            this.setClickCountToStart(2);
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            GenericObject genericObject = GenericObjectList.this.objects.get(n);
            JComponent jComponent = (JComponent)super.getTableCellEditorComponent(jTable, genericObject.getTextOutput(), bl, n, n2);
            jComponent.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 5));
            return jComponent;
        }
    }

    public abstract class UpdateListener {
        public abstract void updatePerformed();
    }

    public abstract class SelectionListener
    implements ListSelectionListener {
        public abstract void selectionChanged(GenericObject var1);

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (GenericObjectList.this.table.getSelectedRow() >= 0) {
                this.selectionChanged(GenericObjectList.this.objects.get(GenericObjectList.this.table.getSelectedRow()));
            } else {
                this.selectionChanged(null);
            }
        }
    }
}

