/*
 * Decompiled with CFR 0.152.
 */
package com.hero.ui;

import com.hero.HeroDesigner;
import com.hero.Rules;
import com.hero.objects.GenericObject;
import com.hero.objects.List;
import com.hero.objects.characteristics.Strength;
import com.hero.objects.enhancers.Enhancer;
import com.hero.objects.martialarts.ExtraDamageClasses;
import com.hero.objects.martialarts.Maneuver;
import com.hero.objects.martialarts.RangedDamageClasses;
import com.hero.objects.martialarts.WeaponElement;
import com.hero.ui.GenericObjectList;
import com.hero.ui.widgets.PopupMessage;

public class EquipmentList
extends GenericObjectList {
    private static final long serialVersionUID = 465955563511162593L;

    public EquipmentList() {
        super("Equipment", "Cost", "Equipment", "END", HeroDesigner.getActiveHero().getEquipment());
    }

    @Override
    public void addObject(GenericObject genericObject) {
        GenericObject genericObject2;
        PopupMessage popupMessage;
        double d;
        genericObject.setIsEquipment(true);
        if (HeroDesigner.getActiveHero().isPrefab()) {
            super.addObject(genericObject);
            return;
        }
        genericObject.setPower(true);
        boolean bl = true;
        boolean bl2 = false;
        Rules rules = HeroDesigner.getActiveHero().getRules();
        if (!bl2 && rules.getAttackAPMaxResponse() > 0 && genericObject.getTypes().contains("ATTACK") && (d = genericObject.getActiveCost()) > (double)rules.getAttackAPMaxValue()) {
            popupMessage = PopupMessage.getInstance(HeroDesigner.getAppFrame(), this, "This Attack exceeds the maximum Active Points for an Attack set in the campaign rules.", rules.getAttackAPMaxResponse() == 1);
            popupMessage.setVisible(true);
            bl2 = true;
            boolean bl3 = bl = rules.getAttackAPMaxResponse() == 1;
        }
        if (!bl2 && rules.getDefenseAPMaxResponse() > 0 && genericObject.getTypes().contains("DEFENSE") && (d = genericObject.getActiveCost()) > (double)rules.getDefenseAPMaxValue()) {
            popupMessage = PopupMessage.getInstance(HeroDesigner.getAppFrame(), this, "This Defense ability exceeds the maximum Active Points for a Defense ability set in the campaign rules.", rules.getDefenseAPMaxResponse() == 1);
            popupMessage.setVisible(true);
            bl2 = true;
            boolean bl4 = bl = rules.getDefenseAPMaxResponse() == 1;
        }
        if (!bl2 && rules.getEquipmentCostResponse() > 0) {
            d = 0.0;
            for (int i = 0; i < HeroDesigner.getActiveHero().getEquipment().size(); ++i) {
                genericObject2 = HeroDesigner.getActiveHero().getEquipment().get(i);
                d += genericObject2.getTotalPrice();
            }
            if (genericObject.getPrice() > 0.0 && genericObject.getTotalPrice() + d > (double)rules.getEquipmentCostValue()) {
                PopupMessage popupMessage2 = PopupMessage.getInstance(HeroDesigner.getAppFrame(), this, "This purchase puts you over the max total value (in " + rules.getEquipmentCostUnits() + ") set in the campaign rules.", rules.getEquipmentCostResponse() == 1);
                popupMessage2.setVisible(true);
                bl2 = true;
                boolean bl5 = bl = rules.getEquipmentCostResponse() == 1;
            }
        }
        if (!bl2 && genericObject.isCarried() && HeroDesigner.getActiveHero().getCharacteristic(1) != null) {
            d = genericObject.getTotalWeight();
            for (int i = 0; i < HeroDesigner.getActiveHero().getEquipment().size(); ++i) {
                genericObject2 = HeroDesigner.getActiveHero().getEquipment().get(i);
                if (!genericObject2.isCarried()) continue;
                d += genericObject2.getTotalWeight();
            }
            Strength strength = (Strength)HeroDesigner.getActiveHero().getCharacteristic(1);
            double d2 = 25.0;
            double d3 = 25.0;
            double d4 = strength.getPrimaryValue() / 5.0;
            double d5 = strength.getSecondaryValue() / 5.0;
            d2 = d4 > 0.0 ? Math.pow(2.0, d4) * d2 : (d2 /= Math.pow(2.0, Math.abs(d4)));
            d3 = d5 > 0.0 ? Math.pow(2.0, d5) * d3 : (d3 /= Math.pow(2.0, Math.abs(d5)));
            if (!HeroDesigner.getInstance().getPrefs().isMetric()) {
                d2 /= 0.4535924;
                d3 /= 0.4535924;
            }
            if (d > d2) {
                PopupMessage popupMessage3 = PopupMessage.getInstance(HeroDesigner.getAppFrame(), this, "This purchase puts the total weight of Equipment carried by the character over the amount he can lift (primary STR).", true);
                popupMessage3.setVisible(true);
                bl2 = true;
            } else if (d > d3) {
                PopupMessage popupMessage4 = PopupMessage.getInstance(HeroDesigner.getAppFrame(), this, "This purchase puts the total weight of Equipment carried by the character over the amount he can lift (secondary STR).", true);
                popupMessage4.setVisible(true);
                bl2 = true;
            }
        }
        if (bl) {
            super.addObject(genericObject);
        }
    }

    @Override
    protected boolean checkPaste() {
        GenericObject genericObject = HeroDesigner.getCopyBuffer();
        if (genericObject == null) {
            return false;
        }
        if (genericObject instanceof Maneuver || genericObject instanceof ExtraDamageClasses || genericObject instanceof RangedDamageClasses || genericObject instanceof WeaponElement) {
            return false;
        }
        if (genericObject instanceof Enhancer) {
            return false;
        }
        if (genericObject instanceof List) {
            List list = (List)genericObject;
            for (int i = 0; i < list.getObjects().size(); ++i) {
                if (!(list.getObjects().get(i) instanceof Maneuver) && !(list.getObjects().get(i) instanceof ExtraDamageClasses) && !(list.getObjects().get(i) instanceof RangedDamageClasses) && !(list.getObjects().get(i) instanceof WeaponElement)) continue;
                return false;
            }
            return true;
        }
        return true;
    }

    @Override
    protected boolean checkReplace(GenericObject genericObject, GenericObject genericObject2) {
        GenericObject genericObject3;
        PopupMessage popupMessage;
        double d;
        genericObject.setIsEquipment(true);
        if (HeroDesigner.getActiveHero().isPrefab()) {
            return true;
        }
        boolean bl = true;
        boolean bl2 = false;
        Rules rules = HeroDesigner.getActiveHero().getRules();
        if (!bl2 && rules.getAttackAPMaxResponse() > 0 && genericObject.getTypes().contains("ATTACK") && (d = genericObject.getActiveCost()) > (double)rules.getAttackAPMaxValue() && d > genericObject2.getActiveCost()) {
            popupMessage = PopupMessage.getInstance(HeroDesigner.getAppFrame(), this, "This Attack exceeds the maximum Active Points for an Attack set in the campaign rules.", rules.getAttackAPMaxResponse() == 1);
            popupMessage.setVisible(true);
            bl2 = true;
            boolean bl3 = bl = rules.getAttackAPMaxResponse() == 1;
        }
        if (!bl2 && rules.getDefenseAPMaxResponse() > 0 && genericObject.getTypes().contains("DEFENSE") && (d = genericObject.getActiveCost()) > (double)rules.getDefenseAPMaxValue() && d > genericObject2.getActiveCost()) {
            popupMessage = PopupMessage.getInstance(HeroDesigner.getAppFrame(), this, "This Defense ability exceeds the maximum Active Points for a Defense ability set in the campaign rules.", rules.getDefenseAPMaxResponse() == 1);
            popupMessage.setVisible(true);
            bl2 = true;
            boolean bl4 = bl = rules.getDefenseAPMaxResponse() == 1;
        }
        if (!bl2 && rules.getEquipmentCostResponse() > 0 && genericObject.getTotalPrice() > genericObject2.getTotalPrice()) {
            d = 0.0;
            for (int i = 0; i < HeroDesigner.getActiveHero().getEquipment().size(); ++i) {
                genericObject3 = HeroDesigner.getActiveHero().getEquipment().get(i);
                d += genericObject3.getTotalPrice();
            }
            if (genericObject.getPrice() > 0.0 && genericObject.getTotalPrice() + d > (double)rules.getEquipmentCostValue()) {
                PopupMessage popupMessage2 = PopupMessage.getInstance(HeroDesigner.getAppFrame(), this, "This purchase puts you over the max total value (in " + rules.getEquipmentCostUnits() + ") set in the campaign rules.", rules.getEquipmentCostResponse() == 1);
                popupMessage2.setVisible(true);
                bl2 = true;
                boolean bl5 = bl = rules.getEquipmentCostResponse() == 1;
            }
        }
        if (!bl2 && genericObject.isCarried() && (genericObject.getTotalWeight() > genericObject2.getTotalWeight() || !genericObject2.isCarried()) && HeroDesigner.getActiveHero().getCharacteristic(1) != null) {
            d = genericObject.getTotalWeight();
            for (int i = 0; i < HeroDesigner.getActiveHero().getEquipment().size(); ++i) {
                genericObject3 = HeroDesigner.getActiveHero().getEquipment().get(i);
                if (!genericObject3.isCarried()) continue;
                d += genericObject3.getTotalWeight();
            }
            Strength strength = (Strength)HeroDesigner.getActiveHero().getCharacteristic(1);
            double d2 = 25.0;
            double d3 = 25.0;
            double d4 = strength.getPrimaryValue() / 5.0;
            double d5 = strength.getSecondaryValue() / 5.0;
            d2 = d4 > 0.0 ? Math.pow(2.0, d4) * d2 : (d2 /= Math.pow(2.0, Math.abs(d4)));
            d3 = d5 > 0.0 ? Math.pow(2.0, d5) * d3 : (d3 /= Math.pow(2.0, Math.abs(d5)));
            if (!HeroDesigner.getInstance().getPrefs().isMetric()) {
                d2 /= 0.4535924;
                d3 /= 0.4535924;
            }
            if (d > d2) {
                PopupMessage popupMessage3 = PopupMessage.getInstance(HeroDesigner.getAppFrame(), this, "This purchase puts the total weight of Equipment carried by the character over the amount he can lift (primary STR).", true);
                popupMessage3.setVisible(true);
                bl2 = true;
            } else if (d > d3) {
                PopupMessage popupMessage4 = PopupMessage.getInstance(HeroDesigner.getAppFrame(), this, "This purchase puts the total weight of Equipment carried by the character over the amount he can lift (secondary STR).", true);
                popupMessage4.setVisible(true);
                bl2 = true;
            }
        }
        return bl;
    }
}

