/*
 * Decompiled with CFR 0.152.
 */
package com.hero.ui;

import com.hero.HeroDesigner;
import com.hero.objects.GenericObject;
import com.hero.ui.AbilityPanel;
import com.hero.ui.DisadsList;
import com.hero.ui.GenericObjectList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public class DisadsPanel
extends AbilityPanel {
    private static final long serialVersionUID = 4822707714467319940L;

    protected void checkIndices() {
        this.selectionList.checkIndices();
    }

    @Override
    protected GenericObjectList createSelectionList() {
        return new DisadsList();
    }

    @Override
    protected String getAvailableLabel() {
        if (HeroDesigner.getActiveTemplate().is6E()) {
            return "Complications";
        }
        return "Disadvantages";
    }

    @Override
    protected ArrayList<GenericObject> getAvailableObjects() {
        return HeroDesigner.getActiveTemplate().getDisads();
    }

    @Override
    protected ArrayList<GenericObject> getAvailablePrefabs() {
        return HeroDesigner.getInstance().getPrefabDisads();
    }

    @Override
    protected ArrayList<GenericObject> getObjects() {
        return HeroDesigner.getActiveHero().getDisads();
    }

    @Override
    protected boolean isEquipment() {
        return false;
    }

    @Override
    protected boolean isPower() {
        return false;
    }

    @Override
    public void reset() {
        this.selectionList.setData(HeroDesigner.getActiveHero().getDisads());
        this.availableList.setAvailableList(HeroDesigner.getActiveTemplate().getDisads());
        this.availableTab.setTitleAt(0, HeroDesigner.getActiveTemplate().is6E() ? "Complications" : "Disadvantages");
    }

    @Override
    public void updateTotal() {
        if (HeroDesigner.getActiveHero().isNCMSelected()) {
            if (GenericObject.findObjectByID(HeroDesigner.getActiveHero().getDisads(), "NCM") == null) {
                HeroDesigner.getActiveHero().getDisads().add(HeroDesigner.getActiveHero().getNCMObject());
                if (HeroDesigner.getActiveHero().getAgeObject() != null) {
                    HeroDesigner.getActiveHero().getDisads().add(HeroDesigner.getActiveHero().getAgeObject());
                }
            }
            Collections.sort(HeroDesigner.getActiveHero().getDisads(), new Comparator(){

                public int compare(Object object, Object object2) {
                    if (object instanceof GenericObject && object2 instanceof GenericObject) {
                        GenericObject genericObject = (GenericObject)object;
                        GenericObject genericObject2 = (GenericObject)object2;
                        return genericObject.getPosition() - genericObject2.getPosition();
                    }
                    return object.toString().compareTo(object2.toString());
                }
            });
        } else if (GenericObject.findObjectByID(HeroDesigner.getActiveHero().getDisads(), "NCM") != null) {
            HeroDesigner.getActiveHero().getDisads().remove(HeroDesigner.getActiveHero().getNCMObject());
            if (HeroDesigner.getActiveHero().getAgeObject() != null) {
                HeroDesigner.getActiveHero().getDisads().remove(HeroDesigner.getActiveHero().getAgeObject());
            }
        }
        super.updateTotal();
    }
}

