/*
 * Decompiled with CFR 0.152.
 */
package com.hero.ui;

import com.hero.HeroDesigner;
import com.hero.objects.Adder;
import com.hero.objects.GenericObject;
import com.hero.objects.List;
import com.hero.objects.powers.CompoundPower;
import com.hero.ui.AbilityPanel;
import com.hero.ui.CompoundPowerList;
import com.hero.ui.GenericObjectList;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;

public class CompoundPowerPanel
extends AbilityPanel {
    private static final long serialVersionUID = 3259674678685251145L;
    CompoundPower parent;

    public CompoundPowerPanel(CompoundPower compoundPower) {
        super(false);
        this.parent = compoundPower;
        this.initWidgets();
        this.initListeners();
        this.layoutComponent();
    }

    public void addUpdateListener(GenericObjectList.UpdateListener updateListener) {
        this.selectionList.addUpdateListener(updateListener);
    }

    @Override
    protected GenericObjectList createSelectionList() {
        return new CompoundPowerList(this.parent);
    }

    @Override
    protected String getAvailableLabel() {
        return "Powers";
    }

    @Override
    protected ArrayList<GenericObject> getAvailableObjects() {
        ArrayList<GenericObject> arrayList = HeroDesigner.getActiveTemplate().getPowers();
        if (GenericObject.findObjectByID(this.parent.getPowers(), "COMPOUNDPOWER") != null) {
            arrayList.remove(GenericObject.findObjectByID(this.parent.getPowers(), "COMPOUNDPOWER"));
        }
        return arrayList;
    }

    @Override
    protected ArrayList<GenericObject> getAvailablePrefabs() {
        return HeroDesigner.getInstance().getPrefabEquipment();
    }

    @Override
    protected ArrayList<GenericObject> getObjects() {
        return this.parent.getPowers();
    }

    @Override
    public GenericObjectList getSelectionList() {
        return this.selectionList;
    }

    @Override
    protected void initListeners() {
        super.initListeners();
        this.selectionList.setPasteAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object;
                GenericObject genericObject = HeroDesigner.getCopyBuffer();
                if (genericObject instanceof Adder) {
                    return;
                }
                genericObject.resetID();
                int n = CompoundPowerPanel.this.selectionList.getInsertionIndex();
                if (CompoundPowerPanel.this.selectionList.insertBefore && n > 0) {
                    --n;
                }
                ArrayList<Object> arrayList = new ArrayList();
                if (genericObject instanceof List) {
                    object = (List)genericObject;
                    arrayList = ((List)object).getObjects();
                } else if (genericObject instanceof CompoundPower) {
                    object = (CompoundPower)genericObject;
                    arrayList = ((CompoundPower)object).getPowers();
                }
                genericObject.setIsEquipment(CompoundPowerPanel.this.isEquipment());
                genericObject.setPower(CompoundPowerPanel.this.isPower());
                for (GenericObject genericObject2 : arrayList) {
                    GenericObject genericObject22 = genericObject2.clone();
                    genericObject22.resetID();
                    genericObject22.setParent(null);
                    genericObject22.setIsEquipment(CompoundPowerPanel.this.isEquipment());
                    genericObject22.setPower(CompoundPowerPanel.this.isPower());
                    genericObject22.setMainPower(CompoundPowerPanel.this.parent);
                    CompoundPowerPanel.this.selectionList.addObject(genericObject22);
                }
                if (!(genericObject instanceof List) && !(genericObject instanceof CompoundPower)) {
                    genericObject.setMainPower(CompoundPowerPanel.this.parent);
                    CompoundPowerPanel.this.selectionList.addObject(genericObject);
                }
                CompoundPowerPanel.this.selectionList.checkIndices();
                HeroDesigner.getActiveHero().setDirty(true);
            }
        });
    }

    @Override
    protected boolean isEquipment() {
        return this.parent.isEquipment();
    }

    @Override
    protected boolean isPower() {
        return true;
    }

    @Override
    protected void layoutComponent() {
        this.add((Component)this.selectionList, "Center");
        this.listMenu.setVisible(false);
    }

    @Override
    public void reset() {
    }
}

