/*
 * Decompiled with CFR 0.152.
 */
package com.hero.ui;

import com.hero.HeroDesigner;
import com.hero.Rules;
import com.hero.objects.GenericObject;
import com.hero.objects.List;
import com.hero.objects.enhancers.Enhancer;
import com.hero.objects.martialarts.Maneuver;
import com.hero.objects.powers.CompoundPower;
import com.hero.ui.GenericObjectList;
import com.hero.ui.dialog.AvailablePowersDialog;
import com.hero.ui.dialog.CompoundPowerDialog;
import com.hero.ui.widgets.PopupMessage;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;

public class CompoundPowerList
extends GenericObjectList {
    private static final long serialVersionUID = 2447924922730948445L;
    protected JButton addPowerBtn;
    protected CompoundPower parent;

    public CompoundPowerList(CompoundPower compoundPower) {
        super("Compound Power", "Cost", "Power", "END", compoundPower.getPowers());
        this.parent = compoundPower;
        this.updateTotal();
    }

    @Override
    public void addObject(GenericObject genericObject) {
        PopupMessage popupMessage;
        double d;
        if (HeroDesigner.getActiveHero().isPrefab()) {
            super.addObject(genericObject);
            return;
        }
        genericObject.setPower(true);
        genericObject.setMainPower(this.parent);
        boolean bl = true;
        boolean bl2 = false;
        Rules rules = HeroDesigner.getActiveHero().getRules();
        if (!bl2 && rules.getAttackAPMaxResponse() > 0 && genericObject.getTypes().contains("ATTACK") && (d = genericObject.getActiveCost()) > (double)rules.getAttackAPMaxValue()) {
            popupMessage = PopupMessage.getInstance(HeroDesigner.getAppFrame(), this, "This Attack exceeds the maximum Active Points for an Attack set in the campaign rules.", rules.getAttackAPMaxResponse() == 1);
            popupMessage.setVisible(true);
            bl2 = true;
            boolean bl3 = bl = rules.getAttackAPMaxResponse() == 1;
        }
        if (!bl2 && rules.getDefenseAPMaxResponse() > 0 && genericObject.getTypes().contains("DEFENSE") && (d = genericObject.getActiveCost()) > (double)rules.getDefenseAPMaxValue()) {
            popupMessage = PopupMessage.getInstance(HeroDesigner.getAppFrame(), this, "This Defense ability exceeds the maximum Active Points for a Defense ability set in the campaign rules.", rules.getDefenseAPMaxResponse() == 1);
            popupMessage.setVisible(true);
            bl2 = true;
            boolean bl4 = bl = rules.getDefenseAPMaxResponse() == 1;
        }
        if (bl) {
            super.addObject(genericObject);
        }
    }

    @Override
    protected boolean checkPaste() {
        GenericObject genericObject = HeroDesigner.getCopyBuffer();
        if (genericObject == null) {
            return false;
        }
        if (genericObject instanceof Maneuver) {
            return false;
        }
        if (genericObject instanceof Enhancer) {
            return false;
        }
        if (genericObject instanceof CompoundPower) {
            return false;
        }
        if (genericObject instanceof List) {
            List list = (List)genericObject;
            for (int i = 0; i < list.getObjects().size(); ++i) {
                if (!(list.getObjects().get(i) instanceof Maneuver)) continue;
                return false;
            }
            return true;
        }
        return true;
    }

    @Override
    protected boolean checkReplace(GenericObject genericObject, GenericObject genericObject2) {
        PopupMessage popupMessage;
        double d;
        if (HeroDesigner.getActiveHero().isPrefab()) {
            return true;
        }
        boolean bl = true;
        boolean bl2 = false;
        Rules rules = HeroDesigner.getActiveHero().getRules();
        if (!bl2 && rules.getAttackAPMaxResponse() > 0 && genericObject.getTypes().contains("ATTACK") && (d = genericObject.getActiveCost()) > (double)rules.getAttackAPMaxValue() && d > genericObject2.getActiveCost()) {
            popupMessage = PopupMessage.getInstance(HeroDesigner.getAppFrame(), this, "This Attack exceeds the maximum Active Points for an Attack set in the campaign rules.", rules.getAttackAPMaxResponse() == 1);
            popupMessage.setVisible(true);
            bl2 = true;
            boolean bl3 = bl = rules.getAttackAPMaxResponse() == 1;
        }
        if (!bl2 && rules.getDefenseAPMaxResponse() > 0 && genericObject.getTypes().contains("DEFENSE") && (d = genericObject.getActiveCost()) > (double)rules.getDefenseAPMaxValue() && d > genericObject2.getActiveCost()) {
            popupMessage = PopupMessage.getInstance(HeroDesigner.getAppFrame(), this, "This Defense ability exceeds the maximum Active Points for a Defense ability set in the campaign rules.", rules.getDefenseAPMaxResponse() == 1);
            popupMessage.setVisible(true);
            bl2 = true;
            bl = rules.getDefenseAPMaxResponse() == 1;
        }
        return bl;
    }

    @Override
    protected JPanel getButtonPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(1));
        jPanel.add(this.downBtn);
        jPanel.add(this.addPowerBtn);
        jPanel.add(this.editBtn);
        jPanel.add(this.insertBtn);
        jPanel.add(this.deleteBtn);
        jPanel.add(this.upBtn);
        jPanel.setOpaque(false);
        return jPanel;
    }

    @Override
    protected void initListeners() {
        super.initListeners();
        this.addPowerBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Container container;
                for (container = CompoundPowerList.this.getParent(); container != null && !(container instanceof CompoundPowerDialog); container = container.getParent()) {
                }
                AvailablePowersDialog availablePowersDialog = new AvailablePowersDialog(CompoundPowerList.this.parent, (JDialog)container);
                availablePowersDialog.setLocationRelativeTo(CompoundPowerList.this);
                availablePowersDialog.setVisible(true);
                CompoundPowerList.this.updateTotal();
                ((CompoundPowerDialog)container).updateValues();
            }
        });
    }

    @Override
    protected void initWidgets() {
        super.initWidgets();
        this.addPowerBtn = new JButton("Add");
    }

    @Override
    public void setTotalCost() {
        this.setTitle("Component Powers");
    }
}

