/*
 * Decompiled with CFR 0.152.
 */
package com.hero.ui;

import com.hero.HeroDesigner;
import com.hero.objects.Adder;
import com.hero.objects.GenericObject;
import com.hero.objects.characteristics.Characteristic;
import com.hero.ui.CharacteristicRow;
import com.hero.util.Rounder;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class CharacteristicsPanel
extends JPanel {
    private static final long serialVersionUID = 8359793380568478019L;
    private JLabel baseLbl;
    ArrayList<CharacteristicRow> characteristicRows;
    private JLabel charLbl;
    private JLabel charTotalLbl;
    protected long lastUpdateTime;
    private JLabel levelsLbl;
    JCheckBox ncmCheck;
    JComboBox ncmOptions;
    JTextField ncmTF;
    JLabel ncmValueLbl;
    private JLabel notesLbl;
    private JLabel pointsLbl;
    private JLabel rollLbl;
    private JLabel totalLbl;
    private JLabel totalValueLbl;

    public CharacteristicsPanel() {
        super(new GridBagLayout());
        this.initWidgets();
        this.initListeners();
        this.layoutComponent();
    }

    private void initListeners() {
        if (this.ncmCheck != null) {
            this.ncmTF.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void changedUpdate(DocumentEvent documentEvent) {
                    HeroDesigner.getActiveHero().getFullNCMObject().setAlias(CharacteristicsPanel.this.ncmTF.getText());
                    if (GenericObject.findObjectByID(HeroDesigner.getActiveHero().getDisads(), "NCM") != null) {
                        HeroDesigner.getActiveHero().getDisads().remove(HeroDesigner.getActiveHero().getNCMObject());
                        if (HeroDesigner.getActiveHero().getAgeObject() != null) {
                            HeroDesigner.getActiveHero().getDisads().remove(HeroDesigner.getActiveHero().getAgeObject());
                        }
                    }
                    HeroDesigner.getActiveHero().getFullNCMObject().setAlias(CharacteristicsPanel.this.ncmTF.getText());
                    if (GenericObject.findObjectByID(HeroDesigner.getActiveHero().getDisads(), "NCM") == null) {
                        HeroDesigner.getActiveHero().getDisads().add(HeroDesigner.getActiveHero().getNCMObject());
                        if (HeroDesigner.getActiveHero().getAgeObject() != null) {
                            HeroDesigner.getActiveHero().getDisads().add(HeroDesigner.getActiveHero().getAgeObject());
                        }
                    }
                    HeroDesigner.getActiveHero().setDirty(true);
                    CharacteristicsPanel.this.updateTotal();
                }

                @Override
                public void insertUpdate(DocumentEvent documentEvent) {
                    if (GenericObject.findObjectByID(HeroDesigner.getActiveHero().getDisads(), "NCM") != null) {
                        HeroDesigner.getActiveHero().getDisads().remove(HeroDesigner.getActiveHero().getNCMObject());
                        if (HeroDesigner.getActiveHero().getAgeObject() != null) {
                            HeroDesigner.getActiveHero().getDisads().remove(HeroDesigner.getActiveHero().getAgeObject());
                        }
                    }
                    HeroDesigner.getActiveHero().getFullNCMObject().setAlias(CharacteristicsPanel.this.ncmTF.getText());
                    if (GenericObject.findObjectByID(HeroDesigner.getActiveHero().getDisads(), "NCM") == null) {
                        HeroDesigner.getActiveHero().getDisads().add(HeroDesigner.getActiveHero().getNCMObject());
                        if (HeroDesigner.getActiveHero().getAgeObject() != null) {
                            HeroDesigner.getActiveHero().getDisads().add(HeroDesigner.getActiveHero().getAgeObject());
                        }
                    }
                    HeroDesigner.getActiveHero().setDirty(true);
                    CharacteristicsPanel.this.updateTotal();
                }

                @Override
                public void removeUpdate(DocumentEvent documentEvent) {
                    if (GenericObject.findObjectByID(HeroDesigner.getActiveHero().getDisads(), "NCM") != null) {
                        HeroDesigner.getActiveHero().getDisads().remove(HeroDesigner.getActiveHero().getNCMObject());
                        if (HeroDesigner.getActiveHero().getAgeObject() != null) {
                            HeroDesigner.getActiveHero().getDisads().remove(HeroDesigner.getActiveHero().getAgeObject());
                        }
                    }
                    HeroDesigner.getActiveHero().getFullNCMObject().setAlias(CharacteristicsPanel.this.ncmTF.getText());
                    if (GenericObject.findObjectByID(HeroDesigner.getActiveHero().getDisads(), "NCM") == null) {
                        HeroDesigner.getActiveHero().getDisads().add(HeroDesigner.getActiveHero().getNCMObject());
                        if (HeroDesigner.getActiveHero().getAgeObject() != null) {
                            HeroDesigner.getActiveHero().getDisads().add(HeroDesigner.getActiveHero().getAgeObject());
                        }
                    }
                    HeroDesigner.getActiveHero().setDirty(true);
                    CharacteristicsPanel.this.updateTotal();
                }
            });
            this.ncmCheck.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    HeroDesigner.getActiveHero().getDisads().remove(HeroDesigner.getActiveHero().getNCMObject());
                    if (HeroDesigner.getActiveHero().getAgeObject() != null) {
                        HeroDesigner.getActiveHero().getDisads().remove(HeroDesigner.getActiveHero().getAgeObject());
                    }
                    HeroDesigner.getActiveHero().setNCMSelected(CharacteristicsPanel.this.ncmCheck.isSelected());
                    if (CharacteristicsPanel.this.ncmCheck.isSelected() && GenericObject.findObjectByID(HeroDesigner.getActiveHero().getDisads(), "NCM") == null) {
                        HeroDesigner.getActiveHero().getDisads().add(HeroDesigner.getActiveHero().getNCMObject());
                        if (HeroDesigner.getActiveHero().getAgeObject() != null) {
                            HeroDesigner.getActiveHero().getDisads().add(HeroDesigner.getActiveHero().getAgeObject());
                        }
                    }
                    HeroDesigner.getActiveHero().setDirty(true);
                    CharacteristicsPanel.this.updateTotal();
                }
            });
        }
        if (this.ncmOptions != null) {
            this.ncmOptions.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    if (GenericObject.findObjectByID(HeroDesigner.getActiveHero().getDisads(), "NCM") != null) {
                        HeroDesigner.getActiveHero().getDisads().remove(HeroDesigner.getActiveHero().getNCMObject());
                        if (HeroDesigner.getActiveHero().getAgeObject() != null) {
                            HeroDesigner.getActiveHero().getDisads().remove(HeroDesigner.getActiveHero().getAgeObject());
                        }
                    }
                    HeroDesigner.getActiveHero().getFullNCMObject().setSelectedOption((Adder)CharacteristicsPanel.this.ncmOptions.getSelectedItem());
                    CharacteristicsPanel.this.ncmValueLbl.setText(Rounder.roundHalfUp(HeroDesigner.getActiveHero().getFullNCMObject().getBaseCost()) + " point" + (HeroDesigner.getActiveHero().getFullNCMObject().getBaseCost() != 1.0 ? "s" : ""));
                    Adder adder = (Adder)CharacteristicsPanel.this.ncmOptions.getSelectedItem();
                    String string = adder.getDisplay();
                    ((JTextField)CharacteristicsPanel.this.ncmOptions.getEditor().getEditorComponent()).setText(string);
                    HeroDesigner.getActiveHero().getFullNCMObject().getSelectedOption().setAlias(string);
                    if (GenericObject.findObjectByID(HeroDesigner.getActiveHero().getDisads(), "NCM") == null) {
                        HeroDesigner.getActiveHero().getDisads().add(HeroDesigner.getActiveHero().getNCMObject());
                        if (HeroDesigner.getActiveHero().getAgeObject() != null) {
                            HeroDesigner.getActiveHero().getDisads().add(HeroDesigner.getActiveHero().getAgeObject());
                        }
                    }
                    HeroDesigner.getActiveHero().setDirty(true);
                    CharacteristicsPanel.this.updateTotal();
                }
            });
            ((JTextField)this.ncmOptions.getEditor().getEditorComponent()).getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void changedUpdate(DocumentEvent documentEvent) {
                    if (GenericObject.findObjectByID(HeroDesigner.getActiveHero().getDisads(), "NCM") != null) {
                        HeroDesigner.getActiveHero().getDisads().remove(HeroDesigner.getActiveHero().getNCMObject());
                        if (HeroDesigner.getActiveHero().getAgeObject() != null) {
                            HeroDesigner.getActiveHero().getDisads().remove(HeroDesigner.getActiveHero().getAgeObject());
                        }
                    }
                    HeroDesigner.getActiveHero().getFullNCMObject().getSelectedOption().setAlias(((JTextField)CharacteristicsPanel.this.ncmOptions.getEditor().getEditorComponent()).getText());
                    if (GenericObject.findObjectByID(HeroDesigner.getActiveHero().getDisads(), "NCM") == null) {
                        HeroDesigner.getActiveHero().getDisads().add(HeroDesigner.getActiveHero().getNCMObject());
                        if (HeroDesigner.getActiveHero().getAgeObject() != null) {
                            HeroDesigner.getActiveHero().getDisads().add(HeroDesigner.getActiveHero().getAgeObject());
                        }
                    }
                    HeroDesigner.getActiveHero().setDirty(true);
                }

                @Override
                public void insertUpdate(DocumentEvent documentEvent) {
                    if (GenericObject.findObjectByID(HeroDesigner.getActiveHero().getDisads(), "NCM") != null) {
                        HeroDesigner.getActiveHero().getDisads().remove(HeroDesigner.getActiveHero().getNCMObject());
                        if (HeroDesigner.getActiveHero().getAgeObject() != null) {
                            HeroDesigner.getActiveHero().getDisads().remove(HeroDesigner.getActiveHero().getAgeObject());
                        }
                    }
                    HeroDesigner.getActiveHero().getFullNCMObject().getSelectedOption().setAlias(((JTextField)CharacteristicsPanel.this.ncmOptions.getEditor().getEditorComponent()).getText());
                    if (GenericObject.findObjectByID(HeroDesigner.getActiveHero().getDisads(), "NCM") == null) {
                        HeroDesigner.getActiveHero().getDisads().add(HeroDesigner.getActiveHero().getNCMObject());
                        if (HeroDesigner.getActiveHero().getAgeObject() != null) {
                            HeroDesigner.getActiveHero().getDisads().add(HeroDesigner.getActiveHero().getAgeObject());
                        }
                    }
                    HeroDesigner.getActiveHero().setDirty(true);
                }

                @Override
                public void removeUpdate(DocumentEvent documentEvent) {
                    if (GenericObject.findObjectByID(HeroDesigner.getActiveHero().getDisads(), "NCM") != null) {
                        HeroDesigner.getActiveHero().getDisads().remove(HeroDesigner.getActiveHero().getNCMObject());
                        if (HeroDesigner.getActiveHero().getAgeObject() != null) {
                            HeroDesigner.getActiveHero().getDisads().remove(HeroDesigner.getActiveHero().getAgeObject());
                        }
                    }
                    HeroDesigner.getActiveHero().getFullNCMObject().getSelectedOption().setAlias(((JTextField)CharacteristicsPanel.this.ncmOptions.getEditor().getEditorComponent()).getText());
                    if (GenericObject.findObjectByID(HeroDesigner.getActiveHero().getDisads(), "NCM") == null) {
                        HeroDesigner.getActiveHero().getDisads().add(HeroDesigner.getActiveHero().getNCMObject());
                        if (HeroDesigner.getActiveHero().getAgeObject() != null) {
                            HeroDesigner.getActiveHero().getDisads().add(HeroDesigner.getActiveHero().getAgeObject());
                        }
                    }
                    HeroDesigner.getActiveHero().setDirty(true);
                }
            });
        }
    }

    private void initWidgets() {
        this.characteristicRows = new ArrayList();
        this.charTotalLbl = new JLabel("Total");
        this.levelsLbl = new JLabel("Value");
        this.charLbl = new JLabel("Char");
        this.baseLbl = new JLabel("Base");
        this.pointsLbl = new JLabel("Cost");
        this.rollLbl = new JLabel("Roll");
        this.notesLbl = new JLabel("Notes");
        this.totalLbl = new JLabel("Total Characteristics Points:");
        this.totalValueLbl = new JLabel("" + Rounder.roundUp(HeroDesigner.getActiveHero().getCharacteristicsTotal()));
        for (int i = 0; i < HeroDesigner.getActiveHero().getCharacteristics().size(); ++i) {
            Characteristic characteristic = (Characteristic)HeroDesigner.getActiveHero().getCharacteristics().get(i);
            CharacteristicRow characteristicRow = new CharacteristicRow(this, characteristic, (GridBagLayout)this.getLayout(), i + 1);
            this.characteristicRows.add(characteristicRow);
        }
        Adder adder = HeroDesigner.getActiveHero().getFullNCMObject();
        if (adder != null) {
            this.ncmCheck = new JCheckBox();
            this.ncmCheck.setSelected(HeroDesigner.getActiveHero().isNCMSelected());
            this.ncmCheck.setEnabled(HeroDesigner.getActiveHero().getRules().isNCMUserChangeable());
            this.ncmTF = new JTextField(adder.getAlias());
            this.ncmTF.setBorder(BorderFactory.createLineBorder(Color.black, 1));
            this.ncmValueLbl = new JLabel(Rounder.roundHalfUp(adder.getBaseCost()) + " point" + (adder.getBaseCost() != 1.0 ? "s" : ""));
            if (adder.getOptions() != null && adder.getOptions().size() > 0) {
                this.ncmOptions = new JComboBox<Object>(adder.getOptions().toArray());
                this.ncmOptions.setEditable(true);
                this.ncmOptions.setSelectedItem(adder.getSelectedOption());
                ((JTextField)this.ncmOptions.getEditor().getEditorComponent()).setText(adder.getSelectedOption().getAlias());
            } else {
                this.ncmOptions = null;
            }
        } else {
            this.ncmCheck = null;
            this.ncmTF = null;
            this.ncmValueLbl = null;
            this.ncmOptions = null;
        }
    }

    private void layoutComponent() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(3, 5, 3, 5);
        this.add((Component)this.levelsLbl, gridBagConstraints);
        ++gridBagConstraints.gridx;
        this.add((Component)this.charLbl, gridBagConstraints);
        ++gridBagConstraints.gridx;
        this.add((Component)this.baseLbl, gridBagConstraints);
        ++gridBagConstraints.gridx;
        this.add((Component)this.pointsLbl, gridBagConstraints);
        ++gridBagConstraints.gridx;
        this.add((Component)this.charTotalLbl, gridBagConstraints);
        ++gridBagConstraints.gridx;
        this.add((Component)this.rollLbl, gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.notesLbl, gridBagConstraints);
        gridBagConstraints.gridy += this.characteristicRows.size();
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        if (this.ncmCheck != null) {
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridy = 0;
            gridBagConstraints2.gridwidth = 1;
            gridBagConstraints2.gridheight = 1;
            gridBagConstraints2.weightx = 0.0;
            gridBagConstraints2.weighty = 1.0;
            gridBagConstraints2.anchor = 13;
            gridBagConstraints2.fill = 3;
            gridBagConstraints2.insets = new Insets(3, 3, 3, 3);
            JPanel jPanel = new JPanel(new GridBagLayout());
            jPanel.add((Component)this.ncmCheck, gridBagConstraints2);
            ++gridBagConstraints2.gridx;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.fill = 1;
            gridBagConstraints2.insets = new Insets(3, 3, 3, 0);
            jPanel.add((Component)this.ncmTF, gridBagConstraints2);
            gridBagConstraints2.fill = 3;
            if (this.ncmOptions != null) {
                ++gridBagConstraints2.gridx;
                gridBagConstraints2.weightx = 0.0;
                gridBagConstraints2.anchor = 17;
                gridBagConstraints2.insets = new Insets(3, 0, 3, 3);
                jPanel.add((Component)this.ncmOptions, gridBagConstraints2);
            }
            gridBagConstraints2.insets = new Insets(3, 3, 3, 3);
            ++gridBagConstraints2.gridx;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.anchor = 17;
            jPanel.add((Component)this.ncmValueLbl, gridBagConstraints2);
            this.add((Component)jPanel, gridBagConstraints);
        }
        gridBagConstraints.fill = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(3, 0, 3, 0);
        this.add((Component)this.totalLbl, gridBagConstraints);
        gridBagConstraints.gridx = 6;
        gridBagConstraints.insets = new Insets(3, 0, 3, 0);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.totalValueLbl, gridBagConstraints);
    }

    public void reset() {
        this.lastUpdateTime = 0L;
        this.removeAll();
        this.initWidgets();
        this.initListeners();
        this.layoutComponent();
    }

    public void update(int n) {
        for (CharacteristicRow characteristicRow : this.characteristicRows) {
            if (characteristicRow.getCharacteristic().getType() != n) continue;
            characteristicRow.update();
        }
    }

    public void updateCosts() {
        double d = HeroDesigner.getActiveHero().getBasePoints() + HeroDesigner.getActiveHero().getDisadPoints() + HeroDesigner.getActiveHero().getExperience();
        if (HeroDesigner.getActiveTemplate().is6E()) {
            d -= (double)HeroDesigner.getActiveHero().getDisadPoints();
        }
        this.totalValueLbl.setText("" + Rounder.roundUp(HeroDesigner.getActiveHero().getCharacteristicsTotal()) + " (Total Spent: " + Rounder.roundUp(HeroDesigner.getActiveHero().getSpentTotal()) + "/" + Rounder.roundUp(d) + ")");
        if (this.ncmCheck != null) {
            this.ncmCheck.setSelected(HeroDesigner.getActiveHero().isNCMSelected());
        }
        if (this.ncmValueLbl != null && HeroDesigner.getActiveHero().getFullNCMObject() != null) {
            this.ncmValueLbl.setText(Rounder.roundHalfUp(HeroDesigner.getActiveHero().getFullNCMObject().getBaseCost()) + " point" + (HeroDesigner.getActiveHero().getFullNCMObject().getBaseCost() != 1.0 ? "s" : ""));
        }
        JScrollPane jScrollPane = null;
        for (Container container = this.getParent(); container != null; container = container.getParent()) {
            if (!(container instanceof JScrollPane)) continue;
            jScrollPane = (JScrollPane)container;
            break;
        }
        if (this.lastUpdateTime <= 0L || this.lastUpdateTime < HeroDesigner.lastEdit) {
            this.lastUpdateTime = System.currentTimeMillis();
            if (jScrollPane != null) {
                HeroDesigner.getInstance().mainPanel.updateFrames(jScrollPane);
            }
        }
    }

    public void updateTotal() {
        if (this.lastUpdateTime <= 0L || this.lastUpdateTime < HeroDesigner.lastEdit) {
            this.updateCosts();
            for (CharacteristicRow characteristicRow : this.characteristicRows) {
                characteristicRow.update();
            }
            this.lastUpdateTime = System.currentTimeMillis();
        }
    }
}

