/*
 * Decompiled with CFR 0.152.
 */
package com.hero.ui;

import com.hero.HeroDesigner;
import com.hero.objects.GenericObject;
import com.hero.objects.characteristics.Characteristic;
import com.hero.objects.powers.Automaton;
import com.hero.ui.CharacteristicsPanel;
import com.hero.ui.widgets.LevelTF;
import com.hero.ui.widgets.PopupMessage;
import com.hero.util.Rounder;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class CharacteristicRow
extends JComponent {
    private static final long serialVersionUID = 757343676469212364L;
    Characteristic characteristic;
    private CharacteristicsPanel main;
    private int row;
    LevelTF level;
    private JLabel charDisplay;
    private JLabel base;
    private JLabel cost;
    private JLabel roll;
    private JLabel total;
    private JLabel notes;
    protected long lastUpdateTime;

    public CharacteristicRow(CharacteristicsPanel characteristicsPanel, Characteristic characteristic, GridBagLayout gridBagLayout, int n) {
        this.setLayout(gridBagLayout);
        this.characteristic = characteristic;
        this.main = characteristicsPanel;
        this.row = n;
        this.initWidgets();
        this.initListeners();
        this.layoutComponent();
    }

    boolean checkFigured() {
        if (!HeroDesigner.getActiveHero().getRules().onlySellOneFigured()) {
            return true;
        }
        if (this.characteristic.isFigured()) {
            for (int i = 0; i < HeroDesigner.getActiveHero().getCharacteristics().size(); ++i) {
                Characteristic characteristic = (Characteristic)HeroDesigner.getActiveHero().getCharacteristics().get(i);
                if (!characteristic.isFigured() || characteristic.getType() == this.characteristic.getType() || characteristic.getLevels() >= 0) continue;
                return false;
            }
            return true;
        }
        return true;
    }

    public Characteristic getCharacteristic() {
        return this.characteristic;
    }

    private void initListeners() {
        this.level.addPropertyChangeListener("Level", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (!propertyChangeEvent.getOldValue().equals(propertyChangeEvent.getNewValue())) {
                    CharacteristicRow.this.valueChanged();
                }
            }
        });
    }

    private void initWidgets() {
        this.total = new JLabel(this.characteristic.getValueDisplay());
        this.level = new LevelTF((int)Rounder.roundHalfUp(this.characteristic.getCharacteristicValue()), this.characteristic.getMaxVal(), this.characteristic.getMinimumLevel());
        this.charDisplay = new JLabel(this.characteristic.getDisplay());
        this.base = new JLabel(this.characteristic.getCharacteristicBase());
        this.cost = new JLabel("" + Rounder.roundUp(this.characteristic.getRealCost()));
        this.roll = new JLabel(this.characteristic.getRoll());
        this.notes = new JLabel(this.characteristic.getDisplayNotes());
    }

    private void layoutComponent() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = this.row;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        this.main.add((Component)this.level, gridBagConstraints);
        ++gridBagConstraints.gridx;
        this.main.add((Component)this.charDisplay, gridBagConstraints);
        ++gridBagConstraints.gridx;
        this.main.add((Component)this.base, gridBagConstraints);
        ++gridBagConstraints.gridx;
        this.main.add((Component)this.cost, gridBagConstraints);
        ++gridBagConstraints.gridx;
        this.main.add((Component)this.total, gridBagConstraints);
        ++gridBagConstraints.gridx;
        if (this.characteristic.showRoll()) {
            this.main.add((Component)this.roll, gridBagConstraints);
        }
        ++gridBagConstraints.gridx;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 18;
        this.main.add((Component)this.notes, gridBagConstraints);
    }

    @Override
    public void setVisible(boolean bl) {
        this.level.setVisible(bl);
        this.charDisplay.setVisible(bl);
        this.base.setVisible(bl);
        this.cost.setVisible(bl);
        if (this.characteristic.showRoll()) {
            this.roll.setVisible(bl);
        }
        this.total.setVisible(bl);
        this.notes.setVisible(bl);
    }

    public synchronized void update() {
        if (this.characteristic.getType() == 14) {
            if (GenericObject.findObjectByID(HeroDesigner.getActiveHero().getPowers(), "AUTOMATON") != null) {
                Automaton automaton = (Automaton)GenericObject.findObjectByID(HeroDesigner.getActiveHero().getPowers(), "AUTOMATON");
                if (automaton.getSelectedOption().getXMLID().toUpperCase().startsWith("NOSTUN")) {
                    this.characteristic.setLevels(0);
                    this.level.setCurrent((int)Rounder.roundHalfUp(this.characteristic.getCharacteristicValue()));
                    this.level.setMin((int)Rounder.roundHalfUp(this.characteristic.getCharacteristicValue()));
                    this.level.setMax((int)Rounder.roundHalfUp(this.characteristic.getCharacteristicValue()));
                    this.setVisible(false);
                } else {
                    this.level.setCurrent((int)Rounder.roundHalfUp(this.characteristic.getCharacteristicValue()));
                    this.level.setMin(this.characteristic.getMinimumLevel());
                    this.level.setMax(this.characteristic.getMaxLevel());
                    this.setVisible(true);
                }
            } else {
                this.level.setCurrent((int)Rounder.roundHalfUp(this.characteristic.getCharacteristicValue()));
                this.level.setMin(this.characteristic.getMinimumLevel());
                this.level.setMax(this.characteristic.getMaxLevel());
                this.setVisible(true);
                for (int i = 0; i < HeroDesigner.getActiveHero().getCharacteristics().size(); ++i) {
                    Characteristic characteristic = (Characteristic)HeroDesigner.getActiveHero().getCharacteristics().get(i);
                    if (characteristic.getType() == this.characteristic.getType() || this.characteristic.getIncrease(characteristic.getType()) == 0.0) continue;
                    this.main.update(characteristic.getType());
                }
            }
        }
        this.level.setMin(this.characteristic.getMinimumLevel());
        double d = Rounder.roundHalfUp(this.characteristic.getCharacteristicValue());
        if (d != (double)this.level.getCurrent()) {
            this.level.setCurrent((int)Rounder.roundHalfUp(this.characteristic.getCharacteristicValue()));
        }
        this.total.setText(this.characteristic.getValueDisplay());
        if (this.characteristic.showRoll()) {
            this.roll.setText(this.characteristic.getRoll());
        }
        this.notes.setText(this.characteristic.getDisplayNotes());
        this.cost.setText("" + Rounder.roundUp(this.characteristic.getRealCost() - 0.005));
        this.base.setText(this.characteristic.getCharacteristicBase());
        for (int i = 0; i < HeroDesigner.getActiveHero().getCharacteristics().size(); ++i) {
            Characteristic characteristic = (Characteristic)HeroDesigner.getActiveHero().getCharacteristics().get(i);
            if (characteristic.getType() == this.characteristic.getType()) continue;
            if (this.characteristic.getIncrease(characteristic.getType()) != 0.0) {
                this.main.update(characteristic.getType());
                continue;
            }
            if (characteristic.getType() != 2 || this.characteristic.getOcvIncrease() == 0.0 && this.characteristic.getDcvIncrease() == 0.0) continue;
            this.main.update(characteristic.getType());
        }
        this.lastUpdateTime = System.currentTimeMillis();
    }

    synchronized void updateValues() {
        this.update();
        this.main.updateCosts();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void valueChanged() {
        try {
            double d = this.characteristic.getCharacteristicValue();
            int n = this.characteristic.getLevels();
            this.characteristic.setValue(this.level.getCurrent());
            int n2 = this.characteristic.getLevels();
            if (n2 != n && (n2 >= 0 || this.checkFigured())) {
                HeroDesigner.getActiveHero().setDirty(true);
            } else {
                if (!this.checkFigured() && n2 < 0 && n != n2) {
                    PopupMessage popupMessage = PopupMessage.getInstance(HeroDesigner.getAppFrame(), this.level, "You may only sell off one figured characteristic.", true);
                    if (this.level.isShowing()) {
                        popupMessage.setVisible(true);
                    }
                }
                if (n2 != n) {
                    this.characteristic.setValue(d);
                }
            }
            this.updateValues();
        }
        catch (Exception exception) {
        }
        catch (Throwable throwable) {
            throw throwable;
        }
    }
}

