/*
 * Decompiled with CFR 0.152.
 */
package com.hero.ui;

import com.hero.HeroDesigner;
import com.hero.Template;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;

public class CharacterInformationPanel
extends JPanel {
    private static final long serialVersionUID = 2443386885639126811L;
    private JLabel alternateIdentitiesLbl;
    JTextField alternateIdentitiesTF;
    private JLabel campaignNameLbl;
    JTextField campaignNameTF;
    ImageIcon characterImage;
    JButton characterImageBtn;
    private JLabel characterImageLbl;
    private JLabel characterNameLbl;
    JTextField characterNameTF;
    JButton clearImageBtn;
    private JLabel genreLbl;
    JTextField genreTF;
    private JLabel gmLbl;
    JTextField gmTF;
    private JLabel playerNameLbl;
    JTextField playerNameTF;

    public CharacterInformationPanel() {
        super(new GridBagLayout());
        this.initWidgets();
        this.initListeners();
        this.layoutComponent();
    }

    private void initListeners() {
        this.characterNameTF.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                HeroDesigner.getActiveHero().setCharacterName(CharacterInformationPanel.this.characterNameTF.getText());
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                HeroDesigner.getActiveHero().setCharacterName(CharacterInformationPanel.this.characterNameTF.getText());
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                HeroDesigner.getActiveHero().setCharacterName(CharacterInformationPanel.this.characterNameTF.getText());
            }
        });
        this.alternateIdentitiesTF.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                HeroDesigner.getActiveHero().setAlternateIdentities(CharacterInformationPanel.this.alternateIdentitiesTF.getText());
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                HeroDesigner.getActiveHero().setAlternateIdentities(CharacterInformationPanel.this.alternateIdentitiesTF.getText());
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                HeroDesigner.getActiveHero().setAlternateIdentities(CharacterInformationPanel.this.alternateIdentitiesTF.getText());
            }
        });
        this.playerNameTF.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                HeroDesigner.getActiveHero().setPlayerName(CharacterInformationPanel.this.playerNameTF.getText());
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                HeroDesigner.getActiveHero().setPlayerName(CharacterInformationPanel.this.playerNameTF.getText());
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                HeroDesigner.getActiveHero().setPlayerName(CharacterInformationPanel.this.playerNameTF.getText());
            }
        });
        this.campaignNameTF.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                HeroDesigner.getActiveHero().setCampaignName(CharacterInformationPanel.this.campaignNameTF.getText());
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                HeroDesigner.getActiveHero().setCampaignName(CharacterInformationPanel.this.campaignNameTF.getText());
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                HeroDesigner.getActiveHero().setCampaignName(CharacterInformationPanel.this.campaignNameTF.getText());
            }
        });
        this.genreTF.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                HeroDesigner.getActiveHero().setGenre(CharacterInformationPanel.this.genreTF.getText());
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                HeroDesigner.getActiveHero().setGenre(CharacterInformationPanel.this.genreTF.getText());
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                HeroDesigner.getActiveHero().setGenre(CharacterInformationPanel.this.genreTF.getText());
            }
        });
        this.gmTF.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                HeroDesigner.getActiveHero().setGm(CharacterInformationPanel.this.gmTF.getText());
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                HeroDesigner.getActiveHero().setGm(CharacterInformationPanel.this.gmTF.getText());
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                HeroDesigner.getActiveHero().setGm(CharacterInformationPanel.this.gmTF.getText());
            }
        });
        this.characterImageBtn.addActionListener(new ActionListener(){
            private JFileChooser chooser;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n;
                String string;
                if (this.chooser == null) {
                    this.chooser = new JFileChooser();
                    this.chooser.setFileFilter(new FileFilter(){

                        @Override
                        public boolean accept(File file) {
                            if (file.isDirectory()) {
                                return true;
                            }
                            return file.getName().toUpperCase().endsWith(".JPG") || file.getName().toUpperCase().endsWith(".GIF") || file.getName().toUpperCase().endsWith(".PNG");
                        }

                        @Override
                        public String getDescription() {
                            return "Images only";
                        }
                    });
                    this.chooser.setApproveButtonText("Set Image");
                    this.chooser.setDialogTitle("Choose Character Image");
                    this.chooser.setFileSelectionMode(0);
                    this.chooser.setMultiSelectionEnabled(false);
                    this.chooser.setAcceptAllFileFilterUsed(false);
                }
                if ((string = HeroDesigner.getInstance().getPrefs().getImageDir()) != null && string.trim().length() > 0) {
                    this.chooser.setCurrentDirectory(new File(string));
                }
                if ((n = this.chooser.showOpenDialog(CharacterInformationPanel.this.characterImageBtn)) == 0) {
                    File file = this.chooser.getSelectedFile();
                    if (file != null) {
                        try {
                            byte[] byArray = new byte[(int)file.length()];
                            FileInputStream fileInputStream = new FileInputStream(file);
                            fileInputStream.read(byArray);
                            fileInputStream.close();
                            HeroDesigner.getActiveHero().setImageData(byArray, file);
                            HeroDesigner.getInstance().getPrefs().setImageDir(file.getParent());
                            ImageIcon imageIcon = new ImageIcon(file.getAbsolutePath());
                            CharacterInformationPanel.this.characterImageBtn.setIcon(imageIcon);
                            CharacterInformationPanel.this.characterImageBtn.setText(null);
                            CharacterInformationPanel.this.characterImageBtn.setBorderPainted(false);
                            CharacterInformationPanel.this.characterImageBtn.setFocusPainted(false);
                            CharacterInformationPanel.this.characterImageBtn.setMargin(new Insets(0, 0, 0, 0));
                            CharacterInformationPanel.this.clearImageBtn.setVisible(true);
                        }
                        catch (FileNotFoundException fileNotFoundException) {
                            fileNotFoundException.printStackTrace();
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                        }
                    } else {
                        HeroDesigner.getActiveHero().setImageData(new byte[0], null);
                        CharacterInformationPanel.this.characterImageBtn.setIcon(null);
                        CharacterInformationPanel.this.characterImageBtn.setText("Click to assign");
                        CharacterInformationPanel.this.clearImageBtn.setVisible(false);
                    }
                }
            }
        });
        this.clearImageBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = JOptionPane.showConfirmDialog(CharacterInformationPanel.this, "Are you sure you want to clear the image?", "Are you sure?", 0);
                if (n == 0) {
                    HeroDesigner.getActiveHero().setImageData(new byte[0], null);
                    CharacterInformationPanel.this.characterImageBtn.setIcon(null);
                    CharacterInformationPanel.this.characterImageBtn.setText("Click to assign");
                    CharacterInformationPanel.this.clearImageBtn.setVisible(false);
                }
            }
        });
    }

    private void initWidgets() {
        this.characterNameLbl = new JLabel();
        this.alternateIdentitiesLbl = new JLabel();
        this.playerNameLbl = new JLabel();
        this.campaignNameLbl = new JLabel();
        this.genreLbl = new JLabel();
        this.gmLbl = new JLabel();
        this.characterImageLbl = new JLabel("Image:");
        this.characterImage = HeroDesigner.getActiveHero().getImageData() != null && HeroDesigner.getActiveHero().getImageData().length > 0 ? new ImageIcon(HeroDesigner.getActiveHero().getImageData()) : new ImageIcon();
        this.characterImageBtn = new JButton(this.characterImage);
        this.clearImageBtn = new JButton("Clear Image...");
        this.characterNameTF = new JTextField("", 30);
        this.alternateIdentitiesTF = new JTextField("", 30);
        this.playerNameTF = new JTextField("", 30);
        this.campaignNameTF = new JTextField("", 30);
        this.genreTF = new JTextField("", 30);
        this.gmTF = new JTextField("", 30);
        this.reset();
    }

    private void layoutComponent() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.characterNameLbl, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        this.add((Component)this.alternateIdentitiesLbl, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        this.add((Component)this.campaignNameLbl, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        this.add((Component)this.genreLbl, gridBagConstraints);
        gridBagConstraints.gridy = 4;
        this.add((Component)this.playerNameLbl, gridBagConstraints);
        gridBagConstraints.gridy = 5;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 13;
        this.add((Component)this.gmLbl, gridBagConstraints);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.characterNameTF, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        this.add((Component)this.alternateIdentitiesTF, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        this.add((Component)this.campaignNameTF, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        this.add((Component)this.genreTF, gridBagConstraints);
        gridBagConstraints.gridy = 4;
        this.add((Component)this.playerNameTF, gridBagConstraints);
        gridBagConstraints.gridy = 5;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.gmTF, gridBagConstraints);
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 12;
        this.add((Component)this.characterImageLbl, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.characterImageBtn, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.clearImageBtn, gridBagConstraints);
        if (!HeroDesigner.getActiveHero().isPrefab()) {
            this.setBorder(BorderFactory.createTitledBorder("Character Information"));
        } else {
            this.setBorder(BorderFactory.createTitledBorder("Prefab Information"));
        }
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        ++gridBagConstraints.gridy;
        this.add((Component)new JPanel(), gridBagConstraints);
    }

    public void reset() {
        Template template = HeroDesigner.getActiveTemplate();
        boolean bl = HeroDesigner.getActiveHero().isPrefab();
        if (HeroDesigner.getActiveHero().isPrefab()) {
            this.characterNameLbl.setText("Prefab Name:");
            this.characterNameTF.setText(HeroDesigner.getActiveHero().getCharacterName());
            this.characterNameLbl.setVisible(true);
            this.characterNameTF.setVisible(true);
        } else if (template.getCharacterNameLabel() != null) {
            this.characterNameLbl.setText(template.getCharacterNameLabel() + ":");
            this.characterNameLbl.setVisible(true);
            this.characterNameTF.setText(HeroDesigner.getActiveHero().getCharacterName());
            this.characterNameTF.setVisible(true);
        } else {
            this.characterNameLbl.setVisible(false);
            this.characterNameTF.setVisible(false);
        }
        if (template.getAlternateIDsLabel() != null && !bl) {
            this.alternateIdentitiesLbl.setText(template.getAlternateIDsLabel() + ":");
            this.alternateIdentitiesLbl.setVisible(true);
            this.alternateIdentitiesTF.setText(HeroDesigner.getActiveHero().getAlternateIdentities());
            this.alternateIdentitiesTF.setVisible(true);
        } else {
            this.alternateIdentitiesLbl.setVisible(false);
            this.alternateIdentitiesTF.setVisible(false);
        }
        if (HeroDesigner.getActiveHero().isPrefab()) {
            this.playerNameLbl.setText("Created By:");
            this.playerNameLbl.setVisible(true);
            this.playerNameTF.setText(HeroDesigner.getActiveHero().getPlayerName());
            this.playerNameTF.setVisible(true);
        } else if (template.getPlayerNameLabel() != null) {
            this.playerNameLbl.setText(template.getPlayerNameLabel() + ":");
            this.playerNameLbl.setVisible(true);
            this.playerNameTF.setText(HeroDesigner.getActiveHero().getPlayerName());
            this.playerNameTF.setVisible(true);
        } else {
            this.playerNameLbl.setVisible(false);
            this.playerNameTF.setVisible(false);
        }
        if (template.getCampaignNameLabel() != null && !bl) {
            this.campaignNameLbl.setText(template.getCampaignNameLabel() + ":");
            this.campaignNameLbl.setVisible(true);
            this.campaignNameTF.setText(HeroDesigner.getActiveHero().getCampaignName());
            this.campaignNameTF.setVisible(true);
        } else {
            this.campaignNameLbl.setVisible(false);
            this.campaignNameTF.setVisible(false);
        }
        if (template.getGenreLabel() != null && !bl) {
            this.genreLbl.setText(template.getGenreLabel() + ":");
            this.genreLbl.setVisible(true);
            this.genreTF.setText(HeroDesigner.getActiveHero().getGenre());
            this.genreTF.setVisible(true);
        } else {
            this.genreLbl.setVisible(false);
            this.genreTF.setVisible(false);
        }
        if (template.getGmLabel() != null && !bl) {
            this.gmLbl.setText(template.getGmLabel() + ":");
            this.gmLbl.setVisible(true);
            this.gmTF.setText(HeroDesigner.getActiveHero().getGm());
            this.gmTF.setVisible(true);
        } else {
            this.gmLbl.setVisible(false);
            this.gmTF.setVisible(false);
        }
        if (!bl) {
            this.characterImageBtn.setVisible(true);
            this.characterImageLbl.setVisible(true);
            if (HeroDesigner.getActiveHero().getImageData() == null || HeroDesigner.getActiveHero().getImageData().length == 0) {
                this.characterImageBtn.setText("Click to assign");
                this.characterImageBtn.setIcon(null);
                this.clearImageBtn.setVisible(false);
            } else {
                ImageIcon imageIcon = new ImageIcon(HeroDesigner.getActiveHero().getImageData());
                this.characterImageBtn.setIcon(imageIcon);
                this.characterImageBtn.setText(null);
                this.characterImageBtn.setBorderPainted(false);
                this.characterImageBtn.setFocusPainted(false);
                this.characterImageBtn.setMargin(new Insets(0, 0, 0, 0));
                this.clearImageBtn.setVisible(true);
            }
        } else {
            this.characterImageBtn.setVisible(false);
            this.characterImageLbl.setVisible(false);
            this.clearImageBtn.setVisible(false);
        }
        if (!HeroDesigner.getActiveHero().isPrefab()) {
            this.setBorder(BorderFactory.createTitledBorder("Character Information"));
        } else {
            this.setBorder(BorderFactory.createTitledBorder("Prefab Information"));
        }
    }
}

