/*
 * Decompiled with CFR 0.152.
 */
package com.hero.ui;

import com.hero.HeroDesigner;
import com.hero.ui.widgets.LevelTF;
import com.hero.util.Rounder;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class BasicConfigurationPanel
extends JPanel {
    private static final long serialVersionUID = 7064881773947894895L;
    private JLabel basePointsLbl;
    LevelTF basePointsTF;
    private JLabel disadPointsAllowedLbl;
    LevelTF disadPointsAllowedTF;
    private JLabel disadPointsUsedLbl;
    private JLabel disadPointsUsedValueLbl;
    private JLabel experienceEarnedLbl;
    LevelTF experienceEarnedTF;
    private JLabel experienceSpentLbl;
    private JLabel experienceSpentValueLbl;
    private JLabel totalPointsLbl;
    private JLabel totalPointsValueLbl;
    private JLabel unspentExperienceLbl;
    private JLabel unspentExperienceValueLbl;

    public BasicConfigurationPanel() {
        super(new GridBagLayout());
        this.initWidgets();
        this.initListeners();
        this.layoutComponent();
    }

    private void initListeners() {
        this.experienceEarnedTF.addPropertyChangeListener("Level", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                HeroDesigner.getActiveHero().setExperience(BasicConfigurationPanel.this.experienceEarnedTF.getCurrent());
                BasicConfigurationPanel.this.setValues();
            }
        });
        this.basePointsTF.addPropertyChangeListener("Level", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                HeroDesigner.getActiveHero().setBasePoints(BasicConfigurationPanel.this.basePointsTF.getCurrent());
                BasicConfigurationPanel.this.setValues();
            }
        });
        this.disadPointsAllowedTF.addPropertyChangeListener("Level", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                HeroDesigner.getActiveHero().setDisadPoints(BasicConfigurationPanel.this.disadPointsAllowedTF.getCurrent());
                BasicConfigurationPanel.this.setValues();
            }
        });
    }

    private void initWidgets() {
        this.experienceEarnedLbl = new JLabel("Experience Earned:");
        this.experienceSpentLbl = new JLabel("Experience Spent:");
        this.unspentExperienceLbl = new JLabel("Unspent Experience:");
        this.basePointsLbl = new JLabel("Base Points:");
        boolean bl = HeroDesigner.getActiveTemplate().is6E();
        if (bl) {
            this.basePointsLbl.setText("Points:");
        }
        String string = "Max. Disad.Points";
        if (bl) {
            string = "Matching Complications";
        }
        this.disadPointsAllowedLbl = new JLabel(string);
        this.totalPointsLbl = new JLabel("Total Points Spent");
        this.totalPointsValueLbl = new JLabel("");
        this.experienceEarnedTF = new LevelTF(HeroDesigner.getActiveHero().getExperience(), 9999, 0);
        this.experienceSpentValueLbl = new JLabel("");
        this.unspentExperienceValueLbl = new JLabel("");
        string = "Disad. Points Used:";
        if (bl) {
            string = "Complication Points Used:";
        }
        this.disadPointsUsedLbl = new JLabel(string);
        this.disadPointsUsedValueLbl = new JLabel("");
        this.basePointsTF = new LevelTF(HeroDesigner.getActiveHero().getBasePoints(), 9999, -9999);
        this.disadPointsAllowedTF = new LevelTF(HeroDesigner.getActiveHero().getDisadPoints(), 9999, 0);
        this.setValues();
    }

    private void layoutComponent() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.basePointsLbl, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.add((Component)this.disadPointsAllowedLbl, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.add((Component)this.disadPointsUsedLbl, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.add((Component)this.experienceEarnedLbl, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.add((Component)this.experienceSpentLbl, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.add((Component)this.unspentExperienceLbl, gridBagConstraints);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.basePointsTF, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.add((Component)this.disadPointsAllowedTF, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.add((Component)this.disadPointsUsedValueLbl, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.add((Component)this.experienceEarnedTF, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.add((Component)this.experienceSpentValueLbl, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.add((Component)this.unspentExperienceValueLbl, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.totalPointsValueLbl, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 12;
        this.add((Component)this.totalPointsLbl, gridBagConstraints);
        this.setBorder(BorderFactory.createTitledBorder("Basic Configuration"));
    }

    public void reset() {
        this.experienceEarnedTF.setCurrent(HeroDesigner.getActiveHero().getExperience());
        this.basePointsTF.setCurrent(HeroDesigner.getActiveHero().getBasePoints());
        this.disadPointsAllowedTF.setCurrent(HeroDesigner.getActiveHero().getDisadPoints());
        boolean bl = HeroDesigner.getActiveTemplate().is6E();
        String string = "Max. Disad. Points";
        if (bl) {
            string = "Matching Complications";
        }
        this.disadPointsAllowedLbl.setText(string);
        string = "Disad. Points Used:";
        if (bl) {
            string = "Complication Points Used:";
        }
        this.disadPointsUsedLbl.setText(string);
        if (bl) {
            this.basePointsLbl.setText("Points:");
        } else {
            this.basePointsLbl.setText("Base Points:");
        }
        this.setValues();
    }

    void setValues() {
        int n;
        int n2 = HeroDesigner.getActiveHero().getExperience();
        int n3 = HeroDesigner.getActiveHero().getBasePoints();
        int n4 = HeroDesigner.getActiveHero().getDisadPoints();
        int n5 = (int)Rounder.roundUp(HeroDesigner.getActiveHero().getSpentTotal());
        int n6 = HeroDesigner.getActiveHero().getDisadsUsed();
        int n7 = n5 - (n3 + n6);
        if (HeroDesigner.getActiveTemplate().is6E()) {
            n7 += n6;
        }
        if (n7 < 0) {
            n7 = 0;
        }
        if ((n = n2 - n7) < 0) {
            n = 0;
        }
        this.experienceSpentValueLbl.setText("" + n7);
        this.unspentExperienceValueLbl.setText("" + n);
        if (n2 - n7 < 0) {
            this.experienceSpentValueLbl.setForeground(Color.red);
        } else {
            this.experienceSpentValueLbl.setForeground(Color.black);
        }
        this.disadPointsUsedValueLbl.setText("" + n6);
        if (n6 > n4) {
            this.disadPointsUsedValueLbl.setForeground(Color.red);
        } else {
            this.disadPointsUsedValueLbl.setForeground(Color.black);
        }
        this.totalPointsValueLbl.setText("" + n5);
        if (n7 > n2) {
            this.totalPointsValueLbl.setForeground(Color.red);
        } else {
            this.totalPointsValueLbl.setForeground(Color.black);
        }
    }

    public void updateTotal() {
        this.setValues();
    }
}

