/*
 * Decompiled with CFR 0.152.
 */
package com.hero.ui;

import com.hero.HeroDesigner;
import com.hero.Template;
import com.hero.ui.widgets.LevelTF;
import com.hero.util.Rounder;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.math.BigDecimal;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class BackgroundPanel
extends JPanel {
    private static final long serialVersionUID = 2894271058119575929L;
    private JLabel backgroundLbl;
    private JScrollPane backgroundScroll;
    JTextArea backgroundTA;
    private JLabel campaignUseLbl;
    private JScrollPane campaignUseScroll;
    JTextArea campaignUseTA;
    private JLabel descriptionLbl;
    private JScrollPane descriptionScroll;
    JTextArea descriptionTA;
    private JLabel eyeColorLbl;
    JTextField eyeColorTF;
    private JLabel hairColorLbl;
    JTextField hairColorTF;
    private JLabel heightLbl;
    LevelTF heightTF;
    private JLabel heightValueLbl;
    private JLabel personalityLbl;
    private JScrollPane personalityScroll;
    JTextArea personalityTA;
    private JLabel quoteLbl;
    private JScrollPane quoteScroll;
    JTextArea quoteTA;
    private JLabel tacticsLbl;
    private JScrollPane tacticsScroll;
    JTextArea tacticsTA;
    private JLabel weightLbl;
    LevelTF weightTF;
    private JLabel weightValueLbl;

    public BackgroundPanel() {
        super(new GridBagLayout());
        this.initWidgets();
        this.initListeners();
        this.layoutComponent();
    }

    private void initListeners() {
        this.heightTF.addPropertyChangeListener("Level", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                HeroDesigner.getActiveHero().setHeight(BackgroundPanel.this.heightTF.getCurrent());
                BackgroundPanel.this.updateValues();
            }
        });
        this.weightTF.addPropertyChangeListener("Level", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                HeroDesigner.getActiveHero().setWeight(BackgroundPanel.this.weightTF.getCurrent());
                BackgroundPanel.this.updateValues();
            }
        });
        this.eyeColorTF.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                HeroDesigner.getActiveHero().setEyeColor(BackgroundPanel.this.eyeColorTF.getText());
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                HeroDesigner.getActiveHero().setEyeColor(BackgroundPanel.this.eyeColorTF.getText());
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                HeroDesigner.getActiveHero().setEyeColor(BackgroundPanel.this.eyeColorTF.getText());
            }
        });
        this.hairColorTF.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                HeroDesigner.getActiveHero().setHairColor(BackgroundPanel.this.hairColorTF.getText());
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                HeroDesigner.getActiveHero().setHairColor(BackgroundPanel.this.hairColorTF.getText());
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                HeroDesigner.getActiveHero().setHairColor(BackgroundPanel.this.hairColorTF.getText());
            }
        });
        this.descriptionTA.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                HeroDesigner.getActiveHero().setAppearance(BackgroundPanel.this.descriptionTA.getText());
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                HeroDesigner.getActiveHero().setAppearance(BackgroundPanel.this.descriptionTA.getText());
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                HeroDesigner.getActiveHero().setAppearance(BackgroundPanel.this.descriptionTA.getText());
            }
        });
        this.backgroundTA.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                HeroDesigner.getActiveHero().setBackground(BackgroundPanel.this.backgroundTA.getText());
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                HeroDesigner.getActiveHero().setBackground(BackgroundPanel.this.backgroundTA.getText());
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                HeroDesigner.getActiveHero().setBackground(BackgroundPanel.this.backgroundTA.getText());
            }
        });
        this.personalityTA.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                HeroDesigner.getActiveHero().setPersonality(BackgroundPanel.this.personalityTA.getText());
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                HeroDesigner.getActiveHero().setPersonality(BackgroundPanel.this.personalityTA.getText());
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                HeroDesigner.getActiveHero().setPersonality(BackgroundPanel.this.personalityTA.getText());
            }
        });
        this.quoteTA.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                HeroDesigner.getActiveHero().setQuote(BackgroundPanel.this.quoteTA.getText());
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                HeroDesigner.getActiveHero().setQuote(BackgroundPanel.this.quoteTA.getText());
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                HeroDesigner.getActiveHero().setQuote(BackgroundPanel.this.quoteTA.getText());
            }
        });
        this.tacticsTA.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                HeroDesigner.getActiveHero().setTactics(BackgroundPanel.this.tacticsTA.getText());
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                HeroDesigner.getActiveHero().setTactics(BackgroundPanel.this.tacticsTA.getText());
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                HeroDesigner.getActiveHero().setTactics(BackgroundPanel.this.tacticsTA.getText());
            }
        });
        this.campaignUseTA.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                HeroDesigner.getActiveHero().setCampaignUse(BackgroundPanel.this.campaignUseTA.getText());
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                HeroDesigner.getActiveHero().setCampaignUse(BackgroundPanel.this.campaignUseTA.getText());
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                HeroDesigner.getActiveHero().setCampaignUse(BackgroundPanel.this.campaignUseTA.getText());
            }
        });
    }

    private void initWidgets() {
        this.heightLbl = new JLabel("Height (in.):");
        if (HeroDesigner.getInstance().getPrefs().isMetric()) {
            this.heightLbl.setText("Height (cm):");
        }
        this.heightValueLbl = new JLabel("");
        this.weightLbl = new JLabel("Weight (lbs.):");
        if (HeroDesigner.getInstance().getPrefs().isMetric()) {
            this.weightLbl.setText("Weight (kg):");
        }
        this.weightValueLbl = new JLabel("");
        this.eyeColorLbl = new JLabel("");
        this.hairColorLbl = new JLabel("");
        this.descriptionLbl = new JLabel("");
        this.backgroundLbl = new JLabel("");
        this.personalityLbl = new JLabel("");
        this.quoteLbl = new JLabel("");
        this.tacticsLbl = new JLabel("");
        this.campaignUseLbl = new JLabel("");
        this.heightTF = new LevelTF(0, 999999, 1);
        this.weightTF = new LevelTF(0, 999999, 1);
        this.eyeColorTF = new JTextField("", 20);
        this.hairColorTF = new JTextField("", 20);
        this.descriptionTA = new JTextArea("", 5, 40);
        this.descriptionTA.setLineWrap(true);
        this.descriptionTA.setWrapStyleWord(true);
        this.descriptionTA.setTabSize(3);
        this.descriptionScroll = new JScrollPane(this.descriptionTA);
        this.backgroundTA = new JTextArea("", 5, 40);
        this.backgroundTA.setLineWrap(true);
        this.backgroundTA.setWrapStyleWord(true);
        this.backgroundTA.setTabSize(3);
        this.backgroundScroll = new JScrollPane(this.backgroundTA);
        this.personalityTA = new JTextArea("", 5, 40);
        this.personalityTA.setLineWrap(true);
        this.personalityTA.setWrapStyleWord(true);
        this.personalityTA.setTabSize(3);
        this.personalityScroll = new JScrollPane(this.personalityTA);
        this.quoteTA = new JTextArea("", 2, 40);
        this.quoteTA.setLineWrap(true);
        this.quoteTA.setWrapStyleWord(true);
        this.quoteTA.setTabSize(3);
        this.quoteScroll = new JScrollPane(this.quoteTA);
        this.tacticsTA = new JTextArea("", 5, 40);
        this.tacticsTA.setLineWrap(true);
        this.tacticsTA.setWrapStyleWord(true);
        this.tacticsTA.setTabSize(3);
        this.tacticsScroll = new JScrollPane(this.tacticsTA);
        this.campaignUseTA = new JTextArea("", 5, 40);
        this.campaignUseTA.setLineWrap(true);
        this.campaignUseTA.setWrapStyleWord(true);
        this.campaignUseTA.setTabSize(3);
        this.campaignUseScroll = new JScrollPane(this.campaignUseTA);
        this.reset();
    }

    private void layoutComponent() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.heightLbl, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        this.add((Component)this.weightLbl, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        this.add((Component)this.hairColorLbl, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        this.add((Component)this.eyeColorLbl, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        gridBagConstraints.anchor = 12;
        this.add((Component)this.backgroundLbl, gridBagConstraints);
        gridBagConstraints.gridy = 4;
        this.add((Component)this.personalityLbl, gridBagConstraints);
        gridBagConstraints.gridy = 6;
        this.add((Component)this.quoteLbl, gridBagConstraints);
        gridBagConstraints.gridy = 8;
        this.add((Component)this.tacticsLbl, gridBagConstraints);
        gridBagConstraints.gridy = 10;
        this.add((Component)this.campaignUseLbl, gridBagConstraints);
        gridBagConstraints.gridy = 12;
        this.add((Component)this.descriptionLbl, gridBagConstraints);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 5, 5);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        JPanel jPanel = new JPanel(new FlowLayout(0));
        jPanel.add(this.heightTF);
        jPanel.add(this.heightValueLbl);
        this.add((Component)jPanel, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        jPanel2.add(this.weightTF);
        jPanel2.add(this.weightValueLbl);
        this.add((Component)jPanel2, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        this.add((Component)this.hairColorTF, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        this.add((Component)this.eyeColorTF, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        gridBagConstraints.gridwidth = 0;
        this.add((Component)this.backgroundScroll, gridBagConstraints);
        gridBagConstraints.gridy = 4;
        this.add((Component)this.personalityScroll, gridBagConstraints);
        gridBagConstraints.gridy = 6;
        this.add((Component)this.quoteScroll, gridBagConstraints);
        gridBagConstraints.gridy = 8;
        this.add((Component)this.tacticsScroll, gridBagConstraints);
        gridBagConstraints.gridy = 10;
        this.add((Component)this.campaignUseScroll, gridBagConstraints);
        gridBagConstraints.gridy = 12;
        this.add((Component)this.descriptionScroll, gridBagConstraints);
    }

    public void reset() {
        Template template = HeroDesigner.getActiveTemplate();
        if (HeroDesigner.getInstance().getPrefs().isMetric()) {
            this.heightLbl.setText("Height (cm):");
        } else {
            this.heightLbl.setText("Height (in.):");
        }
        this.heightTF.setCurrent(HeroDesigner.getActiveHero().getHeight());
        if (!HeroDesigner.getActiveTemplate().isHeightAllowed()) {
            this.heightLbl.setVisible(false);
            this.heightValueLbl.setVisible(false);
            this.heightTF.setVisible(false);
        } else {
            this.heightLbl.setVisible(true);
            this.heightValueLbl.setVisible(true);
            this.heightTF.setVisible(true);
        }
        if (HeroDesigner.getInstance().getPrefs().isMetric()) {
            this.weightLbl.setText("Weight (kg):");
        } else {
            this.weightLbl.setText("Weight (lbs.):");
        }
        this.weightTF.setCurrent(HeroDesigner.getActiveHero().getWeight());
        if (!HeroDesigner.getActiveTemplate().isWeightAllowed()) {
            this.weightLbl.setVisible(false);
            this.weightValueLbl.setVisible(false);
            this.weightTF.setVisible(false);
        } else {
            this.weightLbl.setVisible(true);
            this.weightValueLbl.setVisible(true);
            this.weightTF.setVisible(true);
        }
        if (template.getEyeColorLabel() != null && HeroDesigner.getActiveTemplate().isEyeColorAllowed()) {
            this.eyeColorLbl.setText(template.getEyeColorLabel() + ":");
            this.eyeColorLbl.setVisible(true);
            this.eyeColorTF.setText(HeroDesigner.getActiveHero().getEyeColor());
            this.eyeColorTF.setVisible(true);
        } else {
            this.eyeColorLbl.setVisible(false);
            this.eyeColorTF.setVisible(false);
        }
        if (template.getHairColorLabel() != null && HeroDesigner.getActiveTemplate().isHairColorAllowed()) {
            this.hairColorLbl.setText(template.getHairColorLabel() + ":");
            this.hairColorLbl.setVisible(true);
            this.hairColorTF.setText(HeroDesigner.getActiveHero().getHairColor());
            this.hairColorTF.setVisible(true);
        } else {
            this.hairColorLbl.setVisible(false);
            this.hairColorTF.setVisible(false);
        }
        if (template.getAppearanceLabel() != null && template.getAppearanceLabel().trim().length() > 0) {
            this.descriptionLbl.setText(template.getAppearanceLabel() + ":");
            this.descriptionLbl.setVisible(true);
            this.descriptionTA.setText(HeroDesigner.getActiveHero().getAppearance());
            this.descriptionScroll.setVisible(true);
        } else {
            this.descriptionLbl.setVisible(false);
            this.descriptionScroll.setVisible(false);
        }
        if (template.getBackgroundLabel() != null && template.getBackgroundLabel().trim().length() > 0) {
            this.backgroundLbl.setText(template.getBackgroundLabel() + ":");
            this.backgroundLbl.setVisible(true);
            this.backgroundTA.setText(HeroDesigner.getActiveHero().getBackground());
            this.backgroundScroll.setVisible(true);
        } else {
            this.backgroundLbl.setVisible(false);
            this.backgroundScroll.setVisible(false);
        }
        if (template.getPersonalityLabel() != null && template.getPersonalityLabel().trim().length() > 0) {
            this.personalityLbl.setText(template.getPersonalityLabel() + ":");
            this.personalityLbl.setVisible(true);
            this.personalityTA.setText(HeroDesigner.getActiveHero().getPersonality());
            this.personalityScroll.setVisible(true);
        } else {
            this.personalityLbl.setVisible(false);
            this.personalityScroll.setVisible(false);
        }
        if (template.getQuoteLabel() != null && template.getQuoteLabel().trim().length() > 0) {
            this.quoteLbl.setText(template.getQuoteLabel() + ":");
            this.quoteLbl.setVisible(true);
            this.quoteTA.setText(HeroDesigner.getActiveHero().getQuote());
            this.quoteScroll.setVisible(true);
        } else {
            this.quoteLbl.setVisible(false);
            this.quoteScroll.setVisible(false);
        }
        if (template.getTacticsLabel() != null && template.getTacticsLabel().trim().length() > 0) {
            this.tacticsLbl.setText(template.getTacticsLabel() + ":");
            this.tacticsLbl.setVisible(true);
            this.tacticsTA.setText(HeroDesigner.getActiveHero().getTactics());
            this.tacticsScroll.setVisible(true);
        } else {
            this.tacticsLbl.setVisible(false);
            this.tacticsScroll.setVisible(false);
        }
        if (template.getCampaignUseLabel() != null && template.getCampaignUseLabel().trim().length() > 0) {
            this.campaignUseLbl.setText(template.getCampaignUseLabel() + ":");
            this.campaignUseLbl.setVisible(true);
            this.campaignUseTA.setText(HeroDesigner.getActiveHero().getCampaignUse());
            this.campaignUseScroll.setVisible(true);
        } else {
            this.campaignUseLbl.setVisible(false);
            this.campaignUseScroll.setVisible(false);
        }
        this.updateValues();
    }

    private void updateValues() {
        double d = HeroDesigner.getActiveHero().getHeight();
        double d2 = HeroDesigner.getActiveHero().getWeight();
        double d3 = d * 2.54;
        double d4 = d2 * 453.5924;
        if (HeroDesigner.getInstance().getPrefs().isMetric()) {
            d3 = HeroDesigner.getActiveHero().getHeight();
            d4 = HeroDesigner.getActiveHero().getWeight() * 1000;
            d = d3 / 2.54;
            d2 = d4 / 453.5924;
        }
        int n = (int)Rounder.roundHalfUp(d) / 12;
        int n2 = (int)Rounder.roundHalfUp(d) % 12;
        BigDecimal bigDecimal = new BigDecimal(d3 / 100.0);
        bigDecimal = bigDecimal.setScale(2, 4);
        BigDecimal bigDecimal2 = new BigDecimal(d4 / 1000.0);
        if (HeroDesigner.getInstance().getPrefs().isMetric()) {
            bigDecimal2 = new BigDecimal(d2);
        }
        bigDecimal2 = bigDecimal2.setScale(2, 4);
        String string = n + "' " + n2 + "\" (" + bigDecimal.toString() + " m)";
        String string2 = "(" + bigDecimal2.toString() + " kg)";
        if (HeroDesigner.getInstance().getPrefs().isMetric()) {
            string = bigDecimal.toString() + " m (" + n + "' " + n2 + "\")";
            string2 = "(" + bigDecimal2.toString() + " lbs)";
        }
        this.heightValueLbl.setText(string);
        this.weightValueLbl.setText(string2);
    }
}

