/*
 * Decompiled with CFR 0.152.
 */
package com.hero.objects.talents;

import com.hero.HeroDesigner;
import com.hero.objects.GenericObject;
import com.hero.ui.dialog.GenericDialog;
import com.hero.ui.dialog.TalentDialog;
import com.hero.util.XMLUtility;
import org.jdom.Element;

public class Talent
extends GenericObject {
    public Talent(Element element) {
        super(element);
    }

    public Talent(Element element, String string) {
        super(element, string);
    }

    @Override
    public String getColumn2Output() {
        String string = this.getAlias();
        if (this.getName() != null && this.getName().trim().length() > 0) {
            string = "<i>" + this.getName() + ":</i>  " + string;
        }
        if (this.getInput() != null && this.getInput().trim().length() > 0) {
            string = string + ":  " + this.getInput();
        }
        if (this.getSelectedOption() != null) {
            string = string + " (";
            string = string + this.getSelectedOption().getAlias();
            String string2 = this.getAdderString();
            if (string2.trim().length() > 0) {
                string = string + "; " + string2;
            }
            string = string + ")";
        } else {
            String string3 = this.getAdderString();
            if (string3.trim().length() > 0) {
                string = string + " (" + string3 + ")";
            }
        }
        string = string + this.getModifierString();
        if (this.getRoll() != null && this.getRoll().trim().length() > 0) {
            string = string + " " + this.getRoll();
        }
        if (this.getEndUsage() > 0 && GenericObject.findObjectByID(HeroDesigner.getActiveHero().getPowers(), "ENDURANCERESERVE") != null && GenericObject.findObjectByID(this.getAssignedModifiers(), "ENDRESERVEOREND") == null && !HeroDesigner.getInstance().getPrefs().useWG()) {
            string = this.getUseENDReserve() ? string + " (uses END Reserve)" : string + " (uses Personal END)";
        }
        return string;
    }

    @Override
    public GenericDialog getDialog(boolean bl, boolean bl2) {
        TalentDialog talentDialog = new TalentDialog(this, bl, bl2);
        return talentDialog;
    }

    public String getRoll() {
        return "";
    }

    @Override
    public Element getSaveXML() {
        Element element = this.getGeneralSaveXML();
        element.setName("TALENT");
        return element;
    }

    @Override
    protected void init(Element element) {
        String string;
        this.duration = "CONSTANT";
        super.init(element);
        this.target = "SELFONLY";
        if (!this.types.contains("SPECIAL")) {
            this.types.add("SPECIAL");
        }
        if ((string = XMLUtility.getValue(element, "TARGET")) != null && string.trim().length() > 0) {
            this.target = string;
        }
    }
}

