/*
 * Decompiled with CFR 0.152.
 */
package com.hero.objects.talents;

import com.hero.HeroDesigner;
import com.hero.objects.GenericObject;
import com.hero.objects.characteristics.Characteristic;
import com.hero.objects.skills.CharacteristicChoice;
import com.hero.objects.talents.Talent;
import com.hero.ui.dialog.GenericDialog;
import com.hero.ui.dialog.SimulateDeathDialog;
import com.hero.util.Constants;
import com.hero.util.Rounder;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;

public class SimulateDeath
extends Talent {
    private static String xmlID = "SIMULATE_DEATH";
    protected int characteristic;
    protected ArrayList<CharacteristicChoice> characteristicChoices;

    public SimulateDeath(Element element) {
        super(element, xmlID);
    }

    public int getCharacteristic() {
        return this.characteristic;
    }

    public ArrayList<CharacteristicChoice> getCharacteristicChoices() {
        return this.characteristicChoices;
    }

    @Override
    public String getColumn2Output() {
        String string;
        String string2 = this.getAlias();
        if (this.getName() != null && this.getName().trim().length() > 0) {
            string2 = "<i>" + this.getName() + ":</i>  " + string2;
        }
        if (this.getLevels() != 0) {
            string2 = string2 + " (+" + this.getLevels() + " to roll)";
        }
        if (this.getInput() != null && this.getInput().trim().length() > 0) {
            string2 = string2 + ":  " + this.getInput();
        }
        if (!HeroDesigner.getInstance().getPrefs().useWG() && this.getCharacteristicChoices() != null && this.getCharacteristicChoices().size() > 1 && this.getCharacteristic() != 0) {
            string2 = string2 + " (" + Constants.getCharacteristicString(this.getCharacteristic()) + "-based)";
        }
        if ((string = this.getAdderString()).trim().length() > 0) {
            string2 = string2 + " (";
            string2 = string2 + string;
            string2 = string2 + ")";
        }
        string2 = string2 + this.getModifierString();
        if (this.getEndUsage() > 0 && GenericObject.findObjectByID(HeroDesigner.getActiveHero().getPowers(), "ENDURANCERESERVE") != null && GenericObject.findObjectByID(this.getAssignedModifiers(), "ENDRESERVEOREND") == null && !HeroDesigner.getInstance().getPrefs().useWG()) {
            string2 = this.getUseENDReserve() ? string2 + " (uses END Reserve)" : string2 + " (uses Personal END)";
        }
        return string2;
    }

    @Override
    public GenericDialog getDialog(boolean bl, boolean bl2) {
        SimulateDeathDialog simulateDeathDialog = new SimulateDeathDialog(this, bl, bl2);
        return simulateDeathDialog;
    }

    @Override
    public String getRoll() {
        String string = "";
        if (HeroDesigner.getActiveHero() != null) {
            Characteristic characteristic = HeroDesigner.getActiveHero().getCharacteristic(this.characteristic);
            int n = (int)Rounder.roundHalfUp(11.0 + (double)this.getLevels() * this.getLevelValue());
            if (this.getLevels() < 0) {
                n = this.getMinimumLevel();
            } else if (characteristic != null && !characteristic.getXMLID().equals("GENERAL")) {
                n = 9 + (int)((double)Rounder.roundHalfUp(characteristic.getPrimaryValue() / 5.0) + (double)this.getLevels() * this.getLevelValue());
            } else if (characteristic != null && characteristic.getXMLID().equals("GENERAL")) {
                n = 9 + (int)((double)Rounder.roundHalfUp((double)HeroDesigner.getActiveTemplate().getGeneralLevel() / 5.0) + (double)this.getLevels() * this.getLevelValue());
            }
            string = string + n + "-";
        } else {
            string = "11-";
        }
        return string;
    }

    @Override
    public Element getSaveXML() {
        Element element = super.getSaveXML();
        element.setAttribute("CHARACTERISTIC", Constants.getCharacteristicString(this.getCharacteristic()));
        return element;
    }

    @Override
    protected void init(Element element) {
        this.display = "Simulate Death";
        this.baseCost = 15.0;
        this.levelCost = 1.0;
        this.levelValue = 1.0;
        this.exclusive = true;
        this.characteristicChoices = new ArrayList();
        this.characteristic = 0;
        super.init(element);
        Element element2 = element.getChild("CHARACTERISTIC_CHOICE");
        if (element2 != null) {
            List list = element2.getChildren("ITEM");
            for (Element element3 : list) {
                if (element3 == null) continue;
                CharacteristicChoice characteristicChoice = new CharacteristicChoice(element3);
                this.characteristicChoices.add(characteristicChoice);
            }
        }
    }

    @Override
    public void restoreFromSave(Element element) {
        super.restoreFromSave(element);
        String string = element.getChildTextTrim("CHARACTERISTIC");
        if (string != null && string.trim().length() > 0) {
            this.setCharacteristic(Constants.getCharacteristicInteger(string));
        }
    }

    public void setCharacteristic(int n) {
        for (CharacteristicChoice characteristicChoice : this.getCharacteristicChoices()) {
            if (characteristicChoice.getCharacteristic() != n) continue;
            this.characteristic = n;
            if (characteristicChoice.getBaseCost() >= 0.0) {
                this.setBaseCost(characteristicChoice.getBaseCost());
            }
            if (characteristicChoice.getLevelCost() >= 0.0) {
                this.setLevelCost(characteristicChoice.getLevelCost());
            }
            if (characteristicChoice.getLevelValue() >= 0.0) {
                this.setLevelValue(characteristicChoice.getLevelValue());
            }
            if (characteristicChoice.getMinimumCost() > -999.0) {
                this.setMinimumCost(characteristicChoice.getMinimumCost());
            }
            if (characteristicChoice.getMinimumLevel() < 0) continue;
            this.setMinimumLevel(characteristicChoice.getMinimumLevel());
        }
    }
}

