/*
 * Decompiled with CFR 0.152.
 */
package com.hero.objects.talents;

import com.hero.HeroDesigner;
import com.hero.objects.Adder;
import com.hero.objects.GenericObject;
import com.hero.objects.characteristics.Characteristic;
import com.hero.objects.talents.Talent;
import com.hero.ui.dialog.DangerSenseDialog;
import com.hero.ui.dialog.GenericDialog;
import com.hero.util.Rounder;
import java.util.ArrayList;
import org.jdom.Element;

public class DangerSense
extends Talent {
    private static String xmlID = "DANGER_SENSE";

    public DangerSense(Element element) {
        super(element, xmlID);
    }

    @Override
    public ArrayList<Adder> getAssignedAdders() {
        ArrayList<Adder> arrayList = super.getAssignedAdders();
        Adder adder = null;
        Adder adder2 = null;
        Adder adder3 = null;
        if (GenericObject.findObjectByID(arrayList, "AREA") != null) {
            adder = (Adder)GenericObject.findObjectByID(arrayList, "AREA");
        }
        if (GenericObject.findObjectByID(arrayList, "SENSITIVITY") != null) {
            adder2 = (Adder)GenericObject.findObjectByID(arrayList, "SENSITIVITY");
        }
        if (GenericObject.findObjectByID(arrayList, "INTUITIONAL") != null) {
            adder3 = (Adder)GenericObject.findObjectByID(arrayList, "INTUITIONAL");
        }
        if (adder3 == null) {
            return arrayList;
        }
        if ((adder == null || adder.getSelectedOption().getXMLID().equals("IMMEDIATE_VICINITY")) && (adder2 == null || adder2.getSelectedOption().getXMLID().equals("OUT_OF_COMBAT"))) {
            return arrayList;
        }
        arrayList.remove(adder3);
        return arrayList;
    }

    @Override
    public ArrayList<Adder> getAvailableAdders() {
        ArrayList arrayList = (ArrayList)super.getAvailableAdders().clone();
        Adder adder = null;
        Adder adder2 = null;
        Adder adder3 = null;
        if (GenericObject.findObjectByID(arrayList, "AREA") != null) {
            adder = (Adder)GenericObject.findObjectByID(arrayList, "AREA");
        }
        if (GenericObject.findObjectByID(arrayList, "SENSITIVITY") != null) {
            adder2 = (Adder)GenericObject.findObjectByID(arrayList, "SENSITIVITY");
        }
        if (GenericObject.findObjectByID(arrayList, "INTUITIONAL") != null) {
            adder3 = (Adder)GenericObject.findObjectByID(arrayList, "INTUITIONAL");
        }
        if (adder3 == null) {
            return arrayList;
        }
        if ((adder == null || adder.getSelectedOption().getXMLID().equals("IMMEDIATE_VICINITY")) && (adder2 == null || adder2.getSelectedOption().getXMLID().equals("OUT_OF_COMBAT"))) {
            return arrayList;
        }
        arrayList.remove(adder3);
        return arrayList;
    }

    @Override
    public String getColumn2Output() {
        Object object;
        String string = this.getAlias();
        String string2 = "self only";
        String string3 = "in combat";
        if (GenericObject.findObjectByID(this.getAssignedAdders(), "AREA") != null) {
            object = (Adder)GenericObject.findObjectByID(this.getAssignedAdders(), "AREA");
            ((Adder)object).setDisplayInString(false);
            if (((Adder)object).isSelected()) {
                string2 = ((GenericObject)object).getSelectedOption().getAlias();
            }
        }
        if (GenericObject.findObjectByID(this.getAssignedAdders(), "SENSITIVITY") != null) {
            object = (Adder)GenericObject.findObjectByID(this.getAssignedAdders(), "SENSITIVITY");
            ((Adder)object).setDisplayInString(false);
            if (((Adder)object).isSelected()) {
                string3 = ((GenericObject)object).getSelectedOption().getAlias();
            }
        }
        if (this.getName() != null && this.getName().trim().length() > 0) {
            string = "<i>" + this.getName() + ":</i>  " + string;
        }
        if (this.getInput() != null && this.getInput().trim().length() > 0) {
            string = string + ":  " + this.getInput();
        }
        string = string + " (" + string2 + ", " + string3;
        if (this.getSelectedOption() != null) {
            string = string + ", " + this.getSelectedOption().getAlias();
            object = this.getAdderString();
            if (((String)object).trim().length() > 0) {
                string = string + ", " + (String)object;
            }
        } else {
            object = this.getAdderString();
            if (((String)object).trim().length() > 0) {
                string = string + ", " + (String)object;
            }
        }
        string = string + ")";
        string = string + this.getModifierString();
        if (this.getRoll() != null && this.getRoll().trim().length() > 0) {
            string = string + " " + this.getRoll();
        }
        if (this.getEndUsage() > 0 && GenericObject.findObjectByID(HeroDesigner.getActiveHero().getPowers(), "ENDURANCERESERVE") != null && GenericObject.findObjectByID(this.getAssignedModifiers(), "ENDRESERVEOREND") == null && !HeroDesigner.getInstance().getPrefs().useWG()) {
            string = this.getUseENDReserve() ? string + " (uses END Reserve)" : string + " (uses Personal END)";
        }
        return string;
    }

    @Override
    public GenericDialog getDialog(boolean bl, boolean bl2) {
        DangerSenseDialog dangerSenseDialog = new DangerSenseDialog(this, bl, bl2);
        return dangerSenseDialog;
    }

    @Override
    public String getRoll() {
        String string = "";
        if (HeroDesigner.getActiveHero() != null) {
            int n;
            Characteristic characteristic = HeroDesigner.getActiveHero().getCharacteristic(5);
            int n2 = 11;
            int n3 = 11;
            if (characteristic != null && characteristic.getPerIncrease() > 0.0 && characteristic.getPerIncreaseLevels() > 0) {
                n = (int)Rounder.roundHalfUp(characteristic.getPerIncrease() * characteristic.getPrimaryValue() / (double)characteristic.getPerIncreaseLevels());
                n2 = (int)(9L + Rounder.roundHalfUp(n));
                n = (int)Rounder.roundHalfUp(characteristic.getPerIncrease() * characteristic.getSecondaryValue() / (double)characteristic.getPerIncreaseLevels());
                n3 = (int)(9L + Rounder.roundHalfUp(n));
            }
            n = (int)Rounder.roundHalfUp((double)n2 + (double)this.getLevels() * this.getLevelValue());
            int n4 = (int)Rounder.roundHalfUp((double)n3 + (double)this.getLevels() * this.getLevelValue());
            if (this.getLevels() < 0) {
                n = this.getMinimumLevel();
            }
            string = string + n + "-";
            if (n != n4) {
                string = string + "/" + n4 + "-";
            }
        } else {
            string = "11-";
        }
        return string;
    }

    @Override
    public Element getSaveXML() {
        Element element = super.getSaveXML();
        element.setAttribute("LEVELS", "" + this.getLevels());
        return element;
    }
}

