/*
 * Decompiled with CFR 0.152.
 */
package com.hero.objects.talents;

import com.hero.objects.talents.Talent;
import com.hero.ui.dialog.CustomTalentDialog;
import com.hero.ui.dialog.GenericDialog;
import com.hero.util.XMLUtility;
import org.jdom.Element;

public class CustomTalent
extends Talent {
    private static String xmlID = "CUSTOMTALENT";
    private int roll;

    public CustomTalent(Element element) {
        super(element, xmlID);
        this.minimumLevel = -999;
    }

    @Override
    public GenericDialog getDialog(boolean bl, boolean bl2) {
        CustomTalentDialog customTalentDialog = new CustomTalentDialog(this, bl, bl2);
        return customTalentDialog;
    }

    @Override
    public String getRoll() {
        if (this.roll == 0) {
            return "";
        }
        return this.roll + "-";
    }

    public int getRollValue() {
        return this.roll;
    }

    @Override
    public Element getSaveXML() {
        Element element = super.getSaveXML();
        element.setAttribute("LEVELS", "" + this.getLevels());
        element.setAttribute("ROLL", "" + this.roll);
        return element;
    }

    @Override
    public void restoreFromSave(Element element) {
        super.restoreFromSave(element);
        String string = XMLUtility.getValue(element, "ROLL");
        if (string != null && string.trim().length() > 0) {
            try {
                this.roll = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                this.roll = 0;
            }
        } else {
            this.roll = 0;
        }
    }

    public void setRoll(int n) {
        this.roll = n;
    }
}

