/*
 * Decompiled with CFR 0.152.
 */
package com.hero.objects.talents;

import com.hero.objects.talents.Talent;
import com.hero.ui.dialog.CombatLuckDialog;
import com.hero.ui.dialog.GenericDialog;
import com.hero.util.XMLUtility;
import org.jdom.Element;

public class CombatLuck
extends Talent {
    private static String xmlID = "COMBAT_LUCK";
    protected boolean affectsPrimary;
    protected boolean affectsTotal;

    public CombatLuck(Element element) {
        super(element, xmlID);
        this.setLevels(this.getLevels());
    }

    public boolean getAffectPrimary() {
        return this.affectsPrimary;
    }

    public boolean getAffectTotal() {
        if (this.affectsPrimary) {
            this.affectsTotal = true;
        }
        return this.affectsTotal;
    }

    @Override
    public GenericDialog getDialog(boolean bl, boolean bl2) {
        CombatLuckDialog combatLuckDialog = new CombatLuckDialog(this, bl, bl2);
        return combatLuckDialog;
    }

    public int getEdIncrease() {
        return 3;
    }

    public int getEdIncreaseLevels() {
        return 1;
    }

    public int getPdIncrease() {
        return 3;
    }

    public int getPdIncreaseLevels() {
        return 1;
    }

    @Override
    public Element getSaveXML() {
        Element element = super.getSaveXML();
        element.setAttribute("LEVELS", "" + this.getLevels());
        element.setAttribute("AFFECTS_PRIMARY", this.getAffectPrimary() ? "Yes" : "No");
        element.setAttribute("AFFECTS_TOTAL", this.getAffectTotal() ? "Yes" : "No");
        return element;
    }

    @Override
    public void restoreFromSave(Element element) {
        super.restoreFromSave(element);
        String string = XMLUtility.getValue(element, "AFFECTS_PRIMARY");
        if (string != null && string.trim().length() > 0) {
            this.affectsPrimary = string.trim().toUpperCase().startsWith("Y");
        }
        if ((string = XMLUtility.getValue(element, "AFFECTS_TOTAL")) != null && string.trim().length() > 0) {
            this.affectsTotal = string.trim().toUpperCase().startsWith("Y");
        }
    }

    public void setAffectPrimary(boolean bl) {
        this.affectsPrimary = bl;
    }

    public void setAffectTotal(boolean bl) {
        this.affectsTotal = bl;
    }

    @Override
    public void setLevels(int n) {
        super.setLevels(n);
        String string = this.getDisplay();
        int n2 = this.getPdIncrease() * this.getLevels() / this.getPdIncreaseLevels();
        int n3 = this.getEdIncrease() * this.getLevels() / this.getEdIncreaseLevels();
        string = string + " (" + n2 + " PD/" + n3 + " ED)";
        this.setAlias(string);
    }
}

