/*
 * Decompiled with CFR 0.152.
 */
package com.hero.objects.skills;

import com.hero.HeroDesigner;
import com.hero.objects.Adder;
import com.hero.objects.GenericObject;
import com.hero.objects.skills.Skill;
import com.hero.util.Constants;
import java.util.ArrayList;
import org.jdom.Element;

public class TransportFamiliarity
extends Skill {
    private static String xmlID = "TRANSPORT_FAMILIARITY";
    private boolean combatDrivingDiscounted = false;
    private boolean combatPilotingDiscounted = false;
    private boolean ridingDiscounted = false;

    public TransportFamiliarity(Element element) {
        super(element, xmlID);
        this.alias = "TF";
    }

    private boolean checkForBonus(String string, ArrayList<Adder> arrayList) {
        for (Adder adder : arrayList) {
            boolean bl;
            if (adder.containsType(string) && adder.getTotalCost() == 1.0) {
                return true;
            }
            if (adder.getAssignedAdders() == null || adder.getAssignedAdders().size() <= 0 || adder.isSelected() || !(bl = this.checkForBonus(string, adder.getAssignedAdders()))) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getColumn2Output() {
        String string;
        String string2;
        String string3 = this.getAlias();
        if (this.getInput() != null && this.getInput().trim().length() > 0) {
            string3 = string3 + ":  " + this.getInput();
        }
        if (!HeroDesigner.getInstance().getPrefs().useWG() && this.getCharacteristicChoices() != null && this.getCharacteristicChoices().size() > 1 && this.getCharacteristic() != 0) {
            string3 = string3 + " (" + Constants.getCharacteristicString(this.getCharacteristic()) + "-based)";
        }
        if ((string2 = this.getAdderString()).trim().length() > 0) {
            string3 = string3 + ":  ";
            string3 = string3 + string2;
        }
        if ((string = this.getModifierString()).trim().length() > 0) {
            string3 = string3 + " ";
            string3 = string3 + this.getModifierString();
        }
        if (this.getEndUsage() > 0 && GenericObject.findObjectByID(HeroDesigner.getActiveHero().getPowers(), "ENDURANCERESERVE") != null && GenericObject.findObjectByID(this.getAllAssignedModifiers(), "ENDRESERVEOREND") == null && !HeroDesigner.getInstance().getPrefs().useWG()) {
            string3 = this.getUseENDReserve() ? string3 + " (uses END Reserve)" : string3 + " (uses Personal END)";
        }
        return string3;
    }

    @Override
    public String getColumn3Output() {
        return "";
    }

    @Override
    public String getRoll() {
        return "";
    }

    @Override
    public double getTotalCost() {
        ArrayList<GenericObject> arrayList;
        double d = super.getTotalCost();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        ArrayList<Adder> arrayList2 = this.getAssignedAdders();
        bl = this.checkForBonus("DRIVING", arrayList2);
        bl2 = this.checkForBonus("PILOTING", arrayList2);
        bl3 = this.checkForBonus("RIDING", arrayList2);
        if (bl) {
            bl = false;
            arrayList = HeroDesigner.getActiveHero().getSkills();
            for (GenericObject genericObject : arrayList) {
                if (!genericObject.getXMLID().equalsIgnoreCase("COMBAT_DRIVING")) continue;
                bl = true;
            }
        }
        if (bl2) {
            bl2 = false;
            arrayList = HeroDesigner.getActiveHero().getSkills();
            for (GenericObject genericObject : arrayList) {
                if (!genericObject.getXMLID().equalsIgnoreCase("COMBAT_PILOTING")) continue;
                bl2 = true;
            }
        }
        if (bl3) {
            bl3 = false;
            arrayList = HeroDesigner.getActiveHero().getSkills();
            for (GenericObject genericObject : arrayList) {
                if (!genericObject.getXMLID().equalsIgnoreCase("RIDING")) continue;
                bl3 = true;
            }
        }
        if (bl || bl2 || bl3) {
            arrayList = HeroDesigner.getActiveHero().getSkills();
            for (GenericObject genericObject : arrayList) {
                if (!genericObject.getXMLID().equals(this.getXMLID()) || genericObject.getID() == this.getID()) continue;
                TransportFamiliarity transportFamiliarity = (TransportFamiliarity)genericObject;
                if (transportFamiliarity.isCombatDrivingDiscounted()) {
                    bl = false;
                }
                if (transportFamiliarity.isCombatPilotingDiscounted()) {
                    bl2 = false;
                }
                if (!transportFamiliarity.isRidingDiscounted()) continue;
                bl3 = false;
            }
        }
        if (bl) {
            this.combatDrivingDiscounted = true;
            d += -1.0;
        }
        if (bl2) {
            this.combatPilotingDiscounted = true;
            d += -1.0;
        }
        if (bl3) {
            this.ridingDiscounted = true;
            d += -1.0;
        }
        return d;
    }

    @Override
    protected void init(Element element) {
        this.rollBased = false;
        super.init(element);
    }

    private boolean isCombatDrivingDiscounted() {
        return this.combatDrivingDiscounted;
    }

    private boolean isCombatPilotingDiscounted() {
        return this.combatPilotingDiscounted;
    }

    private boolean isRidingDiscounted() {
        return this.ridingDiscounted;
    }
}

