/*
 * Decompiled with CFR 0.152.
 */
package com.hero.objects.skills;

import com.hero.HeroDesigner;
import com.hero.objects.Adder;
import com.hero.objects.GenericObject;
import com.hero.objects.characteristics.Characteristic;
import com.hero.objects.powers.Automaton;
import com.hero.objects.skills.CharacteristicChoice;
import com.hero.ui.dialog.GenericDialog;
import com.hero.ui.dialog.SkillDialog;
import com.hero.util.Constants;
import com.hero.util.Rounder;
import com.hero.util.XMLUtility;
import java.util.ArrayList;
import java.util.Iterator;
import org.jdom.Element;

public class Skill
extends GenericObject {
    protected boolean area;
    protected int characteristic;
    protected ArrayList<CharacteristicChoice> characteristicChoices;
    protected boolean contact;
    protected boolean everyman;
    protected boolean familiarity;
    protected int familiarityCost;
    protected int familiarityRoll;
    protected boolean includeFamiliarity;
    protected boolean proficiency;
    protected int proficiencyCost;
    protected int proficiencyRoll;
    protected boolean includeProficiency;
    protected boolean knowledge;
    protected boolean language;
    protected boolean professional;
    protected boolean levelsOnly;
    protected boolean displayLevelsOnly;
    protected boolean scientist;
    protected boolean rollBased = true;
    protected boolean showRoll = true;

    public Skill(Element element) {
        super(element);
    }

    public Skill(Element element, String string) {
        super(element, string);
    }

    @Override
    public double getBaseCost() {
        if (this.isFamiliarity() && this.isEveryman()) {
            return 0.0;
        }
        if (this.isFamiliarity() && (double)this.familiarityCost < super.getBaseCost()) {
            return this.familiarityCost;
        }
        if (this.isProficiency() && (double)this.proficiencyCost < super.getBaseCost()) {
            return this.proficiencyCost;
        }
        if (this.levelsOnly) {
            return 0.0;
        }
        return super.getBaseCost();
    }

    public int getCharacteristic() {
        return this.characteristic;
    }

    public String getCharacteristicString() {
        if (this.characteristic < 0) {
            return "";
        }
        return Constants.getCharacteristicString(this.getCharacteristic());
    }

    public ArrayList<CharacteristicChoice> getCharacteristicChoices() {
        if (this.characteristicChoices == null) {
            this.characteristicChoices = new ArrayList();
        }
        return this.characteristicChoices;
    }

    public String getColumn2OutputWithoutRoll() {
        this.showRoll = false;
        String string = this.getName();
        this.setName("");
        String string2 = this.getColumn2Output();
        this.showRoll = true;
        this.setName(string);
        return string2;
    }

    @Override
    public String getColumn2Output() {
        String string;
        if (this.levelsOnly) {
            return this.getLevelOnlyOutput();
        }
        String string2 = this.getAlias();
        if (this.displayLevelsOnly) {
            string2 = this.getLevels() > 0 ? "+" : "";
            string2 = string2 + this.getLevels();
        }
        if (this.getName() != null && this.getName().trim().length() > 0) {
            string2 = "<i>" + this.getName() + ":</i>  " + string2;
        }
        if (this.getInput() != null && this.getInput().trim().length() > 0) {
            string2 = string2 + ":  " + this.getInput();
        }
        if (this.getSelectedOption() != null) {
            string2 = !this.displayLevelsOnly ? string2 + ":  " + this.getSelectedOption().getAlias() : string2 + " " + this.getSelectedOption().getAlias();
        }
        if (!HeroDesigner.getInstance().getPrefs().useWG() && this.getCharacteristicChoices() != null && this.getCharacteristicChoices().size() > 1 && this.getCharacteristic() != 0) {
            string2 = string2 + " (" + Constants.getCharacteristicString(this.getCharacteristic()) + "-based)";
        }
        if ((string = this.getAdderString()).trim().length() > 0) {
            string2 = string2 + " (";
            string2 = string2 + string;
            string2 = string2 + ")";
        }
        if (!this.displayLevelsOnly && this.showRoll) {
            string2 = string2 + " " + this.getRoll();
        }
        string2 = string2 + this.getModifierString();
        if (this.getEndUsage() > 0 && GenericObject.findObjectByID(HeroDesigner.getActiveHero().getPowers(), "ENDURANCERESERVE") != null && GenericObject.findObjectByID(this.getAllAssignedModifiers(), "ENDRESERVEOREND") == null && !HeroDesigner.getInstance().getPrefs().useWG()) {
            string2 = this.getUseENDReserve() ? string2 + " (uses END Reserve)" : string2 + " (uses Personal END)";
        }
        return string2;
    }

    @Override
    public String getColumn3Output() {
        if (this.getEndUsage() > 0) {
            return "" + this.getEndUsage();
        }
        return "";
    }

    @Override
    public GenericDialog getDialog(boolean bl, boolean bl2) {
        SkillDialog skillDialog = new SkillDialog(this, bl, bl2);
        return skillDialog;
    }

    public int getFamiliarityRoll() {
        return this.familiarityRoll;
    }

    public int getProficiencyRoll() {
        return this.proficiencyRoll;
    }

    protected String getLevelOnlyOutput() {
        String string;
        String string2;
        String string3 = string2 = this.getLevels() >= 0 ? "+" : "-";
        if (this.getName() != null && this.getName().trim().length() > 0) {
            string2 = "<i>" + this.getName() + ":</i>  " + string2;
        }
        string2 = string2 + this.getLevels() + " with " + this.getAlias();
        if (this.getInput().trim().length() > 0) {
            string2 = string2 + ": " + this.getInput();
        }
        if ((string = this.getAdderString()).trim().length() > 0) {
            string2 = string2 + " (";
            string2 = string2 + string;
            string2 = string2 + ")";
        }
        string2 = string2 + this.getModifierString();
        if (this.getEndUsage() > 0 && GenericObject.findObjectByID(HeroDesigner.getActiveHero().getPowers(), "ENDURANCERESERVE") != null && GenericObject.findObjectByID(this.getAllAssignedModifiers(), "ENDRESERVEOREND") == null && !HeroDesigner.getInstance().getPrefs().useWG()) {
            string2 = this.getUseENDReserve() ? string2 + " (uses END Reserve)" : string2 + " (uses Personal END)";
        }
        return string2;
    }

    @Override
    public int getLevels() {
        if (this.isFamiliarity()) {
            return 0;
        }
        if (this.isProficiency()) {
            return 0;
        }
        return super.getLevels();
    }

    @Override
    public double getMinimumCost() {
        if (this.isEveryman()) {
            return 0.0;
        }
        if (this.isFamiliarity()) {
            return this.familiarityCost;
        }
        if (this.isProficiency()) {
            return this.proficiencyCost;
        }
        if (this.levelsOnly()) {
            return 0.0;
        }
        return this.minimumCost;
    }

    @Override
    public double getRealCostPreList() {
        boolean bl = false;
        for (int i = 0; i < this.getAssignedAdders().size(); ++i) {
            Adder adder = this.getAssignedAdders().get(i);
            if (GenericObject.findObjectByID(this.getAvailableAdders(), adder.getXMLID()) != null) continue;
            bl = true;
            break;
        }
        if (bl) {
            return super.getRealCostPreList();
        }
        if (this.isFamiliarity() && this.isEveryman()) {
            return 0.0;
        }
        return super.getRealCostPreList();
    }

    public String getRoll() {
        if (this.displayLevelsOnly) {
            return "";
        }
        if (this.levelsOnly) {
            String string = this.getLevels() >= 0 ? "+" : "-";
            string = string + this.getLevels() + " with " + this.getAlias();
            return string;
        }
        if (this.levelValue < 1.0 && this.levelCost < 1.0) {
            return "";
        }
        int n = this.getRollValue();
        int n2 = this.getSecondaryRollValue();
        String string = "";
        if (n == 0) {
            return "";
        }
        string = n != n2 ? n + "- (" + n2 + "-)" : n + "-";
        return string;
    }

    public int getRollValue() {
        int n = 0;
        if (this.isFamiliarity()) {
            n = this.getFamiliarityRoll() > 0 ? this.getFamiliarityRoll() : 8;
        } else if (this.isProficiency()) {
            n = this.getProficiencyRoll() > 0 ? this.getProficiencyRoll() : 10;
        } else if (this.isFocus() && HeroDesigner.getActiveHero() != null) {
            int n2 = HeroDesigner.getActiveHero().getRules().getSkillRollBase();
            n2 = this.getLevels() < 0 ? this.getMinimumLevel() : (n2 += this.getLevels());
            n = n2;
        } else if (HeroDesigner.getActiveHero() != null) {
            Characteristic characteristic = HeroDesigner.getActiveHero().getCharacteristic(this.characteristic);
            int n3 = HeroDesigner.getActiveHero().getRules().getSkillRollBase();
            n3 = characteristic != null && !characteristic.getXMLID().equals("GENERAL") ? HeroDesigner.getActiveHero().getRules().getSkillRollBase() + (int)((double)Rounder.roundHalfUp(characteristic.getPrimaryValue() / HeroDesigner.getActiveHero().getRules().getSkillRollDenominator()) + (double)this.getLevels() * this.getLevelValue()) : (this.characteristic == 0 ? HeroDesigner.getActiveHero().getRules().getSkillRollBase() + (int)((double)Rounder.roundHalfUp((double)HeroDesigner.getActiveTemplate().getGeneralLevel() / HeroDesigner.getActiveHero().getRules().getSkillRollDenominator()) + (double)this.getLevels() * this.getLevelValue()) : HeroDesigner.getActiveHero().getRules().getSkillRollBase() + (int)Rounder.roundHalfUp((double)this.getLevels() * this.getLevelValue()));
            n = n3;
        } else {
            int n4;
            n = n4 = 9 + (int)((double)Rounder.roundHalfUp(HeroDesigner.getActiveTemplate().getGeneralLevel() / 5) + (double)this.getLevels() * this.getLevelValue());
        }
        return n;
    }

    @Override
    public Element getSaveXML() {
        Element element = this.getGeneralSaveXML();
        element.setName("SKILL");
        element.setAttribute("CHARACTERISTIC", Constants.getCharacteristicString(this.getCharacteristic()));
        element.setAttribute("FAMILIARITY", this.isFamiliarity() ? "Yes" : "No");
        element.setAttribute("PROFICIENCY", this.isProficiency() ? "Yes" : "No");
        if (this.levelsOnlyAllowed()) {
            element.setAttribute("LEVELSONLY", this.levelsOnly() ? "Yes" : "No");
        }
        if (this.isFamiliarity()) {
            element.setAttribute("EVERYMAN", this.isEveryman() ? "Yes" : "No");
        }
        return element;
    }

    public int getSecondaryRollValue() {
        int n = 0;
        if (this.isFamiliarity()) {
            n = this.getFamiliarityRoll() > 0 ? this.getFamiliarityRoll() : 8;
        } else if (this.isProficiency()) {
            n = this.getProficiencyRoll() > 0 ? this.getProficiencyRoll() : 10;
        } else if (this.isFocus() && HeroDesigner.getActiveHero() != null) {
            int n2 = HeroDesigner.getActiveHero().getRules().getSkillRollBase();
            n2 = this.getLevels() < 0 ? this.getMinimumLevel() : (n2 += this.getLevels());
            n = n2;
        } else if (HeroDesigner.getActiveHero() != null) {
            Characteristic characteristic = HeroDesigner.getActiveHero().getCharacteristic(this.characteristic);
            int n3 = HeroDesigner.getActiveHero().getRules().getSkillRollBase();
            int n4 = HeroDesigner.getActiveHero().getRules().getSkillRollBase();
            if (characteristic != null && !characteristic.getXMLID().equals("GENERAL")) {
                n3 = HeroDesigner.getActiveHero().getRules().getSkillRollBase() + (int)((double)Rounder.roundHalfUp(characteristic.getPrimaryValue() / HeroDesigner.getActiveHero().getRules().getSkillRollDenominator()) + (double)this.getLevels() * this.getLevelValue());
                n4 = HeroDesigner.getActiveHero().getRules().getSkillRollBase() + (int)((double)Rounder.roundHalfUp(characteristic.getSecondaryValue() / HeroDesigner.getActiveHero().getRules().getSkillRollDenominator()) + (double)this.getLevels() * this.getLevelValue());
            } else {
                n4 = this.characteristic == 0 ? (n3 = HeroDesigner.getActiveHero().getRules().getSkillRollBase() + (int)((double)Rounder.roundHalfUp((double)HeroDesigner.getActiveTemplate().getGeneralLevel() / HeroDesigner.getActiveHero().getRules().getSkillRollDenominator()) + (double)this.getLevels() * this.getLevelValue())) : (n3 = HeroDesigner.getActiveHero().getRules().getSkillRollBase() + (int)Rounder.roundHalfUp((double)this.getLevels() * this.getLevelValue()));
            }
            n = n4;
        } else {
            int n5;
            n = n5 = 9 + (int)((double)Rounder.roundHalfUp(HeroDesigner.getActiveTemplate().getGeneralLevel() / 5) + (double)this.getLevels() * this.getLevelValue());
        }
        return n;
    }

    @Override
    public double getTotalCost() {
        double d = this.getBaseCost();
        ArrayList<Adder> arrayList = this.getAvailableAdders();
        if (this.getLevelValue() != 0.0) {
            d += (double)this.getLevels() / this.getLevelValue() * this.getLevelCost();
            if (this.getLevels() > 0 && HeroDesigner.getActiveHero().getRules().getUseSkillMaxima() && this.rollBased) {
                int n = HeroDesigner.getActiveHero().getRules().getSkillMaximaLimit();
                int n2 = this.getRollValue();
                int n3 = this.getSecondaryRollValue();
                if (n3 > n2) {
                    n2 = n3;
                }
                if (n2 > n) {
                    int n4 = n2 - n;
                    if (n4 > this.getLevels()) {
                        n4 = this.getLevels();
                    }
                    d += (double)n4 / this.getLevelValue() * this.getLevelCost();
                }
            }
            if (this.getLevelCost() < this.getLevelValue()) {
                d = d > 0.0 && d < 1.0 ? 1.0 : (double)Rounder.roundHalfDown(d);
            }
        }
        for (Adder adder : this.getAssignedAdders()) {
            if (!adder.isRequired()) continue;
            d += adder.getRealCost();
        }
        for (Adder adder : this.getAssignedAdders()) {
            if (adder.isRequired() || GenericObject.findObjectByID(arrayList, adder.getXMLID()) == null) continue;
            d += adder.getRealCost();
        }
        if (d < this.getMinimumCost() && this.isMinSet() && !this.levelsOnly) {
            d = this.getMinimumCost();
        } else if (d > this.getMaxCost() && this.isMaxSet() && !this.levelsOnly) {
            d = this.getMaxCost();
        }
        Object object = this.getAssignedAdders().iterator();
        while (object.hasNext()) {
            Adder adder = object.next();
            if (adder.isRequired() || GenericObject.findObjectByID(arrayList, adder.getXMLID()) != null) continue;
            d += adder.getRealCost();
        }
        if (this.getTypes().contains("DEFENSE") && HeroDesigner.getActiveHero() != null && GenericObject.findObjectByID(HeroDesigner.getActiveHero().getPowers(), "AUTOMATON") != null && ((GenericObject)(object = (Automaton)GenericObject.findObjectByID(HeroDesigner.getActiveHero().getPowers(), "AUTOMATON"))).getSelectedOption().getXMLID().toUpperCase().startsWith("NOSTUN")) {
            d *= (double)((Automaton)object).getDefenseCostMultiplier();
        }
        return d;
    }

    public boolean includeFamiliarity() {
        return this.includeFamiliarity;
    }

    public boolean includeProficiency() {
        return this.includeProficiency;
    }

    @Override
    protected void init(Element element) {
        Object object;
        this.characteristicChoices = new ArrayList();
        this.familiarityRoll = 8;
        this.proficiencyRoll = 10;
        this.includeFamiliarity = false;
        this.includeProficiency = false;
        this.proficiencyCost = 2;
        this.duration = "CONSTANT";
        super.init(element);
        this.target = "SELFONLY";
        if (!this.types.contains("SPECIAL")) {
            this.types.add("SPECIAL");
        }
        this.scientist = this.types.contains("SCIENCE");
        this.professional = this.types.contains("PROFESSIONAL");
        this.language = this.types.contains("LANGUAGE");
        this.knowledge = this.types.contains("KNOWLEDGE");
        this.area = this.types.contains("AREA");
        this.contact = this.types.contains("CONTACT");
        Element element2 = element.getChild("CHARACTERISTIC_CHOICE");
        if (element2 != null) {
            object = element2.getChildren("ITEM");
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                Element element3 = (Element)iterator.next();
                if (element3 == null) continue;
                CharacteristicChoice characteristicChoice = new CharacteristicChoice(element3);
                this.characteristicChoices.add(characteristicChoice);
            }
        }
        if ((object = XMLUtility.getValue(element, "FAMILIARITYROLL")) != null && ((String)object).trim().length() > 0) {
            try {
                this.familiarityRoll = Integer.parseInt((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((object = XMLUtility.getValue(element, "PROFICIENCYROLL")) != null && ((String)object).trim().length() > 0) {
            try {
                this.proficiencyRoll = Integer.parseInt((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((object = XMLUtility.getValue(element, "TARGET")) != null && ((String)object).trim().length() > 0) {
            this.target = object;
        }
        if ((object = XMLUtility.getValue(element, "FAMILIARITYCOST")) != null && ((String)object).trim().length() > 0) {
            try {
                this.familiarityCost = Integer.parseInt((String)object);
                this.includeFamiliarity = true;
            }
            catch (NumberFormatException numberFormatException) {
                this.includeFamiliarity = false;
            }
        } else {
            this.includeFamiliarity = false;
        }
        if ((object = XMLUtility.getValue(element, "PROFICIENCYCOST")) != null && ((String)object).trim().length() > 0) {
            try {
                this.proficiencyCost = Integer.parseInt((String)object);
                this.includeProficiency = true;
            }
            catch (NumberFormatException numberFormatException) {
                this.includeProficiency = false;
            }
        } else {
            this.includeProficiency = this.includeFamiliarity;
        }
        this.displayLevelsOnly = (object = XMLUtility.getValue(element, "DISPLAYLEVELSONLY")) != null && ((String)object).trim().toUpperCase().startsWith("Y");
    }

    public boolean isEveryman() {
        if (!this.isFamiliarity()) {
            return false;
        }
        return this.everyman;
    }

    public boolean isFamiliarity() {
        return this.familiarity && !this.proficiency;
    }

    public boolean isProficiency() {
        return this.proficiency;
    }

    protected boolean isFocus() {
        if (GenericObject.findObjectByID(this.getAssignedModifiers(), "FOCUS") != null) {
            return true;
        }
        return this.getParentList() != null && GenericObject.findObjectByID(this.getParentList().getAssignedModifiers(), "FOCUS") != null;
    }

    public boolean levelsOnly() {
        if (this.getRoll().trim().length() > 0 && this.getLevelCost() > 0.0 && this.getLevelValue() != 0.0) {
            return this.levelsOnly;
        }
        return false;
    }

    public boolean levelsOnlyAllowed() {
        return this.getRoll().trim().length() > 0 && this.getLevelCost() > 0.0 && this.getLevelValue() != 0.0;
    }

    @Override
    public void restoreFromSave(Element element) {
        super.restoreFromSave(element);
        String string = XMLUtility.getValue(element, "CHARACTERISTIC");
        if (string != null && string.trim().length() > 0) {
            this.setCharacteristic(Constants.getCharacteristicInteger(string));
        }
        if ((string = XMLUtility.getValue(element, "FAMILIARITY")) != null && string.trim().length() > 0) {
            this.setFamiliarity(string.toUpperCase().startsWith("Y"));
        }
        if ((string = XMLUtility.getValue(element, "PROFICIENCY")) != null && string.trim().length() > 0) {
            this.setProficiency(string.toUpperCase().startsWith("Y"));
        }
        if ((string = XMLUtility.getValue(element, "LEVELSONLY")) != null && string.trim().length() > 0) {
            this.setLevelsOnly(string.toUpperCase().startsWith("Y"));
        }
        if ((string = XMLUtility.getValue(element, "EVERYMAN")) != null && string.trim().toUpperCase().startsWith("Y")) {
            this.setEveryman(true);
        } else {
            this.setEveryman(false);
        }
    }

    public void setCharacteristic(int n) {
        for (CharacteristicChoice characteristicChoice : this.getCharacteristicChoices()) {
            if (characteristicChoice.getCharacteristic() != n) continue;
            this.characteristic = n;
            if (characteristicChoice.getBaseCost() >= 0.0) {
                this.setBaseCost(characteristicChoice.getBaseCost());
            }
            if (characteristicChoice.getLevelCost() >= 0.0) {
                this.setLevelCost(characteristicChoice.getLevelCost());
            }
            if (characteristicChoice.getLevelValue() >= 0.0) {
                this.setLevelValue(characteristicChoice.getLevelValue());
            }
            if (characteristicChoice.isMinSet()) {
                this.setMinimumCost(characteristicChoice.getMinimumCost());
            }
            if (characteristicChoice.getMinimumLevel() < 0) continue;
            this.setMinimumLevel(characteristicChoice.getMinimumLevel());
        }
    }

    public void setEveryman(boolean bl) {
        if (bl) {
            this.levelsOnly = false;
        }
        this.everyman = bl;
    }

    public void setFamiliarity(boolean bl) {
        if (bl) {
            this.levelsOnly = false;
        }
        this.familiarity = bl;
    }

    public void setProficiency(boolean bl) {
        if (bl) {
            this.levelsOnly = false;
        }
        this.proficiency = bl;
    }

    public void setLevelsOnly(boolean bl) {
        if (bl) {
            this.familiarity = false;
            this.everyman = false;
            this.proficiency = false;
        }
        this.levelsOnly = this.getRoll().trim().length() > 0 && this.getLevelCost() > 0.0 && this.getLevelValue() != 0.0 ? bl : false;
    }
}

