/*
 * Decompiled with CFR 0.152.
 */
package com.hero.objects.skills;

import com.hero.HeroDesigner;
import com.hero.objects.GenericObject;
import com.hero.objects.characteristics.Characteristic;
import com.hero.objects.skills.Skill;
import com.hero.util.Constants;
import com.hero.util.Rounder;
import org.jdom.Element;

public class ProfessionalSkill
extends Skill {
    private static String xmlID = "PROFESSIONAL_SKILL";

    public ProfessionalSkill(Element element) {
        super(element, xmlID);
        this.alias = "PS";
    }

    @Override
    public int getRollValue() {
        int n = 0;
        if (this.isFamiliarity()) {
            n = this.isEveryman() ? 11 : (this.getFamiliarityRoll() > 0 ? this.getFamiliarityRoll() : 8);
        } else if (this.isProficiency()) {
            n = this.getProficiencyRoll() > 0 ? this.getProficiencyRoll() : 10;
        } else if (this.isFocus() && HeroDesigner.getActiveHero() != null) {
            int n2 = HeroDesigner.getActiveHero().getRules().getSkillRollBase();
            n2 = this.getLevels() < 0 ? this.getMinimumLevel() : (n2 += this.getLevels());
            n = n2;
        } else if (HeroDesigner.getActiveHero() != null) {
            Characteristic characteristic = HeroDesigner.getActiveHero().getCharacteristic(this.characteristic);
            int n3 = HeroDesigner.getActiveHero().getRules().getSkillRollBase();
            n3 = characteristic != null && !characteristic.getXMLID().equals("GENERAL") ? HeroDesigner.getActiveHero().getRules().getSkillRollBase() + (int)((double)Rounder.roundHalfUp(characteristic.getPrimaryValue() / HeroDesigner.getActiveHero().getRules().getSkillRollDenominator()) + (double)this.getLevels() * this.getLevelValue()) : (this.characteristic == 0 ? HeroDesigner.getActiveHero().getRules().getSkillRollBase() + (int)((double)Rounder.roundHalfUp((double)HeroDesigner.getActiveTemplate().getGeneralLevel() / HeroDesigner.getActiveHero().getRules().getSkillRollDenominator()) + (double)this.getLevels() * this.getLevelValue()) : HeroDesigner.getActiveHero().getRules().getSkillRollBase() + (int)Rounder.roundHalfUp((double)this.getLevels() * this.getLevelValue()));
            n = n3;
        } else {
            int n4;
            n = n4 = 9 + (int)((double)Rounder.roundHalfUp(HeroDesigner.getActiveTemplate().getGeneralLevel() / 5) + (double)this.getLevels() * this.getLevelValue());
        }
        return n;
    }

    @Override
    public int getSecondaryRollValue() {
        int n = 0;
        if (this.isFamiliarity()) {
            n = this.isEveryman() ? 11 : (this.getFamiliarityRoll() > 0 ? this.getFamiliarityRoll() : 8);
        } else if (this.isProficiency()) {
            n = this.getProficiencyRoll() > 0 ? this.getProficiencyRoll() : 10;
        } else if (this.isFocus() && HeroDesigner.getActiveHero() != null) {
            int n2 = HeroDesigner.getActiveHero().getRules().getSkillRollBase();
            n2 = this.getLevels() < 0 ? this.getMinimumLevel() : (n2 += this.getLevels());
            n = n2;
        } else if (HeroDesigner.getActiveHero() != null) {
            Characteristic characteristic = HeroDesigner.getActiveHero().getCharacteristic(this.characteristic);
            int n3 = HeroDesigner.getActiveHero().getRules().getSkillRollBase();
            int n4 = HeroDesigner.getActiveHero().getRules().getSkillRollBase();
            if (characteristic != null && !characteristic.getXMLID().equals("GENERAL")) {
                n3 = HeroDesigner.getActiveHero().getRules().getSkillRollBase() + (int)((double)Rounder.roundHalfUp(characteristic.getPrimaryValue() / HeroDesigner.getActiveHero().getRules().getSkillRollDenominator()) + (double)this.getLevels() * this.getLevelValue());
                n4 = HeroDesigner.getActiveHero().getRules().getSkillRollBase() + (int)((double)Rounder.roundHalfUp(characteristic.getSecondaryValue() / HeroDesigner.getActiveHero().getRules().getSkillRollDenominator()) + (double)this.getLevels() * this.getLevelValue());
            } else {
                n4 = this.characteristic == 0 ? (n3 = HeroDesigner.getActiveHero().getRules().getSkillRollBase() + (int)((double)Rounder.roundHalfUp((double)HeroDesigner.getActiveTemplate().getGeneralLevel() / HeroDesigner.getActiveHero().getRules().getSkillRollDenominator()) + (double)this.getLevels() * this.getLevelValue())) : (n3 = HeroDesigner.getActiveHero().getRules().getSkillRollBase() + (int)Rounder.roundHalfUp((double)this.getLevels() * this.getLevelValue()));
            }
            n = n4;
        } else {
            int n5;
            n = n5 = 9 + (int)((double)Rounder.roundHalfUp(HeroDesigner.getActiveTemplate().getGeneralLevel() / 5) + (double)this.getLevels() * this.getLevelValue());
        }
        return n;
    }

    @Override
    public String getColumn2Output() {
        String string;
        if (this.levelsOnly) {
            return this.getLevelOnlyOutput();
        }
        String string2 = this.getAlias();
        if (this.getName() != null && this.getName().trim().length() > 0) {
            string2 = "<i>" + this.getName() + ":</i> " + string2;
        }
        if (this.getInput() != null && this.getInput().trim().length() > 0) {
            string2 = string2 + ": " + this.getInput();
        }
        if (this.getSelectedOption() != null) {
            string2 = string2 + ": " + this.getSelectedOption().getAlias();
        }
        if (!HeroDesigner.getInstance().getPrefs().useWG() && this.getCharacteristicChoices() != null && this.getCharacteristicChoices().size() > 1 && this.getCharacteristic() != 0) {
            string2 = string2 + " (" + Constants.getCharacteristicString(this.getCharacteristic()) + "-based)";
        }
        if ((string = this.getAdderString()).trim().length() > 0) {
            string2 = string2 + " (";
            string2 = string2 + string;
            string2 = string2 + ")";
        }
        string2 = string2 + this.getModifierString();
        if (this.showRoll) {
            string2 = string2 + " " + this.getRoll();
        }
        if (this.getEndUsage() > 0 && GenericObject.findObjectByID(HeroDesigner.getActiveHero().getPowers(), "ENDURANCERESERVE") != null && GenericObject.findObjectByID(this.getAllAssignedModifiers(), "ENDRESERVEOREND") == null && !HeroDesigner.getInstance().getPrefs().useWG()) {
            string2 = this.getUseENDReserve() ? string2 + " (uses END Reserve)" : string2 + " (uses Personal END)";
        }
        return string2;
    }
}

