/*
 * Decompiled with CFR 0.152.
 */
package com.hero.objects.skills;

import com.hero.HeroDesigner;
import com.hero.objects.Adder;
import com.hero.objects.GenericObject;
import com.hero.objects.enhancers.Enhancer;
import com.hero.objects.skills.Skill;
import java.util.ArrayList;
import java.util.Iterator;
import org.jdom.Element;

public class Navigation
extends Skill {
    private static String xmlID = "NAVIGATION";

    public Navigation(Element element) {
        super(element, xmlID);
    }

    @Override
    public double getTotalCost() {
        this.enhancerApplied = null;
        double d = this.getBaseCost();
        if (this.isFamiliarity() && this.isEveryman()) {
            return 0.0;
        }
        if (this.getAssignedAdders().size() == 0) {
            d = this.isFamiliarity() ? 1.0 : (this.isProficiency() ? (double)this.proficiencyCost : (this.levelsOnly() ? 0.0 : 3.0));
        }
        if (this.getLevelValue() != 0.0) {
            double d2 = (double)this.getLevels() / this.getLevelValue() * this.getLevelCost();
            d += d2;
            if (this.getLevels() > 0 && HeroDesigner.getActiveHero().getRules().getUseSkillMaxima() && this.rollBased) {
                int n = HeroDesigner.getActiveHero().getRules().getSkillMaximaLimit();
                int n2 = this.getRollValue();
                int n3 = this.getSecondaryRollValue();
                if (n3 > n2) {
                    n2 = n3;
                }
                if (n2 > n) {
                    int n4 = n2 - n;
                    if (n4 > this.getLevels()) {
                        n4 = this.getLevels();
                    }
                    d += (double)n4 / this.getLevelValue() * this.getLevelCost();
                }
            }
        }
        int n = -1;
        for (Adder adder : this.getAssignedAdders()) {
            ++n;
            if (!(adder.getRealCost() > 0.0)) continue;
            if (n == 0 && !this.isFamiliarity() && !this.isProficiency()) {
                d += adder.getRealCost();
                continue;
            }
            if (adder.getMinimumCost() < adder.getRealCost()) {
                d += adder.getMinimumCost();
                continue;
            }
            d += adder.getRealCost();
        }
        if (d < this.getMinimumCost() && this.isMinSet()) {
            d = this.getMinimumCost();
        } else if (d > this.getMaxCost() && this.isMaxSet()) {
            d = this.getMaxCost();
        }
        n = -1;
        for (Adder adder : this.getAssignedAdders()) {
            ++n;
            if (!(adder.getRealCost() < 0.0)) continue;
            if (n == 0 && !this.isFamiliarity() && !this.isProficiency()) {
                d += adder.getRealCost();
                continue;
            }
            if (adder.getMinimumCost() < adder.getRealCost()) {
                d += adder.getMinimumCost();
                continue;
            }
            d += adder.getRealCost();
        }
        if (this.getTypes() != null && this.getTypes().size() > 0 && !this.levelsOnly()) {
            ArrayList<GenericObject> arrayList = HeroDesigner.getActiveHero().getSkills();
            Iterator iterator = arrayList.iterator();
            block2: while (iterator.hasNext()) {
                GenericObject genericObject = (GenericObject)iterator.next();
                if (!(genericObject instanceof Enhancer)) continue;
                Enhancer enhancer = (Enhancer)genericObject;
                for (String string : this.getTypes()) {
                    if (!enhancer.appliesToType(string)) continue;
                    this.enhancerApplied = enhancer;
                    if (d > (double)enhancer.getCostSavings()) {
                        d -= (double)enhancer.getCostSavings();
                        break block2;
                    }
                    if (!(d > 0.0)) break block2;
                    d = 1.0;
                    break block2;
                }
            }
        }
        return d;
    }

    @Override
    public boolean includeFamiliarity() {
        return true;
    }
}

