/*
 * Decompiled with CFR 0.152.
 */
package com.hero.objects.skills;

import com.hero.HeroDesigner;
import com.hero.objects.Adder;
import com.hero.objects.GenericObject;
import com.hero.objects.List;
import com.hero.objects.characteristics.Characteristic;
import com.hero.objects.skills.Skill;
import com.hero.ui.dialog.GenericDialog;
import com.hero.ui.dialog.LanguageDialog;
import com.hero.util.Rounder;
import com.hero.util.XMLUtility;
import java.util.ArrayList;
import java.util.Collections;
import org.jdom.Element;

public class Language
extends Skill {
    private static ArrayList<ChartEntry> chart;
    private static String globalExclude;
    private static int numberLanguagesPurchased;
    private static String xmlID;
    private String discountedBy;
    private boolean nativeTongue;

    public Language(Element element) {
        super(element, xmlID);
    }

    @Override
    public String getColumn2Output() {
        String string = this.getAlias();
        if (this.getName() != null && this.getName().trim().length() > 0) {
            string = "<i>" + this.getName() + ":</i>  " + string;
        }
        if (this.getInput() != null && this.getInput().trim().length() > 0) {
            string = string + ":  " + this.getInput();
        }
        if (this.getSelectedOption() != null) {
            Object object;
            string = string + " (" + this.getSelectedOption().getAlias();
            if (HeroDesigner.getActiveHero().getRules().useLanguagesAsINTSkill() && (object = HeroDesigner.getActiveHero().getCharacteristic(5)) != null) {
                string = string + "; " + ((Characteristic)object).getRoll();
            }
            if (((String)(object = this.getAdderString())).trim().length() > 0) {
                string = string + "; ";
                string = string + (String)object;
            }
            string = string + ")";
        } else {
            String string2 = this.getAdderString();
            if (string2.trim().length() > 0) {
                string = string + " (";
                string = string + string2;
                string = string + ")";
            }
        }
        string = string + this.getModifierString();
        if (this.getEndUsage() > 0 && GenericObject.findObjectByID(HeroDesigner.getActiveHero().getPowers(), "ENDURANCERESERVE") != null && GenericObject.findObjectByID(this.getAllAssignedModifiers(), "ENDRESERVEOREND") == null && !HeroDesigner.getInstance().getPrefs().useWG()) {
            string = this.getUseENDReserve() ? string + " (uses END Reserve)" : string + " (uses Personal END)";
        }
        return string.trim();
    }

    @Override
    public GenericDialog getDialog(boolean bl, boolean bl2) {
        return new LanguageDialog(this, bl, bl2);
    }

    private String getDiscountedBy() {
        if (this.discountedBy == null) {
            return "";
        }
        return this.discountedBy;
    }

    private Language getDiscountingLanguage(ArrayList<String> arrayList, ChartEntry chartEntry) {
        GenericObject genericObject = null;
        GenericObject genericObject2 = null;
        GenericObject genericObject3 = null;
        GenericObject genericObject4 = null;
        numberLanguagesPurchased = 0;
        if (this.getInput() == null || this.getInput().trim().length() == 0) {
            return null;
        }
        block0: for (int i = 0; i < HeroDesigner.getActiveHero().getSkills().size(); ++i) {
            GenericObject genericObject5;
            GenericObject genericObject6 = HeroDesigner.getActiveHero().getSkills().get(i);
            if (genericObject6 instanceof Language) {
                ++numberLanguagesPurchased;
                if (genericObject6.equals(this)) break;
                genericObject5 = (Language)genericObject6;
                if (arrayList.contains(genericObject5.getInput().trim().toUpperCase())) continue;
                if (((Skill)genericObject5).getBaseCost() < this.getBaseCost()) {
                    // empty if block
                }
                if (genericObject5.getInput().equals(this.getInput())) break;
                if (chartEntry.getLevel4().contains(genericObject5.getInput().toUpperCase().trim())) {
                    if (genericObject4 != null) {
                        if (!(((Skill)genericObject5).getBaseCost() > ((Skill)genericObject4).getBaseCost())) continue;
                        genericObject4 = genericObject5;
                        continue;
                    }
                    genericObject4 = genericObject5;
                    continue;
                }
                if (chartEntry.getLevel3().contains(genericObject5.getInput().toUpperCase().trim())) {
                    if (genericObject3 != null) {
                        if (!(((Skill)genericObject5).getBaseCost() > ((Skill)genericObject3).getBaseCost())) continue;
                        genericObject3 = genericObject5;
                        continue;
                    }
                    genericObject3 = genericObject5;
                    continue;
                }
                if (chartEntry.getLevel2().contains(genericObject5.getInput().toUpperCase().trim())) {
                    if (genericObject2 != null) {
                        if (!(((Skill)genericObject5).getBaseCost() > ((Skill)genericObject2).getBaseCost())) continue;
                        genericObject2 = genericObject5;
                        continue;
                    }
                    genericObject2 = genericObject5;
                    continue;
                }
                if (chartEntry.getLevel1().contains(genericObject5.getInput().toUpperCase().trim())) {
                    if (genericObject != null) {
                        if (!(((Skill)genericObject5).getBaseCost() > ((Skill)genericObject).getBaseCost())) continue;
                        genericObject = genericObject5;
                        continue;
                    }
                    genericObject = genericObject5;
                    continue;
                }
                String string = this.getFamily((Language)genericObject5);
                if (!chartEntry.getFamily().contains(string)) continue;
                if (genericObject != null) {
                    if (!(((Skill)genericObject5).getBaseCost() > ((Skill)genericObject).getBaseCost())) continue;
                    genericObject = genericObject5;
                    continue;
                }
                genericObject = genericObject5;
                continue;
            }
            if (!(genericObject6 instanceof List)) continue;
            genericObject5 = (List)genericObject6;
            for (int j = 0; j < ((List)genericObject5).getObjects().size(); ++j) {
                GenericObject genericObject7 = ((List)genericObject5).getObjects().get(j);
                if (!(genericObject7 instanceof Language)) continue;
                ++numberLanguagesPurchased;
                if (genericObject7.equals(this)) continue block0;
                Language language = (Language)genericObject7;
                if (arrayList.contains(language.getInput().trim().toUpperCase())) continue;
                if (language.getBaseCost() < this.getBaseCost()) {
                    // empty if block
                }
                if (chartEntry.getLevel4().contains(language.getInput().toUpperCase().trim())) {
                    if (genericObject4 != null) {
                        if (!(language.getBaseCost() > ((Skill)genericObject4).getBaseCost())) continue;
                        genericObject4 = language;
                        continue;
                    }
                    genericObject4 = language;
                    continue;
                }
                if (chartEntry.getLevel3().contains(language.getInput().toUpperCase().trim())) {
                    if (genericObject3 != null) {
                        if (!(language.getBaseCost() > ((Skill)genericObject3).getBaseCost())) continue;
                        genericObject3 = language;
                        continue;
                    }
                    genericObject3 = language;
                    continue;
                }
                if (chartEntry.getLevel2().contains(language.getInput().toUpperCase().trim())) {
                    if (genericObject2 != null) {
                        if (!(language.getBaseCost() > ((Skill)genericObject2).getBaseCost())) continue;
                        genericObject2 = language;
                        continue;
                    }
                    genericObject2 = language;
                    continue;
                }
                if (chartEntry.getLevel1().contains(language.getInput().toUpperCase().trim())) {
                    if (genericObject != null) {
                        if (!(language.getBaseCost() > ((Skill)genericObject).getBaseCost())) continue;
                        genericObject = language;
                        continue;
                    }
                    genericObject = language;
                    continue;
                }
                String string = this.getFamily(language);
                if (!chartEntry.getFamily().contains(string)) continue;
                if (genericObject != null) {
                    if (!(language.getBaseCost() > ((Skill)genericObject).getBaseCost())) continue;
                    genericObject = language;
                    continue;
                }
                genericObject = language;
            }
        }
        if (genericObject4 != null) {
            return genericObject4;
        }
        if (genericObject3 != null) {
            return genericObject3;
        }
        if (genericObject2 != null) {
            return genericObject2;
        }
        if (genericObject != null) {
            return genericObject;
        }
        return null;
    }

    private String getFamily(Language language) {
        String string = "";
        for (ChartEntry chartEntry : chart) {
            if (!chartEntry.getDisplay().toLowerCase().contains(language.getInput().toLowerCase().trim())) continue;
            string = chartEntry.getFamily();
        }
        if (string == null || string.trim().length() == 0) {
            string = language.getInput();
        }
        return string;
    }

    @Override
    public double getRealCostPreList() {
        boolean bl;
        Cloneable cloneable;
        Object object;
        double d;
        this.discountedBy = "";
        int n = 0;
        if (this.nativeTongue) {
            d = 4.0;
            object = this.getOptions().iterator();
            while (object.hasNext()) {
                cloneable = object.next();
                if (!((GenericObject)cloneable).getXMLID().equals("IDIOMATIC")) continue;
                d = (int)((GenericObject)cloneable).getBaseCost();
            }
            n = this.getSelectedOption() != null && this.getSelectedOption().getBaseCost() < d ? (int)((double)n + this.getSelectedOption().getBaseCost()) : (int)((double)n + d);
            if (GenericObject.findObjectByID(this.getAssignedAdders(), "LITERACY") != null && (((Adder)(object = (Adder)GenericObject.findObjectByID(this.getAssignedAdders(), "LITERACY"))).isSelected() && HeroDesigner.getActiveHero().getRules().isNativeLiteracyFree() || HeroDesigner.getActiveHero().getRules().isLiteracyFree())) {
                n = (int)((double)n + ((Adder)object).getTotalCost());
            }
        }
        d = super.getRealCostPreList();
        if (this.nativeTongue) {
            if ((d -= (double)n) < 0.0) {
                d = 0.0;
            }
        } else if (HeroDesigner.getActiveHero().getRules().isLiteracyFree() && GenericObject.findObjectByID(this.getAssignedAdders(), "LITERACY") != null) {
            object = (Adder)GenericObject.findObjectByID(this.getAssignedAdders(), "LITERACY");
            if (((Adder)object).isSelected() && HeroDesigner.getActiveHero().getRules().isNativeLiteracyFree() || HeroDesigner.getActiveHero().getRules().isLiteracyFree()) {
                d -= ((Adder)object).getTotalCost();
            }
            if (d < 0.0) {
                d = 0.0;
            }
        }
        if (d <= 0.0 || !HeroDesigner.getActiveHero().getRules().isLanguageSimilaritiesUsed() || this.nativeTongue) {
            if (HeroDesigner.getActiveHero() != null && HeroDesigner.getActiveHero().getRules().multiplierAllowed() && this.getMultiplier() != 1.0) {
                d *= this.getMultiplier();
                d = Rounder.roundHalfDown(d);
            } else if (HeroDesigner.getActiveHero() != null && HeroDesigner.getActiveHero().getRules().multiplierAllowed() && this.getParentList() != null && this.getParentList().getMultiplier() != 1.0) {
                d *= this.getParentList().getMultiplier();
                d = Rounder.roundHalfDown(d);
            }
            return d;
        }
        boolean bl2 = false;
        cloneable = new ArrayList();
        if (globalExclude != null && globalExclude.trim().length() > 0) {
            ((ArrayList)cloneable).add(globalExclude);
        }
        ChartEntry chartEntry = null;
        for (ChartEntry object2 : chart) {
            if (!object2.getDisplay().equalsIgnoreCase(this.getInput().trim())) continue;
            chartEntry = object2;
            break;
        }
        if (chartEntry == null) {
            if (HeroDesigner.getActiveHero() != null && HeroDesigner.getActiveHero().getRules().multiplierAllowed() && this.getMultiplier() != 1.0) {
                d *= this.getMultiplier();
                d = Rounder.roundHalfDown(d);
            } else if (HeroDesigner.getActiveHero() != null && HeroDesigner.getActiveHero().getRules().multiplierAllowed() && this.getParentList() != null && this.getParentList().getMultiplier() != 1.0) {
                d *= this.getParentList().getMultiplier();
                d = Rounder.roundHalfDown(d);
            }
            return d;
        }
        Language language = this.getDiscountingLanguage((ArrayList<String>)cloneable, chartEntry);
        if (language != null && language.getBaseCost() == this.getBaseCost() && (globalExclude == null || globalExclude.trim().length() == 0)) {
            this.discountedBy = language.getInput();
            globalExclude = "";
        }
        if (numberLanguagesPurchased <= 1) {
            if (HeroDesigner.getActiveHero() != null && HeroDesigner.getActiveHero().getRules().multiplierAllowed() && this.getMultiplier() != 1.0) {
                d *= this.getMultiplier();
                d = Rounder.roundHalfDown(d);
            } else if (HeroDesigner.getActiveHero() != null && HeroDesigner.getActiveHero().getRules().multiplierAllowed() && this.getParentList() != null && this.getParentList().getMultiplier() != 1.0) {
                d *= this.getParentList().getMultiplier();
                d = Rounder.roundHalfDown(d);
            }
            return d;
        }
        if (language != null) {
            this.discountedBy = language.getInput();
            String bl22 = this.getFamily(language);
            String string = this.getFamily(this);
            if (chartEntry.getLevel4().contains(language.getInput().toUpperCase().trim())) {
                bl2 = true;
                d = language.getBaseCost() / 2.0 > 1.0 ? (d -= (double)Rounder.roundHalfDown(language.getBaseCost() / 2.0)) : (d -= 0.0);
            } else if (chartEntry.getLevel3().contains(language.getInput().toUpperCase().trim())) {
                d -= 1.0;
            } else if (chartEntry.getLevel2().contains(language.getInput().toUpperCase().trim())) {
                d -= 1.0;
            } else if (chartEntry.getLevel1().contains(language.getInput().toUpperCase().trim())) {
                d += 0.0;
            } else if (bl22.equalsIgnoreCase(string)) {
                d += 0.0;
            }
        } else if (d >= 1.0 && chartEntry != null && HeroDesigner.getActiveHero().getRules().penalizeNoLevel1() && !this.nativeTongueExistsInGroup(chartEntry)) {
            d += 1.0;
        }
        boolean bl3 = true;
        if (bl2) {
            bl = false;
        }
        if (d < (double)bl) {
            d = (double)bl;
        }
        if (HeroDesigner.getActiveHero() != null && HeroDesigner.getActiveHero().getRules().multiplierAllowed() && this.getMultiplier() != 1.0) {
            d *= this.getMultiplier();
            d = Rounder.roundHalfDown(d);
        } else if (HeroDesigner.getActiveHero() != null && HeroDesigner.getActiveHero().getRules().multiplierAllowed() && this.getParentList() != null && this.getParentList().getMultiplier() != 1.0) {
            d *= this.getParentList().getMultiplier();
            d = Rounder.roundHalfDown(d);
        }
        return d;
    }

    @Override
    public String getRoll() {
        return "";
    }

    @Override
    public Element getSaveXML() {
        Element element = super.getSaveXML();
        element.removeAttribute("CHARACTERISTIC");
        element.setAttribute("NATIVE_TONGUE", this.nativeTongue ? "Yes" : "No");
        return element;
    }

    @Override
    public double getTotalCost() {
        this.rollBased = false;
        return super.getTotalCost();
    }

    @Override
    protected void init(Element element) {
        this.display = "Language";
        this.baseCost = 0.0;
        this.levelCost = 0.0;
        this.levelValue = 0.0;
        this.minimumCost = 0.0;
        this.minimumLevel = 0;
        this.rollBased = false;
        chart = new ArrayList();
        super.init(element);
        this.alias = "Language";
        java.util.List list = element.getChildren("LANGUAGE");
        for (Element element2 : list) {
            ChartEntry chartEntry = new ChartEntry(element2);
            if (!chartEntry.included() || chart.contains(chartEntry)) continue;
            chart.add(chartEntry);
            if (this.examples.contains(chartEntry.getDisplay())) continue;
            this.examples.add(chartEntry.getDisplay());
        }
        Collections.sort(this.examples);
    }

    public boolean isNativeTongue() {
        return this.nativeTongue;
    }

    private boolean nativeTongueExistsInGroup(ChartEntry chartEntry) {
        numberLanguagesPurchased = 0;
        if (this.getInput() == null || this.getInput().trim().length() == 0) {
            return false;
        }
        for (GenericObject genericObject : HeroDesigner.getActiveHero().getSkills()) {
            if (!(genericObject instanceof Language)) continue;
            ++numberLanguagesPurchased;
            Language language = (Language)genericObject;
            if (language.getInput().equals(this.getInput()) || !language.isNativeTongue()) continue;
            if (chartEntry.getLevel4().contains(language.getInput().toUpperCase().trim())) {
                return true;
            }
            if (chartEntry.getLevel3().contains(language.getInput().toUpperCase().trim())) {
                return true;
            }
            if (chartEntry.getLevel2().contains(language.getInput().toUpperCase().trim())) {
                return true;
            }
            if (!chartEntry.getLevel1().contains(language.getInput().toUpperCase().trim())) continue;
            return true;
        }
        return false;
    }

    public boolean nativeTongueSelected() {
        for (GenericObject genericObject : HeroDesigner.getActiveHero().getSkills()) {
            if (!(genericObject instanceof Language)) continue;
            ++numberLanguagesPurchased;
            Language language = (Language)genericObject;
            if (!language.isNativeTongue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void restoreFromSave(Element element) {
        super.restoreFromSave(element);
        String string = XMLUtility.getValue(element, "NATIVE_TONGUE");
        this.nativeTongue = string != null && string.trim().toUpperCase().startsWith("Y");
    }

    public void setNativeTongue(boolean bl) {
        this.nativeTongue = bl;
    }

    static {
        xmlID = "LANGUAGES";
    }

    protected class ChartEntry {
        private String display;
        private String family;
        private boolean included;
        private ArrayList<String> level1;
        private ArrayList<String> level2;
        private ArrayList<String> level3;
        private ArrayList<String> level4;

        public ChartEntry(Element element) {
            this.init(element);
        }

        public boolean equals(Object object) {
            if (object instanceof ChartEntry) {
                ChartEntry chartEntry = (ChartEntry)object;
                return this.getDisplay().equals(chartEntry.getDisplay());
            }
            return false;
        }

        protected String getDiscountedBy() {
            if (Language.this.discountedBy == null) {
                return "";
            }
            HeroDesigner.getInstance();
            if (!HeroDesigner.getActiveHero().getSkills().contains(Language.this.discountedBy)) {
                Language.this.discountedBy = null;
                return "";
            }
            return Language.this.discountedBy;
        }

        public String getDisplay() {
            return this.display;
        }

        public String getFamily() {
            if (this.family == null) {
                this.family = "";
            }
            return this.family;
        }

        public ArrayList<String> getLevel1() {
            return this.level1;
        }

        public ArrayList<String> getLevel2() {
            return this.level2;
        }

        public ArrayList<String> getLevel3() {
            return this.level3;
        }

        public ArrayList<String> getLevel4() {
            return this.level4;
        }

        public int hashCode() {
            return this.getDisplay().hashCode();
        }

        public boolean included() {
            return this.included;
        }

        private void init(Element element) {
            this.display = "";
            this.level1 = new ArrayList();
            this.level2 = new ArrayList();
            this.level3 = new ArrayList();
            this.level4 = new ArrayList();
            this.family = "";
            this.included = true;
            Language.this.nativeTongue = false;
            this.display = XMLUtility.getValue(element, "DISPLAY");
            this.family = XMLUtility.getValue(element, "TYPE");
            if (this.display == null || this.display.trim().length() == 0) {
                this.included = false;
                return;
            }
            java.util.List list = element.getChildren("ONEPOINTSIMILARITY");
            for (Element element2 : list) {
                if (element2.getTextTrim() == null || element2.getTextTrim().length() <= 0) continue;
                this.level1.add(element2.getTextTrim().toUpperCase());
            }
            list = element.getChildren("TWOPOINTSIMILARITY");
            for (Element element2 : list) {
                if (element2.getTextTrim() == null || element2.getTextTrim().length() <= 0) continue;
                this.level2.add(element2.getTextTrim().toUpperCase());
            }
            list = element.getChildren("THREEPOINTSIMILARITY");
            for (Element element2 : list) {
                if (element2.getTextTrim() == null || element2.getTextTrim().length() <= 0) continue;
                this.level3.add(element2.getTextTrim().toUpperCase());
            }
            list = element.getChildren("FOURPOINTSIMILARITY");
            for (Element element2 : list) {
                if (element2.getTextTrim() == null || element2.getTextTrim().length() <= 0) continue;
                this.level4.add(element2.getTextTrim().toUpperCase());
            }
        }

        public void setFamily(String string) {
            this.family = string;
        }
    }
}

