/*
 * Decompiled with CFR 0.152.
 */
package com.hero.objects.skills;

import com.hero.HeroDesigner;
import com.hero.objects.GenericObject;
import com.hero.objects.skills.Skill;
import com.hero.ui.dialog.GenericDialog;
import com.hero.ui.dialog.KnowledgeSkillDialog;
import com.hero.util.Constants;
import com.hero.util.XMLUtility;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jdom.Element;

public class KnowledgeSkill
extends Skill {
    private static String xmlID = "KNOWLEDGE_SKILL";
    private String groupsDisplay;
    private String groupsType;
    private ArrayList<String> groupsExamples;
    private boolean groupsAvailable;
    private String peopleDisplay;
    private String peopleType;
    private ArrayList<String> peopleExamples;
    private boolean peopleAvailable;
    private String placesDisplay;
    private String placesType;
    private ArrayList<String> placesExamples;
    private boolean placesAvailable;
    private String thingsDisplay;
    private String thingsType;
    private ArrayList<String> thingsExamples;
    private boolean thingsAvailable;
    private String selectedType;
    private String selectedDisplay;

    public KnowledgeSkill(Element element) {
        super(element, xmlID);
    }

    @Override
    public String getColumn2Output() {
        String string;
        if (this.levelsOnly) {
            return this.getLevelOnlyOutput();
        }
        String string2 = this.getAlias();
        if (this.getName() != null && this.getName().trim().length() > 0) {
            string2 = "<i>" + this.getName() + ":</i>  " + string2;
        }
        if (this.getInput() != null && this.getInput().trim().length() > 0) {
            string2 = string2 + ": " + this.getInput();
        }
        if (this.getSelectedOption() != null) {
            string2 = string2 + ": " + this.getSelectedOption().getAlias();
        }
        if (!HeroDesigner.getInstance().getPrefs().useWG() && this.getCharacteristicChoices() != null && this.getCharacteristicChoices().size() > 1 && this.getCharacteristic() != 0) {
            string2 = string2 + " (" + Constants.getCharacteristicString(this.getCharacteristic()) + "-based)";
        }
        if ((string = this.getAdderString()).trim().length() > 0) {
            string2 = string2 + " (";
            string2 = string2 + string;
            string2 = string2 + ")";
        }
        string2 = string2 + this.getModifierString();
        if (this.showRoll) {
            string2 = string2 + " " + this.getRoll();
        }
        if (this.getEndUsage() > 0 && GenericObject.findObjectByID(HeroDesigner.getActiveHero().getPowers(), "ENDURANCERESERVE") != null && GenericObject.findObjectByID(this.getAllAssignedModifiers(), "ENDRESERVEOREND") == null && !HeroDesigner.getInstance().getPrefs().useWG()) {
            string2 = this.getUseENDReserve() ? string2 + " (uses END Reserve)" : string2 + " (uses Personal END)";
        }
        return string2;
    }

    @Override
    public GenericDialog getDialog(boolean bl, boolean bl2) {
        return new KnowledgeSkillDialog(this, bl, bl2);
    }

    @Override
    public ArrayList<String> getExamples() {
        if (this.getSelectedDisplay().equals(this.groupsDisplay)) {
            if (this.groupsExamples.size() > 0) {
                return (ArrayList)this.groupsExamples.clone();
            }
        } else if (this.getSelectedDisplay().equals(this.peopleDisplay)) {
            if (this.peopleExamples.size() > 0) {
                return (ArrayList)this.peopleExamples.clone();
            }
        } else if (this.getSelectedDisplay().equals(this.placesDisplay)) {
            if (this.placesExamples.size() > 0) {
                return (ArrayList)this.placesExamples.clone();
            }
        } else if (this.getSelectedDisplay().equals(this.thingsDisplay) && this.groupsExamples.size() > 0) {
            return (ArrayList)this.thingsExamples.clone();
        }
        return super.getExamples();
    }

    public String getGroupsDisplay() {
        return this.groupsDisplay;
    }

    public String getGroupsType() {
        return this.groupsType;
    }

    public String getPeopleDisplay() {
        return this.peopleDisplay;
    }

    public String getPeopleType() {
        return this.peopleType;
    }

    public String getPlacesDisplay() {
        return this.placesDisplay;
    }

    public String getPlacesType() {
        return this.placesType;
    }

    @Override
    public Element getSaveXML() {
        Element element = super.getSaveXML();
        element.setAttribute("TYPE", this.getSelectedDisplay());
        return element;
    }

    public String getSelectedDisplay() {
        return this.selectedDisplay;
    }

    public String getSelectedType() {
        if (this.selectedType == null) {
            this.selectedType = this.getGroupsType();
        }
        return this.selectedType;
    }

    public String getThingsDisplay() {
        return this.thingsDisplay;
    }

    public String getThingsType() {
        return this.thingsType;
    }

    @Override
    public ArrayList<String> getTypes() {
        GenericObject genericObject;
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(this.getSelectedType());
        if (GenericObject.findObjectByID(this.getAllAssignedModifiers(), "UOO") != null && (genericObject = GenericObject.findObjectByID(this.getAllAssignedModifiers(), "UOO")).getSelectedOption() != null && genericObject.getSelectedOption().getXMLID().equals("UAA")) {
            arrayList.add("ATTACK");
        }
        return arrayList;
    }

    @Override
    protected void init(Element element) {
        boolean bl;
        Element element2;
        int n;
        List list;
        String string;
        this.groupsDisplay = "Groups";
        this.groupsType = "KNOWLEDGE";
        this.groupsAvailable = true;
        this.peopleDisplay = "People";
        this.peopleType = "AREA";
        this.peopleAvailable = true;
        this.placesDisplay = "Places";
        this.placesType = "AREA";
        this.placesAvailable = true;
        this.thingsDisplay = "City";
        this.thingsType = "AREA";
        this.thingsAvailable = true;
        this.selectedType = "KNOWLEDGE";
        this.selectedDisplay = "Groups";
        this.characteristic = 0;
        this.display = "Knowledge Skill";
        this.alias = "KS";
        this.baseCost = 2.0;
        this.levelCost = 1.0;
        this.levelValue = 1.0;
        this.minimumCost = 1.0;
        this.minimumLevel = 8;
        super.init(element);
        Element element3 = element.getChild("GROUPS");
        if (element3 != null) {
            this.groupsAvailable = true;
            string = XMLUtility.getValue(element3, "DISPLAY");
            if (string != null && string.trim().length() > 0) {
                this.groupsDisplay = string;
            }
            if ((string = XMLUtility.getValue(element3, "TYPE")) != null && string.trim().length() > 0) {
                this.groupsType = string;
            }
            list = element3.getChildren("EXAMPLE");
            this.groupsExamples = new ArrayList();
            if (list != null) {
                for (n = 0; n < list.size(); ++n) {
                    element2 = (Element)list.get(n);
                    if (element2.getTextTrim().length() <= 0) continue;
                    bl = true;
                    if (element2.getChildren("SOURCE") != null && element2.getChildren("SOURCE").size() > 0) {
                        bl = false;
                        for (Element element4 : element2.getChildren("SOURCE")) {
                            if (!GenericObject.getAllSources().contains(element4.getTextTrim())) {
                                GenericObject.getAllSources().add(element4.getTextTrim());
                            }
                            if (!HeroDesigner.getInstance().getPrefs().getSources().contains(element4.getTextTrim())) continue;
                            bl = true;
                            break;
                        }
                    }
                    if (!bl) continue;
                    this.groupsExamples.add(element2.getTextTrim());
                }
            }
        } else {
            this.groupsAvailable = false;
        }
        if ((element3 = element.getChild("PEOPLE")) != null) {
            this.peopleAvailable = true;
            string = XMLUtility.getValue(element3, "DISPLAY");
            if (string != null && string.trim().length() > 0) {
                this.peopleDisplay = string;
            }
            if ((string = XMLUtility.getValue(element3, "TYPE")) != null && string.trim().length() > 0) {
                this.peopleType = string;
            }
            list = element3.getChildren("EXAMPLE");
            this.peopleExamples = new ArrayList();
            if (list != null) {
                for (n = 0; n < list.size(); ++n) {
                    element2 = (Element)list.get(n);
                    if (element2.getTextTrim().length() <= 0) continue;
                    bl = true;
                    if (element2.getChildren("SOURCE") != null && element2.getChildren("SOURCE").size() > 0) {
                        bl = false;
                        for (Element element4 : element2.getChildren("SOURCE")) {
                            if (!GenericObject.getAllSources().contains(element4.getTextTrim())) {
                                GenericObject.getAllSources().add(element4.getTextTrim());
                            }
                            if (!HeroDesigner.getInstance().getPrefs().getSources().contains(element4.getTextTrim())) continue;
                            bl = true;
                            break;
                        }
                    }
                    if (!bl) continue;
                    this.peopleExamples.add(element2.getTextTrim());
                }
            }
        } else {
            this.peopleAvailable = false;
        }
        if ((element3 = element.getChild("PLACES")) != null) {
            this.placesAvailable = true;
            string = XMLUtility.getValue(element3, "DISPLAY");
            if (string != null && string.trim().length() > 0) {
                this.placesDisplay = string;
            }
            if ((string = XMLUtility.getValue(element3, "TYPE")) != null && string.trim().length() > 0) {
                this.placesType = string;
            }
            list = element3.getChildren("EXAMPLE");
            this.placesExamples = new ArrayList();
            if (list != null) {
                for (n = 0; n < list.size(); ++n) {
                    element2 = (Element)list.get(n);
                    if (element2.getTextTrim().length() <= 0) continue;
                    bl = true;
                    if (element2.getChildren("SOURCE") != null && element2.getChildren("SOURCE").size() > 0) {
                        bl = false;
                        for (Element element4 : element2.getChildren("SOURCE")) {
                            if (!GenericObject.getAllSources().contains(element4.getTextTrim())) {
                                GenericObject.getAllSources().add(element4.getTextTrim());
                            }
                            if (!HeroDesigner.getInstance().getPrefs().getSources().contains(element4.getTextTrim())) continue;
                            bl = true;
                            break;
                        }
                    }
                    if (!bl) continue;
                    this.placesExamples.add(element2.getTextTrim());
                }
            }
        } else {
            this.placesAvailable = false;
        }
        if ((element3 = element.getChild("THINGS")) != null) {
            this.thingsAvailable = true;
            string = XMLUtility.getValue(element3, "DISPLAY");
            if (string != null && string.trim().length() > 0) {
                this.thingsDisplay = string;
            }
            if ((string = XMLUtility.getValue(element3, "TYPE")) != null && string.trim().length() > 0) {
                this.thingsType = string;
            }
            list = element3.getChildren("EXAMPLE");
            this.thingsExamples = new ArrayList();
            if (list != null) {
                for (n = 0; n < list.size(); ++n) {
                    element2 = (Element)list.get(n);
                    if (element2.getTextTrim().length() <= 0) continue;
                    bl = true;
                    if (element2.getChildren("SOURCE") != null && element2.getChildren("SOURCE").size() > 0) {
                        bl = false;
                        for (Element element4 : element2.getChildren("SOURCE")) {
                            if (!GenericObject.getAllSources().contains(element4.getTextTrim())) {
                                GenericObject.getAllSources().add(element4.getTextTrim());
                            }
                            if (!HeroDesigner.getInstance().getPrefs().getSources().contains(element4.getTextTrim())) continue;
                            bl = true;
                            break;
                        }
                    }
                    if (!bl) continue;
                    this.thingsExamples.add(element2.getTextTrim());
                }
            }
        } else {
            this.thingsAvailable = false;
        }
        if (this.groupsExamples.size() > 0) {
            Collections.sort(this.groupsExamples);
        }
        if (this.peopleExamples.size() > 0) {
            Collections.sort(this.peopleExamples);
        }
        if (this.placesExamples.size() > 0) {
            Collections.sort(this.placesExamples);
        }
        if (this.thingsExamples.size() > 0) {
            Collections.sort(this.thingsExamples);
        }
    }

    public boolean isGroupsAvailable() {
        return this.groupsAvailable;
    }

    public boolean isPeopleAvailable() {
        return this.peopleAvailable;
    }

    public boolean isPlacesAvailable() {
        return this.placesAvailable;
    }

    public boolean isThingsAvailable() {
        return this.thingsAvailable;
    }

    @Override
    public void restoreFromSave(Element element) {
        super.restoreFromSave(element);
        String string = XMLUtility.getValue(element, "TYPE");
        if (string != null && string.trim().length() > 0) {
            this.setSelectedTypeByDisplay(string);
        }
    }

    public void setSelectedTypeByDisplay(String string) {
        boolean bl = false;
        String string2 = this.getAlias();
        if (string.toUpperCase().equals("GROUPS")) {
            string = this.groupsDisplay;
        } else if (string.toUpperCase().equals("PEOPLE")) {
            string = this.peopleDisplay;
        } else if (string.toUpperCase().equals("PLACES")) {
            string = this.placesDisplay;
        } else if (string.toUpperCase().equals("THINGS")) {
            string = this.groupsDisplay;
        }
        if (this.getSelectedType().equals(this.groupsType) && string2.equals("KS")) {
            bl = true;
        } else if (this.getSelectedType().equals(this.peopleType) && string2.equals("CuK")) {
            bl = true;
        } else if (this.getSelectedType().equals(this.placesType) && string2.equals("AK")) {
            bl = true;
        } else if (this.getSelectedType().equals(this.thingsType) && string2.equals("CK")) {
            bl = true;
        } else if (string2.equals(this.display)) {
            bl = true;
        }
        this.selectedDisplay = string;
        if (string.equals(this.groupsDisplay)) {
            this.selectedType = this.groupsType;
            if (bl) {
                this.alias = "KS";
                this.display = "KS";
            }
        } else if (string.equals(this.peopleDisplay)) {
            this.selectedType = this.peopleType;
            if (bl) {
                this.alias = "CuK";
                this.display = "CuK";
            }
        } else if (string.equals(this.placesDisplay)) {
            this.selectedType = this.placesType;
            if (bl) {
                this.alias = "AK";
                this.display = "AK";
            }
        } else if (string.equals(this.thingsDisplay)) {
            this.selectedType = this.thingsType;
            if (bl) {
                this.alias = "CK";
                this.display = "CK";
            }
        }
    }
}

