/*
 * Decompiled with CFR 0.152.
 */
package com.hero.objects.skills;

import com.hero.objects.skills.Skill;
import com.hero.ui.dialog.CustomSkillDialog;
import com.hero.ui.dialog.GenericDialog;
import com.hero.util.XMLUtility;
import org.jdom.Element;

public class CustomSkill
extends Skill {
    private static String xmlID = "CUSTOMSKILL";
    private int roll;

    public CustomSkill(Element element) {
        super(element, xmlID);
        this.minimumLevel = -999;
    }

    @Override
    public GenericDialog getDialog(boolean bl, boolean bl2) {
        CustomSkillDialog customSkillDialog = new CustomSkillDialog(this, bl, bl2);
        return customSkillDialog;
    }

    @Override
    public String getRoll() {
        String string = this.getRollValue() + "-";
        if (this.roll == 0) {
            return "";
        }
        return string;
    }

    @Override
    public int getRollValue() {
        return this.roll;
    }

    @Override
    public Element getSaveXML() {
        Element element = super.getSaveXML();
        element.setAttribute("ROLL", "" + this.roll);
        return element;
    }

    @Override
    public void restoreFromSave(Element element) {
        super.restoreFromSave(element);
        String string = XMLUtility.getValue(element, "ROLL");
        if (string != null && string.trim().length() > 0) {
            try {
                this.roll = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                this.roll = 0;
            }
        } else {
            this.roll = 0;
        }
    }

    public void setRoll(int n) {
        this.roll = n;
    }
}

