/*
 * Decompiled with CFR 0.152.
 */
package com.hero.objects.skills;

import com.hero.objects.GenericObject;
import com.hero.util.Constants;
import com.hero.util.XMLUtility;
import org.jdom.Element;

public class CharacteristicChoice
extends GenericObject {
    protected int characteristic;

    public CharacteristicChoice(Element element) {
        super(element);
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof CharacteristicChoice) {
            CharacteristicChoice characteristicChoice = (CharacteristicChoice)object;
            return characteristicChoice.getCharacteristic() == this.getCharacteristic();
        }
        return false;
    }

    public int getCharacteristic() {
        return this.characteristic;
    }

    @Override
    public int hashCode() {
        return this.getCharacteristic();
    }

    @Override
    protected void init(Element element) {
        this.characteristic = 0;
        super.init(element);
        String string = XMLUtility.getValue(element, "CHARACTERISTIC");
        if (string == null || string.trim().length() == 0) {
            this.characteristic = 0;
        }
        this.characteristic = Constants.getCharacteristicInteger(string);
    }

    @Override
    public String toString() {
        return Constants.getCharacteristicString(this.characteristic);
    }
}

