/*
 * Decompiled with CFR 0.152.
 */
package com.hero.objects.powers;

import com.hero.HeroDesigner;
import com.hero.objects.Adder;
import com.hero.objects.GenericObject;
import com.hero.objects.powers.Power;
import com.hero.ui.dialog.GenericDialog;
import com.hero.ui.dialog.SummonDialog;
import com.hero.util.XMLUtility;
import java.io.File;
import java.text.NumberFormat;
import java.util.Date;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;

public class Summon
extends Power {
    private static String xmlID = "SUMMON";
    private String filePath;
    private Date fileAssociationLastCheck;

    public Summon(Element element) {
        super(element, xmlID);
    }

    private void checkFileAssociation() {
        if (this.filePath == null) {
            return;
        }
        File file = new File(this.filePath);
        if (!file.exists()) {
            file = new File(HeroDesigner.getInstance().getPrefs().getSaveDir() + File.separator + file.getName());
        }
        if (!file.exists()) {
            return;
        }
        if (file.lastModified() > this.fileAssociationLastCheck.getTime()) {
            this.setFilePath(this.filePath);
        }
    }

    public void clearFilePath() {
        this.filePath = null;
        this.fileAssociationLastCheck = null;
    }

    @Override
    public String getColumn2Output() {
        Object object;
        String string = this.getAlias();
        double d = 1.0;
        for (Adder adder : this.getAssignedAdders()) {
            if (!adder.getXMLID().equals("INCREASETOTAL")) continue;
            adder.setDisplayInString(false);
            int n = adder.getLevels() * adder.getLevelMultiplier();
            if (adder.getLevelPower() <= 1) {
                d = n;
                continue;
            }
            d = (double)adder.getLevelMultiplier() * Math.pow(adder.getLevelPower(), adder.getLevels());
        }
        if (d > 1.0) {
            string = string + " " + NumberFormat.getIntegerInstance().format(d);
        }
        string = string + " " + this.getLevels() + "-point";
        if (this.getName().trim().length() > 0) {
            string = "<i>" + this.getName() + ":</i>  " + string;
        }
        string = this.getInput() != null && this.getInput().trim().length() > 0 ? string + " " + this.getInput() : string + " creatures";
        if (this.getSelectedOption() != null) {
            string = string + " (";
            string = string + this.getSelectedOption().getAlias();
            object = this.getAdderString();
            if (((String)object).trim().length() > 0) {
                string = string + "; " + (String)object;
            }
            string = string + ")";
        } else {
            object = this.getAdderString();
            if (((String)object).trim().length() > 0) {
                string = string + " (" + (String)object + ")";
            }
        }
        string = string + this.getModifierString();
        if (this.getEndUsage() > 0 && GenericObject.findObjectByID(HeroDesigner.getActiveHero().getPowers(), "ENDURANCERESERVE") != null && GenericObject.findObjectByID(this.getAllAssignedModifiers(), "ENDRESERVEOREND") == null && !HeroDesigner.getInstance().getPrefs().useWG()) {
            string = this.getUseENDReserve() ? string + " (uses END Reserve)" : string + " (uses Personal END)";
        }
        return string;
    }

    @Override
    public String getDamageDisplay() {
        return this.getLevels() + "-point " + this.getInput();
    }

    @Override
    public GenericDialog getDialog(boolean bl, boolean bl2) {
        return new SummonDialog(this, bl);
    }

    public String getFilePath() {
        return this.filePath;
    }

    @Override
    public int getLevels() {
        this.checkFileAssociation();
        return super.getLevels();
    }

    @Override
    public Element getSaveXML() {
        Element element = super.getSaveXML();
        if (this.filePath != null) {
            element.setAttribute("FILE_ASSOCIATION", this.filePath);
        }
        return element;
    }

    @Override
    public void restoreFromSave(Element element) {
        super.restoreFromSave(element);
        String string = XMLUtility.getValue(element, "FILE_ASSOCIATION");
        if (string != null && string.trim().length() > 0) {
            this.setFilePath(string);
        }
    }

    public void setFilePath(String string) {
        File file = new File(string);
        if (!file.exists()) {
            file = new File(HeroDesigner.getInstance().getPrefs().getSaveDir() + File.separator + file.getName());
        }
        if (file.exists() && file.canRead()) {
            try {
                SAXBuilder sAXBuilder = new SAXBuilder(false);
                Document document = sAXBuilder.build(file);
                sAXBuilder = null;
                Element element = document.getRootElement();
                Element element2 = element.getChild("BASIC_CONFIGURATION");
                String string2 = XMLUtility.getValue(element2, "BASE_POINTS");
                if (string2 != null && string2.trim().length() > 0) {
                    try {
                        this.levels = Integer.parseInt(string2);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (!HeroDesigner.getActiveTemplate().is6E() && (string2 = XMLUtility.getValue(element2, "DISAD_POINTS")) != null && string2.trim().length() > 0) {
                    try {
                        this.levels += Integer.parseInt(string2);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((string2 = XMLUtility.getValue(element2, "EXPERIENCE")) != null && string2.trim().length() > 0) {
                    try {
                        this.levels += Integer.parseInt(string2);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.filePath = string;
                this.fileAssociationLastCheck = new Date();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

