/*
 * Decompiled with CFR 0.152.
 */
package com.hero.objects.powers;

import com.hero.HeroDesigner;
import com.hero.objects.GenericObject;
import com.hero.objects.powers.Power;
import com.hero.ui.dialog.GenericDialog;
import com.hero.ui.dialog.PowerDialog;
import com.hero.util.Rounder;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import org.jdom.Element;

public class Shrinking
extends Power {
    private static String xmlID = "SHRINKING";

    public Shrinking(Element element) {
        super(element, xmlID);
    }

    @Override
    public String getColumn2Output() {
        String string = this.getAlias() + " (" + this.getPlainDamageDisplay() + ")";
        if (this.getName().trim().length() > 0) {
            string = "<i>" + this.getName() + ":</i>  " + string;
        }
        if (this.getInput() != null && this.getInput().trim().length() > 0) {
            string = string + ":  " + this.getInput();
        }
        if (this.getSelectedOption() != null) {
            string = string + " (";
            string = string + this.getSelectedOption().getAlias();
            String string2 = this.getAdderString();
            if (string2.trim().length() > 0) {
                string = string + "; " + string2;
            }
            string = string + ")";
        } else {
            String string3 = this.getAdderString();
            if (string3.trim().length() > 0) {
                string = string + " (" + string3 + ")";
            }
        }
        string = string + this.getModifierString();
        if (this.getEndUsage() > 0 && GenericObject.findObjectByID(HeroDesigner.getActiveHero().getPowers(), "ENDURANCERESERVE") != null && GenericObject.findObjectByID(this.getAllAssignedModifiers(), "ENDRESERVEOREND") == null && !HeroDesigner.getInstance().getPrefs().useWG()) {
            string = this.getUseENDReserve() ? string + " (uses END Reserve)" : string + " (uses Personal END)";
        }
        return string;
    }

    @Override
    public String getDamageDisplay() {
        return "<html>" + this.getPlainDamageDisplay() + "</html>";
    }

    @Override
    public GenericDialog getDialog(boolean bl, boolean bl2) {
        PowerDialog powerDialog = new PowerDialog(this, bl, bl2);
        powerDialog.setSize(powerDialog.getSize().width + 100, powerDialog.getSize().height);
        return powerDialog;
    }

    private String getPlainDamageDisplay() {
        int n;
        double d;
        int n2;
        String string;
        DecimalFormat decimalFormat = new DecimalFormat("#.###E0");
        double d2 = (double)HeroDesigner.getActiveHero().getWeight() * 453.5924;
        if (HeroDesigner.getInstance().getPrefs().isMetric()) {
            d2 = HeroDesigner.getActiveHero().getWeight() * 1000;
        }
        if (Shrinking.findObjectByID(this.getAssignedModifiers(), "NORMALMASS") == null) {
            d2 *= Math.pow(this.massMultiplier, (double)this.getLevels() / (double)this.getMassMultiplierLevels());
        }
        BigDecimal bigDecimal = new BigDecimal(d2 / 1000.0);
        bigDecimal = bigDecimal.setScale(4, 4);
        if (d2 / 1000.0 > 9.0E-5) {
            decimalFormat = new DecimalFormat("#.####");
        }
        String string2 = decimalFormat.format(d2 / 1000.0) + " kg mass, ";
        String string3 = this.getStrIncrease() != 0.0 ? "+" + this.getStrIncrease() * (double)Rounder.roundHalfUp((double)this.getLevels() / (double)this.strIncreaseLevels) + " STR" : "";
        int n3 = (int)Rounder.roundHalfUp(this.bodyIncrease * (double)Rounder.roundHalfUp((double)this.getLevels() / (double)this.bodyIncreaseLevels));
        String string4 = n3 != 0 ? "+" + n3 + " BODY, " : "";
        int n4 = (int)Rounder.roundHalfUp(this.kbIncrease * (double)Rounder.roundHalfUp((double)this.getLevels() / (double)this.kbIncreaseLevels));
        String string5 = n4 != 0 ? (n4 < 0 ? "takes " : "takes +") + n4 + "\" KB, " : (string = "");
        if (HeroDesigner.getActiveTemplate().is6E()) {
            string = n4 != 0 ? (n4 < 0 ? "takes " : "takes +") + n4 + "m KB, " : "";
        }
        String string6 = (n2 = (int)Rounder.roundHalfUp(this.stunIncrease * (double)Rounder.roundHalfUp((double)this.getLevels() / (double)this.stunIncreaseLevels))) != 0 ? "+" + n2 + " STUN, " : "";
        int n5 = (int)Rounder.roundHalfUp(this.dcvIncrease * (double)Rounder.roundHalfUp((double)this.getLevels() / (double)this.dcvIncreaseLevels));
        String string7 = n5 != 0 ? (n5 < 0 ? "" : "+") + n5 + " DCV, " : "";
        int n6 = (int)Rounder.roundHalfUp(this.perIncrease * (double)Rounder.roundHalfUp((double)this.getLevels() / (double)this.perIncreaseLevels));
        String string8 = n6 != 0 ? (n6 >= 0 ? "+" : "" + n6 + " PER Rolls to perceive character, ") : "";
        double d3 = d = this.getLevels() >= this.getHeightIncreaseLevels() ? (double)HeroDesigner.getActiveHero().getHeight() * 2.54 * Math.pow(this.getHeightIncrease(), (double)this.getLevels() / (double)this.heightIncreaseLevels) : (double)HeroDesigner.getActiveHero().getHeight() * 2.54;
        if (HeroDesigner.getInstance().getPrefs().isMetric()) {
            d = this.getLevels() >= this.getHeightIncreaseLevels() ? (double)HeroDesigner.getActiveHero().getHeight() * Math.pow(this.getHeightIncrease(), (double)this.getLevels() / (double)this.heightIncreaseLevels) : (double)HeroDesigner.getActiveHero().getHeight();
        }
        double d4 = d / 100.0;
        double d5 = d / 200.0;
        decimalFormat = new DecimalFormat("#.###E0");
        BigDecimal bigDecimal2 = new BigDecimal(d4);
        bigDecimal2 = bigDecimal2.setScale(3, 4);
        BigDecimal bigDecimal3 = new BigDecimal(d5);
        bigDecimal3 = bigDecimal3.setScale(3, 4);
        if (d4 > 9.0E-4) {
            decimalFormat = new DecimalFormat("#.####");
        }
        String string9 = decimalFormat.format(d4) + " m tall, ";
        decimalFormat = new DecimalFormat("#.###E0");
        if (d5 > 9.0E-4) {
            decimalFormat = new DecimalFormat("#.####");
        }
        String string10 = (n = (int)Math.pow(this.reachIncrease, (double)this.getLevels() / (double)this.reachIncreaseLevels)) != 0 ? n + "\" reach, " : "";
        String string11 = string9 + string2 + string3 + string4 + string6 + string8 + string7 + string + string10;
        if (HeroDesigner.getActiveTemplate().is6E()) {
            string11 = string9 + string2 + string8 + string7 + string;
        }
        string11 = string11.substring(0, string11.length() - 2);
        return string11;
    }
}

