/*
 * Decompiled with CFR 0.152.
 */
package com.hero.objects.powers;

import com.hero.HeroDesigner;
import com.hero.objects.Adder;
import com.hero.objects.GenericObject;
import com.hero.objects.powers.Sense;
import com.hero.objects.powers.SenseAffectingPower;
import com.hero.objects.powers.SenseGroup;
import java.util.ArrayList;
import java.util.Collections;
import org.jdom.Element;

public class Shapeshift
extends SenseAffectingPower {
    private static String xmlID = "SHAPESHIFT";

    public Shapeshift(Element element) {
        super(element, xmlID);
    }

    @Override
    public ArrayList<Adder> getAssignedAdders() {
        if (!HeroDesigner.getActiveTemplate().is6E()) {
            return super.getAssignedAdders();
        }
        long l = System.currentTimeMillis();
        ArrayList<Adder> arrayList = super.getAssignedAdders();
        for (int i = 0; i < arrayList.size(); ++i) {
            Adder adder = arrayList.get(i);
            if (adder.getXMLID().indexOf("SIGHT") >= 0) {
                adder.setBaseCost(this.targetingCost);
                continue;
            }
            if (adder.getXMLID().indexOf("HEARING") >= 0) {
                adder.setBaseCost(this.nontargetingCost);
                continue;
            }
            if (adder.getXMLID().indexOf("TOUCH") >= 0) {
                adder.setBaseCost(this.nontargetingCost);
                continue;
            }
            if (adder.getXMLID().indexOf("MENTAL") >= 0) {
                adder.setBaseCost(this.targetingGroupCost);
                continue;
            }
            if (adder.getXMLID().indexOf("RADIO") >= 0) {
                adder.setBaseCost(this.targetingGroupCost);
                continue;
            }
            if (adder.getXMLID().indexOf("SMELL") >= 0) {
                adder.setBaseCost(this.targetingGroupCost);
                continue;
            }
            if (!adder.getXMLID().endsWith("GROUP")) continue;
            adder.setBaseCost(this.nontargetingGroupCost);
        }
        return arrayList;
    }

    @Override
    public ArrayList<Adder> getAvailableAdders() {
        if (!HeroDesigner.getActiveTemplate().is6E()) {
            return super.getAvailableAdders();
        }
        ArrayList<Adder> arrayList = super.getAvailableAdders();
        for (int i = 0; i < arrayList.size(); ++i) {
            Adder adder = arrayList.get(i);
            if (adder.getXMLID().indexOf("SIGHT") >= 0) {
                adder.setBaseCost(this.targetingCost);
                continue;
            }
            if (adder.getXMLID().indexOf("HEARING") >= 0) {
                adder.setBaseCost(this.nontargetingCost);
                continue;
            }
            if (adder.getXMLID().indexOf("TOUCH") >= 0) {
                adder.setBaseCost(this.nontargetingCost);
                continue;
            }
            if (adder.getXMLID().indexOf("MENTAL") >= 0) {
                adder.setBaseCost(this.targetingGroupCost);
                continue;
            }
            if (adder.getXMLID().indexOf("RADIO") >= 0) {
                adder.setBaseCost(this.targetingGroupCost);
                continue;
            }
            if (adder.getXMLID().indexOf("SMELL") >= 0) {
                adder.setBaseCost(this.targetingGroupCost);
                continue;
            }
            if (!adder.getXMLID().endsWith("GROUP")) continue;
            adder.setBaseCost(this.nontargetingGroupCost);
        }
        return arrayList;
    }

    @Override
    public String getColumn2Output() {
        int n;
        String string = this.getAlias() + " " + this.getDamageDisplay();
        if (this.getName().trim().length() > 0) {
            string = "<i>" + this.getName() + ":</i>  " + string;
        }
        if (this.getInput() != null && this.getInput().trim().length() > 0) {
            string = string + ":  " + this.getInput();
        }
        String string2 = "";
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ArrayList<Sense> arrayList3 = Sense.getAllSenses();
        String string3 = "[Unknown]";
        if (this.getSelectedOption() != null) {
            string3 = this.getSelectedOption().getAlias();
        }
        if (string3.toUpperCase().indexOf("GROUP") > 0) {
            string3 = string3.substring(0, string3.toUpperCase().indexOf("GROUP")).trim();
        }
        arrayList.add(string3);
        for (Adder adder : this.getAssignedAdders()) {
            String string4;
            if (adder.getXMLID().equals("SHAPES") && adder.getSelectedOption() != null) {
                adder.setDisplayInString(false);
                string2 = adder.getSelectedOption().getAlias();
            }
            if (adder.getXMLID().equals("ADDITIONAL_GROUP")) {
                adder.setDisplayInString(false);
                string3 = adder.getSelectedOption().getAlias();
                if (string3.toUpperCase().indexOf("GROUP") > 0) {
                    string3 = string3.substring(0, string3.toUpperCase().indexOf("GROUP")).trim();
                }
                arrayList.add(string3);
                continue;
            }
            if (adder.getXMLID().endsWith("GROUP")) {
                adder.setDisplayInString(false);
                string3 = adder.getAlias();
                if (string3.toUpperCase().indexOf("GROUP") > 0) {
                    string3 = string3.substring(0, string3.toUpperCase().indexOf("GROUP")).trim();
                }
                arrayList.add(string3);
                continue;
            }
            if (adder.getXMLID().equals("ADDITIONAL_SENSE")) {
                adder.setDisplayInString(false);
                string4 = adder.getSelectedOption().getAlias();
                arrayList2.add(string4);
                continue;
            }
            if (GenericObject.findObjectByID(arrayList3, adder.getXMLID()) == null) continue;
            adder.setDisplayInString(false);
            string4 = adder.getAlias();
            arrayList2.add(string4);
        }
        string = string + " (";
        for (n = 0; n < arrayList.size(); ++n) {
            if (n > 0 && n < arrayList.size() - 1) {
                string = string + ", ";
            } else if (n == arrayList.size() - 1 && n > 0) {
                string = string + " and ";
            }
            string = string + (String)arrayList.get(n);
        }
        string = arrayList.size() > 1 ? string + " Groups" : string + " Group";
        for (n = 0; n < arrayList2.size(); ++n) {
            string = n < arrayList2.size() - 1 ? string + ", " : string + " and ";
            string = string + (String)arrayList2.get(n);
        }
        if (string2.trim().length() > 0) {
            string = string + ", " + string2;
        }
        string = string + ")";
        String string5 = this.getAdderString();
        if (string5.trim().length() > 0) {
            string = string + ", " + string5;
        }
        string = string + this.getModifierString();
        if (this.getEndUsage() > 0 && GenericObject.findObjectByID(HeroDesigner.getActiveHero().getPowers(), "ENDURANCERESERVE") != null && GenericObject.findObjectByID(this.getAllAssignedModifiers(), "ENDRESERVEOREND") == null && !HeroDesigner.getInstance().getPrefs().useWG()) {
            string = this.getUseENDReserve() ? string + " (uses END Reserve)" : string + " (uses Personal END)";
        }
        return string;
    }

    @Override
    public String getDamageDisplay() {
        return "";
    }

    @Override
    public ArrayList<Adder> getOptions() {
        if (!HeroDesigner.getActiveTemplate().is6E()) {
            return super.getOptions();
        }
        if (this.optionsLastCall > 0L && this.optionsLastCall >= GenericObject.lastEdit && this.optionsSaver != null) {
            return this.optionsSaver;
        }
        this.optionsLastCall = System.currentTimeMillis();
        ArrayList<Adder> arrayList = new ArrayList<Adder>();
        if (this.targetingCost >= 0.0 || this.nontargetingCost >= 0.0) {
            ArrayList<SenseGroup> arrayList2 = SenseGroup.getAllGroups();
            for (SenseGroup senseGroup : arrayList2) {
                Adder adder;
                if (senseGroup.getXMLID().equals("UNUSUALGROUP") || senseGroup.getXMLID().equals("NOGROUP")) continue;
                if (senseGroup.getXMLID().equals("SIGHTGROUP")) {
                    adder = new Adder(senseGroup);
                    if (this.levelValue <= 0.0) {
                        adder.setBaseCost(this.targetingCost);
                        adder.setLevelCost(-1.0);
                        adder.setLevelValue(-1.0);
                    } else {
                        adder.setBaseCost(0.0);
                        adder.setLevelCost(this.targetingCost);
                        adder.setLevelValue(this.levelValue);
                    }
                    arrayList.add(adder);
                    continue;
                }
                if (senseGroup.getXMLID().equals("HEARINGGROUP")) {
                    adder = new Adder(senseGroup);
                    if (this.levelValue <= 0.0) {
                        adder.setBaseCost(this.nontargetingCost);
                        adder.setLevelCost(-1.0);
                        adder.setLevelValue(-1.0);
                    } else {
                        adder.setBaseCost(0.0);
                        adder.setLevelCost(this.nontargetingCost);
                        adder.setLevelValue(this.levelValue);
                    }
                    arrayList.add(adder);
                    continue;
                }
                if (senseGroup.getXMLID().equals("TOUCHGROUP")) {
                    adder = new Adder(senseGroup);
                    if (this.levelValue <= 0.0) {
                        adder.setBaseCost(this.nontargetingCost);
                        adder.setLevelCost(-1.0);
                        adder.setLevelValue(-1.0);
                    } else {
                        adder.setBaseCost(0.0);
                        adder.setLevelCost(this.nontargetingCost);
                        adder.setLevelValue(this.levelValue);
                    }
                    arrayList.add(adder);
                    continue;
                }
                if (senseGroup.getXMLID().equals("SMELLGROUP")) {
                    adder = new Adder(senseGroup);
                    if (this.levelValue <= 0.0) {
                        adder.setBaseCost(this.targetingGroupCost);
                        adder.setLevelCost(-1.0);
                        adder.setLevelValue(-1.0);
                    } else {
                        adder.setBaseCost(0.0);
                        adder.setLevelCost(this.targetingGroupCost);
                        adder.setLevelValue(this.levelValue);
                    }
                    arrayList.add(adder);
                    continue;
                }
                if (senseGroup.getXMLID().equals("MENTALGROUP")) {
                    adder = new Adder(senseGroup);
                    if (this.levelValue <= 0.0) {
                        adder.setBaseCost(this.targetingGroupCost);
                        adder.setLevelCost(-1.0);
                        adder.setLevelValue(-1.0);
                    } else {
                        adder.setBaseCost(0.0);
                        adder.setLevelCost(this.targetingGroupCost);
                        adder.setLevelValue(this.levelValue);
                    }
                    arrayList.add(adder);
                    continue;
                }
                if (!senseGroup.getXMLID().equals("RADIOGROUP")) continue;
                adder = new Adder(senseGroup);
                if (this.levelValue <= 0.0) {
                    adder.setBaseCost(this.targetingGroupCost);
                    adder.setLevelCost(-1.0);
                    adder.setLevelValue(-1.0);
                } else {
                    adder.setBaseCost(0.0);
                    adder.setLevelCost(this.targetingGroupCost);
                    adder.setLevelValue(this.levelValue);
                }
                arrayList.add(adder);
            }
        }
        if (arrayList.size() == 0) {
            this.oldMethod = true;
            this.optionsSaver = super.getOptions();
            return super.getOptions();
        }
        Collections.sort(arrayList);
        this.optionsSaver = arrayList;
        return arrayList;
    }
}

