/*
 * Decompiled with CFR 0.152.
 */
package com.hero.objects.powers;

import com.hero.HeroDesigner;
import com.hero.objects.Adder;
import com.hero.objects.GenericObject;
import com.hero.objects.powers.Detect;
import com.hero.objects.powers.Power;
import com.hero.objects.powers.Sense;
import com.hero.objects.powers.SenseGroup;
import com.hero.ui.dialog.GenericDialog;
import com.hero.util.XMLUtility;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.jdom.Element;

public class SenseAdder
extends Power {
    private static ArrayList<SenseAdder> allSenseAdders = new ArrayList();
    protected int allCost;
    private long assignedAddersLastCalc;
    private ArrayList<Adder> assignedAddersSaver;
    private long automaticAddersLastCalc;
    private ArrayList<Adder> automaticAddersSaver;
    private long availableAddersLastCalc;
    private ArrayList<Adder> availableAddersSaver;
    protected int groupCost;
    private long optionsLastCalc;
    private ArrayList<Adder> optionsSaver;
    public boolean selectedOptionLock;
    protected int senseCost;
    private long senseGroupsLastCalc;
    private ArrayList<String> senseGroupsSaver;
    private long sensesLastCalc;
    private ArrayList<String> sensesSaver;

    public static ArrayList<SenseAdder> getAllSenseAdders() {
        return allSenseAdders;
    }

    public static String getDetectDisplay(Detect detect) {
        String string = detect.getAlias();
        String string2 = detect.getSelectedOption().getAlias();
        boolean bl = false;
        ArrayList arrayList = detect.assignedAdders;
        for (Adder adder : arrayList) {
            if (!adder.getXMLID().equals("EXTRA")) continue;
            string2 = string2 + ", " + adder.getAlias();
            bl = true;
            adder.setDisplayInString(false);
        }
        if (bl) {
            string2 = string2.substring(0, string2.lastIndexOf(",")) + " and" + string2.substring(string2.lastIndexOf(",") + 1, string2.length());
        }
        string = string + " " + string2;
        return string;
    }

    public SenseAdder(Element element) {
        super(element, "SENSEADDER");
        if (this.xmlID != null && this.xmlID.trim().length() > 0 && this.includedInTemplate()) {
            allSenseAdders.add(this);
        }
    }

    public SenseAdder(Element element, String string) {
        super(element, string);
        if (GenericObject.findObjectByID(allSenseAdders, string) == null && this.xmlID != null && this.xmlID.trim().length() > 0 && this.includedInTemplate()) {
            allSenseAdders.add(this);
        }
    }

    @Override
    public ArrayList<Adder> getAssignedAdders() {
        if (this.assignedAddersSaver != null && this.assignedAddersLastCalc > Power.lastSenseEdit && Power.lastSenseEdit > 0L) {
            return this.assignedAddersSaver;
        }
        ArrayList<Adder> arrayList = super.getAssignedAdders();
        ArrayList<String> arrayList2 = this.getSenseGroups();
        if (arrayList2 == null) {
            arrayList2 = new ArrayList();
        }
        block0: for (int i = arrayList.size() - 1; i >= 0; --i) {
            ArrayList<String> arrayList3;
            ArrayList<Power> arrayList4;
            Adder adder = arrayList.get(i);
            if (adder.getXMLID().equals("GROUP") && adder.getSelectedOption() != null) {
                if (adder.getSelectedOption().getXMLID().equals(this.getSelectedOption().getXMLID())) {
                    arrayList.remove(i);
                    continue;
                }
                arrayList4 = SenseGroup.getAllGroups();
                for (Power power : arrayList4) {
                    if (!power.getXMLID().equals(adder.getSelectedOption().getXMLID())) continue;
                    arrayList3 = ((SenseGroup)power).getSenseAdders(this.getID());
                    if (arrayList3.contains(this.getXMLID())) {
                        arrayList.remove(i);
                        continue block0;
                    }
                    if (this.levelValue < 1.0) {
                        adder.setBaseCost(this.groupCost);
                        continue block0;
                    }
                    adder.setBaseCost((double)(this.groupCost * this.levels) / this.levelValue);
                    continue block0;
                }
                continue;
            }
            if (adder.getXMLID().endsWith("GROUP")) {
                if (this.getSelectedOption() != null && adder.getXMLID().equals(this.getSelectedOption().getXMLID())) {
                    arrayList.remove(i);
                    continue;
                }
                arrayList4 = SenseGroup.getAllGroups();
                for (Power power : arrayList4) {
                    if (!power.getXMLID().equals(adder.getXMLID())) continue;
                    arrayList3 = ((SenseGroup)power).getSenseAdders(this.getID());
                    if (arrayList3.contains(this.getXMLID())) {
                        arrayList.remove(i);
                        continue block0;
                    }
                    if (this.levelValue < 1.0) {
                        adder.setBaseCost(this.groupCost);
                        continue block0;
                    }
                    adder.setBaseCost((double)(this.groupCost * this.levels) / this.levelValue);
                    continue block0;
                }
                continue;
            }
            if (adder.getXMLID().equals("SINGLE") && adder.getSelectedOption() != null) {
                if (adder.getSelectedOption().getXMLID().equals(this.getSelectedOption().getXMLID())) {
                    arrayList.remove(i);
                    continue;
                }
                arrayList4 = Sense.getAllSenses();
                for (Power power : arrayList4) {
                    if (!power.getXMLID().equals(adder.getSelectedOption().getXMLID())) continue;
                    if (arrayList2.contains(((Sense)power).getGroup().getXMLID())) {
                        arrayList.remove(i);
                        continue block0;
                    }
                    arrayList3 = ((Sense)power).getBuiltInSenseAdders(this.getID());
                    if (arrayList3.contains(this.getXMLID())) {
                        arrayList.remove(i);
                        continue block0;
                    }
                    if (this.levelValue < 1.0) {
                        adder.setBaseCost(this.senseCost);
                        continue block0;
                    }
                    adder.setBaseCost((double)(this.senseCost * this.levels) / this.levelValue);
                    continue block0;
                }
                continue;
            }
            if (this.getSelectedOption() != null && adder.getXMLID().equals(this.getSelectedOption().getXMLID()) && adder.getDisplay().equals(this.getSelectedOption().getDisplay())) {
                arrayList.remove(i);
                continue;
            }
            arrayList4 = Sense.getAllSenses();
            for (Power power : arrayList4) {
                if (!power.getXMLID().equals(adder.getXMLID()) || power.getXMLID().equals("DETECT") && !((String)((Object)(arrayList3 = SenseAdder.getDetectDisplay((Detect)power)))).equals(adder.getDisplay())) continue;
                if (((Sense)power).getGroup() != null && arrayList2.contains(((Sense)power).getGroup().getXMLID())) {
                    arrayList.remove(i);
                    continue block0;
                }
                arrayList3 = ((Sense)power).getBuiltInSenseAdders(this.getID());
                if (arrayList3.contains(this.getXMLID())) {
                    arrayList.remove(i);
                    continue block0;
                }
                if (this.levelValue < 1.0) {
                    adder.setBaseCost(this.senseCost);
                    continue block0;
                }
                adder.setBaseCost((double)(this.senseCost * this.levels) / this.levelValue);
                continue block0;
            }
        }
        this.assignedAddersSaver = arrayList;
        this.assignedAddersLastCalc = System.currentTimeMillis();
        return arrayList;
    }

    protected ArrayList<Adder> getAutomaticAdders() {
        Cloneable cloneable;
        Object object;
        ArrayList<Power> arrayList;
        ArrayList<String> arrayList2;
        if (this.automaticAddersSaver != null && this.automaticAddersLastCalc > Power.lastSenseEdit && Power.lastSenseEdit > 0L) {
            return this.automaticAddersSaver;
        }
        ArrayList<Adder> arrayList3 = new ArrayList<Adder>();
        ArrayList<String> arrayList4 = this.getSenseGroups();
        if (this.getSelectedOption() == null || this.getSelectedOption().getXMLID() == null) {
            return arrayList3;
        }
        if (this.groupCost > 0 && !this.getSelectedOption().getXMLID().equals("ALL")) {
            arrayList2 = this.getSenseGroups();
            arrayList = SenseGroup.getOwnedGroups();
            for (Power power : arrayList) {
                if (power.getXMLID().equals("UNUSUALGROUP") || power.getXMLID().equals("NOGROUP") || arrayList2.contains(power.getXMLID()) || ((ArrayList)(object = ((SenseGroup)power).getSenseAdders(this.getID()))).contains(this.getXMLID())) continue;
                cloneable = new Adder(power);
                ((GenericObject)cloneable).setAvailableAdders(new ArrayList<Adder>());
                ((GenericObject)cloneable).setAssignedAdders(new ArrayList<Adder>());
                ((GenericObject)cloneable).setExclusive(true);
                if (this.levelValue < 1.0) {
                    ((GenericObject)cloneable).setBaseCost(this.groupCost);
                } else {
                    ((GenericObject)cloneable).setLevelValue(-1.0);
                    ((GenericObject)cloneable).setBaseCost((double)(this.groupCost * this.levels) / this.levelValue);
                }
                arrayList3.add((Adder)cloneable);
            }
        }
        if (this.senseCost > 0) {
            arrayList2 = this.getSenses();
            arrayList = Sense.getOwnedSenses();
            block1: for (Power power : arrayList) {
                if (arrayList2.contains(power.getXMLID()) && !power.getXMLID().equals("DETECT") || arrayList4.contains(((Sense)power).getGroup().getXMLID())) continue;
                if (power.getXMLID().equals("DETECT")) {
                    object = SenseAdder.getDetectDisplay((Detect)power);
                    if (((String)object).equals(this.getSelectedOption().getDisplay())) continue;
                    cloneable = this.getAssignedAdders();
                    Iterator<Adder> iterator = ((ArrayList)cloneable).iterator();
                    while (iterator.hasNext()) {
                        Adder adder = iterator.next();
                        if (!adder.getDisplay().equals(object)) continue;
                        continue block1;
                    }
                }
                if (((ArrayList)(object = ((Sense)power).getBuiltInSenseAdders(this.getID()))).contains(this.getXMLID())) continue;
                cloneable = new Adder(power);
                if (power.getXMLID().equals("DETECT")) {
                    ((GenericObject)cloneable).setDisplay(SenseAdder.getDetectDisplay((Detect)power));
                    ((GenericObject)cloneable).setAlias(SenseAdder.getDetectDisplay((Detect)power));
                    ((GenericObject)cloneable).setOptions(new ArrayList<Adder>());
                    ((GenericObject)cloneable).setLevelValue(-1.0);
                    ((GenericObject)cloneable).setLevelCost(-1.0);
                    ((GenericObject)cloneable).setSelectedOption(null);
                }
                ((GenericObject)cloneable).setExclusive(true);
                ((GenericObject)cloneable).setAvailableAdders(new ArrayList<Adder>());
                ((GenericObject)cloneable).setAssignedAdders(new ArrayList<Adder>());
                if (this.levelValue < 1.0) {
                    ((GenericObject)cloneable).setBaseCost(this.senseCost);
                } else {
                    ((GenericObject)cloneable).setBaseCost((double)(this.senseCost * this.levels) / this.levelValue);
                }
                arrayList3.add((Adder)cloneable);
            }
        }
        this.automaticAddersSaver = arrayList3;
        this.automaticAddersLastCalc = System.currentTimeMillis();
        return arrayList3;
    }

    @Override
    public ArrayList<Adder> getAvailableAdders() {
        if (this.availableAddersSaver != null && this.availableAddersLastCalc > Power.lastSenseEdit && Power.lastSenseEdit > 0L) {
            return this.availableAddersSaver;
        }
        ArrayList<Adder> arrayList = super.getAvailableAdders();
        ArrayList<Adder> arrayList2 = new ArrayList<Adder>();
        arrayList2.addAll(this.getAssignedAdders());
        Collections.sort(arrayList2);
        ArrayList<Adder> arrayList3 = this.getAutomaticAdders();
        block0: for (Adder adder : arrayList3) {
            if (GenericObject.findObjectByID(arrayList2, adder.getXMLID()) == null) {
                arrayList.add(adder);
                continue;
            }
            if (!adder.getXMLID().equals("DETECT")) continue;
            for (int i = 0; i < arrayList2.size(); ++i) {
                Adder adder2 = arrayList2.get(i);
                if (adder2.getDisplay().equals(adder.getDisplay())) continue block0;
            }
            arrayList.add(adder);
        }
        Collections.sort(arrayList);
        arrayList2.addAll(arrayList);
        this.availableAddersSaver = arrayList2;
        this.availableAddersLastCalc = System.currentTimeMillis();
        return arrayList2;
    }

    @Override
    public String getColumn2Output() {
        String string = this.getAlias();
        if (this.getName().trim().length() > 0) {
            string = "<i>" + this.getName() + ":</i>  " + string;
        }
        if (this.getInput() != null && this.getInput().trim().length() > 0) {
            string = string + ":  " + this.getInput();
        }
        String string2 = " with ";
        if (this.getSelectedOption() != null) {
            string2 = string2 + this.getSelectedOption().getAlias();
            String string3 = this.getAdderString();
            if (string3.trim().length() > 0) {
                string2 = string2 + ", " + string3;
                string2 = string2.substring(0, string2.lastIndexOf(",")) + " and" + string2.substring(string2.lastIndexOf(",") + 1, string2.length());
            }
        } else {
            String string4 = this.getAdderString();
            if (string4.trim().length() > 0 && (string2 = string2 + " " + string4).indexOf(", ") > 0) {
                string2 = string2.substring(0, string2.lastIndexOf(",")) + " and" + string2.substring(string2.lastIndexOf(",") + 1, string2.length());
            }
        }
        if (!string2.equals(" for")) {
            string = string + string2;
        }
        string = string + this.getModifierString();
        if (this.getEndUsage() > 0 && GenericObject.findObjectByID(HeroDesigner.getActiveHero().getPowers(), "ENDURANCERESERVE") != null && GenericObject.findObjectByID(this.getAllAssignedModifiers(), "ENDRESERVEOREND") == null && !HeroDesigner.getInstance().getPrefs().useWG()) {
            string = this.getUseENDReserve() ? string + " (uses END Reserve)" : string + " (uses Personal END)";
        }
        return string;
    }

    @Override
    public GenericDialog getDialog(boolean bl, boolean bl2) {
        Power.lastSenseEdit = System.currentTimeMillis();
        return super.getDialog(bl, bl2);
    }

    @Override
    public ArrayList<Adder> getOptions() {
        Object object;
        Power power;
        Iterator<Power> iterator;
        Cloneable cloneable;
        if (this.optionsSaver != null && this.options.size() > 0 && this.optionsLastCalc > Power.lastSenseEdit && Power.lastSenseEdit > 0L) {
            return this.optionsSaver;
        }
        ArrayList arrayList = (ArrayList)super.getOptions().clone();
        if (this.allCost > 0 && GenericObject.findObjectByID(arrayList, "ALL") == null) {
            cloneable = new Adder(new Element("ADDER"));
            ((Adder)cloneable).setXMLID("ALL");
            if (this.levelValue > 0.0) {
                ((GenericObject)cloneable).setLevelCost(this.allCost);
            } else {
                ((GenericObject)cloneable).setBaseCost(this.allCost);
            }
            ((GenericObject)cloneable).setDisplay("all Sense Groups");
            ((GenericObject)cloneable).setAlias("all Sense Groups");
            arrayList.add(cloneable);
        }
        if (this.groupCost > 0) {
            cloneable = SenseGroup.getOwnedGroups();
            iterator = ((ArrayList)cloneable).iterator();
            while (iterator.hasNext()) {
                power = (SenseGroup)iterator.next();
                if (this.getXMLID().startsWith("DIMENSIONAL") && (((SenseGroup)power).getSenseAdders(this.getID()).contains("DIMENSIONALSINGLE") || ((SenseGroup)power).getSenseAdders(this.getID()).contains("DIMENSIONALALL") || ((SenseGroup)power).getSenseAdders(this.getID()).contains("DIMENSIONALGROUP")) || GenericObject.findObjectByID(arrayList, power.getXMLID()) != null || ((SenseGroup)power).getSenseAdders(this.getID()).contains(this.getXMLID()) && !(this.getLevelCost() > 0.0)) continue;
                object = new Adder(power);
                if (this.levelValue > 0.0) {
                    ((GenericObject)object).setLevelCost(this.groupCost);
                } else {
                    ((GenericObject)object).setBaseCost(this.groupCost);
                }
                arrayList.add(object);
            }
        }
        if (this.senseCost > 0) {
            cloneable = Sense.getOwnedSenses();
            iterator = ((ArrayList)cloneable).iterator();
            block1: while (iterator.hasNext()) {
                power = (Sense)iterator.next();
                if (this.getXMLID().startsWith("DIMENSIONAL") && (((Sense)power).getBuiltInSenseAdders(this.getID()).contains("DIMENSIONALSINGLE") || ((Sense)power).getBuiltInSenseAdders(this.getID()).contains("DIMENSIONALALL") || ((Sense)power).getBuiltInSenseAdders(this.getID()).contains("DIMENSIONALGROUP")) || ((Sense)power).getBuiltInSenseAdders(this.getID()).contains(this.getXMLID()) && !(this.getLevelCost() > 0.0)) continue;
                object = power.getDisplay();
                if (power.getXMLID().equals("DETECT")) {
                    object = SenseAdder.getDetectDisplay((Detect)power);
                }
                for (Adder adder : arrayList) {
                    if (!adder.getDisplay().equals(object)) continue;
                    continue block1;
                }
                Adder adder = new Adder(power);
                if (this.levelValue > 0.0) {
                    adder.setBaseCost(0.0);
                    adder.setLevelCost(this.senseCost);
                } else {
                    adder.setLevelCost(0.0);
                    adder.setLevelValue(-1.0);
                    adder.setBaseCost(this.senseCost);
                }
                if (power.getXMLID().equals("DETECT")) {
                    adder.setDisplay((String)object);
                    adder.setAlias((String)object);
                    adder.setAvailableAdders(new ArrayList<Adder>());
                    adder.setAssignedAdders(new ArrayList<Adder>());
                }
                arrayList.add(adder);
            }
        }
        this.optionsSaver = arrayList;
        this.optionsLastCalc = System.currentTimeMillis();
        return arrayList;
    }

    @Override
    public Adder getSelectedOption() {
        Adder adder = super.getSelectedOption();
        return adder;
    }

    public ArrayList<String> getSenseGroups() {
        if (this.senseGroupsSaver != null && this.senseGroupsLastCalc > Power.lastSenseEdit && Power.lastSenseEdit > 0L) {
            return this.senseGroupsSaver;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.getSelectedOption() != null) {
            if (this.getSelectedOption().getXMLID().equals("ALL")) {
                ArrayList<SenseGroup> arrayList2 = SenseGroup.getAllGroups();
                for (SenseGroup senseGroup : arrayList2) {
                    arrayList.add(senseGroup.getXMLID());
                }
                this.senseGroupsSaver = arrayList;
                this.senseGroupsLastCalc = System.currentTimeMillis();
                return arrayList;
            }
            if (this.getSelectedOption().getXMLID().endsWith("GROUP")) {
                arrayList.add(this.getSelectedOption().getXMLID());
            }
        }
        for (Adder adder : super.getAssignedAdders()) {
            if (adder.getXMLID().equals("GROUP")) {
                if (adder.getSelectedOption() == null || arrayList.contains(adder.getSelectedOption().getXMLID())) continue;
                arrayList.add(adder.getSelectedOption().getXMLID());
                continue;
            }
            if (!adder.getXMLID().endsWith("GROUP") || arrayList.contains(adder.getXMLID())) continue;
            arrayList.add(adder.getXMLID());
        }
        this.senseGroupsSaver = arrayList;
        this.senseGroupsLastCalc = System.currentTimeMillis();
        return arrayList;
    }

    public ArrayList<String> getSenses() {
        if (this.sensesSaver != null && this.sensesLastCalc > Power.lastSenseEdit && Power.lastSenseEdit > 0L) {
            return this.sensesSaver;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.getSelectedOption() != null && !this.getSelectedOption().getXMLID().endsWith("GROUP")) {
            arrayList.add(this.getSelectedOption().getXMLID());
        }
        for (Adder adder : super.getAssignedAdders()) {
            if (adder.getXMLID().endsWith("GROUP")) continue;
            if (adder.getSelectedOption() != null) {
                if (arrayList.contains(adder.getSelectedOption().getXMLID())) continue;
                arrayList.add(adder.getSelectedOption().getXMLID());
                continue;
            }
            if (arrayList.contains(adder.getXMLID())) continue;
            arrayList.add(adder.getXMLID());
        }
        this.sensesSaver = arrayList;
        this.sensesLastCalc = System.currentTimeMillis();
        return arrayList;
    }

    @Override
    protected void init(Element element) {
        int n;
        super.init(element);
        this.allCost = -1;
        this.groupCost = -1;
        this.senseCost = -1;
        String string = XMLUtility.getValue(element, "ALLCOST");
        if (string != null && string.trim().length() > 0) {
            try {
                this.allCost = n = Integer.parseInt(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((string = XMLUtility.getValue(element, "GROUPCOST")) != null && string.trim().length() > 0) {
            try {
                this.groupCost = n = Integer.parseInt(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((string = XMLUtility.getValue(element, "SENSECOST")) != null && string.trim().length() > 0) {
            try {
                int n2;
                this.senseCost = n2 = Integer.parseInt(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void restoreFromSave(Element element) {
        ArrayList<Object> arrayList;
        ArrayList<Power> arrayList2;
        super.restoreFromSave(element);
        Power.lastSenseEdit = System.currentTimeMillis();
        String string = null;
        String string2 = XMLUtility.getValue(element, "OPTIONID");
        if (string2 != null && string2.trim().length() > 0) {
            string = string2;
        } else {
            string2 = XMLUtility.getValue(element, "OPTION");
            if (string2 != null && string2.trim().length() > 0) {
                string = string2;
            }
        }
        if (string != null) {
            arrayList2 = new ArrayList<Power>();
            arrayList2.addAll(Sense.getAllSenses());
            arrayList2.addAll(SenseGroup.getAllGroups());
            arrayList = new ArrayList();
            for (GenericObject object2 : arrayList2) {
                Object object = new Adder(object2);
                if (this.levelValue > 0.0) {
                    ((GenericObject)object).setBaseCost(0.0);
                    ((GenericObject)object).setLevelCost(this.senseCost);
                } else {
                    ((GenericObject)object).setLevelCost(0.0);
                    ((GenericObject)object).setLevelValue(-1.0);
                    ((GenericObject)object).setBaseCost(this.senseCost);
                }
                arrayList.add(object);
            }
            if (this.allCost > 0 && GenericObject.findObjectByID(arrayList, "ALL") == null) {
                Adder adder = new Adder(new Element("ADDER"));
                adder.setXMLID("ALL");
                if (this.levelValue > 0.0) {
                    adder.setLevelCost(this.allCost);
                } else {
                    adder.setBaseCost(this.allCost);
                }
                adder.setDisplay("all Sense Groups");
                adder.setAlias("all Sense Groups");
                arrayList.add(adder);
            }
            boolean bl = false;
            String string3 = XMLUtility.getValue(element, "OPTION_ALIAS");
            for (Object object4 : arrayList) {
                if (!((GenericObject)object4).getXMLID().equals(string) && !((GenericObject)object4).getDisplay().toUpperCase().equals(string.toUpperCase())) continue;
                if (string3 != null && string3.trim().length() > 0) {
                    ((GenericObject)object4).setAlias(string3);
                }
                this.setSelectedOption((Adder)object4);
                bl = true;
                break;
            }
            if (!bl) {
                if (string3 != null && string3.trim().length() > 0) {
                    for (Object object4 : arrayList) {
                        if (!((GenericObject)object4).getDisplay().toUpperCase().startsWith(string3.trim().toUpperCase()) && !string3.trim().toUpperCase().startsWith(((GenericObject)object4).getDisplay()) && !((GenericObject)object4).getAlias().equals(string3)) continue;
                        ((GenericObject)object4).setAlias(string3);
                        this.setSelectedOption((Adder)object4);
                        bl = true;
                        break;
                    }
                }
                if (!bl) {
                    for (Object object4 : arrayList) {
                        if (((GenericObject)object4).getBaseCost() != this.baseCost) continue;
                        if (string3 != null && string3.trim().length() > 0) {
                            ((GenericObject)object4).setAlias(string3);
                        }
                        this.setSelectedOption((Adder)object4);
                        bl = true;
                        break;
                    }
                }
            }
        }
        arrayList2 = this.availableAdders;
        this.assignedAdders = new ArrayList();
        this.availableAdders = new ArrayList();
        arrayList = this.getAvailableAdders();
        this.availableAdders = arrayList2;
        ArrayList<Adder> arrayList3 = new ArrayList<Adder>();
        block6: for (Object object : element.getChildren("ADDER")) {
            Object object2;
            Object object3;
            Object object4;
            object4 = XMLUtility.getValue((Element)object, "XMLID");
            if (object4 != null && (((String)object4).trim().equals("SINGLE") || ((String)object4).trim().equals("GROUP"))) {
                object3 = null;
                object2 = XMLUtility.getValue(object, "OPTIONID");
                if (object2 != null && ((String)object2).trim().length() > 0) {
                    object3 = object2;
                } else {
                    object2 = XMLUtility.getValue(object, "OPTION");
                    if (object2 != null && ((String)object2).trim().length() > 0) {
                        object3 = object2;
                    }
                }
                if (object3 != null && ((String)object3).trim().length() > 0) {
                    for (Adder adder : arrayList) {
                        if (!adder.getXMLID().startsWith(((String)object3).trim().toUpperCase()) && !((String)object3).trim().toUpperCase().startsWith(adder.getXMLID()) && !adder.getDisplay().equals(object3)) continue;
                        try {
                            Adder adder2 = adder.clone();
                            adder2.setSelected(true);
                            arrayList3.add(adder2);
                            continue block6;
                        }
                        catch (Exception exception) {
                        }
                    }
                }
            }
            object3 = new Adder((Element)object);
            ((GenericObject)object3).setExclusive(false);
            ((Adder)object3).setAvailableCheck(false);
            ((Adder)object3).restoreFromSave((Element)object);
            arrayList3.add((Adder)object3);
            object2 = this.getOptions();
            if (this.selectedOption != null || ((ArrayList)object2).size() <= 0) continue;
            this.setSelectedOption((Adder)((ArrayList)object2).get(0));
        }
        this.assignedAdders = arrayList3;
        Power.lastSenseEdit = System.currentTimeMillis();
    }

    @Override
    public void setSelectedOption(Adder adder) {
        double d = this.levelValue;
        Power.lastSenseEdit = System.currentTimeMillis();
        super.setSelectedOption(adder);
        this.levelValue = d;
        if (adder != null) {
            this.baseCost = 0.0;
            this.levelCost = 0.0;
            if (adder.getXMLID().equals("ALL")) {
                if (this.levelValue > 0.0) {
                    this.levelCost = this.allCost;
                } else {
                    this.baseCost = this.allCost;
                }
            } else if (adder.getXMLID().endsWith("GROUP") && this.groupCost > 0) {
                if (this.levelValue > 0.0) {
                    this.levelCost = this.groupCost;
                } else {
                    this.baseCost = this.groupCost;
                }
            } else if (this.levelValue > 0.0) {
                this.levelCost = this.senseCost;
            } else {
                this.baseCost = this.senseCost;
            }
        }
        Power.lastSenseEdit = System.currentTimeMillis();
    }
}

