/*
 * Decompiled with CFR 0.152.
 */
package com.hero.objects.powers;

import com.hero.HeroDesigner;
import com.hero.objects.Adder;
import com.hero.objects.GenericObject;
import com.hero.objects.powers.CompoundPower;
import com.hero.objects.powers.Detect;
import com.hero.objects.powers.Power;
import com.hero.objects.powers.SenseAdder;
import com.hero.objects.powers.SenseGroup;
import com.hero.ui.dialog.GenericDialog;
import com.hero.ui.dialog.SenseDialog;
import com.hero.util.XMLUtility;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import org.jdom.Element;

public class Sense
extends Power {
    private static ArrayList<Sense> allSenses = new ArrayList();
    private static ArrayList<Sense> builtInSenses = new ArrayList();
    private static long lastCalculated;
    private static ArrayList<Sense> timeSaver;
    protected boolean active;
    private boolean activeSelectable;
    private boolean allowAnyGroup;
    private boolean allowSenseModifiers;
    private long assignedAddersLastCall;
    private ArrayList<Adder> assignedAddersSaver;
    private long availableAddersLastCall;
    private ArrayList<Adder> availableAddersSaver;
    private long builtInSenseAddersLastCall;
    private long builtInSenseAddersLastID;
    private ArrayList<String> builtInSenseAddersSaver;
    private SenseGroup group;
    private String groupID;
    private ArrayList<String> senseAdders;
    private long senseModifiersLastCall;
    private ArrayList<String> senseModifiersSaver;

    public static void clear() {
        allSenses.clear();
        builtInSenses.clear();
    }

    public static ArrayList<Sense> getAllSenses() {
        return allSenses;
    }

    public static ArrayList<Sense> getBuiltInSenses() {
        return builtInSenses;
    }

    public static ArrayList<Sense> getOwnedSenses() {
        long l = System.currentTimeMillis();
        if (lastCalculated > 0L && lastCalculated >= GenericObject.lastEdit && HeroDesigner.lastEdit > 0L && lastCalculated > HeroDesigner.lastEdit && timeSaver != null) {
            return timeSaver;
        }
        lastCalculated = l;
        ArrayList<Sense> arrayList = new ArrayList<Sense>();
        arrayList.addAll(builtInSenses);
        if (HeroDesigner.getActiveHero() != null) {
            Sense sense;
            CompoundPower compoundPower;
            Sense sense2;
            for (GenericObject genericObject : HeroDesigner.getActiveHero().getTalents()) {
                sense2 = (Sense)GenericObject.findObjectByID(allSenses, genericObject.getXMLID());
                if (sense2 != null && sense2.allowSenseModifiers()) {
                    if (genericObject instanceof Sense) {
                        arrayList.add((Sense)genericObject);
                        continue;
                    }
                    arrayList.add(sense2);
                    continue;
                }
                if (!(genericObject instanceof CompoundPower)) continue;
                compoundPower = (CompoundPower)genericObject;
                for (GenericObject genericObject2 : compoundPower.getPowers()) {
                    sense = (Sense)GenericObject.findObjectByID(allSenses, genericObject2.getXMLID());
                    if (sense == null || !sense.allowSenseModifiers()) continue;
                    if (genericObject2 instanceof Sense) {
                        arrayList.add((Sense)genericObject2);
                        continue;
                    }
                    arrayList.add(sense);
                }
            }
            for (GenericObject genericObject : HeroDesigner.getActiveHero().getPowers()) {
                sense2 = (Sense)GenericObject.findObjectByID(allSenses, genericObject.getXMLID());
                if (sense2 != null && sense2.allowSenseModifiers()) {
                    if (genericObject instanceof Sense) {
                        arrayList.add((Sense)genericObject);
                        continue;
                    }
                    arrayList.add(sense2);
                    continue;
                }
                if (!(genericObject instanceof CompoundPower)) continue;
                compoundPower = (CompoundPower)genericObject;
                for (GenericObject genericObject2 : compoundPower.getPowers()) {
                    sense = (Sense)GenericObject.findObjectByID(allSenses, genericObject2.getXMLID());
                    if (sense == null || !sense.allowSenseModifiers()) continue;
                    if (genericObject2 instanceof Sense) {
                        arrayList.add((Sense)genericObject2);
                        continue;
                    }
                    arrayList.add(sense);
                }
            }
            for (GenericObject genericObject : HeroDesigner.getActiveHero().getEquipment()) {
                sense2 = (Sense)GenericObject.findObjectByID(allSenses, genericObject.getXMLID());
                if (sense2 != null && sense2.allowSenseModifiers()) {
                    if (genericObject instanceof Sense) {
                        arrayList.add((Sense)genericObject);
                        continue;
                    }
                    arrayList.add(sense2);
                    continue;
                }
                if (!(genericObject instanceof CompoundPower)) continue;
                compoundPower = (CompoundPower)genericObject;
                for (GenericObject genericObject2 : compoundPower.getPowers()) {
                    sense = (Sense)GenericObject.findObjectByID(allSenses, genericObject2.getXMLID());
                    if (sense == null || !sense.allowSenseModifiers()) continue;
                    if (genericObject2 instanceof Sense) {
                        arrayList.add((Sense)genericObject2);
                        continue;
                    }
                    arrayList.add(sense);
                }
            }
        }
        timeSaver = arrayList;
        return arrayList;
    }

    public static Sense getSenseByID(String string) {
        ArrayList<Sense> arrayList = Sense.getAllSenses();
        for (Sense sense : arrayList) {
            if (!sense.getXMLID().equals(string)) continue;
            return sense;
        }
        return null;
    }

    public Sense(Element element) {
        super(element);
        if (this.xmlID == null || this.xmlID.trim().length() == 0) {
            this.xmlID = XMLUtility.getValue(element, "XMLID");
        }
        if (this.xmlID != null && this.xmlID.trim().length() > 0 && this.display != null && this.display.trim().length() > 0 && this.includedInTemplate()) {
            while (GenericObject.findObjectByID(allSenses, this.xmlID) != null) {
                allSenses.remove(GenericObject.findObjectByID(allSenses, this.xmlID));
            }
            allSenses.add(this);
        }
    }

    public Sense(Element element, String string) {
        super(element, string);
        if (this.xmlID == null || this.xmlID.trim().length() == 0) {
            this.xmlID = string;
        }
        if (this.xmlID != null && this.xmlID.trim().length() > 0 && this.display != null && this.display.trim().length() > 0 && this.includedInTemplate()) {
            while (GenericObject.findObjectByID(allSenses, this.xmlID) != null) {
                allSenses.remove(GenericObject.findObjectByID(allSenses, this.xmlID));
            }
            allSenses.add(this);
        }
    }

    public boolean allowSenseModifiers() {
        return this.allowSenseModifiers;
    }

    @Override
    public String getAdderString() {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<Adder> arrayList2 = this.getAssignedAdders();
        Collections.sort(arrayList2, new Comparator(){

            public int compare(Object object, Object object2) {
                GenericObject genericObject = (GenericObject)object;
                GenericObject genericObject2 = (GenericObject)object2;
                String string = genericObject.getSortingValue().toUpperCase();
                String string2 = genericObject2.getSortingValue().toUpperCase();
                if (string.equals("ANALYZE")) {
                    string = "DISCRIMINATORYANALYZE";
                } else if (string2.equals("ANALYZE")) {
                    string2 = "DISCRIMINATORYANALYZE";
                }
                return string.compareTo(string2);
            }

            @Override
            public boolean equals(Object object) {
                return false;
            }
        });
        for (Adder object : arrayList2) {
            object.addAliasToVector(arrayList);
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (String string : arrayList) {
            if (string.trim().length() <= 0) continue;
            if (stringBuffer.length() > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(string.trim());
        }
        return stringBuffer.toString();
    }

    @Override
    public ArrayList<Adder> getAssignedAdders() {
        if (this.assignedAddersLastCall > 0L && this.assignedAddersLastCall >= GenericObject.lastEdit && HeroDesigner.lastEdit > 0L && this.assignedAddersLastCall > HeroDesigner.lastEdit && this.assignedAddersSaver != null) {
            return this.assignedAdders;
        }
        ArrayList<Adder> arrayList = super.getAssignedAdders();
        ArrayList<Object> arrayList2 = new ArrayList();
        if (this.getGroup() != null) {
            arrayList2 = this.getGroup().getSenseAdders();
        }
        if (this.senseAdders == null) {
            this.senseAdders = new ArrayList();
        }
        ArrayList arrayList3 = (ArrayList)this.senseAdders.clone();
        arrayList3.addAll(this.getSenseModifiers());
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            Adder adder = arrayList.get(i);
            if (arrayList2.contains(adder.getXMLID()) || arrayList3.contains(adder.getXMLID())) {
                arrayList.remove(i);
                continue;
            }
            if (adder.getXMLID().equals("INCREASEDARC240")) {
                if (!arrayList2.contains("INCREASEDARC360") && !arrayList3.contains("INCREASEDARC360") && GenericObject.findObjectByID(arrayList, "INCREASEDARC360") == null) continue;
                arrayList.remove(i);
                continue;
            }
            if (adder.getXMLID().equals("DIMENSIONALSINGLE")) {
                if (arrayList2.contains("DIMENSIONALALL") || arrayList3.contains("DIMENSIONALALL") || GenericObject.findObjectByID(arrayList, "DIMENSIONALALL") != null) {
                    arrayList.remove(i);
                    continue;
                }
                if (!arrayList2.contains("DIMENSIONALGROUP") && !arrayList3.contains("DIMENSIONALGROUP") && GenericObject.findObjectByID(arrayList, "DIMENSIONALGROUP") == null) continue;
                arrayList.remove(i);
                continue;
            }
            if (adder.getXMLID().equals("DIMENSIONALGROUP")) {
                if (arrayList2.contains("DIMENSIONALALL") || arrayList3.contains("DIMENSIONALALL") || GenericObject.findObjectByID(arrayList, "DIMENSIONALALL") != null) {
                    arrayList.remove(i);
                    continue;
                }
                if (!arrayList2.contains("DIMENSIONALSINGLE") && !arrayList3.contains("DIMENSIONALSINGLE") && GenericObject.findObjectByID(arrayList, "DIMENSIONALSINGLE") == null) continue;
                arrayList.remove(i);
                continue;
            }
            if (adder.getXMLID().equals("DIMENSIONALALL")) {
                if (arrayList2.contains("DIMENSIONALGROUP") || arrayList3.contains("DIMENSIONALGROUP") || GenericObject.findObjectByID(arrayList, "DIMENSIONALGROUP") != null) {
                    arrayList.remove(i);
                    continue;
                }
                if (!arrayList2.contains("DIMENSIONALSINGLE") && !arrayList3.contains("DIMENSIONALSINGLE") && GenericObject.findObjectByID(arrayList, "DIMENSIONALSINGLE") == null) continue;
                arrayList.remove(i);
                continue;
            }
            if (adder.getXMLID().equals("CONCEALED")) {
                if (this.active || arrayList2.contains("TRANSMIT") || arrayList3.contains("TRANSMIT") || GenericObject.findObjectByID(arrayList, "TRANSMIT") != null) {
                    adder.setDisplay("Concealed (-[LVL] with " + this.getAlias() + " PER Rolls)");
                    adder.setAlias(adder.getDisplay());
                    continue;
                }
                arrayList.remove(i);
                continue;
            }
            if (!adder.getXMLID().equals("ANALYZESENSE") || arrayList3.contains("DISCRIMINATORY") || arrayList2.contains("DISCRIMINATORY") || GenericObject.findObjectByID(arrayList, "DISCRIMINATORY") != null) continue;
            arrayList.remove(i);
        }
        this.assignedAddersSaver = arrayList;
        this.assignedAddersLastCall = System.currentTimeMillis();
        return arrayList;
    }

    @Override
    public ArrayList<Adder> getAvailableAdders() {
        if (this.availableAddersLastCall > 0L && this.availableAddersLastCall > GenericObject.lastEdit && HeroDesigner.lastEdit > 0L && this.availableAddersLastCall > HeroDesigner.lastEdit && this.availableAddersSaver != null) {
            return this.availableAddersSaver;
        }
        ArrayList<Adder> arrayList = super.getAvailableAdders();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ArrayList<Adder> arrayList3 = new ArrayList<Adder>();
        ArrayList<SenseAdder> arrayList4 = SenseAdder.getAllSenseAdders();
        ArrayList<String> arrayList5 = this.getBuiltInSenseAdders();
        ArrayList<Adder> arrayList6 = this.getAssignedAdders();
        ArrayList<Adder> arrayList7 = new ArrayList<Adder>();
        for (Adder genericObject : arrayList6) {
            if (genericObject.getXMLID().equals("GENERIC_OBJECT") || GenericObject.findObjectByID(arrayList, genericObject.getXMLID()) != null) continue;
            arrayList7.add(genericObject);
            arrayList2.add(genericObject.getXMLID());
        }
        for (GenericObject genericObject : arrayList4) {
            Adder adder;
            if (!arrayList5.contains(genericObject.getXMLID()) && !arrayList2.contains(genericObject.getXMLID())) {
                if (genericObject.getXMLID().equals("INCREASEDARC240") && arrayList5.contains("INCREASEDARC360") || genericObject.getXMLID().equals("DIMENSIONALSINGLE") && (arrayList5.contains("DIMENSIONALGROUP") || arrayList6.contains("DIMENSIONALGROUP")) || genericObject.getXMLID().equals("DIMENSIONALSINGLE") && (arrayList5.contains("DIMENSIONALALL") || arrayList6.contains("DIMENSIONALALL")) || genericObject.getXMLID().equals("DIMENSIONALGROUP") && (arrayList5.contains("DIMENSIONALSINGLE") || arrayList6.contains("DIMENSIONALSINGLE")) || genericObject.getXMLID().equals("DIMENSIONALGROUP") && (arrayList5.contains("DIMENSIONALALL") || arrayList6.contains("DIMENSIONALALL")) || genericObject.getXMLID().equals("DIMENSIONALALL") && (arrayList5.contains("DIMENSIONALGROUP") || arrayList6.contains("DIMENSIONALGROUP")) || genericObject.getXMLID().equals("DIMENSIONALALL") && (arrayList5.contains("DIMENSIONALSINGLE") || arrayList6.contains("DIMENSIONALSINGLE"))) continue;
                adder = new Adder(genericObject);
                if (genericObject instanceof SenseAdder) {
                    adder.setExclusive(true);
                    if (genericObject.getXMLID().equals("ANALYZESENSE")) {
                        if (!arrayList5.contains("DISCRIMINATORY")) {
                            adder.getRequires().add("DISCRIMINATORY");
                        } else {
                            adder.getRequires().clear();
                        }
                    } else if (adder.getXMLID().equals("CONCEALED")) {
                        if (!this.active && !arrayList5.contains("TRANSMIT") && GenericObject.findObjectByID(arrayList6, "TRANSMIT") == null) continue;
                        adder.setDisplay("Concealed (-[LVL] with " + this.getAlias() + " PER Rolls)");
                        adder.setAlias(adder.getDisplay());
                    } else if (adder.getXMLID().equals("ENHANCEDPERCEPTION")) {
                        adder.setDisplay("+[LVL] to PER Roll");
                        adder.setAlias(adder.getDisplay());
                    }
                    SenseAdder senseAdder = (SenseAdder)genericObject;
                    if (senseAdder.getLevelValue() > 0.0) {
                        adder.setLevelCost(senseAdder.senseCost);
                    } else {
                        adder.setBaseCost(senseAdder.senseCost);
                    }
                }
                arrayList.add(adder);
                arrayList2.add(adder.getXMLID());
                continue;
            }
            if (arrayList2.contains(genericObject.getXMLID())) continue;
            adder = new Adder(genericObject);
            adder.setAlias(adder.getAlias() + " (built in)");
            adder.setBaseCost(0.0);
            adder.setLevelCost(0.0);
            adder.setSelected(false);
            adder.setSelectable(false);
            arrayList3.add(adder);
        }
        arrayList3.addAll(arrayList7);
        Collections.sort(arrayList);
        arrayList3.addAll(arrayList);
        this.availableAddersLastCall = System.currentTimeMillis();
        this.availableAddersSaver = arrayList3;
        return arrayList3;
    }

    public ArrayList<SenseGroup> getAvailableGroups() {
        ArrayList<SenseGroup> arrayList = new ArrayList<SenseGroup>();
        arrayList.add(this.getGroup());
        if (this.allowAnyGroup) {
            ArrayList<SenseGroup> arrayList2 = SenseGroup.getAllGroups();
            for (SenseGroup senseGroup : arrayList2) {
                if (arrayList.contains(senseGroup)) continue;
                arrayList.add(senseGroup);
            }
        }
        return arrayList;
    }

    public ArrayList<String> getBuiltInSenseAdders() {
        ArrayList<String> arrayList = this.getSenseAdders();
        if (this.getGroup() != null) {
            arrayList.addAll(this.getGroup().getSenseAdders());
        }
        if (HeroDesigner.getActiveHero() == null) {
            return arrayList;
        }
        arrayList.addAll(this.getSenseModifiers());
        return arrayList;
    }

    public ArrayList<String> getBuiltInSenseAdders(long l) {
        ArrayList<Adder> arrayList;
        Iterator<Adder> iterator;
        Power power;
        if (this.builtInSenseAddersLastCall > 0L && this.builtInSenseAddersLastCall > Power.lastSenseEdit && HeroDesigner.lastEdit > 0L && this.builtInSenseAddersLastCall > HeroDesigner.lastEdit && this.builtInSenseAddersSaver != null && this.builtInSenseAddersLastID == l) {
            return this.builtInSenseAddersSaver;
        }
        ArrayList<String> arrayList2 = this.getSenseAdders();
        if (this.getGroup() != null) {
            arrayList2.addAll(this.getGroup().getSenseAdders(l));
        }
        if (HeroDesigner.getActiveHero() == null) {
            return arrayList2;
        }
        for (GenericObject genericObject : HeroDesigner.getActiveHero().getPowers()) {
            if (genericObject instanceof SenseAdder) {
                power = (SenseAdder)genericObject;
                if (power.getID() == l || !((SenseAdder)power).getSenses().contains(this.getXMLID()) || arrayList2.contains(power.getXMLID())) continue;
                if (this.getXMLID().equals("DETECT")) {
                    boolean bl = true;
                    if (((SenseAdder)power).getSelectedOption().getDisplay().equals(SenseAdder.getDetectDisplay((Detect)this))) {
                        bl = false;
                    }
                    ArrayList<Adder> arrayList3 = ((SenseAdder)power).getAssignedAdders();
                    iterator = arrayList3.iterator();
                    while (iterator.hasNext()) {
                        Adder adder = (Adder)iterator.next();
                        if (!adder.getDisplay().equals(SenseAdder.getDetectDisplay((Detect)this))) continue;
                        bl = false;
                        break;
                    }
                    if (bl) continue;
                }
                arrayList2.add(power.getXMLID());
                continue;
            }
            if (!(genericObject instanceof CompoundPower)) continue;
            power = (CompoundPower)genericObject;
            for (GenericObject genericObject2 : ((CompoundPower)power).getPowers()) {
                if (!(genericObject2 instanceof SenseAdder) || ((GenericObject)((Object)(iterator = (SenseAdder)genericObject2))).getID() == l || !((SenseAdder)((Object)iterator)).getSenses().contains(this.getXMLID()) || arrayList2.contains(((GenericObject)((Object)iterator)).getXMLID())) continue;
                if (this.getXMLID().equals("DETECT")) {
                    boolean bl = true;
                    if (((SenseAdder)((Object)iterator)).getSelectedOption().getDisplay().equals(SenseAdder.getDetectDisplay((Detect)this))) {
                        bl = false;
                    }
                    arrayList = ((SenseAdder)((Object)iterator)).getAssignedAdders();
                    for (Adder adder : arrayList) {
                        if (!adder.getDisplay().equals(SenseAdder.getDetectDisplay((Detect)this))) continue;
                        bl = false;
                        break;
                    }
                    if (bl) continue;
                }
                arrayList2.add(((GenericObject)((Object)iterator)).getXMLID());
            }
        }
        for (GenericObject genericObject : HeroDesigner.getActiveHero().getEquipment()) {
            if (genericObject instanceof SenseAdder) {
                power = (SenseAdder)genericObject;
                if (power.getID() == l || !((SenseAdder)power).getSenses().contains(this.getXMLID()) || arrayList2.contains(power.getXMLID())) continue;
                if (this.getXMLID().equals("DETECT")) {
                    boolean bl = true;
                    if (((SenseAdder)power).getSelectedOption().getDisplay().equals(SenseAdder.getDetectDisplay((Detect)this))) {
                        bl = false;
                    }
                    ArrayList<Adder> arrayList4 = ((SenseAdder)power).getAssignedAdders();
                    iterator = arrayList4.iterator();
                    while (iterator.hasNext()) {
                        Adder adder = iterator.next();
                        if (!adder.getDisplay().equals(SenseAdder.getDetectDisplay((Detect)this))) continue;
                        bl = false;
                        break;
                    }
                    if (bl) continue;
                }
                arrayList2.add(power.getXMLID());
                continue;
            }
            if (!(genericObject instanceof CompoundPower)) continue;
            power = (CompoundPower)genericObject;
            for (GenericObject genericObject3 : ((CompoundPower)power).getPowers()) {
                if (!(genericObject3 instanceof SenseAdder) || ((GenericObject)((Object)(iterator = (SenseAdder)genericObject3))).getID() == l || !((SenseAdder)((Object)iterator)).getSenses().contains(this.getXMLID()) || arrayList2.contains(((GenericObject)((Object)iterator)).getXMLID())) continue;
                if (this.getXMLID().equals("DETECT")) {
                    boolean bl = true;
                    if (((SenseAdder)((Object)iterator)).getSelectedOption().getDisplay().equals(SenseAdder.getDetectDisplay((Detect)this))) {
                        bl = false;
                    }
                    arrayList = ((SenseAdder)((Object)iterator)).getAssignedAdders();
                    for (Adder adder : arrayList) {
                        if (!adder.getDisplay().equals(SenseAdder.getDetectDisplay((Detect)this))) continue;
                        bl = false;
                        break;
                    }
                    if (bl) continue;
                }
                arrayList2.add(((GenericObject)((Object)iterator)).getXMLID());
            }
        }
        this.builtInSenseAddersSaver = arrayList2;
        this.builtInSenseAddersLastCall = System.currentTimeMillis();
        this.builtInSenseAddersLastID = l;
        return arrayList2;
    }

    @Override
    public String getColumn2Output() {
        String string = this.getAlias();
        if (this.getName().trim().length() > 0) {
            string = "<i>" + this.getName() + ":</i>  " + string;
        }
        if (this.getGroup() != null && this.getAvailableGroups().size() > 1) {
            string = string + " (" + this.getGroup().getAlias() + ")";
        } else if (this.getGroup() == null && this.getAvailableGroups().size() > 1) {
            string = string + " (Unusual Group)";
        }
        if (this.getInput() != null && this.getInput().trim().length() > 0) {
            string = string + ":  " + this.getInput();
        }
        if (this.getSelectedOption() != null) {
            string = string + ", ";
            string = string + this.getSelectedOption().getAlias();
            String string2 = this.getAdderString();
            if (string2.trim().length() > 0) {
                string = string + ", " + string2;
            }
        } else {
            String string3 = this.getAdderString();
            if (string3.trim().length() > 0) {
                string = string + ", " + string3;
            }
        }
        string = string + this.getModifierString();
        if (this.getEndUsage() > 0 && GenericObject.findObjectByID(HeroDesigner.getActiveHero().getPowers(), "ENDURANCERESERVE") != null && GenericObject.findObjectByID(this.getAllAssignedModifiers(), "ENDRESERVEOREND") == null && !HeroDesigner.getInstance().getPrefs().useWG()) {
            string = this.getUseENDReserve() ? string + " (uses END Reserve)" : string + " (uses Personal END)";
        }
        return string;
    }

    @Override
    public GenericDialog getDialog(boolean bl, boolean bl2) {
        Power.lastSenseEdit = System.currentTimeMillis();
        return new SenseDialog(this, bl, bl2);
    }

    public SenseGroup getGroup() {
        Cloneable cloneable;
        if (this.group == null) {
            cloneable = SenseGroup.getAllGroups();
            Iterator<SenseGroup> iterator = ((ArrayList)cloneable).iterator();
            while (iterator.hasNext()) {
                SenseGroup senseGroup = iterator.next();
                if (!senseGroup.getXMLID().equals(this.groupID)) continue;
                this.group = senseGroup;
                return this.group;
            }
        }
        if (this.group == null) {
            cloneable = new SenseGroup(new Element("SENSEGROUP"), false);
            ((GenericObject)cloneable).setDisplay("no Sense Group");
            ((GenericObject)cloneable).setAlias("no Sense Group");
            ((GenericObject)cloneable).setXMLID("NOGROUP");
            return cloneable;
        }
        return this.group;
    }

    @Override
    public Element getSaveXML() {
        Element element = super.getSaveXML();
        element.setAttribute("GROUP", this.getGroup().getXMLID());
        return element;
    }

    @Override
    public Adder getSelectedOption() {
        ArrayList<Adder> arrayList;
        Adder adder = super.getSelectedOption();
        if (adder == null && (arrayList = this.getOptions()).size() > 0) {
            adder = arrayList.get(0);
        }
        return adder;
    }

    @Override
    public double getTotalCost() {
        double d = super.getTotalCost();
        HeroDesigner.getInstance();
        if (HeroDesigner.getActiveTemplate().is6E() && this.getGroup() != null && this.getGroup().getSenseAdders() != null && this.getGroup().getSenseAdders().size() > 0) {
            if (this.senseAdders == null) {
                this.senseAdders = new ArrayList();
            }
            block0: for (String string : this.senseAdders) {
                if (!this.getGroup().getSenseAdders().contains(string)) continue;
                for (SenseAdder senseAdder : SenseAdder.getAllSenseAdders()) {
                    if (!senseAdder.getXMLID().equalsIgnoreCase(string) || senseAdder.senseCost < 0) continue;
                    d -= (double)senseAdder.senseCost;
                    continue block0;
                }
            }
        }
        return d;
    }

    protected ArrayList<String> getSenseAdders() {
        if (this.senseAdders == null) {
            this.senseAdders = new ArrayList();
        }
        ArrayList arrayList = (ArrayList)this.senseAdders.clone();
        for (Adder adder : this.assignedAdders) {
            if (arrayList.contains(adder.getXMLID())) continue;
            arrayList.add(adder.getXMLID());
        }
        return arrayList;
    }

    private ArrayList<String> getSenseModifiers() {
        if (this.senseModifiersLastCall > 0L && this.senseModifiersLastCall > GenericObject.lastEdit && HeroDesigner.lastEdit > 0L && this.senseModifiersLastCall > HeroDesigner.lastEdit && this.senseModifiersSaver != null) {
            return this.senseModifiersSaver;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        if (HeroDesigner.getActiveHero() != null) {
            ArrayList<Adder> arrayList2;
            Iterator<Adder> iterator;
            Power power;
            for (GenericObject genericObject : HeroDesigner.getActiveHero().getPowers()) {
                if (genericObject instanceof SenseAdder) {
                    power = (SenseAdder)genericObject;
                    if (!((SenseAdder)power).getSenses().contains(this.getXMLID()) || arrayList.contains(power.getXMLID())) continue;
                    if (this.getXMLID().equals("DETECT")) {
                        boolean bl = true;
                        if (((SenseAdder)power).getSelectedOption().getDisplay().equals(SenseAdder.getDetectDisplay((Detect)this))) {
                            bl = false;
                        }
                        ArrayList<Adder> arrayList3 = ((SenseAdder)power).getAssignedAdders();
                        iterator = arrayList3.iterator();
                        while (iterator.hasNext()) {
                            Adder adder = (Adder)iterator.next();
                            if (!adder.getDisplay().equals(SenseAdder.getDetectDisplay((Detect)this))) continue;
                            bl = false;
                            break;
                        }
                        if (bl) continue;
                    }
                    arrayList.add(power.getXMLID());
                    continue;
                }
                if (!(genericObject instanceof CompoundPower)) continue;
                power = (CompoundPower)genericObject;
                for (GenericObject genericObject2 : ((CompoundPower)power).getPowers()) {
                    if (!(genericObject2 instanceof SenseAdder) || !((SenseAdder)((Object)(iterator = (SenseAdder)genericObject2))).getSenses().contains(this.getXMLID()) || arrayList.contains(((GenericObject)((Object)iterator)).getXMLID())) continue;
                    if (this.getXMLID().equals("DETECT")) {
                        boolean bl = true;
                        if (((SenseAdder)((Object)iterator)).getSelectedOption().getDisplay().equals(SenseAdder.getDetectDisplay((Detect)this))) {
                            bl = false;
                        }
                        arrayList2 = ((SenseAdder)((Object)iterator)).getAssignedAdders();
                        for (Adder adder : arrayList2) {
                            if (!adder.getDisplay().equals(SenseAdder.getDetectDisplay((Detect)this))) continue;
                            bl = false;
                            break;
                        }
                        if (bl) continue;
                    }
                    arrayList.add(((GenericObject)((Object)iterator)).getXMLID());
                }
            }
            for (GenericObject genericObject : HeroDesigner.getActiveHero().getEquipment()) {
                if (genericObject instanceof SenseAdder) {
                    power = (SenseAdder)genericObject;
                    if (!((SenseAdder)power).getSenses().contains(this.getXMLID()) || arrayList.contains(power.getXMLID())) continue;
                    if (this.getXMLID().equals("DETECT")) {
                        boolean bl = true;
                        if (((SenseAdder)power).getSelectedOption().getDisplay().equals(SenseAdder.getDetectDisplay((Detect)this))) {
                            bl = false;
                        }
                        ArrayList<Adder> arrayList4 = ((SenseAdder)power).getAssignedAdders();
                        iterator = arrayList4.iterator();
                        while (iterator.hasNext()) {
                            Adder adder = iterator.next();
                            if (!adder.getDisplay().equals(SenseAdder.getDetectDisplay((Detect)this))) continue;
                            bl = false;
                            break;
                        }
                        if (bl) continue;
                    }
                    arrayList.add(power.getXMLID());
                    continue;
                }
                if (!(genericObject instanceof CompoundPower)) continue;
                power = (CompoundPower)genericObject;
                for (GenericObject genericObject3 : ((CompoundPower)power).getPowers()) {
                    if (!(genericObject3 instanceof SenseAdder) || !((SenseAdder)((Object)(iterator = (SenseAdder)genericObject3))).getSenses().contains(this.getXMLID()) || arrayList.contains(((GenericObject)((Object)iterator)).getXMLID())) continue;
                    if (this.getXMLID().equals("DETECT")) {
                        boolean bl = true;
                        if (((SenseAdder)((Object)iterator)).getSelectedOption().getDisplay().equals(SenseAdder.getDetectDisplay((Detect)this))) {
                            bl = false;
                        }
                        arrayList2 = ((SenseAdder)((Object)iterator)).getAssignedAdders();
                        for (Adder adder : arrayList2) {
                            if (!adder.getDisplay().equals(SenseAdder.getDetectDisplay((Detect)this))) continue;
                            bl = false;
                            break;
                        }
                        if (bl) continue;
                    }
                    arrayList.add(((GenericObject)((Object)iterator)).getXMLID());
                }
            }
        }
        this.senseModifiersSaver = arrayList;
        this.senseModifiersLastCall = System.currentTimeMillis();
        return arrayList;
    }

    @Override
    protected void init(Element element) {
        Object object2;
        super.init(element);
        this.allowAnyGroup = true;
        this.active = false;
        this.activeSelectable = false;
        this.allowSenseModifiers = true;
        String string = XMLUtility.getValue(element, "XMLID");
        if (string != null) {
            this.xmlID = string;
        }
        for (Object object2 : element.getChildren("PROVIDES")) {
            String string2 = ((Element)object2).getTextTrim().toUpperCase();
            if (this.senseAdders == null) {
                this.senseAdders = new ArrayList();
            }
            if (this.senseAdders.contains(string2)) continue;
            this.senseAdders.add(string2);
        }
        object2 = XMLUtility.getValue(element, "INCLUDED");
        if (object2 != null && ((String)object2).trim().toUpperCase().startsWith("Y") && this.xmlID != null && this.xmlID.trim().length() > 0) {
            builtInSenses.add(this);
        }
        if ((object2 = XMLUtility.getValue(element, "ACTIVE")) != null && ((String)object2).trim().toUpperCase().startsWith("Y")) {
            this.active = true;
        }
        if ((object2 = XMLUtility.getValue(element, "ALLOWSENSEMODIFIERS")) != null && ((String)object2).trim().toUpperCase().startsWith("N")) {
            this.allowSenseModifiers = false;
        }
        if ((object2 = XMLUtility.getValue(element, "ACTIVESELECT")) != null && ((String)object2).trim().toUpperCase().startsWith("Y")) {
            this.activeSelectable = true;
        }
        if ((object2 = XMLUtility.getValue(element, "ALLOWANYGROUP")) != null && ((String)object2).trim().toUpperCase().startsWith("N")) {
            this.allowAnyGroup = false;
        }
        this.groupID = (object2 = XMLUtility.getValue(element, "SENSEGROUP")) != null && ((String)object2).trim().length() > 0 ? object2 : "UNUSUALGROUP";
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean isActiveSelectable() {
        return this.activeSelectable;
    }

    @Override
    public void restoreFromSave(Element element) {
        String string = XMLUtility.getValue(element, "GROUP");
        if (string != null && string.trim().length() > 0) {
            this.group = null;
            this.groupID = string;
        }
        super.restoreFromSave(element);
        ArrayList arrayList = this.availableAdders;
        ArrayList arrayList2 = this.assignedAdders;
        this.assignedAdders = new ArrayList();
        this.availableAdders = new ArrayList();
        ArrayList<Adder> arrayList3 = this.getAvailableAdders();
        this.availableAdders = arrayList;
        ArrayList<Adder> arrayList4 = new ArrayList<Adder>();
        for (Adder adder : arrayList2) {
            for (Adder adder2 : arrayList3) {
                if (!adder.getXMLID().startsWith(adder2.getXMLID()) && !adder2.getXMLID().startsWith(adder.getXMLID()) || adder.getBaseCost() != adder2.getBaseCost()) continue;
                try {
                    Adder adder3 = adder;
                    adder = adder2.clone();
                    adder.setSelected(true);
                    adder.setAlias(adder3.getAlias());
                    adder.setLevels(adder3.getLevels());
                    adder.setSelectedOption(adder3.getSelectedOption());
                }
                catch (Exception exception) {}
                break;
            }
            arrayList4.add(adder);
        }
        this.assignedAdders = arrayList4;
        Power.lastSenseEdit = System.currentTimeMillis();
    }

    public void setActive(boolean bl) {
        if (this.activeSelectable) {
            this.active = bl;
        }
    }

    public void setGroup(SenseGroup senseGroup) {
        this.group = senseGroup;
        Power.lastSenseEdit = System.currentTimeMillis();
    }

    @Override
    public void setSelectedOption(Adder adder) {
        GenericObject.lastEdit = System.currentTimeMillis();
        super.setSelectedOption(adder);
        Power.lastSenseEdit = System.currentTimeMillis();
    }
}

