/*
 * Decompiled with CFR 0.152.
 */
package com.hero.objects.powers;

import com.hero.HeroDesigner;
import com.hero.objects.Adder;
import com.hero.objects.CharAffectingObject;
import com.hero.objects.GenericObject;
import com.hero.ui.dialog.GenericDialog;
import com.hero.ui.dialog.PowerDialog;
import com.hero.util.Rounder;
import com.hero.util.XMLUtility;
import org.jdom.Element;

public class Power
extends CharAffectingObject {
    public static long lastSenseEdit;
    protected boolean canAffectPrimary;
    protected int end;
    protected boolean resistantDefenses;
    protected boolean standardEffectAllowed;
    protected boolean useStandardEffect;

    public Power(Element element) {
        super(element);
    }

    public Power(Element element, String string) {
        super(element, string);
    }

    public boolean canAffectPrimary() {
        return this.canAffectPrimary;
    }

    public boolean checkFigured(GenericObject genericObject) {
        return true;
    }

    @Override
    public String getColumn2Output() {
        String string;
        String string2 = this.getAlias() + " " + this.getDamageDisplay();
        string2 = string2.trim();
        if (this.getName().trim().length() > 0) {
            string2 = "<i>" + this.getName() + ":</i>  " + string2;
        }
        if (this.getInput() != null && this.getInput().trim().length() > 0) {
            string2 = string2 + ":  " + this.getInput();
        }
        if (this.getSelectedOption() != null) {
            string2 = string2 + " (";
            string2 = string2 + this.getSelectedOption().getAlias();
            string2 = string2 + ")";
        }
        if ((string = this.getAdderString()).trim().length() > 0) {
            string2 = string2 + ", " + string;
        }
        string2 = string2 + this.getModifierString();
        if (this.getEndUsage() > 0 && GenericObject.findObjectByID(HeroDesigner.getActiveHero().getPowers(), "ENDURANCERESERVE") != null && GenericObject.findObjectByID(this.getAllAssignedModifiers(), "ENDRESERVEOREND") == null && !HeroDesigner.getInstance().getPrefs().useWG()) {
            string2 = this.getUseENDReserve() ? string2 + " (uses END Reserve)" : string2 + " (uses Personal END)";
        }
        return string2;
    }

    @Override
    public String getColumn3Output() {
        if (this.getEndUsage() > 0) {
            return "" + this.getEndUsage();
        }
        if (GenericObject.findObjectByID(this.getAssignedModifiers(), "CHARGES") == null) {
            return "0";
        }
        GenericObject genericObject = GenericObject.findObjectByID(this.getAssignedModifiers(), "CHARGES");
        String string = genericObject.getSelectedOption().getAlias();
        if (GenericObject.findObjectByID(genericObject.getAssignedAdders(), "BOOSTABLE") != null) {
            return "[" + string + " bc]";
        }
        if (GenericObject.findObjectByID(genericObject.getAssignedAdders(), "RECOVERABLE") != null) {
            return "[" + string + " rc]";
        }
        if (GenericObject.findObjectByID(genericObject.getAssignedAdders(), "CONTINUING") != null) {
            return "[" + string + " cc]";
        }
        if (GenericObject.findObjectByID(genericObject.getAssignedAdders(), "NEVERRECOVER") != null) {
            return "[" + string + " nr]";
        }
        return "[" + string + "]";
    }

    public String getDamageDisplay() {
        if (this.display.toUpperCase().indexOf("[LVL]") >= 0) {
            return "";
        }
        if (this.getLevelValue() == 0.0 || this.getLevelCost() == 0.0) {
            return "";
        }
        String string = "" + this.getLevels() + "d6";
        int n = 0;
        for (Adder adder : this.getAssignedAdders()) {
            if (adder.getXMLID().equals("PLUSONEPIP")) {
                adder.setDisplayInString(false);
                string = this.getLevels() > 0 ? this.getLevels() + "d6+1" : "1 point";
                ++n;
            }
            if (adder.getXMLID().equals("PLUSONEHALFDIE")) {
                adder.setDisplayInString(false);
                string = this.getLevels() + " 1/2d6";
                ++n;
            }
            if (!adder.getXMLID().equals("MINUSONEPIP")) continue;
            adder.setDisplayInString(false);
            string = "" + (this.getLevels() + 1);
            string = this.getLevels() + 1 + "d6-1";
            ++n;
        }
        if (this.useStandardEffect()) {
            string = string + " (standard effect: " + (this.getLevels() * 3 + n) + " point" + (this.getLevels() > 0 ? "s" : "") + ")";
        }
        return string;
    }

    @Override
    public GenericDialog getDialog(boolean bl, boolean bl2) {
        return new PowerDialog(this, bl, bl2);
    }

    public int getMdLevels() {
        if (this.getMDIncreaseLevels() != 0) {
            return (int)Rounder.roundHalfUp((double)(this.getLevels() / this.getMDIncreaseLevels()) * this.getMDIncrease());
        }
        return 0;
    }

    @Override
    public Element getSaveXML() {
        Element element = this.getGeneralSaveXML();
        element.setName("POWER");
        if (this.standardEffectAllowed) {
            element.setAttribute("USESTANDARDEFFECT", this.useStandardEffect ? "Yes" : "No");
        }
        element.setAttribute("QUANTITY", this.getQuantity() + "");
        element.setAttribute("AFFECTS_PRIMARY", this.getAffectPrimary() ? "Yes" : "No");
        element.setAttribute("AFFECTS_TOTAL", this.getAffectTotal() ? "Yes" : "No");
        return element;
    }

    @Override
    protected void init(Element element) {
        this.duration = "INSTANT";
        this.end = 0;
        this.canAffectPrimary = true;
        this.resistantDefenses = false;
        this.standardEffectAllowed = false;
        this.quantity = 1;
        super.init(element);
        this.affectsPrimary = false;
        this.exclusive = false;
        String string = XMLUtility.getValue(element, "EXCLUSIVE");
        if (string != null && string.trim().toUpperCase().startsWith("Y")) {
            this.exclusive = true;
        }
        if ((string = XMLUtility.getValue(element, "STANDARDEFFECTALLOWED")) != null && string.trim().toUpperCase().startsWith("Y")) {
            this.standardEffectAllowed = true;
        }
    }

    public boolean isSummable() {
        return this.affectsCharacteristics();
    }

    public boolean resistantDefenses() {
        if (Power.findObjectByID(this.getAssignedModifiers(), "RESISTANT") != null) {
            return true;
        }
        return this.resistantDefenses;
    }

    @Override
    public void restoreFromSave(Element element) {
        super.restoreFromSave(element);
        String string = XMLUtility.getValue(element, "AFFECTS_PRIMARY");
        if (string != null && string.trim().length() > 0) {
            this.affectsPrimary = string.trim().toUpperCase().startsWith("Y");
        }
        if ((string = XMLUtility.getValue(element, "AFFECTS_TOTAL")) != null && string.trim().length() > 0) {
            this.affectsTotal = string.trim().toUpperCase().startsWith("Y");
        }
        if ((string = XMLUtility.getValue(element, "USESTANDARDEFFECT")) != null && string.trim().length() > 0) {
            this.useStandardEffect = string.trim().toUpperCase().startsWith("Y");
        }
        if ((string = XMLUtility.getValue(element, "QUANTITY")) != null && string.trim().length() > 0) {
            try {
                this.quantity = Integer.parseInt(string);
            }
            catch (Exception exception) {
                this.quantity = 1;
            }
        } else {
            this.quantity = 1;
        }
    }

    public void setResistantDefenses(boolean bl) {
        this.resistantDefenses = bl;
    }

    public void setUseStandardEffect(boolean bl) {
        this.useStandardEffect = bl;
    }

    public boolean standardEffectAllowed() {
        return this.standardEffectAllowed;
    }

    public boolean useStandardEffect() {
        if (!this.standardEffectAllowed) {
            return false;
        }
        if (HeroDesigner.getActiveHero() != null && !HeroDesigner.getActiveHero().getRules().isStandardEffectAllowed()) {
            return false;
        }
        return this.useStandardEffect;
    }
}

