/*
 * Decompiled with CFR 0.152.
 */
package com.hero.objects.powers;

import com.hero.HeroDesigner;
import com.hero.objects.GenericObject;
import com.hero.objects.powers.Power;
import com.hero.ui.dialog.GenericDialog;
import com.hero.ui.dialog.MultiformDialog;
import com.hero.util.XMLUtility;
import java.io.File;
import java.text.NumberFormat;
import java.util.Date;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;

public class Multiform
extends Power {
    private static String xmlID = "MULTIFORM";
    private String filePath;
    private Date fileAssociationLastCheck;

    public Multiform(Element element) {
        super(element, xmlID);
    }

    private void checkFileAssociation() {
        if (this.filePath == null) {
            return;
        }
        File file = new File(this.filePath);
        if (!file.exists()) {
            file = new File(HeroDesigner.getInstance().getPrefs().getSaveDir() + File.separator + file.getName());
        }
        if (!file.exists()) {
            return;
        }
        if (file.lastModified() > this.fileAssociationLastCheck.getTime()) {
            this.setFilePath(this.filePath);
        }
    }

    public void clearFilePath() {
        this.filePath = null;
        this.fileAssociationLastCheck = null;
    }

    @Override
    public String getColumn2Output() {
        String string = this.getAlias() + " (" + this.getDamageDisplay() + ")";
        if (this.getName().trim().length() > 0) {
            string = "<i>" + this.getName() + ":</i>  " + string;
        }
        if (this.getInput() != null && this.getInput().trim().length() > 0) {
            string = string + ":  " + this.getInput();
        }
        if (this.getSelectedOption() != null) {
            string = string + " (";
            string = string + this.getSelectedOption().getAlias();
            String string2 = this.getAdderString();
            if (string2.trim().length() > 0) {
                string = string + "; " + string2;
            }
            string = string + ")";
        } else {
            String string3 = this.getAdderString();
            if (string3.trim().length() > 0) {
                string = string + " (" + string3 + ")";
            }
        }
        string = string + this.getModifierString();
        if (this.getEndUsage() > 0 && GenericObject.findObjectByID(HeroDesigner.getActiveHero().getPowers(), "ENDURANCERESERVE") != null && GenericObject.findObjectByID(this.getAllAssignedModifiers(), "ENDRESERVEOREND") == null && !HeroDesigner.getInstance().getPrefs().useWG()) {
            string = this.getUseENDReserve() ? string + " (uses END Reserve)" : string + " (uses Personal END)";
        }
        return string;
    }

    @Override
    public String getDamageDisplay() {
        return NumberFormat.getIntegerInstance().format(this.getLevels()) + " Character Points in the most expensive form";
    }

    @Override
    public GenericDialog getDialog(boolean bl, boolean bl2) {
        return new MultiformDialog(this, bl);
    }

    @Override
    public int getEndUsage() {
        if (GenericObject.findObjectByID(this.getAssignedModifiers(), "COSTSENDTOCHANGE") != null) {
            boolean bl = this.usesEND;
            this.usesEND = true;
            int n = super.getEndUsage();
            this.usesEND = bl;
            return n;
        }
        if (GenericObject.findObjectByID(this.getAssignedModifiers(), "COSTSEND") != null) {
            boolean bl = this.usesEND;
            this.usesEND = true;
            int n = super.getEndUsage();
            this.usesEND = bl;
            return n;
        }
        return super.getEndUsage();
    }

    public String getFilePath() {
        return this.filePath;
    }

    @Override
    public int getLevels() {
        this.checkFileAssociation();
        return super.getLevels();
    }

    @Override
    public Element getSaveXML() {
        Element element = super.getSaveXML();
        if (this.filePath != null) {
            element.setAttribute("FILE_ASSOCIATION", this.filePath);
        }
        return element;
    }

    @Override
    public void restoreFromSave(Element element) {
        super.restoreFromSave(element);
        String string = XMLUtility.getValue(element, "FILE_ASSOCIATION");
        if (string != null && string.trim().length() > 0) {
            this.setFilePath(string);
        }
    }

    public void setFilePath(String string) {
        File file = new File(string);
        if (!file.exists()) {
            file = new File(HeroDesigner.getInstance().getPrefs().getSaveDir() + File.separator + file.getName());
        }
        if (file.exists() && file.canRead()) {
            try {
                SAXBuilder sAXBuilder = new SAXBuilder(false);
                Document document = sAXBuilder.build(file);
                sAXBuilder = null;
                Element element = document.getRootElement();
                Element element2 = element.getChild("BASIC_CONFIGURATION");
                String string2 = XMLUtility.getValue(element2, "BASE_POINTS");
                if (string2 != null && string2.trim().length() > 0) {
                    try {
                        this.levels = Integer.parseInt(string2);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((string2 = XMLUtility.getValue(element2, "DISAD_POINTS")) != null && string2.trim().length() > 0 && !HeroDesigner.getActiveTemplate().is6E()) {
                    try {
                        this.levels += Integer.parseInt(string2);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((string2 = XMLUtility.getValue(element2, "EXPERIENCE")) != null && string2.trim().length() > 0) {
                    try {
                        this.levels += Integer.parseInt(string2);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.filePath = string;
                this.fileAssociationLastCheck = new Date();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

