/*
 * Decompiled with CFR 0.152.
 */
package com.hero.objects.powers;

import com.hero.HeroDesigner;
import com.hero.objects.ElementalControl;
import com.hero.objects.GenericObject;
import com.hero.objects.Multipower;
import com.hero.objects.characteristics.Characteristic;
import com.hero.objects.modifiers.Modifier;
import com.hero.objects.powers.CompoundPower;
import com.hero.objects.powers.ForceField;
import com.hero.objects.powers.Power;
import com.hero.util.Rounder;
import java.util.ArrayList;
import org.jdom.Element;

public class MentalDefense
extends Power {
    private static String xmlID = "MENTALDEFENSE";

    public MentalDefense(Element element) {
        super(element, xmlID);
    }

    @Override
    public double getActiveCost() {
        double d = this.getTotalCost();
        Characteristic characteristic = HeroDesigner.getActiveHero().getCharacteristic(6);
        int n = 0;
        if (characteristic != null && this.getLevels() > 0) {
            n += (int)Rounder.roundHalfUp(characteristic.getSecondaryValue() / 5.0);
        }
        if (!HeroDesigner.getActiveTemplate().is6E()) {
            d += (double)n * this.getLevelCost() / this.getLevelValue();
        }
        double d2 = 0.0;
        boolean bl = false;
        for (int i = 0; i < this.assignedModifiers.size(); ++i) {
            Modifier modifier = (Modifier)this.assignedModifiers.get(i);
            if (!(modifier.getTotalValue() > 0.0)) continue;
            d2 += modifier.getTotalValue();
            bl = true;
        }
        if (this.getParentList() != null) {
            ArrayList<Modifier> arrayList = this.getParentList().getAssignedModifiers();
            for (Modifier modifier : arrayList) {
                if (modifier.getTypes().contains("VPP") || modifier.getXMLID().equals("CHARGES") && this.getParentList() instanceof Multipower || !(modifier.getTotalValue() > 0.0) || GenericObject.findObjectByID(this.assignedModifiers, modifier.getXMLID()) != null && !modifier.getXMLID().equals("GENERIC_OBJECT") && !modifier.getXMLID().equals("CUSTOM_MODIFIER") || this.getParentList() instanceof Multipower || this.getParentList() instanceof ElementalControl) continue;
                d2 += modifier.getTotalValue();
                bl = true;
            }
        }
        double d3 = d * (1.0 + d2);
        if (!HeroDesigner.getActiveTemplate().is6E()) {
            d3 -= (double)n * this.getLevelCost() / this.getLevelValue();
        }
        if (bl) {
            d3 = Rounder.roundHalfDown(d3);
        }
        return d3;
    }

    @Override
    public double getActiveCost(String string) {
        double d = this.getTotalCost();
        Characteristic characteristic = HeroDesigner.getActiveHero().getCharacteristic(6);
        int n = 0;
        if (characteristic != null && this.getLevels() > 0) {
            n += (int)Rounder.roundHalfUp(characteristic.getSecondaryValue() / 5.0);
        }
        if (!HeroDesigner.getActiveTemplate().is6E()) {
            d += (double)n * this.getLevelCost() / this.getLevelValue();
        }
        double d2 = 0.0;
        boolean bl = false;
        for (Object object : this.assignedModifiers) {
            if (!(((Modifier)object).getTotalValue() > 0.0) || ((GenericObject)object).getXMLID().equals(string)) continue;
            d2 += ((Modifier)object).getTotalValue();
            bl = true;
        }
        if (this.getParentList() != null) {
            Object object;
            ArrayList<Modifier> arrayList = this.getParentList().getAssignedModifiers();
            object = arrayList.iterator();
            while (object.hasNext()) {
                Modifier modifier = (Modifier)object.next();
                if (modifier.getTypes().contains("VPP") || modifier.getXMLID().equals("CHARGES") && this.getParentList() instanceof Multipower || !(modifier.getTotalValue() > 0.0) || modifier.getXMLID().equals(string) || GenericObject.findObjectByID(this.assignedModifiers, modifier.getXMLID()) != null && !modifier.getXMLID().equals("GENERIC_OBJECT") && !modifier.getXMLID().equals("CUSTOM_MODIFIER") || this.getParentList() instanceof Multipower || this.getParentList() instanceof ElementalControl) continue;
                d2 += modifier.getTotalValue();
                bl = true;
            }
        }
        double d3 = d * (1.0 + d2);
        if (!HeroDesigner.getActiveTemplate().is6E()) {
            d3 -= (double)n * this.getLevelCost() / this.getLevelValue();
        }
        if (bl) {
            d3 = Rounder.roundHalfDown(d3);
        }
        return d3;
    }

    @Override
    public String getColumn2Output() {
        Object object;
        String string = this.getAlias() + " (" + this.getDamageDisplay() + ")";
        boolean bl = false;
        if (this.isEquipment()) {
            for (GenericObject genericObject : HeroDesigner.getActiveHero().getEquipment()) {
                if (!(genericObject instanceof MentalDefense)) continue;
                MentalDefense mentalDefense = (MentalDefense)genericObject;
                if (mentalDefense.getID() != this.getID()) break;
                bl = true;
                break;
            }
        } else {
            for (GenericObject genericObject : HeroDesigner.getActiveHero().getPowers()) {
                if (!(genericObject instanceof MentalDefense)) continue;
                MentalDefense mentalDefense = (MentalDefense)genericObject;
                if (mentalDefense.getID() != this.getID()) break;
                bl = true;
                break;
            }
        }
        if (!bl) {
            string = "+" + this.getLevels() + " " + string;
        }
        if (this.getName().trim().length() > 0) {
            string = "<i>" + this.getName() + ":</i>  " + string;
        }
        if (this.getInput() != null && this.getInput().trim().length() > 0) {
            string = string + ":  " + this.getInput();
        }
        if (this.getSelectedOption() != null) {
            string = string + " (";
            string = string + this.getSelectedOption().getAlias();
            object = this.getAdderString();
            if (((String)object).trim().length() > 0) {
                string = string + "; " + (String)object;
            }
            string = string + ")";
        } else {
            object = this.getAdderString();
            if (((String)object).trim().length() > 0) {
                string = string + " (" + (String)object + ")";
            }
        }
        string = string + this.getModifierString();
        if (this.getEndUsage() > 0 && GenericObject.findObjectByID(HeroDesigner.getActiveHero().getPowers(), "ENDURANCERESERVE") != null && GenericObject.findObjectByID(this.getAllAssignedModifiers(), "ENDRESERVEOREND") == null && !HeroDesigner.getInstance().getPrefs().useWG()) {
            string = this.getUseENDReserve() ? string + " (uses END Reserve)" : string + " (uses Personal END)";
        }
        return string;
    }

    @Override
    public String getDamageDisplay() {
        int n;
        if (HeroDesigner.getActiveTemplate().is6E()) {
            int n2;
            int n3 = n2 = this.getMdLevels();
            if (n2 != n3) {
                return n2 + "/" + n3 + " points total";
            }
            return n2 + " points total";
        }
        Characteristic characteristic = HeroDesigner.getActiveHero().getCharacteristic(6);
        int n4 = n = this.getMdLevels();
        if (characteristic != null && n > 0) {
            n += (int)Rounder.roundHalfUp(characteristic.getPrimaryValue() / 5.0);
            n4 += (int)Rounder.roundHalfUp(characteristic.getSecondaryValue() / 5.0);
        }
        if (n != n4) {
            return n + "/" + n4 + " points total";
        }
        return n + " points total";
    }

    @Override
    public int getMdLevels() {
        Power power;
        Power power2;
        int n = this.getLevels();
        for (GenericObject genericObject : HeroDesigner.getActiveHero().getPowers()) {
            if (genericObject instanceof MentalDefense) {
                power2 = (MentalDefense)genericObject;
                if (power2.getID() == this.getID()) continue;
                n += power2.getLevels();
                continue;
            }
            if (genericObject instanceof ForceField) {
                power2 = (ForceField)genericObject;
                n += ((ForceField)power2).getMdLevels();
                continue;
            }
            if (!(genericObject instanceof CompoundPower)) continue;
            power2 = (CompoundPower)genericObject;
            for (GenericObject genericObject2 : ((CompoundPower)power2).getPowers()) {
                if (genericObject2 instanceof MentalDefense) {
                    power = (MentalDefense)genericObject2;
                    if (power.getID() == this.getID()) continue;
                    n += power.getLevels();
                    continue;
                }
                if (!(genericObject2 instanceof ForceField)) continue;
                power = (ForceField)genericObject2;
                n += ((ForceField)power).getMdLevels();
            }
        }
        for (GenericObject genericObject : HeroDesigner.getActiveHero().getEquipment()) {
            if (genericObject instanceof MentalDefense) {
                power2 = (MentalDefense)genericObject;
                if (power2.getID() == this.getID()) continue;
                n += power2.getLevels();
                continue;
            }
            if (genericObject instanceof ForceField) {
                power2 = (ForceField)genericObject;
                n += ((ForceField)power2).getMdLevels();
                continue;
            }
            if (!(genericObject instanceof CompoundPower)) continue;
            power2 = (CompoundPower)genericObject;
            for (GenericObject genericObject2 : ((CompoundPower)power2).getPowers()) {
                if (genericObject2 instanceof MentalDefense) {
                    power = (MentalDefense)genericObject2;
                    if (power.getID() == this.getID()) continue;
                    n += power.getLevels();
                    continue;
                }
                if (!(genericObject2 instanceof ForceField)) continue;
                power = (ForceField)genericObject2;
                n += ((ForceField)power).getMdLevels();
            }
        }
        return n;
    }
}

