/*
 * Decompiled with CFR 0.152.
 */
package com.hero.objects.powers;

import com.hero.HeroDesigner;
import com.hero.objects.Adder;
import com.hero.objects.GenericObject;
import com.hero.objects.powers.Power;
import com.hero.util.Rounder;
import java.util.ArrayList;
import java.util.Collections;
import org.jdom.Element;

public class LifeSupport
extends Power {
    private static String xmlID = "LIFESUPPORT";

    public LifeSupport(Element element) {
        super(element, xmlID);
    }

    @Override
    public String getColumn2Output() {
        String string = this.getAlias() + " " + this.getDamageDisplay();
        if (this.getName().trim().length() > 0) {
            string = "<i>" + this.getName() + ":</i>  " + string;
        }
        if (this.getInput() != null && this.getInput().trim().length() > 0) {
            string = string + ":  " + this.getInput();
        }
        if (this.getSelectedOption() != null) {
            string = string + " (";
            string = string + this.getSelectedOption().getAlias();
            string = string + ")";
        }
        ArrayList<Adder> arrayList = this.getAssignedAdders();
        Collections.sort(arrayList);
        String string2 = "";
        for (Adder adder : this.getAssignedAdders()) {
            if (!adder.displayInString() || !adder.isSelected() || adder.getColumn2Output().trim().length() <= 0) continue;
            if (string2.trim().length() > 0) {
                string2 = string2 + "; ";
            }
            string2 = string2 + adder.getColumn2Output();
        }
        if (string2.trim().length() > 0) {
            string = string + " (" + string2 + ")";
        }
        string = string + this.getModifierString();
        if (this.getEndUsage() > 0 && GenericObject.findObjectByID(HeroDesigner.getActiveHero().getPowers(), "ENDURANCERESERVE") != null && GenericObject.findObjectByID(this.getAllAssignedModifiers(), "ENDRESERVEOREND") == null && !HeroDesigner.getInstance().getPrefs().useWG()) {
            string = this.getUseENDReserve() ? string + " (uses END Reserve)" : string + " (uses Personal END)";
        }
        return string;
    }

    @Override
    public String getDamageDisplay() {
        return "";
    }

    @Override
    public void restoreFromSave(Element element) {
        super.restoreFromSave(element);
        for (Adder adder : this.getAssignedAdders()) {
            if (!adder.getXMLID().equals("EXTENDEDBREATHING") || !(adder.getBaseCost() > 0.0)) continue;
            String string = "" + Rounder.roundDown(adder.getBaseCost());
            adder.setLevels(0);
            for (int i = 0; i < adder.getOptions().size(); ++i) {
                Adder adder2 = adder.getOptions().get(i);
                if (!adder2.getXMLID().equals(string)) continue;
                adder.setSelectedOption(adder2);
            }
        }
    }
}

