/*
 * Decompiled with CFR 0.152.
 */
package com.hero.objects.powers;

import com.hero.HeroDesigner;
import com.hero.objects.Adder;
import com.hero.objects.GenericObject;
import com.hero.objects.modifiers.Modifier;
import com.hero.objects.powers.Power;
import org.jdom.Element;

public class KillingAttackRanged
extends Power {
    private static String xmlID = "RKA";

    public KillingAttackRanged(Element element) {
        super(element, xmlID);
    }

    @Override
    public String getColumn2Output() {
        String string = this.getAlias() + " " + this.getDamageDisplay();
        if (this.getName().trim().length() > 0) {
            string = "<i>" + this.getName() + ":</i>  " + string;
        }
        if (this.getInput() != null && this.getInput().trim().length() > 0 && !HeroDesigner.getInstance().getPrefs().useWG()) {
            string = string + " (vs. " + this.getInput() + ")";
        }
        if (this.getSelectedOption() != null) {
            string = string + " (";
            string = string + this.getSelectedOption().getAlias();
            String string2 = this.getAdderString();
            if (string2.trim().length() > 0) {
                string = string + "; " + string2;
            }
            string = string + ")";
        } else {
            String string3 = this.getAdderString();
            if (string3.trim().length() > 0) {
                string = string + " (" + string3 + ")";
            }
        }
        string = string + this.getModifierString();
        if (this.getEndUsage() > 0 && GenericObject.findObjectByID(HeroDesigner.getActiveHero().getPowers(), "ENDURANCERESERVE") != null && GenericObject.findObjectByID(this.getAllAssignedModifiers(), "ENDRESERVEOREND") == null && !HeroDesigner.getInstance().getPrefs().useWG()) {
            string = this.getUseENDReserve() ? string + " (uses END Reserve)" : string + " (uses Personal END)";
        }
        return string;
    }

    @Override
    public String getDamageDisplay() {
        Object object;
        String string = "";
        int n = this.getLevels() * 3;
        int n2 = this.getLevels() * 3;
        int n3 = 0;
        int n4 = 2;
        int n5 = 0;
        if (GenericObject.findObjectByID(this.getAllAssignedModifiers(), "INCREASEDSTUNMULTIPLIER") != null) {
            object = (Modifier)GenericObject.findObjectByID(this.getAllAssignedModifiers(), "INCREASEDSTUNMULTIPLIER");
            n4 += ((GenericObject)object).getLevels();
        }
        if (GenericObject.findObjectByID(this.getAllAssignedModifiers(), "DECREASEDSTUNMULTIPLIER") != null) {
            object = (Modifier)GenericObject.findObjectByID(this.getAllAssignedModifiers(), "DECREASEDSTUNMULTIPLIER");
            n4 -= ((GenericObject)object).getLevels();
        }
        for (Adder adder : this.getAssignedAdders()) {
            if (adder.getXMLID().equals("PLUSONEPIP")) {
                adder.setDisplayInString(false);
                ++n;
                ++n2;
            }
            if (adder.getXMLID().equals("PLUSONEHALFDIE")) {
                adder.setDisplayInString(false);
                n += 2;
                n2 += 2;
                --n5;
            }
            if (!adder.getXMLID().equals("MINUSONEPIP")) continue;
            adder.setDisplayInString(false);
            n += 3;
            n2 += 3;
            n3 = 1;
            n5 -= 2;
        }
        int n6 = n / 3;
        int n7 = n % 3;
        if (n6 != 0) {
            string = string + n6;
        }
        string = n7 == 1 ? (n6 > 0 ? string + "d6+1" : "1 point") : (n7 == 2 ? string + " 1/2d6" : string + "d6");
        string = string.trim();
        if (n3 != 0) {
            string = string + "-" + n3;
        }
        if (n != n2) {
            string = string + " / ";
            n6 = n2 / 3;
            n7 = n2 % 3;
            string = string + n6;
            string = n7 == 1 ? string + "d6+1" : (n7 == 2 ? string + " 1/2d6" : string + "d6");
            if (n3 != 0) {
                string = string + "-" + n3;
            }
        }
        n += n5;
        n2 += n5;
        if (this.useStandardEffect()) {
            if (this.doesBODY()) {
                string = string + " (standard effect: " + n;
                if (n != n2) {
                    string = string + " / " + n2;
                }
                string = string + " BODY, " + n * n4;
                if (n != n2) {
                    string = string + " / " + n2 * n4;
                }
                string = string + " STUN)";
            } else {
                string = string + " (standard effect: " + n * n4;
                if (n != n2) {
                    string = string + " / " + n2 * n4;
                }
                string = string + " STUN)";
            }
        }
        return string;
    }
}

