/*
 * Decompiled with CFR 0.152.
 */
package com.hero.objects.powers;

import com.hero.HeroDesigner;
import com.hero.objects.Adder;
import com.hero.objects.GenericObject;
import com.hero.objects.characteristics.Characteristic;
import com.hero.objects.modifiers.Modifier;
import com.hero.objects.powers.Power;
import com.hero.util.Rounder;
import org.jdom.Element;

public class KillingAttackHTH
extends Power {
    private static String xmlID = "HKA";

    public KillingAttackHTH(Element element) {
        super(element, xmlID);
    }

    @Override
    public String getColumn2Output() {
        String string = this.getAlias() + " " + this.getDamageDisplay();
        if (this.getName().trim().length() > 0) {
            string = "<i>" + this.getName() + ":</i>  " + string;
        }
        if (this.getInput() != null && this.getInput().trim().length() > 0 && !HeroDesigner.getInstance().getPrefs().useWG()) {
            string = string + " (vs. " + this.getInput() + ")";
        }
        if (this.getSelectedOption() != null) {
            string = string + " (";
            string = string + this.getSelectedOption().getAlias();
            String string2 = this.getAdderString();
            if (string2.trim().length() > 0) {
                string = string + "; " + string2;
            }
            string = string + ")";
        } else {
            String string3 = this.getAdderString();
            if (string3.trim().length() > 0) {
                string = string + " (" + string3 + ")";
            }
        }
        string = string + this.getModifierString();
        if (this.getEndUsage() > 0 && GenericObject.findObjectByID(HeroDesigner.getActiveHero().getPowers(), "ENDURANCERESERVE") != null && GenericObject.findObjectByID(this.getAllAssignedModifiers(), "ENDRESERVEOREND") == null && !HeroDesigner.getInstance().getPrefs().useWG()) {
            string = this.getUseENDReserve() ? string + " (uses END Reserve)" : string + " (uses Personal END)";
        }
        return string;
    }

    @Override
    public String getDamageDisplay() {
        boolean bl;
        Object object;
        int n;
        String string = "";
        int n2 = n = this.getLevels() * 3;
        int n3 = n;
        int n4 = 0;
        int n5 = 2;
        int n6 = 0;
        if (GenericObject.findObjectByID(this.getAllAssignedModifiers(), "INCREASEDSTUNMULTIPLIER") != null) {
            object = (Modifier)GenericObject.findObjectByID(this.getAllAssignedModifiers(), "INCREASEDSTUNMULTIPLIER");
            n5 += ((GenericObject)object).getLevels();
        }
        if (GenericObject.findObjectByID(this.getAllAssignedModifiers(), "DECREASEDSTUNMULTIPLIER") != null) {
            object = (Modifier)GenericObject.findObjectByID(this.getAllAssignedModifiers(), "DECREASEDSTUNMULTIPLIER");
            n5 -= ((GenericObject)object).getLevels();
        }
        for (Adder adder : this.getAssignedAdders()) {
            if (adder.getXMLID().equals("PLUSONEPIP")) {
                adder.setDisplayInString(false);
                ++n;
            }
            if (adder.getXMLID().equals("PLUSONEHALFDIE")) {
                adder.setDisplayInString(false);
                n += 2;
                --n6;
            }
            if (!adder.getXMLID().equals("MINUSONEPIP")) continue;
            adder.setDisplayInString(false);
            n += 3;
            n4 = 1;
            n6 -= 2;
        }
        n2 = n - n4;
        int n7 = n + n6;
        n3 = n - n4;
        int n8 = n + n6;
        int n9 = 0;
        boolean bl2 = bl = GenericObject.findObjectByID(this.getAllAssignedModifiers(), "NOSTRBONUS") != null;
        if (GenericObject.findObjectByID(this.getAllAssignedModifiers(), "STRMINIMUM") != null) {
            Modifier modifier = (Modifier)GenericObject.findObjectByID(this.getAllAssignedModifiers(), "STRMINIMUM");
            if (GenericObject.findObjectByID(modifier.getAssignedAdders(), "CANNOTADD") != null) {
                bl = true;
            } else if (modifier.getSelectedOption() != null) {
                try {
                    n9 = Integer.parseInt(modifier.getSelectedOption().getAlias());
                }
                catch (Exception exception) {
                    bl = true;
                }
            } else {
                bl = true;
            }
        }
        if (!bl) {
            double d = 1.0;
            for (Modifier modifier : this.getAllAssignedModifiers()) {
                if (!(modifier.getTotalValue() > 0.0) || modifier.getXMLID().equals("REDUCEDEND")) continue;
                d += modifier.getTotalValue();
            }
            double d2 = 5.0 * d;
            Characteristic characteristic = HeroDesigner.getActiveHero().getCharacteristic(1);
            if (characteristic != null) {
                double d3;
                double d4 = characteristic.getPrimaryValue() - (double)n9;
                if (d4 < 0.0) {
                    d4 = 0.0;
                }
                if ((d3 = characteristic.getSecondaryValue() - (double)n9) < 0.0) {
                    d3 = 0.0;
                }
                n2 = d4 / d2 < (double)(n - n4) || HeroDesigner.getActiveTemplate().is6E() ? (int)((long)n2 + Rounder.roundDown(d4 / d2)) : (n - n4) * 2;
                n7 = d4 / d2 < (double)n7 || HeroDesigner.getActiveTemplate().is6E() ? (int)((double)n7 + d4 / d2) : (n7 *= 2);
                n3 = d3 / d2 < (double)(n - n4) || HeroDesigner.getActiveTemplate().is6E() ? (int)((double)n3 + d3 / d2) : (n - n4) * 2;
                n8 = d3 / d2 < (double)n8 || HeroDesigner.getActiveTemplate().is6E() ? (int)((double)n8 + d3 / d2) : (n8 *= 2);
            }
        }
        int n10 = n / 3;
        int n11 = n % 3;
        if (n10 != 0) {
            string = string + n10;
        }
        string = n11 == 1 ? (n10 > 0 ? string + "d6+1" : string + "1 point") : (n11 == 2 ? string + " 1/2d6" : string + "d6");
        string = string.trim();
        if (n4 != 0) {
            string = string + "-" + n4;
        }
        if (n2 != n - n4 || n2 != n3 && n3 != n - n4) {
            string = string + " (";
            n10 = n2 / 3;
            n11 = n2 % 3;
            string = n11 == 1 ? string + (n10 != 0 ? "" + n10 : "") + "d6+1" : (n11 == 2 ? (n4 == 0 ? string + (n10 != 0 ? n10 + " " : "") + "1/2d6" : string + (n10 != 0 ? "" + (n10 + 1) : "") + "d6 - 1") : string + (n10 != 0 ? "" + n10 : "") + "d6");
            if (n2 != n3) {
                string = string + " / ";
                n10 = n3 / 3;
                n11 = n3 % 3;
                string = n11 == 1 ? string + (n10 != 0 ? "" + n10 : "") + "d6+1" : (n11 == 2 ? (n4 == 0 ? string + (n10 != 0 ? n10 + " " : "") + "1/2d6" : string + (n10 != 0 ? "" + (n10 + 1) : "") + "d6-1") : string + (n10 != 0 ? "" + n10 : "") + "d6");
            }
            string = string + " w/STR)";
        }
        if (this.useStandardEffect()) {
            if (this.doesBODY()) {
                string = string + " (standard effect: " + n7;
                if (n7 != n8) {
                    string = string + " / " + n8;
                }
                string = string + " BODY, " + n7 * n5;
                if (n7 != n8) {
                    string = string + " / " + n8 * n5;
                }
                string = string + " STUN)";
            } else {
                string = string + " (standard effect: " + n7 * n5;
                if (n7 != n8) {
                    string = string + " / " + n8 * n5;
                }
                string = string + " STUN)";
            }
        }
        return string;
    }
}

