/*
 * Decompiled with CFR 0.152.
 */
package com.hero.objects.powers;

import com.hero.HeroDesigner;
import com.hero.objects.Adder;
import com.hero.objects.GenericObject;
import com.hero.objects.modifiers.Modifier;
import com.hero.objects.powers.Power;
import java.util.ArrayList;
import org.jdom.Element;

public class HandToHandAttack
extends Power {
    private static String xmlID = "HANDTOHANDATTACK";

    public HandToHandAttack(Element element) {
        super(element, xmlID);
    }

    @Override
    public ArrayList<Modifier> getAssignedModifiers() {
        ArrayList<Modifier> arrayList = super.getAssignedModifiers();
        Modifier modifier = null;
        for (Modifier modifier2 : this.availableModifiers) {
            if (!modifier2.getXMLID().equals(this.getXMLID())) continue;
            modifier = modifier2;
        }
        if (modifier != null) {
            boolean bl = false;
            for (int i = arrayList.size() - 1; i >= 0; --i) {
                Modifier modifier3 = arrayList.get(i);
                if (!modifier3.getXMLID().equals(modifier.getXMLID())) continue;
                if (bl) {
                    arrayList.remove(i);
                }
                bl = true;
            }
            if (!bl) {
                arrayList.add(modifier.clone());
            }
        }
        return arrayList;
    }

    @Override
    public String getColumn2Output() {
        String string = this.getAlias() + " +" + this.getDamageDisplay();
        if (this.getName().trim().length() > 0) {
            string = "<i>" + this.getName() + ":</i>  " + string;
        }
        if (this.getInput() != null && this.getInput().trim().length() > 0) {
            string = string + ":  " + this.getInput();
        }
        if (this.getSelectedOption() != null) {
            string = string + " (";
            string = string + this.getSelectedOption().getAlias();
            String string2 = this.getAdderString();
            if (string2.trim().length() > 0) {
                string = string + "; " + string2;
            }
            string = string + ")";
        } else {
            String string3 = this.getAdderString();
            if (string3.trim().length() > 0) {
                string = string + " (" + string3 + ")";
            }
        }
        string = string + this.getModifierString();
        if (this.getEndUsage() > 0 && GenericObject.findObjectByID(HeroDesigner.getActiveHero().getPowers(), "ENDURANCERESERVE") != null && GenericObject.findObjectByID(this.getAllAssignedModifiers(), "ENDRESERVEOREND") == null && !HeroDesigner.getInstance().getPrefs().useWG()) {
            string = this.getUseENDReserve() ? string + " (uses END Reserve)" : string + " (uses Personal END)";
        }
        return string;
    }

    @Override
    public String getDamageDisplay() {
        String string = "" + this.getLevels() + "d6";
        int n = 0;
        for (Adder adder : this.getAssignedAdders()) {
            if (adder.getXMLID().equals("PLUSONEPIP")) {
                adder.setDisplayInString(false);
                string = this.getLevels() > 0 ? this.getLevels() + "d6+1" : "1 point";
                ++n;
            }
            if (adder.getXMLID().equals("PLUSONEHALFDIE")) {
                adder.setDisplayInString(false);
                string = this.getLevels() + " 1/2d6";
                ++n;
            }
            if (!adder.getXMLID().equals("MINUSONEPIP")) continue;
            adder.setDisplayInString(false);
            string = "" + (this.getLevels() + 1);
            string = this.getLevels() + 1 + "d6-1";
            ++n;
        }
        if (this.useStandardEffect()) {
            string = string + " (standard effect: " + (this.getLevels() * 3 + n) + " STUN";
            if (this.doesBODY()) {
                string = string + ", " + (this.getLevels() + n) + " BODY";
            }
            string = string + ")";
        }
        return string;
    }
}

