/*
 * Decompiled with CFR 0.152.
 */
package com.hero.objects.powers;

import com.hero.HeroDesigner;
import com.hero.objects.GenericObject;
import com.hero.objects.powers.Power;
import com.hero.ui.dialog.GenericDialog;
import com.hero.ui.dialog.PowerDialog;
import com.hero.util.Rounder;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import org.jdom.Element;

public class Growth
extends Power {
    private static String xmlID = "GROWTH";

    public Growth(Element element) {
        super(element, xmlID);
    }

    @Override
    public String getColumn2Output() {
        String string = this.getAlias() + " (" + this.getPlainDamageDisplay() + ")";
        if (this.getName().trim().length() > 0) {
            string = "<i>" + this.getName() + ":</i>  " + string;
        }
        if (this.getInput() != null && this.getInput().trim().length() > 0) {
            string = string + ":  " + this.getInput();
        }
        if (this.getSelectedOption() != null && !HeroDesigner.getActiveTemplate().is6E()) {
            string = string + " (";
            string = string + this.getSelectedOption().getAlias();
            String string2 = this.getAdderString();
            if (string2.trim().length() > 0) {
                string = string + "; " + string2;
            }
            string = string + ")";
        } else {
            String string3 = this.getAdderString();
            if (string3.trim().length() > 0) {
                string = string + " (" + string3 + ")";
            }
        }
        string = string + this.getModifierString();
        if (this.getEndUsage() > 0 && GenericObject.findObjectByID(HeroDesigner.getActiveHero().getPowers(), "ENDURANCERESERVE") != null && GenericObject.findObjectByID(this.getAllAssignedModifiers(), "ENDRESERVEOREND") == null && !HeroDesigner.getInstance().getPrefs().useWG()) {
            string = this.getUseENDReserve() ? string + " (uses END Reserve)" : string + " (uses Personal END)";
        }
        return string;
    }

    @Override
    public String getDamageDisplay() {
        return "<html>" + this.getPlainDamageDisplay() + "</html>";
    }

    @Override
    public GenericDialog getDialog(boolean bl, boolean bl2) {
        PowerDialog powerDialog = new PowerDialog(this, bl, bl2);
        powerDialog.setSize(powerDialog.getSize().width + 100, powerDialog.getSize().height);
        return powerDialog;
    }

    private String getPlainDamageDisplay() {
        if (HeroDesigner.getActiveTemplate().is6E() && this.getSelectedOption() != null) {
            DecimalFormat decimalFormat = new DecimalFormat("#,###");
            long l = Rounder.roundHalfUp((double)HeroDesigner.getActiveHero().getWeight() * 453.5924);
            if (HeroDesigner.getInstance().getPrefs().isMetric()) {
                l = HeroDesigner.getActiveHero().getWeight() * 1000;
            }
            BigDecimal bigDecimal = new BigDecimal((double)(l *= (long)Math.pow(this.massMultiplier, (double)this.getLevels() / (double)this.massMultiplierLevels)) / 100000.0);
            bigDecimal = bigDecimal.setScale(0, 4);
            bigDecimal = new BigDecimal(bigDecimal.doubleValue() * 100.0);
            bigDecimal = bigDecimal.setScale(0, 4);
            if ((double)l / 100000.0 > 9999.0) {
                decimalFormat = new DecimalFormat("#.###E0");
            }
            String string = decimalFormat.format((double)l / 1000.0) + " kg";
            double d = (double)HeroDesigner.getActiveHero().getHeight() * 2.54;
            if (HeroDesigner.getInstance().getPrefs().isMetric()) {
                d = HeroDesigner.getActiveHero().getHeight();
            }
            if (this.getLevels() >= this.getHeightIncreaseLevels()) {
                d = HeroDesigner.getActiveHero().getRules().useExpandedGrowthChart() ? Math.pow(this.getHeightIncrease(), (double)this.getLevels() / (double)this.getHeightIncreaseLevels()) * d : Math.pow(this.getHeightIncrease(), this.getLevels() / this.getHeightIncreaseLevels()) * d;
            } else if (HeroDesigner.getActiveHero().getRules().useExpandedGrowthChart()) {
                d = Math.pow(this.getHeightIncrease(), (double)this.getLevels() / (double)this.getHeightIncreaseLevels()) * d;
            }
            double d2 = d / 100.0;
            double d3 = d / 200.0;
            decimalFormat = new DecimalFormat("#,###");
            if (d2 > 9999.0) {
                decimalFormat = new DecimalFormat("#.###E0");
            } else if (HeroDesigner.getActiveHero().getRules().useExpandedGrowthChart()) {
                decimalFormat = new DecimalFormat("#,###.#");
            }
            String string2 = decimalFormat.format(d2) + " m tall, ";
            decimalFormat = new DecimalFormat("#,###");
            if (d3 > 9999.0) {
                decimalFormat = new DecimalFormat("#.###E0");
            } else if (HeroDesigner.getActiveHero().getRules().useExpandedGrowthChart()) {
                decimalFormat = new DecimalFormat("#,###.#");
            }
            string2 = string2 + decimalFormat.format(d3) + " m wide";
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            int n8 = 0;
            int n9 = 0;
            int n10 = 0;
            int n11 = 0;
            int n12 = 0;
            int n13 = 0;
            if (this.getSelectedOption().getXMLID().equals("LARGE")) {
                n = 15;
                n2 = 5;
                n3 = 5;
                n4 = 3;
                n5 = 3;
                n6 = 3;
                n7 = 6;
                n8 = 1;
                n9 = 12;
                n10 = 6;
                n11 = 0;
                n12 = 2;
                n13 = 2;
                string = "101-800 kg";
                string2 = "2-4m tall, 1-2m wide";
            } else if (this.getSelectedOption().getXMLID().equals("ENORMOUS")) {
                n = 30;
                n2 = 10;
                n3 = 10;
                n4 = 6;
                n5 = 6;
                n6 = 6;
                n7 = 12;
                n8 = 3;
                n9 = 24;
                n10 = 12;
                n11 = 0;
                n12 = 4;
                n13 = 4;
                string = "801-6,400 kg";
                string2 = "5-8m tall, 3-4m wide";
            } else if (this.getSelectedOption().getXMLID().equals("HUGE")) {
                n = 45;
                n2 = 15;
                n3 = 15;
                n4 = 9;
                n5 = 9;
                n6 = 9;
                n7 = 18;
                n8 = 7;
                n9 = 36;
                n10 = 18;
                n11 = 1;
                n12 = 6;
                n13 = 6;
                string = "6,401-50,000 kg";
                string2 = "9-16m tall, 5-8m wide";
            } else if (this.getSelectedOption().getXMLID().equals("GIGANTIC")) {
                n = 60;
                n2 = 20;
                n3 = 20;
                n4 = 12;
                n5 = 12;
                n6 = 12;
                n7 = 24;
                n8 = 15;
                n9 = 48;
                n10 = 24;
                n11 = 2;
                n12 = 8;
                n13 = 8;
                string = "50,001-400,000 kg";
                string2 = "17-32m tall, 9-16m wide";
            } else if (this.getSelectedOption().getXMLID().equals("GARGANTUAN")) {
                n = 75;
                n2 = 25;
                n3 = 25;
                n4 = 15;
                n5 = 15;
                n6 = 15;
                n7 = 30;
                n8 = 31;
                n9 = 60;
                n10 = 30;
                n11 = 3;
                n12 = 10;
                n13 = 10;
                string = "40,001-3.2 mil kg";
                string2 = "33-64m tall, 17-32m wide";
            } else if (this.getSelectedOption().getXMLID().equals("COLOSSAL")) {
                n = 90;
                n2 = 30;
                n3 = 30;
                n4 = 18;
                n5 = 18;
                n6 = 18;
                n7 = 36;
                n8 = 63;
                n9 = 72;
                n10 = 36;
                n11 = 4;
                n12 = 12;
                n13 = 12;
                string = "3.3-25.6 mil kg";
                string2 = "65-125m tall, 33-64m wide";
            }
            String string3 = "+" + n + " STR, +" + n2 + " CON, +" + n3 + " PRE, +" + n4 + " PD, +" + n5 + " ED, +" + n6 + " BODY, +" + n7 + " STUN, +" + n8 + "m Reach, +" + n9 + "m Running, -" + n10 + "m KB, " + (n11 > 0 ? "hands/feet are Area Of Effect (" + n11 + "m Radius) attacks, " : "") + string + ", +" + n12 + " to OCV to hit, +" + n13 + " to PER Rolls to perceive character, " + string2;
            return string3;
        }
        DecimalFormat decimalFormat = new DecimalFormat("#,###");
        long l = Rounder.roundHalfUp((double)HeroDesigner.getActiveHero().getWeight() * 453.5924);
        if (HeroDesigner.getInstance().getPrefs().isMetric()) {
            l = HeroDesigner.getActiveHero().getWeight() * 1000;
        }
        BigDecimal bigDecimal = new BigDecimal((double)(l *= (long)Math.pow(this.massMultiplier, (double)this.getLevels() / (double)this.massMultiplierLevels)) / 100000.0);
        bigDecimal = bigDecimal.setScale(0, 4);
        bigDecimal = new BigDecimal(bigDecimal.doubleValue() * 100.0);
        bigDecimal = bigDecimal.setScale(0, 4);
        if ((double)l / 100000.0 > 9999.0) {
            decimalFormat = new DecimalFormat("#.###E0");
        }
        String string = decimalFormat.format((double)l / 1000.0) + " kg";
        String string4 = "+" + (long)((int)this.getStrIncrease()) * Rounder.roundDown((double)this.getLevels() / (double)this.strIncreaseLevels) + " STR";
        int n = (int)Rounder.roundHalfUp(this.bodyIncrease * (double)Rounder.roundDown((double)this.getLevels() / (double)this.bodyIncreaseLevels));
        int n14 = (int)Rounder.roundHalfUp(this.kbIncrease * (double)Rounder.roundDown((double)this.getLevels() / (double)this.kbIncreaseLevels));
        int n15 = (int)Rounder.roundHalfUp(this.stunIncrease * (double)Rounder.roundDown((double)this.getLevels() / (double)this.stunIncreaseLevels));
        int n16 = (int)Rounder.roundHalfUp(this.dcvIncrease * (double)Rounder.roundDown((double)this.getLevels() / (double)this.dcvIncreaseLevels));
        int n17 = (int)Rounder.roundHalfUp(this.perIncrease * (double)Rounder.roundDown((double)this.getLevels() / (double)this.perIncreaseLevels));
        if (HeroDesigner.getActiveHero().getRules().useExpandedGrowthChart()) {
            string4 = "+" + (long)((int)this.getStrIncrease()) * Rounder.roundHalfUp((double)this.getLevels() / (double)this.strIncreaseLevels) + " STR";
            n = (int)(this.bodyIncrease / Math.abs(this.bodyIncrease) * (double)Rounder.roundDown(Math.abs(this.bodyIncrease) * (double)this.getLevels() / (double)this.bodyIncreaseLevels));
            n14 = (int)(this.kbIncrease / Math.abs(this.kbIncrease) * (double)Rounder.roundDown(Math.abs(this.kbIncrease) * (double)this.getLevels() / (double)this.kbIncreaseLevels));
            n15 = (int)(this.stunIncrease / Math.abs(this.stunIncrease) * (double)Rounder.roundDown(Math.abs(this.stunIncrease) * (double)this.getLevels() / (double)this.stunIncreaseLevels));
            n16 = (int)(this.dcvIncrease / Math.abs(this.dcvIncrease) * (double)Rounder.roundDown(Math.abs(this.dcvIncrease) * (double)this.getLevels() / (double)this.dcvIncreaseLevels));
            n17 = (int)(this.perIncrease / Math.abs(this.perIncrease) * (double)Rounder.roundDown(Math.abs(this.perIncrease) * (double)this.getLevels() / (double)this.perIncreaseLevels));
        }
        String string5 = "+" + n17 + " PER Rolls to perceive character";
        String string6 = (n16 < 0 ? "" : "+") + n16 + " DCV";
        String string7 = (n14 < 0 ? "" : "+") + n14 + "\" KB";
        if (HeroDesigner.getActiveTemplate().is6E()) {
            string7 = (n14 < 0 ? "" : "+") + n14 + "m KB";
        }
        String string8 = "+" + n + " BODY";
        String string9 = "+" + n15 + " STUN";
        double d = (double)HeroDesigner.getActiveHero().getHeight() * 2.54;
        if (HeroDesigner.getInstance().getPrefs().isMetric()) {
            d = HeroDesigner.getActiveHero().getHeight();
        }
        if (this.getLevels() >= this.getHeightIncreaseLevels()) {
            d = HeroDesigner.getActiveHero().getRules().useExpandedGrowthChart() ? Math.pow(this.getHeightIncrease(), (double)this.getLevels() / (double)this.getHeightIncreaseLevels()) * d : Math.pow(this.getHeightIncrease(), this.getLevels() / this.getHeightIncreaseLevels()) * d;
        } else if (HeroDesigner.getActiveHero().getRules().useExpandedGrowthChart()) {
            d = Math.pow(this.getHeightIncrease(), (double)this.getLevels() / (double)this.getHeightIncreaseLevels()) * d;
        }
        double d4 = d / 100.0;
        double d5 = d / 200.0;
        decimalFormat = new DecimalFormat("#,###");
        if (d4 > 9999.0) {
            decimalFormat = new DecimalFormat("#.###E0");
        } else if (HeroDesigner.getActiveHero().getRules().useExpandedGrowthChart()) {
            decimalFormat = new DecimalFormat("#,###.#");
        }
        String string10 = decimalFormat.format(d4) + " m tall, ";
        decimalFormat = new DecimalFormat("#,###");
        if (d5 > 9999.0) {
            decimalFormat = new DecimalFormat("#.###E0");
        } else if (HeroDesigner.getActiveHero().getRules().useExpandedGrowthChart()) {
            decimalFormat = new DecimalFormat("#,###.#");
        }
        string10 = string10 + decimalFormat.format(d5) + " m wide";
        double d6 = 0.0;
        if (this.getLevels() / this.getReachIncreaseLevels() >= 1) {
            if (this.getLevels() / this.getReachIncreaseLevels() >= 2) {
                if (this.getLevels() / this.getReachIncreaseLevels() >= 3) {
                    double d7 = (double)this.getLevels() / (double)this.getReachIncreaseLevels();
                    d6 = (int)Math.pow(this.reachIncrease, d7 -= 1.0);
                } else {
                    d6 = 2.0;
                }
            } else {
                d6 = 1.0;
            }
        }
        decimalFormat = new DecimalFormat("#,###");
        if (d6 > 9999.0) {
            decimalFormat = new DecimalFormat("#.###E0");
        }
        String string11 = string4 + ", " + string8 + ", " + string9 + ", " + string7 + ", " + string + ", " + string6 + ", " + string5 + ", " + string10;
        return string11;
    }
}

