/*
 * Decompiled with CFR 0.152.
 */
package com.hero.objects.powers;

import com.hero.HeroDesigner;
import com.hero.objects.Adder;
import com.hero.objects.GenericObject;
import com.hero.objects.modifiers.Modifier;
import com.hero.objects.powers.Automaton;
import com.hero.objects.powers.Power;
import com.hero.ui.dialog.ForceWallDialog;
import com.hero.ui.dialog.GenericDialog;
import com.hero.util.Rounder;
import com.hero.util.XMLUtility;
import java.util.ArrayList;
import org.jdom.Element;

public class ForceWall
extends Power {
    private static String xmlID = "FORCEWALL";
    private int pdLevels;
    private int edLevels;
    private int mdLevels;
    private int powdLevels;
    private int lengthLevels;
    private int heightLevels;
    private double widthLevels;
    private int bodyLevels;
    private int costPerInch;
    private int costPerBody;

    public ForceWall(Element element) {
        super(element, xmlID);
    }

    public int getBody() {
        return this.bodyLevels;
    }

    public void setBody(int n) {
        this.bodyLevels = n;
    }

    public void setWidth(double d) {
        this.widthLevels = d - 0.5;
    }

    public double getWidth() {
        return this.widthLevels + 0.5;
    }

    @Override
    public ArrayList<Adder> getAvailableAdders() {
        ArrayList arrayList = (ArrayList)super.getAvailableAdders().clone();
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            Adder adder = (Adder)arrayList.get(i);
            if (!adder.equals("FLASHDEFENSE")) continue;
            for (Modifier modifier : this.getAssignedModifiers()) {
                ArrayList<Adder> arrayList2;
                if (!modifier.getXMLID().equals("TRANSPARENT") || GenericObject.findObjectByID(arrayList2 = modifier.getAssignedAdders(), "FLASHD") == null) continue;
                arrayList.remove(i);
                return arrayList;
            }
        }
        return arrayList;
    }

    @Override
    public String getColumn2Output() {
        boolean bl = HeroDesigner.getActiveTemplate().is6E();
        String string = this.getAlias() + " " + this.getDamageDisplay();
        if (this.getName().trim().length() > 0) {
            string = "<i>" + this.getName() + ":</i>  " + string;
        }
        if (bl) {
            string = string.trim();
            string = string + " ";
        } else {
            string = string + "(";
        }
        boolean bl2 = false;
        if (this.getPdLevels() > 0) {
            if (bl2) {
                string = string + "/";
            }
            string = string + this.getPdLevels() + " PD";
            bl2 = true;
        }
        if (this.getEdLevels() > 0) {
            if (bl2) {
                string = string + "/";
            }
            string = string + this.getEdLevels() + " ED";
            bl2 = true;
        }
        if (this.getMdLevels() > 0) {
            if (bl2) {
                string = string + "/";
            }
            string = string + this.getMdLevels() + " Mental Defense";
            bl2 = true;
        }
        if (this.getPowdLevels() > 0) {
            if (bl2) {
                string = string + "/";
            }
            string = string + this.getPowdLevels() + " Power Defense";
            bl2 = true;
        }
        string = string.trim();
        ArrayList<Adder> arrayList = this.getAssignedAdders();
        ArrayList arrayList2 = (ArrayList)arrayList.clone();
        for (int i = arrayList2.size() - 1; i >= 0; --i) {
            Adder adder = (Adder)arrayList2.get(i);
            if (!adder.getXMLID().equals("FLASHDEFENSE")) continue;
            if (bl2) {
                string = string + "/";
            }
            string = string + adder.getLevels();
            string = string + " " + adder.getAlias() + ":  " + adder.getSelectedOption().getAlias();
            bl2 = true;
            arrayList2.remove(i);
        }
        this.setAssignedAdders(arrayList2);
        String string2 = this.getAdderString();
        this.setAssignedAdders(arrayList);
        if (HeroDesigner.getActiveTemplate().is6E()) {
            string = string + ", " + this.getBody() + " BODY";
            string = string + " (up to ";
            string = string + this.getLength() + "m long, " + this.getHeight() + "m tall, and " + this.getFraction(this.getWidth()) + "m thick)";
        } else if (this.getLength() > 1 || this.getHeight() > 1) {
            string = string + "; " + this.getLength() + "\" long and " + this.getHeight() + "\" tall";
        }
        if (!bl) {
            string = string + ")";
        }
        if (this.getInput() != null && this.getInput().trim().length() > 0) {
            string = string + ":  " + this.getInput();
        }
        if (this.getSelectedOption() != null) {
            string = string + " (";
            string = string + this.getSelectedOption().getAlias();
            if (string2.trim().length() > 0) {
                string = string + "; " + string2;
            }
            string = string + ")";
        } else if (string2.trim().length() > 0) {
            string = bl ? string + ", " + string2 : string + " (" + string2 + ")";
        }
        string = string + this.getModifierString();
        if (this.getEndUsage() > 0 && GenericObject.findObjectByID(HeroDesigner.getActiveHero().getPowers(), "ENDURANCERESERVE") != null && GenericObject.findObjectByID(this.getAllAssignedModifiers(), "ENDRESERVEOREND") == null && !HeroDesigner.getInstance().getPrefs().useWG()) {
            string = this.getUseENDReserve() ? string + " (uses END Reserve)" : string + " (uses Personal END)";
        }
        return string;
    }

    @Override
    public String getDamageDisplay() {
        String string = "";
        return string;
    }

    @Override
    public GenericDialog getDialog(boolean bl, boolean bl2) {
        return new ForceWallDialog(this, bl, bl2);
    }

    public int getEdLevels() {
        return this.edLevels;
    }

    public int getHeight() {
        return this.heightLevels + 1;
    }

    public int getLength() {
        return this.lengthLevels + 1;
    }

    @Override
    public int getLevels() {
        return this.pdLevels + this.edLevels + this.mdLevels + this.powdLevels;
    }

    @Override
    public int getMdLevels() {
        return this.mdLevels;
    }

    public int getPdLevels() {
        return this.pdLevels;
    }

    public int getPowdLevels() {
        return this.powdLevels;
    }

    @Override
    public Element getSaveXML() {
        Element element = super.getSaveXML();
        element.setAttribute("PDLEVELS", "" + this.pdLevels);
        element.setAttribute("EDLEVELS", "" + this.edLevels);
        element.setAttribute("MDLEVELS", "" + this.mdLevels);
        element.setAttribute("POWDLEVELS", "" + this.powdLevels);
        element.setAttribute("LENGTHLEVELS", "" + this.lengthLevels);
        element.setAttribute("HEIGHTLEVELS", "" + this.heightLevels);
        element.setAttribute("BODYLEVELS", "" + this.bodyLevels);
        element.setAttribute("WIDTHLEVELS", "" + this.widthLevels);
        return element;
    }

    @Override
    public double getTotalCost() {
        Automaton automaton;
        double d = super.getTotalCost();
        int n = 1;
        if (this.getTypes().contains("DEFENSE") && HeroDesigner.getActiveHero() != null && GenericObject.findObjectByID(HeroDesigner.getActiveHero().getPowers(), "AUTOMATON") != null && (automaton = (Automaton)GenericObject.findObjectByID(HeroDesigner.getActiveHero().getPowers(), "AUTOMATON")).getSelectedOption().getXMLID().toUpperCase().startsWith("NOSTUN")) {
            n = automaton.getDefenseCostMultiplier();
        }
        if (HeroDesigner.getActiveTemplate().is6E()) {
            d += (double)(this.costPerInch / 2 * this.lengthLevels * n);
            d += (double)(this.costPerInch / 2 * this.heightLevels * n);
            d += (double)this.costPerInch * this.widthLevels * (double)n;
            d += (double)(this.costPerBody * this.bodyLevels * n);
        } else {
            d += (double)(this.costPerInch * this.lengthLevels * n);
            d += (double)(this.costPerInch * this.heightLevels * n);
        }
        return d;
    }

    @Override
    protected void init(Element element) {
        this.duration = "CONSTANT";
        this.target = "HEX";
        this.range = "Yes";
        this.end = 10;
        this.display = "Force Wall";
        this.levelCost = 5.0;
        this.levelValue = 2.0;
        this.minimumCost = 5.0;
        this.baseCost = 0.0;
        this.costPerInch = 2;
        super.init(element);
        this.canAffectPrimary = true;
        String string = XMLUtility.getValue(element, "COSTPERINCH");
        if (string != null && string.trim().length() > 0) {
            try {
                this.costPerInch = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((string = XMLUtility.getValue(element, "COSTPERBODY")) != null && string.trim().length() > 0) {
            try {
                this.costPerBody = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    @Override
    public void restoreFromSave(Element element) {
        super.restoreFromSave(element);
        String string = XMLUtility.getValue(element, "PDLEVELS");
        if (string != null && string.trim().length() > 0) {
            try {
                this.pdLevels = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((string = XMLUtility.getValue(element, "EDLEVELS")) != null && string.trim().length() > 0) {
            try {
                this.edLevels = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.setLevels(this.edLevels + this.pdLevels);
        string = XMLUtility.getValue(element, "MDLEVELS");
        if (string != null && string.trim().length() > 0) {
            try {
                this.mdLevels = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.setLevels(this.edLevels + this.pdLevels);
        string = XMLUtility.getValue(element, "POWDLEVELS");
        if (string != null && string.trim().length() > 0) {
            try {
                this.powdLevels = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((string = XMLUtility.getValue(element, "LENGTHLEVELS")) != null && string.trim().length() > 0) {
            try {
                this.lengthLevels = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((string = XMLUtility.getValue(element, "HEIGHTLEVELS")) != null && string.trim().length() > 0) {
            try {
                this.heightLevels = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (HeroDesigner.getActiveTemplate().is6E()) {
            string = XMLUtility.getValue(element, "BODYLEVELS");
            if (string != null && string.trim().length() > 0) {
                try {
                    this.bodyLevels = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if ((string = XMLUtility.getValue(element, "WIDTHLEVELS")) != null && string.trim().length() > 0) {
                try {
                    this.widthLevels = Double.parseDouble(string);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        this.setLevels(this.edLevels + this.pdLevels + this.mdLevels + this.powdLevels);
    }

    public void setEdLevels(int n) {
        this.edLevels = n;
        this.setLevels(this.getPdLevels() + this.getEdLevels() + this.getMdLevels() + this.getPowdLevels());
    }

    public void setHeight(int n) {
        this.heightLevels = n - 1;
    }

    public void setLength(int n) {
        this.lengthLevels = n - 1;
    }

    public void setMdLevels(int n) {
        this.mdLevels = n;
        this.setLevels(this.getPdLevels() + this.getEdLevels() + this.getMdLevels() + this.getPowdLevels());
    }

    public void setPdLevels(int n) {
        this.pdLevels = n;
        this.setLevels(this.getPdLevels() + this.getEdLevels() + this.getMdLevels() + this.getPowdLevels());
    }

    public void setPowdLevels(int n) {
        this.powdLevels = n;
        this.setLevels(this.getPdLevels() + this.getEdLevels() + this.getMdLevels() + this.getPowdLevels());
    }

    private String getFraction(double d) {
        String string = "";
        if (d == 0.0) {
            return "0";
        }
        if ((d = Math.abs(d)) > 1.0) {
            string = string + (int)Rounder.roundDown(d);
            d -= (double)Rounder.roundDown(d);
        }
        if (d == 0.0) {
            return string;
        }
        String string2 = "";
        double d2 = 1.0;
        if (Math.abs(0.25 - d) < d2) {
            d2 = Math.abs(0.25 - d);
            string2 = "1/4";
        }
        if (Math.abs(0.5 - d) < d2) {
            d2 = Math.abs(0.5 - d);
            string2 = "1/2";
        }
        if (Math.abs(0.75 - d) < d2) {
            d2 = Math.abs(0.75 - d);
            string2 = "3/4";
        }
        if (Math.abs(1.0 - d) < d2) {
            string2 = "";
            if (string.length() > 1) {
                int n = Integer.parseInt(string.substring(1, string.length()));
                string = string.substring(0, 1) + (n + 1);
            } else {
                string = string.length() == 1 ? "" + (Integer.parseInt(string) + 1) : (string.trim().length() == 0 ? "1" : "-1");
            }
        }
        if (string.length() > 1) {
            string = string + " ";
        }
        string = string + string2;
        string = string.trim();
        return string;
    }
}

