/*
 * Decompiled with CFR 0.152.
 */
package com.hero.objects.powers;

import com.hero.HeroDesigner;
import com.hero.objects.Adder;
import com.hero.objects.GenericObject;
import com.hero.objects.powers.Automaton;
import com.hero.objects.powers.Power;
import com.hero.ui.dialog.ForceFieldDialog;
import com.hero.ui.dialog.GenericDialog;
import com.hero.util.Rounder;
import com.hero.util.XMLUtility;
import java.util.ArrayList;
import org.jdom.Element;

public class ForceField
extends Power {
    private static String xmlID = "FORCEFIELD";
    private int pdLevels;
    private int edLevels;
    private int mdLevels;
    private int powdLevels;

    public ForceField(Element element) {
        super(element, xmlID);
        this.canAffectPrimary = true;
    }

    @Override
    public boolean affectsCharacteristics() {
        return true;
    }

    @Override
    public String getColumn2Output() {
        String string = this.getAlias() + " " + this.getDamageDisplay();
        if (this.getName().trim().length() > 0) {
            string = "<i>" + this.getName() + ":</i>  " + string;
        }
        string = string + "(";
        boolean bl = false;
        if (this.getPdLevels() > 0) {
            if (bl) {
                string = string + "/";
            }
            string = string + this.getPdLevels() + " PD";
            bl = true;
        }
        if (this.getEdLevels() > 0) {
            if (bl) {
                string = string + "/";
            }
            string = string + this.getEdLevels() + " ED";
            bl = true;
        }
        if (this.getMdLevels() > 0) {
            if (bl) {
                string = string + "/";
            }
            string = string + this.getMdLevels() + " Mental Defense";
            bl = true;
        }
        if (this.getPowdLevels() > 0) {
            if (bl) {
                string = string + "/";
            }
            string = string + this.getPowdLevels() + " Power Defense";
            bl = true;
        }
        ArrayList<Adder> arrayList = this.getAssignedAdders();
        ArrayList arrayList2 = (ArrayList)arrayList.clone();
        for (int i = arrayList2.size() - 1; i >= 0; --i) {
            Adder adder = (Adder)arrayList2.get(i);
            if (!adder.getXMLID().equals("FLASHDEFENSE")) continue;
            if (bl) {
                string = string + "/";
            }
            string = string + adder.getLevels();
            string = string + " " + adder.getAlias() + ":  " + adder.getSelectedOption().getAlias();
            bl = true;
            arrayList2.remove(i);
        }
        this.setAssignedAdders(arrayList2);
        String string2 = this.getAdderString();
        this.setAssignedAdders(arrayList);
        string = string + ")";
        if (this.getInput() != null && this.getInput().trim().length() > 0) {
            string = string + ":  " + this.getInput();
        }
        if (this.getSelectedOption() != null) {
            string = string + " (";
            string = string + this.getSelectedOption().getAlias();
            if (string2.trim().length() > 0) {
                string = string + "; " + string2;
            }
            string = string + ")";
        } else if (string2.trim().length() > 0) {
            string = string + " (" + string2 + ")";
        }
        string = string + this.getModifierString();
        if (this.getEndUsage() > 0 && GenericObject.findObjectByID(HeroDesigner.getActiveHero().getPowers(), "ENDURANCERESERVE") != null && GenericObject.findObjectByID(this.getAllAssignedModifiers(), "ENDRESERVEOREND") == null && !HeroDesigner.getInstance().getPrefs().useWG()) {
            string = this.getUseENDReserve() ? string + " (uses END Reserve)" : string + " (uses Personal END)";
        }
        return string;
    }

    @Override
    public String getDamageDisplay() {
        String string = "";
        return string;
    }

    @Override
    public GenericDialog getDialog(boolean bl, boolean bl2) {
        return new ForceFieldDialog(this, bl, bl2);
    }

    @Override
    public double getEdIncrease() {
        return this.getEdLevels();
    }

    @Override
    public int getEdIncreaseLevels() {
        return this.getLevels();
    }

    public int getEdLevels() {
        return this.edLevels;
    }

    @Override
    public int getLevels() {
        return this.pdLevels + this.edLevels + this.mdLevels + this.powdLevels;
    }

    @Override
    public double getTotalCost() {
        double d = this.getBaseCost();
        ArrayList<Adder> arrayList = this.getAvailableAdders();
        if (this.getLevelValue() != 0.0) {
            int n = this.getLevels();
            for (Adder adder : this.getAssignedAdders()) {
                if (!adder.getXMLID().equals("FLASHDEFENSE")) continue;
                n += adder.getLevels();
            }
            double d2 = Math.floor((double)n / this.getLevelValue());
            if ((double)n % this.getLevelValue() != 0.0 && this.getLevelValue() > 1.0) {
                d2 += 1.0;
            }
            d += d2 * this.getLevelCost();
            if (this.getLevelCost() < this.getLevelValue()) {
                d = d > 0.0 && d < 1.0 ? 1.0 : (double)Rounder.roundHalfDown(d);
            }
        }
        for (Adder adder : this.getAssignedAdders()) {
            if (!adder.isRequired() || adder.getXMLID().equals("FLASHDEFENSE")) continue;
            d += adder.getRealCost();
        }
        for (Adder adder : this.getAssignedAdders()) {
            if (adder.isRequired() || adder.getXMLID().equals("FLASHDEFENSE") || GenericObject.findObjectByID(arrayList, adder.getXMLID()) == null) continue;
            d += adder.getRealCost();
        }
        if (d < this.getMinimumCost() && this.isMinSet()) {
            d = this.getMinimumCost();
        } else if (d > this.getMaxCost() && this.isMaxSet()) {
            d = this.getMaxCost();
        }
        Object object = this.getAssignedAdders().iterator();
        while (object.hasNext()) {
            Adder adder = object.next();
            if (adder.isRequired() || adder.getXMLID().equals("FLASHDEFENSE") || GenericObject.findObjectByID(arrayList, adder.getXMLID()) != null) continue;
            d += adder.getRealCost();
        }
        if (this.getTypes().contains("DEFENSE") && HeroDesigner.getActiveHero() != null && GenericObject.findObjectByID(HeroDesigner.getActiveHero().getPowers(), "AUTOMATON") != null && ((GenericObject)(object = (Automaton)GenericObject.findObjectByID(HeroDesigner.getActiveHero().getPowers(), "AUTOMATON"))).getSelectedOption().getXMLID().toUpperCase().startsWith("NOSTUN")) {
            d *= (double)((Automaton)object).getDefenseCostMultiplier();
        }
        return d;
    }

    @Override
    public int getMdLevels() {
        return this.mdLevels;
    }

    @Override
    public double getPdIncrease() {
        return this.getPdLevels();
    }

    @Override
    public int getPdIncreaseLevels() {
        return this.getLevels();
    }

    public int getPdLevels() {
        return this.pdLevels;
    }

    public int getPowdLevels() {
        return this.powdLevels;
    }

    @Override
    public Element getSaveXML() {
        Element element = super.getSaveXML();
        element.setAttribute("PDLEVELS", "" + this.pdLevels);
        element.setAttribute("EDLEVELS", "" + this.edLevels);
        element.setAttribute("MDLEVELS", "" + this.mdLevels);
        element.setAttribute("POWDLEVELS", "" + this.powdLevels);
        return element;
    }

    @Override
    public boolean resistantDefenses() {
        return true;
    }

    @Override
    public void restoreFromSave(Element element) {
        super.restoreFromSave(element);
        String string = XMLUtility.getValue(element, "PDLEVELS");
        if (string != null && string.trim().length() > 0) {
            try {
                this.pdLevels = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((string = XMLUtility.getValue(element, "EDLEVELS")) != null && string.trim().length() > 0) {
            try {
                this.edLevels = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.setLevels(this.edLevels + this.pdLevels);
        string = XMLUtility.getValue(element, "MDLEVELS");
        if (string != null && string.trim().length() > 0) {
            try {
                this.mdLevels = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.setLevels(this.edLevels + this.pdLevels);
        string = XMLUtility.getValue(element, "POWDLEVELS");
        if (string != null && string.trim().length() > 0) {
            try {
                this.powdLevels = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.setLevels(this.edLevels + this.pdLevels + this.mdLevels + this.powdLevels);
    }

    public void setEdLevels(int n) {
        this.edLevels = n;
        this.setLevels(this.getPdLevels() + this.getEdLevels() + this.getMdLevels() + this.getPowdLevels());
    }

    public void setMdLevels(int n) {
        this.mdLevels = n;
        this.setLevels(this.getPdLevels() + this.getEdLevels() + this.getMdLevels() + this.getPowdLevels());
    }

    public void setPdLevels(int n) {
        this.pdLevels = n;
        this.setLevels(this.getPdLevels() + this.getEdLevels() + this.getMdLevels() + this.getPowdLevels());
    }

    public void setPowdLevels(int n) {
        this.powdLevels = n;
        this.setLevels(this.getPdLevels() + this.getEdLevels() + this.getMdLevels() + this.getPowdLevels());
    }
}

