/*
 * Decompiled with CFR 0.152.
 */
package com.hero.objects.powers;

import com.hero.HeroDesigner;
import com.hero.objects.GenericObject;
import com.hero.objects.powers.Power;
import com.hero.util.Rounder;
import org.jdom.Element;

public class Flight
extends Power {
    private static String xmlID = "FLIGHT";

    public Flight(Element element) {
        super(element, xmlID);
        this.affectsPrimary = true;
    }

    @Override
    public boolean usesEND() {
        if (HeroDesigner.getActiveTemplate().is6E() && Flight.findObjectByID(this.getAssignedModifiers(), "GLIDING") != null) {
            return false;
        }
        return super.usesEND();
    }

    @Override
    public String getColumn2Output() {
        String string = this.getAlias() + " " + this.getDamageDisplay();
        if (this.getName().trim().length() > 0) {
            string = "<i>" + this.getName() + ":</i>  " + string;
        }
        if (this.getInput() != null && this.getInput().trim().length() > 0) {
            string = string + ":  " + this.getInput();
        }
        if (this.getSelectedOption() != null) {
            string = string + ", ";
            string = string + this.getSelectedOption().getAlias();
            String string2 = this.getAdderString();
            if (string2.trim().length() > 0) {
                string = string + "; " + string2;
            }
        } else {
            String string3 = this.getAdderString();
            if (string3.trim().length() > 0) {
                string = string + ", " + string3;
            }
        }
        string = string + this.getModifierString();
        if (this.getEndUsage() > 0 && GenericObject.findObjectByID(HeroDesigner.getActiveHero().getPowers(), "ENDURANCERESERVE") != null && GenericObject.findObjectByID(this.getAllAssignedModifiers(), "ENDRESERVEOREND") == null && !HeroDesigner.getInstance().getPrefs().useWG()) {
            string = this.getUseENDReserve() ? string + " (uses END Reserve)" : string + " (uses Personal END)";
        }
        return string;
    }

    @Override
    public String getDamageDisplay() {
        if (HeroDesigner.getActiveTemplate().is6E()) {
            int n = (int)Rounder.roundDown((double)this.getLevels() / this.getLevelValue());
            String string = "" + n + "m";
            return string;
        }
        int n = (int)Rounder.roundDown((double)this.getLevels() / this.getLevelValue());
        String string = "" + n + "\"";
        return string;
    }

    @Override
    public boolean isSummable() {
        return true;
    }
}

