/*
 * Decompiled with CFR 0.152.
 */
package com.hero.objects.powers;

import com.hero.HeroDesigner;
import com.hero.objects.Adder;
import com.hero.objects.GenericObject;
import com.hero.objects.modifiers.Modifier;
import com.hero.objects.powers.Power;
import com.hero.util.Rounder;
import org.jdom.Element;

public class Entangle
extends Power {
    private static String xmlID = "ENTANGLE";

    public Entangle(Element element) {
        super(element, xmlID);
    }

    @Override
    public String getColumn2Output() {
        String string = this.getAlias() + " " + this.getDamageDisplay();
        if (this.getName().trim().length() > 0) {
            string = "<i>" + this.getName() + ":</i>  " + string;
        }
        if (this.getInput() != null && this.getInput().trim().length() > 0) {
            string = string + ":  " + this.getInput();
        }
        if (this.getSelectedOption() != null) {
            string = string + " (";
            string = string + this.getSelectedOption().getAlias();
            String string2 = this.getAdderString();
            if (string2.trim().length() > 0) {
                string = string + "; " + string2;
            }
            string = string + ")";
        } else {
            String string3 = this.getAdderString();
            if (string3.trim().length() > 0) {
                string = string + " (" + string3 + ")";
            }
        }
        string = string + this.getModifierString();
        if (this.getEndUsage() > 0 && HeroDesigner.getActiveHero() != null && GenericObject.findObjectByID(HeroDesigner.getActiveHero().getPowers(), "ENDURANCERESERVE") != null && GenericObject.findObjectByID(this.getAllAssignedModifiers(), "ENDRESERVEOREND") == null && !HeroDesigner.getInstance().getPrefs().useWG()) {
            string = this.getUseENDReserve() ? string + " (uses END Reserve)" : string + " (uses Personal END)";
        }
        return string;
    }

    @Override
    public String getDamageDisplay() {
        if (HeroDesigner.getActiveTemplate().is6E()) {
            String string = "" + this.getLevels() + "d6";
            int n = this.getLevels();
            int n2 = 0;
            int n3 = 0;
            int n4 = (int)Rounder.roundDown((double)this.getLevels() / this.getLevelValue());
            int n5 = (int)Rounder.roundDown((double)this.getLevels() / this.getLevelValue());
            for (Adder adder : this.getAssignedAdders()) {
                if (adder.getXMLID().equals("ADDITIONALPD")) {
                    n4 += adder.getLevels();
                    adder.setDisplayInString(false);
                    continue;
                }
                if (adder.getXMLID().equals("ADDITIONALED")) {
                    n5 += adder.getLevels();
                    adder.setDisplayInString(false);
                    continue;
                }
                if (!adder.getXMLID().equals("ADDITIONALBODY")) continue;
                n += adder.getLevels();
                n2 += adder.getLevels();
                adder.setDisplayInString(false);
            }
            string = this.getLevels() + n2 + "d6";
            int n6 = this.getLevels() + n2;
            n2 = 0;
            for (Adder adder : this.getAssignedAdders()) {
                if (adder.getXMLID().equals("PLUSONEPIP")) {
                    adder.setDisplayInString(false);
                    string = n6 + "d6";
                    n2 = 1;
                    ++n3;
                }
                if (adder.getXMLID().equals("PLUSONEHALFDIE")) {
                    adder.setDisplayInString(false);
                    string = n6 + " 1/2d6";
                    ++n3;
                }
                if (!adder.getXMLID().equals("MINUSONEPIP")) continue;
                adder.setDisplayInString(false);
                string = "" + (this.getLevels() + 1);
                string = n6 + 1 + "d6";
                --n2;
                ++n3;
            }
            if (n2 != 0) {
                string = n2 > 0 ? string + " + " : string + " - ";
                string = string + "" + n2;
            }
            for (Modifier modifier : this.getAllAssignedModifiers()) {
                if (!modifier.getXMLID().equals("NODEFENSE")) continue;
                n4 = 0;
                n5 = 0;
            }
            string = string + ", " + n4 + " PD/" + n5 + " ED";
            if (this.useStandardEffect()) {
                string = string + " (standard effect: " + (n + n3) + " BODY, " + n4 + " PD/" + n5 + " ED)";
            }
            return string;
        }
        String string = "" + this.getLevels() + "d6";
        int n = this.getLevels();
        int n7 = 0;
        int n8 = 0;
        int n9 = (int)Rounder.roundDown((double)this.getLevels() / this.getLevelValue());
        for (Adder object : this.getAssignedAdders()) {
            if (object.getXMLID().equals("ADDITIONALDEF")) {
                n9 += object.getLevels();
                object.setDisplayInString(false);
                continue;
            }
            if (!object.getXMLID().equals("ADDITIONALBODY")) continue;
            n += object.getLevels();
            n7 += object.getLevels();
            object.setDisplayInString(false);
        }
        string = this.getLevels() + n7 + "d6";
        int n10 = this.getLevels() + n7;
        n7 = 0;
        for (Adder adder : this.getAssignedAdders()) {
            if (adder.getXMLID().equals("PLUSONEPIP")) {
                adder.setDisplayInString(false);
                string = n10 + "d6";
                n7 = 1;
                ++n8;
            }
            if (adder.getXMLID().equals("PLUSONEHALFDIE")) {
                adder.setDisplayInString(false);
                string = n10 + " 1/2d6";
                ++n8;
            }
            if (!adder.getXMLID().equals("MINUSONEPIP")) continue;
            adder.setDisplayInString(false);
            string = "" + (this.getLevels() + 1);
            string = n10 + 1 + "d6";
            --n7;
            ++n8;
        }
        if (n7 != 0) {
            string = n7 > 0 ? string + " + " : string + " - ";
            string = string + "" + n7;
        }
        for (Modifier modifier : this.getAllAssignedModifiers()) {
            if (!modifier.getXMLID().equals("NODEFENSE")) continue;
            n9 = 0;
        }
        string = string + ", " + n9 + " DEF";
        if (this.useStandardEffect()) {
            string = string + " (standard effect: " + (n + n8) + " BODY, " + n9 + " DEF)";
        }
        return string;
    }

    @Override
    protected void init(Element element) {
        super.init(element);
        this.setLevels(this.getLevels());
    }

    @Override
    public void restoreFromSave(Element element) {
        super.restoreFromSave(element);
        this.setLevels(this.getLevels());
    }

    @Override
    public void setLevels(int n) {
        super.setLevels(n);
        Adder adder = (Adder)GenericObject.findObjectByID(this.availableAdders, "ADDITIONALBODY");
        Adder adder2 = (Adder)GenericObject.findObjectByID(this.availableAdders, "ADDITIONALDEF");
        if (adder != null) {
            adder.setMaxLevel(n);
        }
        if (adder2 != null) {
            adder2.setMaxLevel(n);
        }
        adder = (Adder)GenericObject.findObjectByID(this.assignedAdders, "ADDITIONALBODY");
        adder2 = (Adder)GenericObject.findObjectByID(this.assignedAdders, "ADDITIONALDEF");
        if (adder != null) {
            adder.setMaxLevel(n);
        }
        if (adder2 != null) {
            adder2.setMaxLevel(n);
        }
    }
}

