/*
 * Decompiled with CFR 0.152.
 */
package com.hero.objects.powers;

import com.hero.HeroDesigner;
import com.hero.objects.ElementalControl;
import com.hero.objects.GenericObject;
import com.hero.objects.Multipower;
import com.hero.objects.modifiers.Modifier;
import com.hero.objects.powers.EnduranceReserveRecovery;
import com.hero.objects.powers.Power;
import com.hero.ui.dialog.ENDReserveDialog;
import com.hero.ui.dialog.GenericDialog;
import com.hero.util.Rounder;
import java.util.ArrayList;
import org.jdom.Element;

public class EnduranceReserve
extends Power {
    private static String xmlID = "ENDURANCERESERVE";
    private EnduranceReserveRecovery rec;

    public EnduranceReserve(Element element) {
        super(element, xmlID);
    }

    @Override
    public EnduranceReserve clone() {
        EnduranceReserve enduranceReserve = (EnduranceReserve)super.clone();
        enduranceReserve.setRecovery((EnduranceReserveRecovery)this.rec.clone());
        return enduranceReserve;
    }

    @Override
    public double getActiveCost() {
        boolean bl = this.recIsSamePower();
        double d = super.getTotalCost();
        if (bl) {
            d += this.rec.getTotalCost();
        }
        double d2 = 0.0;
        boolean bl2 = false;
        for (Object object : this.assignedModifiers) {
            if (!(((Modifier)object).getTotalValue() > 0.0)) continue;
            d2 += ((Modifier)object).getTotalValue();
            bl2 = true;
        }
        if (this.getParentList() != null) {
            Object object;
            ArrayList<Modifier> arrayList = this.getParentList().getAssignedModifiers();
            object = arrayList.iterator();
            while (object.hasNext()) {
                Modifier modifier = (Modifier)object.next();
                if (modifier.getXMLID().equals("CHARGES") && this.getParentList() instanceof Multipower || !(modifier.getTotalValue() > 0.0) || GenericObject.findObjectByID(this.getAssignedModifiers(), modifier.getXMLID()) != null && !modifier.getXMLID().equals("GENERIC_OBJECT") && !modifier.getXMLID().equals("CUSTOM_MODIFIER") || this.getParentList() instanceof Multipower || this.getParentList() instanceof ElementalControl) continue;
                d2 += modifier.getTotalValue();
                bl2 = true;
            }
        }
        double d3 = d * (1.0 + d2);
        this.rec.setParent(this.getParentList());
        if (bl2) {
            d3 = Rounder.roundHalfDown(d3);
        }
        if (!bl) {
            d3 += this.rec.getActiveCost();
        }
        return d3;
    }

    @Override
    public String getColumn2Output() {
        String string;
        String string2;
        if (this.getLevels() == 0) {
            String string3;
            String string4;
            String string5 = this.rec.getAlias() + " " + this.rec.getDamageDisplay();
            if (this.rec.getName().trim().length() > 0) {
                string5 = "<i>" + this.rec.getName() + ":</i>  " + string5;
            }
            string5 = string5 + " (" + this.rec.getLevels() + " REC)";
            if (this.rec.getInput() != null && this.rec.getInput().trim().length() > 0) {
                string5 = string5 + ":  " + this.rec.getInput();
            }
            if ((string4 = this.rec.getAdderString()).trim().length() > 0) {
                string5 = string5 + " (";
                string5 = string5 + "REC: " + string4;
                string5 = string5 + ")";
            }
            if ((string3 = this.rec.getModifierString()).trim().startsWith(";")) {
                string3 = string3.trim();
                string3 = string3.substring(1, string3.length());
            }
            if (string3.trim().length() > 0) {
                string5 = string5 + "; " + string3;
            }
            return string5;
        }
        String string6 = this.getAlias() + " " + this.getDamageDisplay();
        if (this.getName().trim().length() > 0) {
            string6 = "<i>" + this.getName() + ":</i>  " + string6;
        }
        string6 = string6 + " (" + this.getLevels() + " END, " + this.rec.getLevels() + " REC)";
        if (this.getInput() != null && this.getInput().trim().length() > 0) {
            string6 = string6 + ":  " + this.getInput();
        }
        if (this.getSelectedOption() != null) {
            string6 = string6 + " (";
            string6 = string6 + this.getSelectedOption().getAlias();
            string2 = this.getAdderString();
            string = this.rec.getAdderString();
            if (string2.trim().length() > 0 || string.trim().length() > 0) {
                string6 = string6 + "; " + string2;
                if (string2.trim().length() > 0) {
                    string6 = string6 + ", ";
                }
                if (string.trim().length() > 0) {
                    string6 = string6 + "REC: " + string;
                }
            }
            string6 = string6 + ")";
        } else {
            string2 = this.getAdderString();
            string = this.rec.getAdderString();
            if (string2.trim().length() > 0 || string.trim().length() > 0) {
                string6 = string6 + " (";
                string6 = string6 + string2;
                if (string2.trim().length() > 0) {
                    string6 = string6 + ", ";
                }
                if (string.trim().length() > 0) {
                    string6 = string6 + "REC: " + string;
                }
                string6 = string6 + ")";
            }
        }
        boolean bl = this.recIsSamePower();
        string = this.getModifierString();
        if (!bl && string.trim().length() > 0) {
            string6 = string6 + " Reserve: ";
            if (string.trim().startsWith(";")) {
                string = string.trim();
                string = string.substring(1, string.length());
            }
        }
        string6 = string6 + string;
        if (!bl) {
            String string7 = this.rec.getModifierString();
            if (string7.trim().startsWith(";")) {
                string7 = string7.trim();
                string7 = string7.substring(1, string7.length());
            }
            if (string7.trim().length() > 0) {
                string6 = string6 + "; REC: " + string7;
            }
        }
        return string6;
    }

    @Override
    public String getDamageDisplay() {
        return "";
    }

    @Override
    public GenericDialog getDialog(boolean bl, boolean bl2) {
        return new ENDReserveDialog(this, bl, bl2);
    }

    @Override
    public double getRealCostPreList() {
        boolean bl = this.recIsSamePower();
        double d = 0.0;
        d = bl ? this.getActiveCost() : super.getActiveCost();
        double d2 = 0.0;
        boolean bl2 = false;
        for (Object object : this.assignedModifiers) {
            if (!(((Modifier)object).getTotalValue() < 0.0)) continue;
            d2 += ((Modifier)object).getTotalValue();
            bl2 = true;
        }
        if (this.getParentList() != null) {
            Object object;
            ArrayList<Modifier> arrayList = this.getParentList().getAssignedModifiers();
            object = arrayList.iterator();
            while (object.hasNext()) {
                Modifier modifier = (Modifier)object.next();
                if (modifier.getTypes().contains("VPP") || modifier.getXMLID().equals("CHARGES") && this.getParentList() instanceof Multipower || !(modifier.getTotalValue() < 0.0) || GenericObject.findObjectByID(this.assignedModifiers, modifier.getXMLID()) != null && !modifier.getXMLID().equals("GENERIC_OBJECT") && !modifier.getXMLID().equals("CUSTOM_MODIFIER")) continue;
                d2 += modifier.getTotalValue();
                bl2 = true;
            }
        }
        double d3 = d / (1.0 + Math.abs(d2));
        if (bl2) {
            d3 = Rounder.roundHalfDown(d3);
        }
        this.rec.setParent(this.getParentList());
        if (!bl) {
            d3 += this.rec.getRealCostPreList();
        }
        if (d3 == 0.0 && d > 0.0) {
            d3 = 1.0;
        }
        if (HeroDesigner.getActiveHero() != null && HeroDesigner.getActiveHero().getRules().multiplierAllowed() && this.getMultiplier() != 1.0) {
            d3 *= this.getMultiplier();
            d3 = Rounder.roundHalfDown(d3);
        } else if (HeroDesigner.getActiveHero() != null && HeroDesigner.getActiveHero().getRules().multiplierAllowed() && this.getParentList() != null && this.getParentList().getMultiplier() != 1.0) {
            d3 *= this.getParentList().getMultiplier();
            d3 = Rounder.roundHalfDown(d3);
        }
        if (this.getQuantity() > 1) {
            int n = 0;
            for (double d4 = (double)this.getQuantity(); d4 > 1.0; d4 /= 2.0) {
                ++n;
            }
            d3 += (double)(n * 5);
        }
        return d3;
    }

    public EnduranceReserveRecovery getRecovery() {
        return this.rec;
    }

    @Override
    public Element getSaveXML() {
        Element element = super.getSaveXML();
        element.addContent(this.rec.getSaveXML());
        return element;
    }

    @Override
    protected void init(Element element) {
        super.init(element);
        this.rec = new EnduranceReserveRecovery(element);
    }

    public boolean recIsSamePower() {
        if (this.rec == null) {
            return true;
        }
        if (this.getAssignedModifiers().size() == this.rec.getAssignedModifiers().size()) {
            block0: for (Modifier modifier : this.getAssignedModifiers()) {
                for (Modifier modifier2 : this.rec.getAssignedModifiers()) {
                    if (!modifier2.getColumn2Output().equals(modifier.getColumn2Output())) continue;
                    continue block0;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public void restoreFromSave(Element element) {
        super.restoreFromSave(element);
        Element element2 = element.getChild("POWER");
        if (element2 != null) {
            this.rec.restoreFromSave(element2);
        }
    }

    public void setRecovery(EnduranceReserveRecovery enduranceReserveRecovery) {
        this.rec = enduranceReserveRecovery;
    }
}

