/*
 * Decompiled with CFR 0.152.
 */
package com.hero.objects.powers;

import com.hero.HeroDesigner;
import com.hero.objects.Adder;
import com.hero.objects.GenericObject;
import com.hero.objects.modifiers.Modifier;
import com.hero.objects.powers.Automaton;
import com.hero.objects.powers.Power;
import com.hero.ui.dialog.DuplicationDialog;
import com.hero.ui.dialog.GenericDialog;
import com.hero.util.XMLUtility;
import java.io.File;
import java.util.Date;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;

public class Duplication
extends Power {
    private static String xmlID = "DUPLICATION";
    private int overCost = 1;
    private int overVal = 1;
    private int multiplierCost = 5;
    private int multiplierVal = 2;
    private int multiples = 1;
    private int points = 0;
    private String filePath;
    private Date fileAssociationLastCheck;

    public Duplication(Element element) {
        super(element, xmlID);
    }

    private void checkFileAssociation() {
        if (this.filePath == null) {
            return;
        }
        File file = new File(this.filePath);
        if (!file.exists()) {
            file = new File(HeroDesigner.getInstance().getPrefs().getSaveDir() + File.separator + file.getName());
        }
        if (!file.exists()) {
            return;
        }
        if (file.lastModified() > this.fileAssociationLastCheck.getTime()) {
            this.setFilePath(this.filePath);
        }
    }

    public void clearFilePath() {
        this.filePath = null;
        this.fileAssociationLastCheck = null;
    }

    @Override
    public String getColumn2Output() {
        String string = this.getAlias();
        if (this.getName() != null && this.getName().trim().length() > 0) {
            string = "<i>" + this.getName() + ":</i>  " + string;
        }
        string = string + " (";
        if (this.multiples > 1) {
            string = string + "creates " + this.multiples + " ";
            string = string + this.points + "-point Duplicates)";
        } else {
            string = string + "creates " + this.points + "-point form)";
        }
        String string2 = this.getAdderString();
        if (string2.trim().length() > 0) {
            string = string + ", ";
            string = string + string2;
        }
        string = string + this.getModifierString();
        return string;
    }

    @Override
    public String getDamageDisplay() {
        return "";
    }

    @Override
    public GenericDialog getDialog(boolean bl, boolean bl2) {
        DuplicationDialog duplicationDialog = new DuplicationDialog(this, bl);
        return duplicationDialog;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public int getMultiples() {
        return this.multiples;
    }

    public int getMultiplierCost() {
        return this.multiplierCost;
    }

    public int getMultiplierVal() {
        return this.multiplierVal;
    }

    public int getOverCost() {
        return this.overCost;
    }

    public int getOverVal() {
        return this.overVal;
    }

    public int getPoints() {
        this.checkFileAssociation();
        return this.points;
    }

    @Override
    public Element getSaveXML() {
        Element element = super.getSaveXML();
        element.setAttribute("NUMBER", "" + this.getMultiples());
        element.setAttribute("POINTS", "" + this.points);
        if (this.filePath != null) {
            element.setAttribute("FILE_ASSOCIATION", this.filePath);
        }
        return element;
    }

    @Override
    public double getTotalCost() {
        Automaton automaton;
        this.enhancerApplied = null;
        double d = this.getBaseCost();
        int n = HeroDesigner.getActiveHero().getBasePoints() + HeroDesigner.getActiveHero().getDisadPoints() + HeroDesigner.getActiveHero().getExperience();
        if (HeroDesigner.getActiveTemplate().is6E()) {
            n -= HeroDesigner.getActiveHero().getDisadPoints();
        }
        if (this.points <= n || HeroDesigner.getActiveTemplate().is6E()) {
            d += (double)this.points / this.levelValue * this.levelCost;
        } else {
            Modifier modifier = null;
            for (Object object2 : this.availableModifiers) {
                if (!((GenericObject)object2).getXMLID().equals("ALTEREDDUPLICATES")) continue;
                modifier = ((Modifier)object2).clone();
                break;
            }
            if (modifier != null) {
                boolean bl = false;
                block1: for (Modifier object3 : this.getAssignedModifiers()) {
                    if (!object3.getXMLID().equals(modifier.getXMLID())) continue;
                    modifier = object3;
                    bl = true;
                    if (modifier.getSelectedOption().equals("ALL")) continue;
                    for (Adder adder : modifier.getOptions()) {
                        if (!adder.getXMLID().equals("ALL")) continue;
                        modifier.setSelectedOption(adder);
                        break block1;
                    }
                }
                if (!bl) {
                    if (!modifier.getSelectedOption().equals("ALL")) {
                        for (Adder adder : modifier.getOptions()) {
                            if (!adder.getXMLID().equals("ALL")) continue;
                            modifier.setSelectedOption(adder);
                            break;
                        }
                    }
                    this.getAssignedModifiers().add(modifier);
                }
            }
            int n2 = n;
            int n3 = this.points - n;
            d += (double)n3 / (double)this.overVal * (double)this.overCost;
            d += (double)n2 / this.levelValue * this.levelCost;
        }
        int n4 = 0;
        double d2 = this.multiples;
        while (d2 > 1.0) {
            d2 /= (double)this.getMultiplierVal();
            ++n4;
        }
        d += (double)(n4 * this.getMultiplierCost());
        for (Adder adder : this.getAssignedAdders()) {
            if (!(adder.getRealCost() > 0.0)) continue;
            d += adder.getRealCost();
        }
        if (d < this.minimumCost && this.minSet) {
            d = this.getMinimumCost();
        } else if (d > this.maxCost && this.maxSet) {
            d = this.getMaxCost();
        }
        for (Adder adder : this.getAssignedAdders()) {
            if (!(adder.getRealCost() < 0.0)) continue;
            d += adder.getRealCost();
        }
        if (this.getTypes().contains("DEFENSE") && HeroDesigner.getActiveHero() != null && GenericObject.findObjectByID(HeroDesigner.getActiveHero().getPowers(), "AUTOMATON") != null && (automaton = (Automaton)GenericObject.findObjectByID(HeroDesigner.getActiveHero().getPowers(), "AUTOMATON")).getSelectedOption().getXMLID().toUpperCase().startsWith("NOSTUN")) {
            d *= (double)automaton.getDefenseCostMultiplier();
        }
        return d;
    }

    @Override
    protected void init(Element element) {
        this.display = "Duplication";
        this.alias = "Duplication";
        this.baseCost = 0.0;
        this.levelCost = 1.0;
        this.levelValue = 5.0;
        this.minimumCost = 1.0;
        super.init(element);
        String string = XMLUtility.getValue(element, "OVERCOST");
        if (string != null && string.trim().length() > 0) {
            try {
                this.overCost = Integer.parseInt(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((string = XMLUtility.getValue(element, "OVERVAL")) != null && string.trim().length() > 0) {
            try {
                this.overVal = Integer.parseInt(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((string = XMLUtility.getValue(element, "MULTIPLIERCOST")) != null && string.trim().length() > 0) {
            try {
                this.multiplierCost = Integer.parseInt(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((string = XMLUtility.getValue(element, "MULTIPLIERVAL")) != null && string.trim().length() > 0) {
            try {
                this.multiplierVal = Integer.parseInt(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void restoreFromSave(Element element) {
        super.restoreFromSave(element);
        String string = XMLUtility.getValue(element, "NUMBER");
        if (string != null && string.trim().length() > 0) {
            try {
                this.multiples = Integer.parseInt(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((string = XMLUtility.getValue(element, "POINTS")) != null && string.trim().length() > 0) {
            try {
                this.points = Integer.parseInt(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((string = XMLUtility.getValue(element, "FILE_ASSOCIATION")) != null && string.trim().length() > 0) {
            this.setFilePath(string);
        }
    }

    public void setFilePath(String string) {
        File file = new File(string);
        if (!file.exists()) {
            file = new File(HeroDesigner.getInstance().getPrefs().getSaveDir() + File.separator + file.getName());
        }
        if (file.exists() && file.canRead()) {
            try {
                SAXBuilder sAXBuilder = new SAXBuilder(false);
                Document document = sAXBuilder.build(file);
                sAXBuilder = null;
                Element element = document.getRootElement();
                Element element2 = element.getChild("BASIC_CONFIGURATION");
                String string2 = XMLUtility.getValue(element2, "BASE_POINTS");
                if (string2 != null && string2.trim().length() > 0) {
                    try {
                        this.points = Integer.parseInt(string2);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((string2 = XMLUtility.getValue(element2, "DISAD_POINTS")) != null && string2.trim().length() > 0) {
                    try {
                        this.points += Integer.parseInt(string2);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((string2 = XMLUtility.getValue(element2, "EXPERIENCE")) != null && string2.trim().length() > 0) {
                    try {
                        this.points += Integer.parseInt(string2);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.filePath = string;
                this.fileAssociationLastCheck = new Date();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void setMultiples(int n) {
        this.multiples = n;
    }

    public void setMultiplierCost(int n) {
        this.multiplierCost = n;
    }

    public void setMultiplierVal(int n) {
        this.multiplierVal = n;
    }

    public void setOverCost(int n) {
        this.overCost = n;
    }

    public void setOverVal(int n) {
        this.overVal = n;
    }

    public void setPoints(int n) {
        this.points = n;
    }
}

