/*
 * Decompiled with CFR 0.152.
 */
package com.hero.objects.powers;

import com.hero.HeroDesigner;
import com.hero.objects.ElementalControl;
import com.hero.objects.GenericObject;
import com.hero.objects.Multipower;
import com.hero.objects.VariablePowerPool;
import com.hero.objects.modifiers.Modifier;
import com.hero.objects.powers.Power;
import com.hero.ui.dialog.DifferingModifierDialog;
import com.hero.ui.dialog.GenericDialog;
import com.hero.ui.widgets.PopupMessage;
import com.hero.util.Rounder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.jdom.Element;

public class DifferingModifier
extends Power {
    private static String xmlID = "DIFFERINGMODIFIER";

    public DifferingModifier(Element element) {
        super(element, xmlID);
    }

    @Override
    public double getActiveCost() {
        double d = this.getLevels();
        double d2 = 0.0;
        for (int i = 0; i < this.getAssignedModifiers().size(); ++i) {
            Modifier modifier = this.getAssignedModifiers().get(i);
            if (!(modifier.getTotalValue() >= 0.0)) continue;
            d2 += modifier.getTotalValue();
        }
        if (this.getParentList() != null) {
            ArrayList<Modifier> arrayList = this.getParentList().getAssignedModifiers();
            for (int i = 0; i < arrayList.size(); ++i) {
                Modifier modifier = arrayList.get(i);
                if (modifier.getTypes().contains("VPP") || modifier.getXMLID().equals("CHARGES") && this.getParentList() instanceof Multipower || !(modifier.getTotalValue() > 0.0) || GenericObject.findObjectByID(this.assignedModifiers, modifier.getXMLID()) != null && !modifier.getXMLID().equals("GENERIC_OBJECT") && !modifier.getXMLID().equals("CUSTOM_MODIFIER") || this.getParentList() instanceof Multipower || this.getParentList() instanceof ElementalControl) continue;
                d2 += modifier.getTotalValue();
            }
        }
        if (d2 > 0.0) {
            d = Rounder.roundHalfDown(d * (1.0 + d2));
        }
        return d;
    }

    @Override
    public double getActiveCost(String string) {
        double d = this.getLevels();
        double d2 = 0.0;
        for (int i = 0; i < this.getAssignedModifiers().size(); ++i) {
            Modifier modifier = this.getAssignedModifiers().get(i);
            if (modifier.getXMLID().equals(string) || !(modifier.getTotalValue() >= 0.0)) continue;
            d2 += modifier.getTotalValue();
        }
        if (this.getParentList() != null) {
            ArrayList<Modifier> arrayList = this.getParentList().getAssignedModifiers();
            for (int i = 0; i < arrayList.size(); ++i) {
                Modifier modifier = arrayList.get(i);
                if (modifier.getTypes().contains("VPP") || modifier.getXMLID().equals("CHARGES") && this.getParentList() instanceof Multipower || !(modifier.getTotalValue() > 0.0) || GenericObject.findObjectByID(this.assignedModifiers, modifier.getXMLID()) != null && !modifier.getXMLID().equals("GENERIC_OBJECT") && !modifier.getXMLID().equals("CUSTOM_MODIFIER") || this.getParentList() instanceof Multipower || this.getParentList() instanceof ElementalControl || modifier.getXMLID().equals(string)) continue;
                d2 += modifier.getTotalValue();
            }
        }
        if (d2 > 0.0) {
            d = Rounder.roundHalfDown(d * (1.0 + d2));
        }
        return d;
    }

    @Override
    public String getColumn2Output() {
        String string = this.getModifierString();
        string = this.getInput() != null && this.getInput().trim().length() > 0 ? string + " for up to " + this.getLevels() + " Points of " + this.getInput() : this.getAlias() + ": " + string + " for up to " + this.getLevels() + " Points of [unknown]";
        if (this.getName().trim().length() > 0) {
            string = "<i>" + this.getName() + ":</i>  " + string;
        }
        string = string.trim();
        String string2 = this.getAdderString();
        if (string2.trim().length() > 0) {
            string = string + " (" + string2 + ")";
        }
        if (this.getEndUsage() > 0 && HeroDesigner.getActiveHero() != null && GenericObject.findObjectByID(HeroDesigner.getActiveHero().getPowers(), "ENDURANCERESERVE") != null && GenericObject.findObjectByID(this.getAllAssignedModifiers(), "ENDRESERVEOREND") == null && !HeroDesigner.getInstance().getPrefs().useWG()) {
            string = this.getUseENDReserve() ? string + " (uses END Reserve)" : string + " (uses Personal END)";
        }
        return string;
    }

    @Override
    public String getDamageDisplay() {
        return "";
    }

    @Override
    public String getDefinition() {
        String string = "";
        for (Modifier modifier : this.getAssignedModifiers()) {
            if (modifier.isPrivate()) continue;
            if (string.trim().length() > 0) {
                string = string + "\n\n";
            }
            string = string + modifier.getAlias() + ":  " + (modifier.getDefinition().trim().length() > 0 ? PopupMessage.normalizeText(modifier.getDefinition()) : "[no definition available]");
        }
        return string;
    }

    @Override
    public GenericDialog getDialog(boolean bl, boolean bl2) {
        return new DifferingModifierDialog(this, bl, bl2);
    }

    @Override
    public int getEndUsage() {
        for (Modifier modifier : this.getAssignedModifiers()) {
            if (modifier.isPrivate() || !modifier.getXMLID().equals("REDUCEDEND")) continue;
            return 0;
        }
        return super.getEndUsage();
    }

    @Override
    public String getModifierString() {
        String string = "";
        ArrayList arrayList = (ArrayList)this.assignedModifiers.clone();
        if (this.getParentList() != null && HeroDesigner.getInstance().getPrefs().showCommonLimitations()) {
            ArrayList<Modifier> arrayList2 = this.getParentList().getAssignedModifiers();
            Object object = arrayList2.iterator();
            while (object.hasNext()) {
                Modifier modifier = object.next();
                if (modifier.getTypes().contains("VPP") || modifier.getXMLID().equals("CHARGES") && this.getParentList() instanceof Multipower || !(modifier.getTotalValue() < 0.0) && !(this.getParentList() instanceof VariablePowerPool) || GenericObject.findObjectByID(this.assignedModifiers, modifier.getXMLID()) != null && !modifier.getXMLID().equals("GENERIC_OBJECT") && !modifier.getXMLID().equals("CUSTOM_MODIFIER") && !modifier.getXMLID().equals("MODIFIER")) continue;
                arrayList.add(modifier);
            }
        }
        Collections.sort(arrayList, new Comparator(){

            public int compare(Object object, Object object2) {
                if (object instanceof Modifier && object2 instanceof Modifier) {
                    Modifier modifier = (Modifier)object;
                    Modifier modifier2 = (Modifier)object2;
                    return (int)((modifier.getTotalValue() - modifier2.getTotalValue()) * 100.0);
                }
                return -1;
            }
        });
        for (Object object : arrayList) {
            if (!(((Modifier)object).getTotalValue() >= 0.0) || !((Modifier)object).displayInString()) continue;
            if (string.length() > 0) {
                string = string + ", ";
            }
            string = string + ((Modifier)object).getColumn2Output();
        }
        if (this.displayActiveCost && (this.getActiveCost() != this.getTotalCost() || this.getRealCost() != this.getTotalCost())) {
            string = string + " (" + Rounder.roundUp(this.getActiveCost()) + " Active Points)";
        }
        int n = 0;
        for (Modifier modifier : arrayList) {
            if (!(modifier.getTotalValue() < 0.0) || !modifier.displayInString()) continue;
            string = ++n == 1 ? string + "; " : string + ", ";
            string = string + modifier.getColumn2Output();
        }
        return string;
    }

    @Override
    public double getRealCostPreList() {
        double d = this.getActiveCost();
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i = 0; i < this.getAssignedModifiers().size(); ++i) {
            Modifier modifier = this.getAssignedModifiers().get(i);
            if (modifier.getTotalValue() > 0.0) {
                d3 += modifier.getTotalValue();
                continue;
            }
            if (!(modifier.getTotalValue() <= 0.0)) continue;
            d2 += modifier.getTotalValue();
        }
        if (this.getParentList() != null) {
            ArrayList<Modifier> arrayList = this.getParentList().getAssignedModifiers();
            for (Modifier modifier : arrayList) {
                if (modifier.getTypes().contains("VPP") || modifier.getXMLID().equals("CHARGES") && this.getParentList() instanceof Multipower || GenericObject.findObjectByID(this.assignedModifiers, modifier.getXMLID()) != null && !modifier.getXMLID().equals("GENERIC_OBJECT") && !modifier.getXMLID().equals("CUSTOM_MODIFIER") || !(modifier.getTotalValue() < 0.0)) continue;
                d2 += modifier.getTotalValue();
            }
        }
        if (d2 != 0.0) {
            d = Rounder.roundHalfDown(d / (1.0 + Math.abs(d2)));
        }
        if (HeroDesigner.getActiveHero() != null && HeroDesigner.getActiveHero().getRules().multiplierAllowed() && this.getMultiplier() != 1.0) {
            d *= this.getMultiplier();
            d = Rounder.roundHalfDown(d);
        } else if (HeroDesigner.getActiveHero() != null && HeroDesigner.getActiveHero().getRules().multiplierAllowed() && this.getParentList() != null && this.getParentList().getMultiplier() != 1.0) {
            d *= this.getParentList().getMultiplier();
            d = Rounder.roundHalfDown(d);
        }
        if (this.getQuantity() > 1) {
            int n = 0;
            for (double d4 = (double)this.getQuantity(); d4 > 1.0; d4 /= 2.0) {
                ++n;
            }
            d += (double)(n * 5);
        }
        return d -= (double)this.getLevels();
    }

    @Override
    public Element getSaveXML() {
        Element element = super.getSaveXML();
        return element;
    }

    @Override
    public void restoreFromSave(Element element) {
        super.restoreFromSave(element);
    }
}

