/*
 * Decompiled with CFR 0.152.
 */
package com.hero.objects.powers;

import com.hero.HeroDesigner;
import com.hero.objects.Adder;
import com.hero.objects.GenericObject;
import com.hero.objects.characteristics.Intelligence;
import com.hero.objects.powers.Sense;
import com.hero.util.Rounder;
import com.hero.util.XMLUtility;
import java.util.ArrayList;
import org.jdom.Element;

public class Detect
extends Sense {
    private static String xmlID = "DETECT";

    public Detect(Element element) {
        super(element, xmlID);
    }

    @Override
    public String getColumn2Output() {
        String string = this.getAlias();
        if (this.getName().trim().length() > 0) {
            string = "<i>" + this.getName() + ":</i>  " + string;
        }
        String string2 = this.getSelectedOption().getAlias();
        boolean bl = false;
        ArrayList<Adder> arrayList = this.getAssignedAdders();
        for (Adder adder : arrayList) {
            if (!adder.getXMLID().equals("EXTRA")) continue;
            string2 = string2 + ", " + adder.getAlias();
            bl = true;
            adder.setDisplayInString(false);
        }
        if (bl) {
            string2 = string2.substring(0, string2.lastIndexOf(",")) + " and" + string2.substring(string2.lastIndexOf(",") + 1, string2.length());
        }
        string = string + " " + string2;
        string = string + " " + this.getDamageDisplay();
        if (this.getGroup() != null && this.getAvailableGroups().size() > 1) {
            string = string + " (" + this.getGroup().getAlias() + ")";
        } else if (this.getGroup() == null && this.getAvailableGroups().size() > 1) {
            string = string + " (Unusual Group)";
        }
        String string3 = this.getAdderString();
        if (string3.trim().length() > 0) {
            string = string + ", " + (String)string3;
        }
        string = string + this.getModifierString();
        if (this.getEndUsage() > 0 && GenericObject.findObjectByID(HeroDesigner.getActiveHero().getPowers(), "ENDURANCERESERVE") != null && GenericObject.findObjectByID(this.getAllAssignedModifiers(), "ENDRESERVEOREND") == null && !HeroDesigner.getInstance().getPrefs().useWG()) {
            string = this.getUseENDReserve() ? string + " (uses END Reserve)" : string + " (uses Personal END)";
        }
        return string;
    }

    protected boolean isFocus() {
        if (GenericObject.findObjectByID(this.getAssignedModifiers(), "FOCUS") != null) {
            return true;
        }
        return this.getParentList() != null && GenericObject.findObjectByID(this.getParentList().getAssignedModifiers(), "FOCUS") != null;
    }

    @Override
    public String getDamageDisplay() {
        int n = 0;
        int n2 = 0;
        String string = "";
        if (this.isFocus() && HeroDesigner.getActiveHero() != null) {
            int n3 = HeroDesigner.getActiveHero().getRules().getSkillRollBase();
            n3 = this.getLevels() < 0 ? this.getMinimumLevel() : (n3 += this.getLevels());
            string = "" + (9 + this.getLevels()) + "-";
        } else {
            Intelligence intelligence = (Intelligence)HeroDesigner.getActiveHero().getCharacteristic(5);
            if (intelligence == null) {
                intelligence = new Intelligence(new Element("INT"));
                intelligence.setLevels((int)Rounder.roundHalfDown((double)HeroDesigner.getActiveTemplate().getGeneralLevel() - intelligence.getBaseValue()));
            }
            n = intelligence.getPrimaryPERRoll() + this.getLevels();
            n2 = intelligence.getSecondaryPERRoll() + this.getLevels();
            string = "" + n + "-";
            if (n != n2) {
                string = string + "/" + n2 + "-";
            }
        }
        return string;
    }

    @Override
    public Element getSaveXML() {
        Element element = super.getSaveXML();
        element.setAttribute("ACTIVE", this.active ? "Yes" : "No");
        return element;
    }

    @Override
    public void restoreFromSave(Element element) {
        super.restoreFromSave(element);
        String string = XMLUtility.getValue(element, "ACTIVE");
        this.active = string != null && string.trim().toUpperCase().startsWith("Y");
    }
}

