/*
 * Decompiled with CFR 0.152.
 */
package com.hero.objects.powers;

import com.hero.HeroDesigner;
import com.hero.objects.GenericObject;
import com.hero.objects.powers.Power;
import com.hero.ui.dialog.DamageResistanceDialog;
import com.hero.ui.dialog.GenericDialog;
import com.hero.util.XMLUtility;
import org.jdom.Element;

public class DamageResistance
extends Power {
    private static String xmlID = "DAMAGERESISTANCE";
    private int pdLevels;
    private int edLevels;
    private int mdLevels;
    private int fdLevels;
    private int powdLevels;

    public DamageResistance(Element element) {
        super(element, xmlID);
    }

    @Override
    public String getColumn2Output() {
        String string = this.getAlias() + " " + this.getDamageDisplay();
        if (this.getName().trim().length() > 0) {
            string = "<i>" + this.getName() + ":</i>  " + string;
        }
        string = string + "(";
        if (this.pdLevels > 0) {
            string = string + this.pdLevels + " PD";
        }
        if (this.edLevels > 0) {
            if (this.pdLevels > 0) {
                string = string + "/";
            }
            string = string + this.edLevels + " ED";
        }
        if (this.mdLevels > 0) {
            if (this.pdLevels > 0 || this.edLevels > 0) {
                string = string + "/";
            }
            string = string + this.mdLevels + " Mental Def.";
        }
        if (this.fdLevels > 0) {
            if (this.pdLevels > 0 || this.edLevels > 0 || this.mdLevels > 0) {
                string = string + "/";
            }
            string = string + this.fdLevels + " Flash Def.";
        }
        if (this.powdLevels > 0) {
            if (this.pdLevels > 0 || this.edLevels > 0 || this.mdLevels > 0 || this.fdLevels > 0) {
                string = string + "/";
            }
            string = string + this.powdLevels + " Power Def.";
        }
        string = string + ")";
        if (this.getInput() != null && this.getInput().trim().length() > 0) {
            string = string + ":  " + this.getInput();
        }
        if (this.getSelectedOption() != null) {
            string = string + " (";
            string = string + this.getSelectedOption().getAlias();
            String string2 = this.getAdderString();
            if (string2.trim().length() > 0) {
                string = string + "; " + string2;
            }
            string = string + ")";
        } else {
            String string3 = this.getAdderString();
            if (string3.trim().length() > 0) {
                string = string + " (" + string3 + ")";
            }
        }
        string = string + this.getModifierString();
        if (this.getEndUsage() > 0 && GenericObject.findObjectByID(HeroDesigner.getActiveHero().getPowers(), "ENDURANCERESERVE") != null && GenericObject.findObjectByID(this.getAllAssignedModifiers(), "ENDRESERVEOREND") == null && !HeroDesigner.getInstance().getPrefs().useWG()) {
            string = this.getUseENDReserve() ? string + " (uses END Reserve)" : string + " (uses Personal END)";
        }
        return string;
    }

    @Override
    public String getDamageDisplay() {
        String string = "";
        return string;
    }

    @Override
    public GenericDialog getDialog(boolean bl, boolean bl2) {
        return new DamageResistanceDialog(this, bl, bl2);
    }

    public int getEdLevels() {
        return this.edLevels;
    }

    public int getFdLevels() {
        return this.fdLevels;
    }

    @Override
    public int getLevels() {
        return this.pdLevels + this.edLevels + this.mdLevels + this.fdLevels + this.powdLevels;
    }

    @Override
    public int getMdLevels() {
        return this.mdLevels;
    }

    public int getPdLevels() {
        return this.pdLevels;
    }

    public int getPowdLevels() {
        return this.powdLevels;
    }

    @Override
    public Element getSaveXML() {
        Element element = super.getSaveXML();
        element.setAttribute("PDLEVELS", "" + this.pdLevels);
        element.setAttribute("EDLEVELS", "" + this.edLevels);
        element.setAttribute("MDLEVELS", "" + this.mdLevels);
        element.setAttribute("FDLEVELS", "" + this.fdLevels);
        element.setAttribute("POWDLEVELS", "" + this.powdLevels);
        return element;
    }

    @Override
    public void restoreFromSave(Element element) {
        super.restoreFromSave(element);
        String string = XMLUtility.getValue(element, "PDLEVELS");
        if (string != null && string.trim().length() > 0) {
            try {
                this.pdLevels = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((string = XMLUtility.getValue(element, "EDLEVELS")) != null && string.trim().length() > 0) {
            try {
                this.edLevels = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((string = XMLUtility.getValue(element, "MDLEVELS")) != null && string.trim().length() > 0) {
            try {
                this.mdLevels = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((string = XMLUtility.getValue(element, "FDLEVELS")) != null && string.trim().length() > 0) {
            try {
                this.fdLevels = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((string = XMLUtility.getValue(element, "POWDLEVELS")) != null && string.trim().length() > 0) {
            try {
                this.powdLevels = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.setLevels(this.pdLevels + this.edLevels + this.mdLevels + this.fdLevels + this.powdLevels);
    }

    public void setEdLevels(int n) {
        this.edLevels = n;
        this.setLevels(this.pdLevels + n + this.mdLevels + this.fdLevels + this.powdLevels);
    }

    public void setFdLevels(int n) {
        this.fdLevels = n;
        this.setLevels(this.pdLevels + this.edLevels + this.mdLevels + n + this.powdLevels);
    }

    public void setMdLevels(int n) {
        this.mdLevels = n;
        this.setLevels(this.pdLevels + this.edLevels + n + this.fdLevels + this.powdLevels);
    }

    public void setPdLevels(int n) {
        this.pdLevels = n;
        this.setLevels(n + this.edLevels + this.mdLevels + this.fdLevels + this.powdLevels);
    }

    public void setPowdLevels(int n) {
        this.powdLevels = n;
        this.setLevels(this.pdLevels + this.edLevels + this.mdLevels + this.fdLevels + n);
    }
}

