/*
 * Decompiled with CFR 0.152.
 */
package com.hero.objects.powers;

import com.hero.HeroDesigner;
import com.hero.objects.Adder;
import com.hero.objects.ElementalControl;
import com.hero.objects.GenericObject;
import com.hero.objects.Multipower;
import com.hero.objects.modifiers.Modifier;
import com.hero.objects.powers.Power;
import com.hero.ui.dialog.CustomPowerDialog;
import com.hero.ui.dialog.GenericDialog;
import com.hero.util.Rounder;
import com.hero.util.XMLUtility;
import java.util.ArrayList;
import java.util.Collections;
import org.jdom.Element;

public class CustomPower
extends Power {
    private static String xmlID = "CUSTOMPOWER";
    private String col3Output = null;
    private boolean useCustomColumn3 = false;

    public CustomPower(Element element) {
        super(element, xmlID);
    }

    @Override
    public double getActiveCost() {
        double d = this.baseCost;
        for (Adder adder : this.getAssignedAdders()) {
            if (!adder.isRequired()) continue;
            d += adder.getRealCost();
        }
        for (Adder adder : this.getAssignedAdders()) {
            if (adder.isRequired() || !(adder.getRealCost() > 0.0)) continue;
            d += adder.getRealCost();
        }
        if (d < this.getMinimumCost() && this.isMinSet()) {
            d = this.getMinimumCost();
        } else if (d > this.getMaxCost() && this.isMaxSet()) {
            d = this.getMaxCost();
        }
        for (Adder adder : this.getAssignedAdders()) {
            if (adder.isRequired() || !(adder.getRealCost() < 0.0)) continue;
            d += adder.getRealCost();
        }
        double d2 = 0.0;
        boolean bl = false;
        for (int i = 0; i < this.assignedModifiers.size(); ++i) {
            Modifier modifier = (Modifier)this.assignedModifiers.get(i);
            if (!(modifier.getTotalValue() > 0.0)) continue;
            d2 += modifier.getTotalValue();
            bl = true;
        }
        if (this.getParentList() != null) {
            ArrayList<Modifier> arrayList = this.getParentList().getAssignedModifiers();
            for (Modifier modifier : arrayList) {
                if (modifier.getTypes().contains("VPP") || modifier.getXMLID().equals("CHARGES") && this.getParentList() instanceof Multipower || !(modifier.getTotalValue() > 0.0) || GenericObject.findObjectByID(this.assignedModifiers, modifier.getXMLID()) != null && !modifier.getXMLID().equals("GENERIC_OBJECT") && !modifier.getXMLID().equals("CUSTOM_MODIFIER") && !modifier.getXMLID().equals("MODIFIER") || this.getParentList() instanceof Multipower || this.getParentList() instanceof ElementalControl) continue;
                d2 += modifier.getTotalValue();
                bl = true;
            }
        }
        double d3 = d * (1.0 + d2);
        if (bl) {
            d3 = Rounder.roundHalfDown(d3);
        }
        return d3;
    }

    @Override
    public double getActiveCost(String string) {
        double d = this.baseCost;
        for (Adder adder : this.getAssignedAdders()) {
            if (!adder.isRequired()) continue;
            d += adder.getRealCost();
        }
        for (Adder adder : this.getAssignedAdders()) {
            if (adder.isRequired() || !(adder.getRealCost() > 0.0)) continue;
            d += adder.getRealCost();
        }
        if (d < this.getMinimumCost() && this.isMinSet()) {
            d = this.getMinimumCost();
        } else if (d > this.getMaxCost() && this.isMaxSet()) {
            d = this.getMaxCost();
        }
        for (Adder adder : this.getAssignedAdders()) {
            if (adder.isRequired() || !(adder.getRealCost() < 0.0)) continue;
            d += adder.getRealCost();
        }
        double d2 = 0.0;
        boolean bl = false;
        for (Object object : this.assignedModifiers) {
            if (!(((Modifier)object).getTotalValue() > 0.0) || ((GenericObject)object).getXMLID().equals(string)) continue;
            d2 += ((Modifier)object).getTotalValue();
            bl = true;
        }
        if (this.getParentList() != null) {
            Object object;
            ArrayList<Modifier> arrayList = this.getParentList().getAssignedModifiers();
            object = arrayList.iterator();
            while (object.hasNext()) {
                Modifier modifier = (Modifier)object.next();
                if (modifier.getTypes().contains("VPP") || modifier.getXMLID().equals("CHARGES") && this.getParentList() instanceof Multipower || !(modifier.getTotalValue() > 0.0) || modifier.getXMLID().equals(string) || GenericObject.findObjectByID(this.assignedModifiers, modifier.getXMLID()) != null && !modifier.getXMLID().equals("GENERIC_OBJECT") && !modifier.getXMLID().equals("CUSTOM_MODIFIER") && !modifier.getXMLID().equals("MODIFIER") || this.getParentList() instanceof Multipower || this.getParentList() instanceof ElementalControl) continue;
                d2 += modifier.getTotalValue();
                bl = true;
            }
        }
        double d3 = d * (1.0 + d2);
        if (bl) {
            d3 = Rounder.roundHalfDown(d3);
        }
        return d3;
    }

    @Override
    public String getColumn3Output() {
        if (this.col3Output == null || !this.useCustomColumn3()) {
            return super.getColumn3Output();
        }
        return this.col3Output;
    }

    @Override
    public String getDamageDisplay() {
        return "";
    }

    @Override
    public GenericDialog getDialog(boolean bl, boolean bl2) {
        return new CustomPowerDialog(this, bl, bl2);
    }

    @Override
    public int getLevels() {
        return (int)Rounder.roundUp(this.baseCost);
    }

    @Override
    public double getRealCostPreList() {
        this.enhancerApplied = null;
        double d = this.getActiveCost();
        boolean bl = false;
        double d2 = 0.0;
        for (int i = 0; i < this.assignedModifiers.size(); ++i) {
            Modifier modifier = (Modifier)this.assignedModifiers.get(i);
            if (!(modifier.getTotalValue() < 0.0)) continue;
            d2 += modifier.getTotalValue();
            bl = true;
        }
        if (this.getParentList() != null) {
            ArrayList<Modifier> arrayList = this.getParentList().getAssignedModifiers();
            for (Modifier modifier : arrayList) {
                if (modifier.getTypes().contains("VPP") || modifier.getXMLID().equals("CHARGES") && this.getParentList() instanceof Multipower || !(modifier.getTotalValue() < 0.0 && GenericObject.findObjectByID(this.assignedModifiers, modifier.getXMLID()) == null || modifier.getXMLID().equals("GENERIC_OBJECT") || modifier.getXMLID().equals("CUSTOM_MODIFIER")) && !modifier.getXMLID().equals("MODIFIER")) continue;
                d2 += modifier.getTotalValue();
                bl = true;
            }
        }
        double d3 = d / (1.0 + Math.abs(d2));
        if (bl) {
            d3 = Rounder.roundHalfDown(d3);
        }
        if (d3 < 1.0 && (d > 0.0 || this.getLevels() > 0 && this.getAssignedAdders().size() == 0 && this.getBaseCost() >= 0.0)) {
            d3 = 1.0;
        }
        if (HeroDesigner.getActiveHero() != null && HeroDesigner.getActiveHero().getRules().multiplierAllowed() && this.getMultiplier() != 1.0) {
            d3 *= this.getMultiplier();
            d3 = Rounder.roundHalfDown(d3);
        } else if (HeroDesigner.getActiveHero() != null && HeroDesigner.getActiveHero().getRules().multiplierAllowed() && this.getParentList() != null && this.getParentList().getMultiplier() != 1.0) {
            d3 *= this.getParentList().getMultiplier();
            d3 = Rounder.roundHalfDown(d3);
        }
        if (this.getQuantity() > 1) {
            int n = 0;
            for (double d4 = (double)this.getQuantity(); d4 > 1.0; d4 /= 2.0) {
                ++n;
            }
            d3 += (double)(n * 5);
        }
        return d3;
    }

    @Override
    public Element getSaveXML() {
        Element element = super.getSaveXML();
        element.setAttribute("DOESBODY", this.doesBODY ? "Yes" : "No");
        element.setAttribute("DOESDAMAGE", this.doesDamage ? "Yes" : "No");
        element.setAttribute("DOESKNOCKBACK", this.doesKnockback ? "Yes" : "No");
        element.setAttribute("KILLING", this.killing ? "Yes" : "No");
        element.setAttribute("DEFENSE", this.getDefense());
        element.setAttribute("END", this.usesEND ? "Yes" : "No");
        element.setAttribute("VISIBLE", this.visible ? "Yes" : "No");
        element.setAttribute("RANGE", this.range);
        element.setAttribute("DURATION", this.duration);
        element.setAttribute("TARGET", this.target);
        element.setAttribute("BASECOST", "" + this.baseCost);
        element.setAttribute("ENDCOLUMNOUTPUT", this.col3Output == null || this.col3Output.trim().length() == 0 ? "" : this.col3Output);
        element.setAttribute("USECUSTOMENDCOLUMN", this.useCustomColumn3 ? "Yes" : "No");
        return element;
    }

    @Override
    public ArrayList<String> getTypes() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Object object = this.getAssignedAdders().iterator();
        while (object.hasNext()) {
            Adder adder = object.next();
            arrayList.add(adder.getXMLID());
        }
        if (GenericObject.findObjectByID(this.getAllAssignedModifiers(), "UOO") != null && ((GenericObject)(object = GenericObject.findObjectByID(this.getAllAssignedModifiers(), "UOO"))).getSelectedOption() != null && ((GenericObject)object).getSelectedOption().getXMLID().equals("UAA")) {
            arrayList.add("ATTACK");
        }
        return arrayList;
    }

    @Override
    protected void init(Element element) {
        this.duration = "INSTANT";
        this.target = "SELFONLY";
        this.range = "SELF";
        this.end = 10;
        this.display = "Custom Power";
        super.init(element);
        if (this.baseCost == 0.0) {
            this.baseCost = 1.0;
        }
        this.minimumLevel = -999;
        Collections.sort(this.availableAdders);
    }

    @Override
    public void restoreFromSave(Element element) {
        super.restoreFromSave(element);
        String string = XMLUtility.getValue(element, "END");
        if (string != null && string.trim().length() > 0) {
            this.usesEND = string.trim().toUpperCase().startsWith("Y");
        }
        this.doesBODY = (string = XMLUtility.getValue(element, "DOESBODY")) != null && string.trim().startsWith("Y");
        string = XMLUtility.getValue(element, "DOESDAMAGE");
        this.doesDamage = string != null && string.trim().startsWith("Y");
        string = XMLUtility.getValue(element, "DOESKNOCKBACK");
        this.doesKnockback = string != null && string.trim().startsWith("Y");
        string = XMLUtility.getValue(element, "KILLING");
        this.killing = string != null && string.trim().startsWith("Y");
        string = XMLUtility.getValue(element, "VISIBLE");
        this.visible = string != null && string.trim().startsWith("Y");
        string = XMLUtility.getValue(element, "DEFENSE");
        this.defense = string != null && string.trim().length() > 0 ? string : "NONE";
        string = XMLUtility.getValue(element, "RANGE");
        if (string != null && string.trim().length() > 0) {
            this.range = string;
        }
        if ((string = XMLUtility.getValue(element, "DURATION")) != null && string.trim().length() > 0) {
            this.duration = string;
        }
        if ((string = XMLUtility.getValue(element, "TARGET")) != null && string.trim().length() > 0) {
            this.target = string;
        }
        if ((string = XMLUtility.getValue(element, "BASECOST")) != null && string.trim().length() > 0) {
            try {
                this.baseCost = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((string = XMLUtility.getValue(element, "ENDCOLUMNOUTPUT")) != null && string.trim().length() > 0) {
            this.col3Output = string;
        }
        this.useCustomColumn3 = (string = XMLUtility.getValue(element, "USECUSTOMENDCOLUMN")) != null && string.trim().startsWith("Y");
    }

    public void setColumn3Output(String string) {
        this.col3Output = string;
    }

    public void setDefense(String string) {
        this.defense = string;
    }

    public void setDoesBODY(boolean bl) {
        this.doesBODY = bl;
    }

    public void setDoesDamage(boolean bl) {
        this.doesDamage = bl;
    }

    public void setDoesKnockback(boolean bl) {
        this.doesKnockback = bl;
    }

    public void setDuration(String string) {
        this.duration = string;
    }

    public void setKilling(boolean bl) {
        this.killing = bl;
    }

    @Override
    public void setLevels(int n) {
        this.baseCost = n;
    }

    public void setRange(String string) {
        this.range = string;
    }

    public void setTarget(String string) {
        this.target = string;
    }

    public void setUseCustomColumn3(boolean bl) {
        this.useCustomColumn3 = bl;
    }

    public boolean useCustomColumn3() {
        if (this.getAPPerEnd() != 0) {
            return false;
        }
        return this.useCustomColumn3;
    }

    public void usesEnd(boolean bl) {
        this.usesEND = bl;
    }
}

