/*
 * Decompiled with CFR 0.152.
 */
package com.hero.objects.powers;

import com.hero.HeroDesigner;
import com.hero.objects.Adder;
import com.hero.objects.CharAffectingObject;
import com.hero.objects.ElementalControl;
import com.hero.objects.GenericObject;
import com.hero.objects.List;
import com.hero.objects.Multipower;
import com.hero.objects.characteristics.Characteristic;
import com.hero.objects.modifiers.Charges;
import com.hero.objects.modifiers.Modifier;
import com.hero.objects.powers.DamageResistance;
import com.hero.objects.powers.Power;
import com.hero.ui.dialog.CompoundPowerDialog;
import com.hero.ui.dialog.GenericDialog;
import com.hero.util.Rounder;
import com.hero.util.XMLUtility;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import org.jdom.Element;

public class CompoundPower
extends Power {
    private static String xmlID = "COMPOUNDPOWER";
    private String listSeparator = " <b>plus</b> ";
    private ArrayList<GenericObject> powers = new ArrayList();

    public CompoundPower(Element element) {
        super(element, xmlID);
    }

    @Override
    public boolean affectsCharacteristics() {
        for (GenericObject genericObject : this.powers) {
            if (!(genericObject instanceof CharAffectingObject)) continue;
            CharAffectingObject charAffectingObject = (CharAffectingObject)genericObject;
            if (charAffectingObject.getStrIncrease() != 0.0) {
                return true;
            }
            if (charAffectingObject.getDexIncrease() != 0.0) {
                return true;
            }
            if (charAffectingObject.getConIncrease() != 0.0) {
                return true;
            }
            if (charAffectingObject.getBodyIncrease() != 0.0) {
                return true;
            }
            if (charAffectingObject.getIntIncrease() != 0.0) {
                return true;
            }
            if (charAffectingObject.getEgoIncrease() != 0.0) {
                return true;
            }
            if (charAffectingObject.getPreIncrease() != 0.0) {
                return true;
            }
            if (charAffectingObject.getComIncrease() != 0.0) {
                return true;
            }
            if (charAffectingObject.getPdIncrease() != 0.0) {
                return true;
            }
            if (charAffectingObject.getEdIncrease() != 0.0) {
                return true;
            }
            if (charAffectingObject.getSpdIncrease() != 0.0) {
                return true;
            }
            if (charAffectingObject.getRecIncrease() != 0.0) {
                return true;
            }
            if (charAffectingObject.getEndIncrease() != 0.0) {
                return true;
            }
            if (charAffectingObject.getStunIncrease() != 0.0) {
                return true;
            }
            if (charAffectingObject.getDefIncrease() != 0.0) {
                return true;
            }
            if (charAffectingObject.getSizeIncrease() != 0.0) {
                return true;
            }
            if (charAffectingObject.getRunningIncrease() != 0.0) {
                return true;
            }
            if (charAffectingObject.getSwimmingIncrease() != 0.0) {
                return true;
            }
            if (charAffectingObject.getLeapingIncrease() == 0.0) continue;
            return true;
        }
        return false;
    }

    @Override
    public CompoundPower clone() {
        CompoundPower compoundPower = (CompoundPower)super.clone();
        compoundPower.setPowers((ArrayList)this.getPowers().clone());
        return compoundPower;
    }

    @Override
    public double getActiveCost() {
        double d = 0.0;
        for (GenericObject genericObject : this.powers) {
            genericObject.setParent(this.getParentList());
            d += genericObject.getActiveCost();
            genericObject.setParent(null);
        }
        return d;
    }

    @Override
    public double getActiveCost(String string) {
        double d = 0.0;
        for (GenericObject genericObject : this.powers) {
            genericObject.setParent(this.getParentList());
            d += genericObject.getActiveCost(string);
            genericObject.setParent(null);
        }
        return d;
    }

    @Override
    public boolean getAffectPrimary() {
        for (GenericObject genericObject : this.powers) {
            CharAffectingObject charAffectingObject;
            if (!(genericObject instanceof CharAffectingObject) || !(charAffectingObject = (CharAffectingObject)genericObject).getAffectPrimary()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean getAffectTotal() {
        for (GenericObject genericObject : this.powers) {
            CharAffectingObject charAffectingObject;
            if (!(genericObject instanceof CharAffectingObject) || !(charAffectingObject = (CharAffectingObject)genericObject).getAffectTotal()) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getColumn2Output() {
        return this.getColumn2Output(true);
    }

    public String getColumn2Output(boolean bl) {
        String string = "";
        ArrayList<Object> arrayList = new ArrayList();
        if (this.getParentList() != null) {
            arrayList = this.getParentList().getAssignedModifiers();
        }
        for (GenericObject genericObject : this.powers) {
            ArrayList<Modifier> arrayList2 = genericObject.getAssignedModifiers();
            ArrayList arrayList3 = (ArrayList)genericObject.getAssignedModifiers().clone();
            for (int i = 0; i < arrayList.size() && HeroDesigner.getInstance().getPrefs().showCommonLimitations(); ++i) {
                Modifier modifier = (Modifier)arrayList.get(i);
                if (modifier instanceof Charges && this.getParentList() instanceof Multipower || !(modifier.getTotalValue() < 0.0) || GenericObject.findObjectByID(arrayList2, modifier.getXMLID()) != null && !modifier.getXMLID().equals("MODIFIER") && !modifier.getXMLID().equals("CUSTOM_MODIFIER") && !modifier.getXMLID().equals("GENERIC_OBJECT")) continue;
                arrayList3.add(modifier);
            }
            genericObject.setAssignedModifiers(arrayList3);
            if (string.trim().length() > 0) {
                string = string + this.listSeparator;
            }
            string = bl ? string + genericObject.getTextOutput() : string + genericObject.getNamelessColumn2Output();
            if (this.getDisplayActiveCost()) {
                string = string + " (Real Cost: " + Rounder.roundHalfDown(genericObject.getRealCostPreList()) + ")";
            }
            genericObject.setAssignedModifiers(arrayList2);
        }
        if (this.getDisplayActiveCost()) {
            string = "(Total: " + Rounder.roundHalfUp(this.getActiveCost()) + " Active Cost, " + Rounder.roundHalfUp(this.getRealCostPreList()) + " Real Cost) " + string;
        }
        if (this.getName() != null && this.getName().trim().length() > 0) {
            string = "<i>" + this.getName() + ":</i>  " + string;
        }
        return string;
    }

    @Override
    public String getColumn3Output() {
        if (this.getEndUsage() > 0) {
            return "" + this.getEndUsage();
        }
        GenericObject genericObject = null;
        for (GenericObject genericObject2 : this.getPowers()) {
            if (GenericObject.findObjectByID(genericObject2.getAssignedModifiers(), "CHARGES") == null) continue;
            genericObject = (Charges)GenericObject.findObjectByID(genericObject2.getAssignedModifiers(), "CHARGES");
            break;
        }
        if (genericObject == null) {
            return "0";
        }
        String string = genericObject.getSelectedOption().getAlias();
        if (GenericObject.findObjectByID(((Charges)genericObject).getAssignedAdders(), "BOOSTABLE") != null) {
            return "[" + (String)string + " bc]";
        }
        if (GenericObject.findObjectByID(((Charges)genericObject).getAssignedAdders(), "RECOVERABLE") != null) {
            return "[" + (String)string + " rc]";
        }
        if (GenericObject.findObjectByID(((Charges)genericObject).getAssignedAdders(), "CONTINUING") != null) {
            return "[" + (String)string + " cc]";
        }
        if (GenericObject.findObjectByID(((Charges)genericObject).getAssignedAdders(), "NEVERRECOVER") != null) {
            return "[" + (String)string + " nr]";
        }
        return "[" + (String)string + "]";
    }

    @Override
    public GenericDialog getDialog(boolean bl, boolean bl2) {
        return new CompoundPowerDialog(this, bl);
    }

    @Override
    public int getEndUsage() {
        int n = 0;
        for (GenericObject genericObject : this.powers) {
            genericObject.setParent(this.getParentList());
            n += genericObject.getEndUsage();
            genericObject.setParent(null);
        }
        return n;
    }

    @Override
    public double getIncrease(int n) {
        double d = 0.0;
        for (GenericObject genericObject : this.powers) {
            CharAffectingObject charAffectingObject;
            if (genericObject instanceof Characteristic && ((Characteristic)genericObject).getType() == n) {
                charAffectingObject = (Characteristic)genericObject;
                d += (double)charAffectingObject.getLevels();
                continue;
            }
            if (!(genericObject instanceof CharAffectingObject)) continue;
            charAffectingObject = (CharAffectingObject)genericObject;
            d += charAffectingObject.getIncrease(n);
        }
        return d;
    }

    @Override
    public int getIncreaseLevels(int n) {
        int n2 = 0;
        for (int i = 0; i < this.powers.size(); ++i) {
            if (this.powers.get(i) instanceof Characteristic && ((Characteristic)this.powers.get(i)).getType() == n) {
                n2 = 1;
                continue;
            }
            if (!(this.powers.get(i) instanceof CharAffectingObject)) continue;
            CharAffectingObject charAffectingObject = (CharAffectingObject)this.powers.get(i);
            n2 = Math.max(n2, charAffectingObject.getIncreaseLevels(n));
        }
        return n2;
    }

    @Override
    public double getIncreaseValue(int n, boolean bl) {
        double d = 0.0;
        for (int i = 0; i < this.powers.size(); ++i) {
            CharAffectingObject charAffectingObject;
            if (this.powers.get(i) instanceof Characteristic) {
                if (((Characteristic)this.powers.get(i)).getType() == n) {
                    charAffectingObject = (Characteristic)this.powers.get(i);
                    if (bl && charAffectingObject.getAffectPrimary() && charAffectingObject.getAffectTotal()) {
                        d += (double)charAffectingObject.getLevels();
                        continue;
                    }
                    if (bl || charAffectingObject.getAffectPrimary() || !charAffectingObject.getAffectTotal()) continue;
                    d += (double)charAffectingObject.getLevels();
                    continue;
                }
                if (bl || (charAffectingObject = (CharAffectingObject)this.powers.get(i)).getIncreaseLevels(n) == 0) continue;
                d += charAffectingObject.getIncreaseValue(n, bl);
                continue;
            }
            if (!(this.powers.get(i) instanceof CharAffectingObject) || (charAffectingObject = (CharAffectingObject)this.powers.get(i)).getIncreaseLevels(n) == 0) continue;
            d += charAffectingObject.getIncreaseValue(n, bl);
        }
        return d;
    }

    public String getListSeparator() {
        return this.listSeparator;
    }

    @Override
    public int getMdLevels() {
        int n = 0;
        for (int i = 0; i < this.powers.size(); ++i) {
            Power power;
            if (!(this.powers.get(i) instanceof Power) || (power = (Power)this.powers.get(i)) instanceof DamageResistance) continue;
            n += power.getMdLevels();
        }
        return n;
    }

    @Override
    public String getNamelessColumn2Output() {
        String string = this.getName();
        this.setName("");
        String string2 = this.getColumn2Output(false);
        this.setName(string);
        return string2;
    }

    public ArrayList<GenericObject> getPowers() {
        return this.powers;
    }

    @Override
    public double getRealCost() {
        if (this.parent != null) {
            if (this.parent instanceof ElementalControl) {
                double d = 0.0;
                double d2 = this.getActiveCost();
                double d3 = this.parent.getActiveCost();
                for (int i = 0; i < this.powers.size(); ++i) {
                    GenericObject genericObject = this.powers.get(i);
                    ArrayList<Adder> arrayList = genericObject.getAssignedAdders();
                    ArrayList<Modifier> arrayList2 = genericObject.getAssignedModifiers();
                    ArrayList arrayList3 = (ArrayList)arrayList.clone();
                    arrayList3.addAll(this.parent.getAssignedAdders());
                    ArrayList arrayList4 = (ArrayList)arrayList2.clone();
                    ArrayList<Modifier> arrayList5 = new ArrayList<Modifier>();
                    for (Modifier modifier : this.parent.getAssignedModifiers()) {
                        if (!(modifier.getTotalValue() < 0.0)) continue;
                        arrayList5.add(modifier);
                    }
                    arrayList4.addAll(arrayList5);
                    double d4 = genericObject.getActiveCost();
                    double d5 = d4 / d2 * d3;
                    d4 = d4 >= d5 * 2.0 ? (d4 -= d5) : d5;
                    double d6 = 0.0;
                    for (Modifier modifier : arrayList4) {
                        if (!(modifier.getTotalValue() < 0.0)) continue;
                        d6 += modifier.getTotalValue();
                    }
                    double d7 = d4 / (1.0 + Math.abs(d6));
                    if (d6 != 0.0) {
                        d7 = Rounder.roundHalfDown(d7);
                    }
                    if (d7 < 1.0) {
                        d7 = 1.0;
                    }
                    d += d7;
                }
                return d;
            }
            return this.parent.getRealCostForChild(this);
        }
        return this.getRealCostPreList();
    }

    @Override
    public double getRealCostPreList() {
        double d = 0.0;
        if (this.getQuantity() > 1) {
            int n = 0;
            for (double d2 = (double)this.getQuantity(); d2 > 1.0; d2 /= 2.0) {
                ++n;
            }
            d += (double)(n * 5);
        }
        for (GenericObject genericObject : this.powers) {
            List list = this.getParentList();
            genericObject.setParent(list);
            d += genericObject.getRealCostPreList();
            genericObject.setParent(null);
        }
        return d;
    }

    @Override
    public Element getSaveXML() {
        Element element = super.getSaveXML();
        for (GenericObject genericObject : this.powers) {
            Element element2 = genericObject.getSaveXML();
            element.addContent(element2);
        }
        return element;
    }

    @Override
    public double getTotalCost() {
        double d = 0.0;
        for (GenericObject genericObject : this.powers) {
            genericObject.setParent(this.getParentList());
            d += genericObject.getTotalCost();
            genericObject.setParent(null);
        }
        return d;
    }

    @Override
    public ArrayList<String> getTypes() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (GenericObject genericObject : this.powers) {
            arrayList.addAll(genericObject.getTypes());
        }
        return arrayList;
    }

    @Override
    public boolean resistantDefenses() {
        for (GenericObject genericObject : this.powers) {
            Power power;
            if (!(genericObject instanceof Power) || !(power = (Power)genericObject).resistantDefenses()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void restoreFromSave(Element element) {
        GenericObject genericObject;
        Iterator<GenericObject> iterator;
        Cloneable cloneable;
        Object object;
        int n;
        super.restoreFromSave(element);
        java.util.List list = element.getChildren("POWER");
        block0: for (Element element2 : list) {
            if (element2 == null) continue;
            String object22 = XMLUtility.getValue(element2, "XMLID");
            for (n = 0; n < HeroDesigner.getActiveTemplate().getPowers().size(); ++n) {
                if (HeroDesigner.getActiveTemplate().getPowers().get(n) instanceof List) {
                    object = (List)HeroDesigner.getActiveTemplate().getPowers().get(n);
                    cloneable = ((List)object).getObjects();
                    iterator = ((ArrayList)cloneable).iterator();
                    while (iterator.hasNext()) {
                        genericObject = iterator.next();
                        if (genericObject instanceof List) {
                            List list2 = (List)genericObject;
                            for (GenericObject genericObject2 : list2.getObjects()) {
                                if (!genericObject2.getXMLID().equals(object22)) continue;
                                genericObject2 = genericObject2.clone();
                                genericObject2.restoreFromSave(element2);
                                this.powers.add(genericObject2);
                                continue block0;
                            }
                            continue;
                        }
                        if (!genericObject.getXMLID().equals(object22)) continue;
                        genericObject = genericObject.clone();
                        genericObject.restoreFromSave(element2);
                        this.powers.add(genericObject);
                        continue block0;
                    }
                    continue;
                }
                object = HeroDesigner.getActiveTemplate().getPowers().get(n);
                if (!((GenericObject)object).getXMLID().equals(object22)) continue;
                object = ((GenericObject)object).clone();
                ((GenericObject)object).restoreFromSave(element2);
                this.powers.add((GenericObject)object);
                continue block0;
            }
        }
        list = element.getChildren("SKILL");
        block4: for (Element element2 : list) {
            if (element2 == null) continue;
            String string = XMLUtility.getValue(element2, "XMLID");
            for (n = 0; n < HeroDesigner.getActiveTemplate().getPowers().size(); ++n) {
                if (HeroDesigner.getActiveTemplate().getPowers().get(n) instanceof List) {
                    object = (List)HeroDesigner.getActiveTemplate().getPowers().get(n);
                    cloneable = ((List)object).getObjects();
                    iterator = ((ArrayList)cloneable).iterator();
                    while (iterator.hasNext()) {
                        genericObject = iterator.next();
                        if (!genericObject.getXMLID().equals(string)) continue;
                        genericObject = genericObject.clone();
                        genericObject.restoreFromSave(element2);
                        this.powers.add(genericObject);
                        continue block4;
                    }
                    continue;
                }
                object = HeroDesigner.getActiveTemplate().getPowers().get(n);
                if (!((GenericObject)object).getXMLID().equals(string)) continue;
                object = ((GenericObject)object).clone();
                ((GenericObject)object).restoreFromSave(element2);
                this.powers.add((GenericObject)object);
                continue block4;
            }
        }
        list = element.getChildren("PERK");
        block7: for (Element element2 : list) {
            if (element2 == null) continue;
            String string = XMLUtility.getValue(element2, "XMLID");
            for (n = 0; n < HeroDesigner.getActiveTemplate().getPowers().size(); ++n) {
                if (HeroDesigner.getActiveTemplate().getPowers().get(n) instanceof List) {
                    object = (List)HeroDesigner.getActiveTemplate().getPowers().get(n);
                    cloneable = ((List)object).getObjects();
                    iterator = ((ArrayList)cloneable).iterator();
                    while (iterator.hasNext()) {
                        genericObject = iterator.next();
                        if (!genericObject.getXMLID().equals(string)) continue;
                        genericObject = genericObject.clone();
                        genericObject.restoreFromSave(element2);
                        this.powers.add(genericObject);
                        continue block7;
                    }
                    continue;
                }
                object = HeroDesigner.getActiveTemplate().getPowers().get(n);
                if (!((GenericObject)object).getXMLID().equals(string)) continue;
                object = ((GenericObject)object).clone();
                ((GenericObject)object).restoreFromSave(element2);
                this.powers.add((GenericObject)object);
                continue block7;
            }
        }
        list = element.getChildren("TALENT");
        block10: for (Element element2 : list) {
            if (element2 == null) continue;
            String string = XMLUtility.getValue(element2, "XMLID");
            for (n = 0; n < HeroDesigner.getActiveTemplate().getPowers().size(); ++n) {
                if (HeroDesigner.getActiveTemplate().getPowers().get(n) instanceof List) {
                    object = (List)HeroDesigner.getActiveTemplate().getPowers().get(n);
                    cloneable = ((List)object).getObjects();
                    iterator = ((ArrayList)cloneable).iterator();
                    while (iterator.hasNext()) {
                        genericObject = iterator.next();
                        if (!genericObject.getXMLID().equals(string)) continue;
                        genericObject = genericObject.clone();
                        genericObject.restoreFromSave(element2);
                        this.powers.add(genericObject);
                        continue block10;
                    }
                    continue;
                }
                object = HeroDesigner.getActiveTemplate().getPowers().get(n);
                if (!((GenericObject)object).getXMLID().equals(string)) continue;
                object = ((GenericObject)object).clone();
                ((GenericObject)object).restoreFromSave(element2);
                this.powers.add((GenericObject)object);
                continue block10;
            }
        }
        for (int i = 0; i < HeroDesigner.getActiveTemplate().getCharacteristics().size(); ++i) {
            GenericObject genericObject3 = HeroDesigner.getActiveTemplate().getCharacteristics().get(i);
            list = element.getChildren(genericObject3.getXMLID());
            for (Element element2 : list) {
                if (element2 == null || HeroDesigner.getActiveHero() == null) continue;
                object = genericObject3.getXMLID();
                cloneable = genericObject3.clone();
                ((GenericObject)cloneable).restoreFromSave(element2);
                ((GenericObject)cloneable).setPower(true);
                this.powers.add((GenericObject)cloneable);
            }
        }
        Collections.sort(this.powers, new Comparator(){

            public int compare(Object object, Object object2) {
                if (object instanceof GenericObject && object2 instanceof GenericObject) {
                    GenericObject genericObject = (GenericObject)object;
                    GenericObject genericObject2 = (GenericObject)object2;
                    return genericObject.getPosition() - genericObject2.getPosition();
                }
                return object.toString().compareTo(object2.toString());
            }

            @Override
            public boolean equals(Object object) {
                return false;
            }
        });
        for (GenericObject genericObject4 : this.powers) {
            genericObject4.setMainPower(this);
        }
    }

    public void setListSeparator(String string) {
        this.listSeparator = string;
    }

    @Override
    public void setParent(List list) {
        super.setParent(list);
        for (int i = 0; i < this.powers.size(); ++i) {
            GenericObject genericObject = this.powers.get(i);
            genericObject.setParent(list);
        }
    }

    public void setPowers(ArrayList<GenericObject> arrayList) {
        this.powers = arrayList;
        for (GenericObject genericObject : this.powers) {
            genericObject.setMainPower(this);
        }
    }

    @Override
    public boolean usesEND() {
        for (GenericObject genericObject : this.powers) {
            if (!genericObject.usesEND()) continue;
            return true;
        }
        return false;
    }
}

