/*
 * Decompiled with CFR 0.152.
 */
package com.hero.objects.powers;

import com.hero.HeroDesigner;
import com.hero.objects.Adder;
import com.hero.objects.GenericObject;
import com.hero.objects.enhancers.Enhancer;
import com.hero.objects.modifiers.Modifier;
import com.hero.objects.powers.Automaton;
import com.hero.objects.powers.Power;
import com.hero.ui.dialog.GenericDialog;
import com.hero.ui.dialog.PowerDialog;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Iterator;
import org.jdom.Element;

public class ChangeEnvironment
extends Power {
    private static String xmlID = "CHANGEENVIRONMENT";
    private GenericDialog dialog;

    public ChangeEnvironment(Element element) {
        super(element, xmlID);
    }

    @Override
    public boolean canAdd(Adder adder) {
        boolean bl = super.canAdd(adder);
        if (!bl) {
            return false;
        }
        if (GenericObject.findObjectByID(this.assignedAdders, "MULTIPLECOMBATEFFECTS") != null) {
            return true;
        }
        if (adder.getXMLID().equals("MULTIPLECOMBATEFFECTS") || adder.getXMLID().equals("VARYINGCOMBATEFFECTS") || adder.getXMLID().equals("LONG")) {
            return true;
        }
        if (GenericObject.findObjectByID(this.availableAdders, "MULTIPLECOMBATEFFECTS") == null) {
            return true;
        }
        for (Adder adder2 : this.assignedAdders) {
            if (!adder2.isSelected() || adder2.getXMLID().equals("VARYINGCOMBATEFFECTS") || adder2.getXMLID().equals("LONG")) continue;
            return false;
        }
        return true;
    }

    @Override
    public ArrayList<Adder> getAssignedAdders() {
        ArrayList<Adder> arrayList = super.getAssignedAdders();
        ArrayList<Adder> arrayList2 = new ArrayList<Adder>();
        if (arrayList.size() == 0) {
            return arrayList;
        }
        if (GenericObject.findObjectByID(this.availableAdders, "MULTIPLECOMBATEFFECTS") == null) {
            return arrayList;
        }
        if (GenericObject.findObjectByID(arrayList, "MULTIPLECOMBATEFFECTS") != null) {
            return arrayList;
        }
        Adder adder = null;
        for (Adder adder2 : arrayList) {
            if (!adder2.isSelected()) continue;
            if (adder2.getXMLID().equals("VARYINGCOMBATEFFECTS") || adder2.getXMLID().equals("LONG")) {
                arrayList2.add(adder2);
                continue;
            }
            if (adder != null && !(adder.getTotalCost() < adder2.getTotalCost())) continue;
            adder = adder2;
        }
        if (adder != null) {
            arrayList2.add(adder);
        }
        this.assignedAdders = arrayList2;
        return arrayList2;
    }

    @Override
    public ArrayList<Adder> getAvailableAdders() {
        ArrayList<Adder> arrayList = super.getAvailableAdders();
        ArrayList<Adder> arrayList2 = new ArrayList<Adder>();
        boolean bl = this.noMoreEffects();
        ArrayList<Adder> arrayList3 = this.getAssignedAdders();
        if (arrayList.size() == 0) {
            return arrayList;
        }
        if (GenericObject.findObjectByID(this.availableAdders, "MULTIPLECOMBATEFFECTS") == null) {
            return arrayList;
        }
        for (Adder adder : arrayList) {
            if (adder.getXMLID().equals("VARYINGCOMBATEFFECTS") || adder.getXMLID().equals("LONG") || adder.getXMLID().equals("MULTIPLECOMBATEFFECTS")) {
                arrayList2.add(adder);
                continue;
            }
            if (GenericObject.findObjectByID(arrayList3, adder.getXMLID()) == null) {
                adder.setSelectable(!bl);
            }
            arrayList2.add(adder);
        }
        return arrayList2;
    }

    @Override
    public String getColumn2Output() {
        String string = this.getAlias() + " " + this.getDamageDisplay();
        string = string.trim();
        if (this.getName().trim().length() > 0) {
            string = "<i>" + this.getName() + ":</i>  " + string;
        }
        if (this.getInput() != null && this.getInput().trim().length() > 0) {
            string = string + ":  " + this.getInput();
        }
        string = string + " (";
        String string2 = "";
        for (Adder genericObject2 : this.getAssignedAdders()) {
            if (!genericObject2.getXMLID().equals("PERROLL") && !genericObject2.getXMLID().equals("PERROLLGROUP")) continue;
            if (string2.trim().length() > 0) {
                string2 = string2 + ", ";
            }
            string2 = string2 + "-" + genericObject2.getLevels() + " to " + genericObject2.getSelectedOption().getAlias() + " PER Rolls";
            genericObject2.setDisplayInString(false);
        }
        String string3 = this.getAdderString();
        if (string3.trim().length() > 0) {
            if (string2.trim().length() > 0) {
                string2 = string2 + ", ";
            }
            string2 = string2 + (String)string3;
        }
        if (this.getSelectedOption() != null) {
            string = string + ", ";
            string = string + this.getSelectedOption().getAlias();
            if (string2.trim().length() > 0) {
                string = string + ", " + string2;
            }
        } else if (string2.trim().length() > 0) {
            string = string + string2;
        }
        string = string + ")";
        Modifier modifier = (Modifier)GenericObject.findObjectByID(this.getAssignedModifiers(), "ALTEREDSHAPE");
        if (modifier != null) {
            this.getAssignedModifiers().remove(modifier);
        }
        string = string + this.getModifierString();
        if (modifier != null) {
            this.getAssignedModifiers().add(modifier);
        }
        if (this.getEndUsage() > 0 && GenericObject.findObjectByID(HeroDesigner.getActiveHero().getPowers(), "ENDURANCERESERVE") != null && GenericObject.findObjectByID(this.getAllAssignedModifiers(), "ENDRESERVEOREND") == null && !HeroDesigner.getInstance().getPrefs().useWG()) {
            string = this.getUseENDReserve() ? string + " (uses END Reserve)" : string + " (uses Personal END)";
        }
        return string;
    }

    @Override
    public String getDamageDisplay() {
        String string = "";
        if (!HeroDesigner.getActiveTemplate().is6E()) {
            double d = Math.pow(this.getLevelPower(), this.getLevels() - 1);
            string = NumberFormat.getIntegerInstance().format(d) + "\" radius";
            Modifier modifier = null;
            if (GenericObject.findObjectByID(this.getAssignedModifiers(), "ALTEREDSHAPE") == null) {
                return string;
            }
            modifier = (Modifier)GenericObject.findObjectByID(this.getAssignedModifiers(), "ALTEREDSHAPE");
            if (modifier != null && modifier.getSelectedOption() != null && modifier.getSelectedOption().getXMLID().equals("CONE")) {
                string = string + " (" + NumberFormat.getIntegerInstance().format(d * 2.0) + "\" Cone; +0)";
            } else if (modifier != null && modifier.getSelectedOption() != null && modifier.getSelectedOption().getXMLID().equals("LINE")) {
                double d2 = 1.0;
                if (GenericObject.findObjectByID(modifier.getAssignedAdders(), "DOUBLEWIDTH") != null) {
                    Adder adder = (Adder)GenericObject.findObjectByID(modifier.getAssignedAdders(), "DOUBLEWIDTH");
                    d2 = Math.pow(adder.getLevelPower(), adder.getLevels());
                }
                string = d2 == 1.0 ? string + " (" + NumberFormat.getIntegerInstance().format(d * 2.0) + "\" Line; +0)" : string + " (" + NumberFormat.getIntegerInstance().format(d * 2.0) + "\" long and " + NumberFormat.getIntegerInstance().format(d2) + "\" wide Line; " + modifier.getFraction(modifier.getTotalValue()) + ")";
            } else if (modifier != null && modifier.getSelectedOption() != null && modifier.getSelectedOption().getXMLID().equals("ANY")) {
                string = string + " (" + NumberFormat.getIntegerInstance().format(d) + "\" Any Area; +0)";
            }
        }
        return string;
    }

    @Override
    public GenericDialog getDialog(boolean bl, boolean bl2) {
        this.dialog = new PowerDialog(this, bl, bl2);
        return this.dialog;
    }

    @Override
    public double getTotalCost() {
        double d;
        this.enhancerApplied = null;
        double d2 = this.getBaseCost();
        if (this.getLevelValue() != 0.0) {
            d = (double)this.getLevels() / this.getLevelValue() * this.getLevelCost();
            d2 += d;
        }
        d = 99999.0;
        int n = -1;
        int n2 = -1;
        for (Adder object2 : this.getAssignedAdders()) {
            ++n2;
            if (!(object2.getRealCost() > 0.0) || !(object2.getLevelCost() > 0.0) || !(object2.getLevelValue() > 0.0) || !(object2.getLevelCost() / object2.getLevelValue() < d)) continue;
            d = object2.getLevelCost() / object2.getLevelValue();
            n = n2;
        }
        n2 = -1;
        for (Adder adder : this.getAssignedAdders()) {
            ++n2;
            if (!(adder.getRealCost() > 0.0)) continue;
            d2 += adder.getRealCost();
            if (n2 != n || HeroDesigner.getActiveTemplate().is6E()) continue;
            d2 -= adder.getLevelCost() / adder.getLevelValue();
        }
        if (d2 < this.getMinimumCost() && this.isMinSet()) {
            d2 = this.getMinimumCost();
        } else if (d2 > this.getMaxCost() && this.isMaxSet()) {
            d2 = this.getMaxCost();
        }
        Cloneable cloneable = this.getAssignedAdders().iterator();
        while (cloneable.hasNext()) {
            Adder adder = cloneable.next();
            if (!(adder.getRealCost() < 0.0)) continue;
            d2 += adder.getRealCost();
        }
        if (this.getTypes() != null && this.getTypes().size() > 0) {
            Enhancer enhancer;
            GenericObject genericObject;
            cloneable = HeroDesigner.getActiveHero().getSkills();
            Iterator iterator = ((ArrayList)cloneable).iterator();
            block3: while (iterator.hasNext()) {
                genericObject = (GenericObject)iterator.next();
                if (!(genericObject instanceof Enhancer)) continue;
                enhancer = (Enhancer)genericObject;
                for (String string : this.getTypes()) {
                    if (!enhancer.appliesToType(string)) continue;
                    this.enhancerApplied = enhancer;
                    if (d2 > (double)enhancer.getCostSavings()) {
                        d2 -= (double)enhancer.getCostSavings();
                        break block3;
                    }
                    if (!(d2 > 0.0)) break block3;
                    d2 = 1.0;
                    break block3;
                }
            }
            cloneable = HeroDesigner.getActiveHero().getPerks();
            Iterator<GenericObject> iterator2 = ((ArrayList)cloneable).iterator();
            block5: while (iterator2.hasNext()) {
                genericObject = iterator2.next();
                if (!(genericObject instanceof Enhancer)) continue;
                enhancer = (Enhancer)genericObject;
                for (String string : this.getTypes()) {
                    if (!enhancer.appliesToType(string)) continue;
                    this.enhancerApplied = enhancer;
                    if (d2 > (double)enhancer.getCostSavings()) {
                        d2 -= (double)enhancer.getCostSavings();
                        break block5;
                    }
                    if (!(d2 > 0.0)) break block5;
                    d2 = 1.0;
                    break block5;
                }
            }
        }
        if (this.getTypes().contains("DEFENSE") && HeroDesigner.getActiveHero() != null && GenericObject.findObjectByID(HeroDesigner.getActiveHero().getPowers(), "AUTOMATON") != null && ((GenericObject)(cloneable = (Automaton)GenericObject.findObjectByID(HeroDesigner.getActiveHero().getPowers(), "AUTOMATON"))).getSelectedOption().getXMLID().toUpperCase().startsWith("NOSTUN")) {
            d2 *= (double)((Automaton)cloneable).getDefenseCostMultiplier();
        }
        return d2;
    }

    private boolean noMoreEffects() {
        ArrayList<Adder> arrayList = super.getAssignedAdders();
        if (arrayList.size() == 0) {
            return false;
        }
        if (GenericObject.findObjectByID(this.availableAdders, "MULTIPLECOMBATEFFECTS") == null) {
            return false;
        }
        if (GenericObject.findObjectByID(arrayList, "MULTIPLECOMBATEFFECTS") != null) {
            return false;
        }
        for (Adder adder : arrayList) {
            if (!adder.isSelected() || adder.getXMLID().equals("VARYINGCOMBATEFFECTS") || adder.getXMLID().equals("LONG")) continue;
            return true;
        }
        return false;
    }
}

