/*
 * Decompiled with CFR 0.152.
 */
package com.hero.objects.powers;

import com.hero.HeroDesigner;
import com.hero.objects.GenericObject;
import com.hero.objects.powers.Power;
import com.hero.ui.dialog.GenericDialog;
import com.hero.ui.dialog.PowerDialog;
import com.hero.util.XMLUtility;
import org.jdom.Element;

public class Automaton
extends Power {
    private static String xmlID = "AUTOMATON";
    private int basePDEDDenomenator;
    private int defenseCostMultiplier;

    public Automaton(Element element) {
        super(element, xmlID);
    }

    public int getBasePDEDDenomenator() {
        if (this.basePDEDDenomenator <= 0) {
            this.basePDEDDenomenator = 3;
        }
        return this.basePDEDDenomenator;
    }

    @Override
    public String getColumn2Output() {
        String string;
        String string2 = this.getSelectedOption().getAlias();
        if (this.getName().trim().length() > 0) {
            string2 = "<i>" + this.getName() + ":</i>  " + string2;
        }
        if (this.getInput() != null && this.getInput().trim().length() > 0) {
            string2 = string2 + ":  " + this.getInput();
        }
        if ((string = this.getAdderString()).trim().length() > 0) {
            string2 = string2 + " (" + string + ")";
        }
        string2 = string2 + this.getModifierString();
        if (this.getEndUsage() > 0 && GenericObject.findObjectByID(HeroDesigner.getActiveHero().getPowers(), "ENDURANCERESERVE") != null && GenericObject.findObjectByID(this.getAllAssignedModifiers(), "ENDRESERVEOREND") == null && !HeroDesigner.getInstance().getPrefs().useWG()) {
            string2 = this.getUseENDReserve() ? string2 + " (uses END Reserve)" : string2 + " (uses Personal END)";
        }
        return string2;
    }

    @Override
    public String getDamageDisplay() {
        String string = "";
        return string;
    }

    public int getDefenseCostMultiplier() {
        if (this.defenseCostMultiplier <= 0) {
            this.defenseCostMultiplier = 1;
        }
        return this.defenseCostMultiplier;
    }

    @Override
    public GenericDialog getDialog(boolean bl, boolean bl2) {
        return new PowerDialog(this, bl, bl2);
    }

    @Override
    protected void init(Element element) {
        this.duration = "INHERENT";
        this.target = "SELFONLY";
        this.range = "SELF";
        this.end = 0;
        this.display = "Automaton";
        this.levelCost = 0.0;
        this.levelValue = 0.0;
        this.minimumCost = 15.0;
        this.baseCost = 15.0;
        this.basePDEDDenomenator = 3;
        this.defenseCostMultiplier = 3;
        super.init(element);
        String string = XMLUtility.getValue(element, "BASEPDEDDENOMENATOR");
        if (string != null && string.trim().length() > 0) {
            try {
                this.basePDEDDenomenator = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((string = XMLUtility.getValue(element, "DEFENSECOSTMULTIPLIER")) != null && string.trim().length() > 0) {
            try {
                this.defenseCostMultiplier = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }
}

