/*
 * Decompiled with CFR 0.152.
 */
package com.hero.objects.powers;

import com.hero.HeroDesigner;
import com.hero.objects.GenericObject;
import com.hero.objects.powers.Power;
import com.hero.ui.dialog.ArmorDialog;
import com.hero.ui.dialog.GenericDialog;
import com.hero.util.XMLUtility;
import org.jdom.Element;

public class Armor
extends Power {
    private static String xmlID = "ARMOR";
    private int edLevels;
    private int pdLevels;

    public Armor(Element element) {
        super(element, xmlID);
        this.canAffectPrimary = true;
    }

    @Override
    public boolean affectsCharacteristics() {
        return true;
    }

    @Override
    public String getColumn2Output() {
        String string = this.getAlias() + " " + this.getDamageDisplay();
        if (this.getName().trim().length() > 0) {
            string = "<i>" + this.getName() + ":</i>  " + string;
        }
        string = string + "(" + this.pdLevels + " PD/" + this.edLevels + " ED)";
        if (this.getInput() != null && this.getInput().trim().length() > 0) {
            string = string + ":  " + this.getInput();
        }
        if (this.getSelectedOption() != null) {
            string = string + " (";
            string = string + this.getSelectedOption().getAlias();
            String string2 = this.getAdderString();
            if (string2.trim().length() > 0) {
                string = string + "; " + string2;
            }
            string = string + ")";
        } else {
            String string3 = this.getAdderString();
            if (string3.trim().length() > 0) {
                string = string + " (" + string3 + ")";
            }
        }
        string = string + this.getModifierString();
        if (this.getEndUsage() > 0 && GenericObject.findObjectByID(HeroDesigner.getActiveHero().getPowers(), "ENDURANCERESERVE") != null && GenericObject.findObjectByID(this.getAllAssignedModifiers(), "ENDRESERVEOREND") == null && !HeroDesigner.getInstance().getPrefs().useWG()) {
            string = this.getUseENDReserve() ? string + " (uses END Reserve)" : string + " (uses Personal END)";
        }
        return string;
    }

    @Override
    public String getDamageDisplay() {
        String string = "";
        return string;
    }

    @Override
    public GenericDialog getDialog(boolean bl, boolean bl2) {
        return new ArmorDialog(this, bl, bl2);
    }

    @Override
    public double getEdIncrease() {
        return this.getEdLevels();
    }

    @Override
    public int getEdIncreaseLevels() {
        return this.getLevels();
    }

    public int getEdLevels() {
        return this.edLevels;
    }

    @Override
    public int getLevels() {
        return this.pdLevels + this.edLevels;
    }

    @Override
    public double getPdIncrease() {
        return this.getPdLevels();
    }

    @Override
    public int getPdIncreaseLevels() {
        return this.getLevels();
    }

    public int getPdLevels() {
        return this.pdLevels;
    }

    @Override
    public Element getSaveXML() {
        Element element = super.getSaveXML();
        element.setAttribute("PDLEVELS", "" + this.pdLevels);
        element.setAttribute("EDLEVELS", "" + this.edLevels);
        return element;
    }

    @Override
    public boolean resistantDefenses() {
        return true;
    }

    @Override
    public void restoreFromSave(Element element) {
        super.restoreFromSave(element);
        String string = XMLUtility.getValue(element, "PDLEVELS");
        if (string != null && string.trim().length() > 0) {
            try {
                this.pdLevels = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((string = XMLUtility.getValue(element, "EDLEVELS")) != null && string.trim().length() > 0) {
            try {
                this.edLevels = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.setLevels(this.edLevels + this.pdLevels);
    }

    public void setEdLevels(int n) {
        this.edLevels = n;
        this.setLevels(this.getPdLevels() + this.getEdLevels());
    }

    public void setPdLevels(int n) {
        this.pdLevels = n;
        this.setLevels(this.getPdLevels() + this.getEdLevels());
    }
}

